/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.hatbox.wk;

import java.io.IOException;
import java.io.InputStream;

public class WKBArrayInputStream
extends InputStream {
    private byte[] wkb;
    private int offset;
    private int length;

    public WKBArrayInputStream(byte[] wkb) {
        this.wkb = wkb;
        this.offset = 0;
        this.length = wkb.length;
    }

    @Override
    public int read() throws IOException {
        if (this.offset < this.length) {
            return this.wkb[this.offset++] & 0xFF;
        }
        return -1;
    }

    @Override
    public int read(byte[] b) throws IOException {
        int size = b.length;
        if (this.offset + size <= this.length) {
            System.arraycopy(this.wkb, this.offset, b, 0, size);
            this.offset += size;
            return size;
        }
        throw new IOException("Attempted to read beyond data array");
    }
}

