/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.hatbox.wk;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.sourceforge.hatbox.wk.AbstractGeometryHandler;
import net.sourceforge.hatbox.wk.ParseException;
import net.sourceforge.hatbox.wk.WKBParseState;
import net.sourceforge.hatbox.wk.WKTParseState;

public class LinestringHandler
extends AbstractGeometryHandler {
    @Override
    public void readWKB(InputStream is, WKBParseState work) throws IOException {
        int coords = LinestringHandler.getInt(is, work);
        for (int i = 0; i < coords; ++i) {
            this.readCoord(is, work);
        }
    }

    @Override
    public void writeWKB(OutputStream os, WKTParseState state) throws IOException, ParseException {
        this.writeWKBHeader(os, state);
        this.writeInt(state.getLinestring().size(), os, state);
        for (WKTParseState.Coord c : state.getLinestring()) {
            this.writeCoord(os, c, state);
        }
    }

    @Override
    public WKTParseState handleToken(int token, WKTParseState state) throws ParseException {
        return state.linestringToken(token);
    }
}

