/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.hatbox.wk;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.sourceforge.hatbox.wk.AbstractGeometryHandler;
import net.sourceforge.hatbox.wk.ParseException;
import net.sourceforge.hatbox.wk.WKBParseState;
import net.sourceforge.hatbox.wk.WKParser;
import net.sourceforge.hatbox.wk.WKTParseState;

public class CollectionHandler
extends AbstractGeometryHandler {
    @Override
    public void readWKB(InputStream is, WKBParseState state) throws IOException {
        int geoms = CollectionHandler.getInt(is, state);
        for (int i = 0; i < geoms; ++i) {
            state.setTypeCount(i);
            WKBParseState child = new WKBParseState();
            child.setParent(state);
            WKParser.parseWKB(is, child);
        }
    }

    @Override
    public void writeWKB(OutputStream os, WKTParseState state) throws IOException, ParseException {
        this.writeWKBHeader(os, state);
        this.writeInt(state.getChildren().size(), os, state);
        for (WKTParseState child : state.getChildren()) {
            child.getType().getHandler().writeWKB(os, child);
        }
    }

    @Override
    public WKTParseState handleToken(int token, WKTParseState state) throws ParseException {
        return state.collectionToken(token);
    }
}

