/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.hatbox;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.sourceforge.hatbox.Entry;
import net.sourceforge.hatbox.Envelope;
import net.sourceforge.hatbox.Node;
import net.sourceforge.hatbox.RTreeSession;

public class RTree {
    private static final double DEFAULT_MIN_NODE_SPLIT = 0.34;
    private double minNodeSplit = 0.34;
    private RTreeSession session;

    public RTree(RTreeSession session) {
        this.session = session;
    }

    public List<Long> search(Envelope searchEnv) throws SQLException {
        ArrayList<Long> matchIds = new ArrayList<Long>();
        this.search(this.session.getRootId(), searchEnv, matchIds);
        return matchIds;
    }

    private void search(long id, Envelope searchEnv, List<Long> matchIds) throws SQLException {
        Node node = this.session.getNode(id);
        boolean leaf = node.isLeaf();
        for (int i = 0; i < node.getEntriesCount(); ++i) {
            if (!node.intersects(searchEnv, i)) continue;
            if (leaf) {
                matchIds.add(node.getEntryId(i));
                continue;
            }
            this.search(node.getEntryId(i), searchEnv, matchIds);
        }
    }

    public void insert(Entry entry) throws SQLException {
        Node node = this.chooseLeaf(this.session.getRootId(), entry);
        if (entry.getLevel() > 0) {
            Node entryNode = this.session.getNode(entry.getId());
            entryNode.setParentId(node.getId());
            this.session.updateNode(entryNode);
        }
        if (node.getEntriesCount() < node.getEntriesMax()) {
            node.addEntry(entry);
            this.session.updateNode(node);
            this.adjustTree(node, null, null);
        } else {
            ArrayList<Entry> split1 = new ArrayList<Entry>(node.getEntriesCount());
            ArrayList<Entry> split2 = new ArrayList<Entry>(node.getEntriesCount());
            this.splitNode(node, entry, split1, split2);
            this.adjustTree(node, split1, split2);
        }
    }

    private Node chooseLeaf(long id, Entry entry) throws SQLException {
        Node node = this.session.getNode(id);
        if (node.getLevel() == entry.getLevel()) {
            return node;
        }
        int entryI = 0;
        Envelope env = new Envelope();
        double smallestArea = Double.POSITIVE_INFINITY;
        double smallestDelta = Double.POSITIVE_INFINITY;
        double area = 0.0;
        double delta = 0.0;
        for (int i = 0; i < node.getEntriesCount(); ++i) {
            area = node.populateEnvelope(env, i);
            delta = env.expandToFit(entry) - area;
            if (delta < smallestDelta) {
                smallestArea = area;
                smallestDelta = delta;
                entryI = i;
                continue;
            }
            if (delta != smallestDelta || !(area < smallestArea)) continue;
            smallestArea = area;
            entryI = i;
        }
        return this.chooseLeaf(node.getEntryId(entryI), entry);
    }

    private void adjustTree(Node n, List<Entry> split1, List<Entry> split2) throws SQLException {
        if (n.getId() == this.session.getRootId()) {
            if (split1 != null) {
                Node root = n.split();
                root.setLevel(n.getLevel() + 1);
                this.session.setRootId(this.session.insertNode(root));
                n.resetEntries();
                n.setParentId(this.session.getRootId());
                for (int i = 0; i < split1.size(); ++i) {
                    Entry e = split1.get(i);
                    n.addEntry(e);
                }
                this.session.updateNode(n);
                Node n2 = n.split();
                n2.setParentId(this.session.getRootId());
                long n2Id = this.session.insertNode(n2);
                for (int i = 0; i < split2.size(); ++i) {
                    Entry e = split2.get(i);
                    n2.addEntry(e);
                    if (n2.isLeaf()) continue;
                    Node child = this.session.getNode(e.getId());
                    child.setParentId(n2Id);
                    this.session.updateNode(child);
                }
                this.session.updateNode(n2);
                root.addEntry(n.getMyEntry());
                root.addEntry(n2.getMyEntry());
                this.session.updateNode(root);
            }
            return;
        }
        Node p = this.session.getNode(n.getParentId());
        if (split1 == null) {
            p.changeEntryEnvelope(n.getMyEntry());
            this.session.updateNode(p);
            this.adjustTree(p, null, null);
        } else {
            n.resetEntries();
            for (int i = 0; i < split1.size(); ++i) {
                Entry e = split1.get(i);
                n.addEntry(e);
            }
            this.session.updateNode(n);
            p.changeEntryEnvelope(n.getMyEntry());
            Node n2 = n.split();
            long n2Id = this.session.insertNode(n2);
            for (int i = 0; i < split2.size(); ++i) {
                Entry e = split2.get(i);
                n2.addEntry(e);
                if (n2.isLeaf()) continue;
                Node child = this.session.getNode(e.getId());
                child.setParentId(n2Id);
                this.session.updateNode(child);
            }
            this.session.updateNode(n2);
            if (p.getEntriesCount() < p.getEntriesMax()) {
                p.addEntry(n2.getMyEntry());
                this.session.updateNode(p);
                this.adjustTree(p, null, null);
            } else {
                ArrayList<Entry> pe1 = new ArrayList<Entry>(n.getEntriesCount());
                ArrayList<Entry> pe2 = new ArrayList<Entry>(n.getEntriesCount());
                this.splitNode(p, n2.getMyEntry(), pe1, pe2);
                this.adjustTree(p, pe1, pe2);
            }
        }
    }

    private void splitNode(Node n, Entry entry, List<Entry> split1, List<Entry> split2) throws SQLException {
        int minEntries = (int)((double)n.getEntriesMax() * this.getMinNodeSplit());
        Envelope e1 = new Envelope();
        Envelope e2 = new Envelope();
        ArrayList<Entry> entryList = new ArrayList<Entry>(n.getEntriesCount() + 1);
        for (int i = 0; i < n.getEntriesCount(); ++i) {
            Entry e = new Entry();
            n.populateEnvelope(e, i);
            e.setId(n.getEntryId(i));
            entryList.add(e);
        }
        entryList.add(entry);
        Entry[] seeds = this.pickSeeds(entryList);
        e1.populate(seeds[0]);
        split1.add(seeds[0]);
        entryList.remove(seeds[0]);
        e2.populate(seeds[1]);
        split2.add(seeds[1]);
        entryList.remove(seeds[1]);
        while (entryList.size() > 0) {
            if (split1.size() + entryList.size() == minEntries) {
                split1.addAll(entryList);
                entryList.clear();
                continue;
            }
            if (split2.size() + entryList.size() == minEntries) {
                split2.addAll(entryList);
                entryList.clear();
                continue;
            }
            Entry next = this.pickNext(entryList, e1, e2);
            if (next.getD1() == next.getD2()) {
                if (e1.getArea() == e2.getArea()) {
                    if (split1.size() < split2.size()) {
                        split1.add(next);
                        e1.expandToFit(next);
                        continue;
                    }
                    split2.add(next);
                    e2.expandToFit(next);
                    continue;
                }
                if (e1.getArea() < e2.getArea()) {
                    split1.add(next);
                    e1.expandToFit(next);
                    continue;
                }
                split2.add(next);
                e2.expandToFit(next);
                continue;
            }
            if (next.getD1() < next.getD2()) {
                split1.add(next);
                e1.expandToFit(next);
                continue;
            }
            split2.add(next);
            e2.expandToFit(next);
        }
    }

    protected Entry[] pickSeeds(List<Entry> entryList) {
        int size = entryList.size();
        double maxD = Double.NEGATIVE_INFINITY;
        Entry j = new Entry();
        Entry maxE1 = null;
        Entry maxE2 = null;
        Entry e1 = null;
        Entry e2 = null;
        for (int x = 0; x < size - 1; ++x) {
            e1 = entryList.get(x);
            for (int y = x + 1; y < size; ++y) {
                e2 = entryList.get(y);
                j.reset();
                j.expandToFit(e1);
                j.expandToFit(e2);
                double d = j.getArea() - e1.getArea() - e2.getArea();
                if (!(d > maxD)) continue;
                maxD = d;
                maxE1 = e1;
                maxE2 = e2;
            }
        }
        return new Entry[]{maxE1, maxE2};
    }

    protected Entry pickNext(List<Entry> entryList, Envelope e1, Envelope e2) {
        int size = entryList.size();
        Entry bestEntry = null;
        int bestEntryIndex = -1;
        Entry e = null;
        double maxDD = Double.NEGATIVE_INFINITY;
        Envelope temp = new Envelope();
        for (int i = 0; i < size; ++i) {
            e = entryList.get(i);
            temp.populate(e1);
            temp.expandToFit(e);
            e.setD1(temp.getArea() - e1.getArea());
            temp.populate(e2);
            temp.expandToFit(e);
            e.setD2(temp.getArea() - e2.getArea());
            double dd = Math.abs(e.getD1() - e.getD2());
            if (!(dd > maxDD)) continue;
            maxDD = dd;
            bestEntry = e;
            bestEntryIndex = i;
        }
        entryList.remove(bestEntryIndex);
        return bestEntry;
    }

    public double getMinNodeSplit() {
        return this.minNodeSplit;
    }

    public void setMinNodeSplit(double minNodeSplit) {
        this.minNodeSplit = minNodeSplit;
    }

    public void delete(Entry entry) throws SQLException {
        Node leaf = this.findLeaf(this.session.getRootId(), entry);
        if (leaf == null) {
            return;
        }
        leaf.removeEntry(entry.getId());
        LinkedList<Entry> orphans = new LinkedList<Entry>();
        this.condenseTree(leaf, orphans);
        int orphanCount = orphans.size();
        for (int i = 0; i < orphanCount; ++i) {
            this.insert(orphans.removeLast());
        }
        Node root = this.session.getNode(this.session.getRootId());
        if (!root.isLeaf() && root.getEntriesCount() == 1) {
            Node newRoot = this.session.getNode(root.getEntryId(0));
            newRoot.setParentId(-1L);
            this.session.updateNode(newRoot);
            this.session.setRootId(newRoot.getId());
            this.session.deleteNode(root);
        }
    }

    private Node findLeaf(long id, Entry entryToFind) throws SQLException {
        Node node = this.session.getNode(id);
        if (node.isLeaf()) {
            for (int i = 0; i < node.getEntriesCount(); ++i) {
                if (node.getEntryId(i) != entryToFind.getId()) continue;
                return node;
            }
        } else {
            for (int i = 0; i < node.getEntriesCount(); ++i) {
                Node leaf;
                if (!node.intersects(entryToFind, i) || (leaf = this.findLeaf(node.getEntryId(i), entryToFind)) == null) continue;
                return leaf;
            }
        }
        return null;
    }

    private void condenseTree(Node node, List<Entry> orphans) throws SQLException {
        if (this.session.getRootId() == node.getId()) {
            this.session.updateNode(node);
            return;
        }
        Node parent = this.session.getNode(node.getParentId());
        int minEntries = (int)((double)node.getEntriesMax() * this.getMinNodeSplit());
        if (node.getEntriesCount() < minEntries) {
            for (int i = 0; i < node.getEntriesCount(); ++i) {
                orphans.add(node.getEntry(i));
            }
            this.session.deleteNode(node);
            parent.removeEntry(node.getId());
        } else {
            this.session.updateNode(node);
            parent.changeEntryEnvelope(node.getMyEntry());
        }
        this.condenseTree(parent, orphans);
    }
}

