/*
 * Decompiled with CFR 0.152.
 */
package geodb;

import geodb.GeoString;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import net.sourceforge.hatbox.MetaNode;
import net.sourceforge.hatbox.jts.Proc;
import net.sourceforge.hatbox.tools.CmdLine;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.IntersectionMatrix;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.io.InStream;
import org.locationtech.jts.io.InputStreamInStream;
import org.locationtech.jts.io.OutStream;
import org.locationtech.jts.io.OutputStreamOutStream;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKBReader;
import org.locationtech.jts.io.WKBWriter;
import org.locationtech.jts.io.WKTReader;
import org.locationtech.jts.io.WKTWriter;
import org.locationtech.jts.simplify.DouglasPeuckerSimplifier;

public class GeoDB {
    static GeometryFactory gfactory;
    static final boolean PRE_JTS12;

    static final WKBWriter wkbwriter() {
        return PRE_JTS12 ? new WKBWriter(3) : new WKBWriter(3, true);
    }

    static final WKBReader wkbreader() {
        return new WKBReader(gfactory);
    }

    static final WKTWriter wktwriter() {
        return new WKTWriter();
    }

    static final WKTReader wktreader() {
        return new WKTReader(gfactory);
    }

    public static String GeoToolsVersion() {
        return "0.1";
    }

    public static String Version() {
        return "9";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void InitGeoDB(Connection cx) throws SQLException {
        try {
            ResultSet rs2222222222;
            Statement st;
            block16: {
                st = cx.createStatement();
                rs2222222222 = st.executeQuery("SELECT checksum FROM _GEODB");
                if (!rs2222222222.next() || !GeoDB.Version().equalsIgnoreCase(rs2222222222.getString(1))) break block16;
                rs2222222222.close();
                st.close();
                return;
            }
            try {
                block17: {
                    try {
                        rs2222222222.close();
                        break block17;
                        {
                            catch (Throwable throwable) {
                                rs2222222222.close();
                                throw throwable;
                            }
                        }
                    }
                    catch (SQLException rs2222222222) {
                        // empty catch block
                    }
                }
                BufferedReader in = new BufferedReader(new InputStreamReader(GeoDB.class.getResourceAsStream("geodb.sql")));
                String line2222222222 = null;
                while ((line2222222222 = in.readLine()) != null) {
                    try {
                        st.execute(line2222222222);
                    }
                    catch (SQLException sQLException) {}
                }
                in.close();
                List ddl = CmdLine.getddl((String)"create_h2.sql");
                for (String line2222222222 : ddl) {
                    try {
                        st.execute(line2222222222);
                    }
                    catch (SQLException sQLException) {}
                }
                st.execute("CREATE TABLE IF NOT EXISTS _GEODB (checksum VARCHAR)");
                st.execute("DELETE FROM _GEODB");
                st.execute("INSERT INTO _GEODB VALUES (" + GeoDB.Version() + ")");
                st.execute("CREATE TABLE IF NOT EXISTS geometry_columns (f_table_schema VARCHAR, f_table_name VARCHAR, f_geometry_column VARCHAR, coord_dimension INT, srid INT, type VARCHAR(30))");
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                st.close();
            }
        }
        catch (Exception e) {
            throw (SQLException)new SQLException("Could not initialize database").initCause(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void AddGeometryColumn(Connection cx, String schema, String table, String column, int srid, String type, int dim) throws SQLException {
        type = type.toUpperCase();
        Statement st = cx.createStatement();
        try {
            ResultSet rs = cx.getMetaData().getColumns(null, schema, table, column);
            try {
                if (!rs.next()) {
                    st.execute("ALTER TABLE " + GeoDB.tbl(schema, table) + " ADD " + GeoDB.esc(column) + " " + type + " COMMENT '" + type + "'");
                }
            }
            finally {
                rs.close();
            }
            String string = schema = schema != null ? schema : "PUBLIC";
            if (!"GEOMETRY".equals(type) && !"GEOMETRYCOLLECTION".equals(type)) {
                st.execute("ALTER TABLE " + GeoDB.tbl(schema, table) + " ADD CONSTRAINT " + GeoDB.esc(GeoDB.geotypeConstraint(schema, table, column)) + " CHECK " + GeoDB.esc(column) + " IS NULL OR GeometryType(" + GeoDB.esc(column) + ") = '" + type + "'");
            }
            st.execute("INSERT INTO geometry_columns VALUES (" + GeoDB.str(schema) + ", " + GeoDB.str(table) + ", " + GeoDB.str(column) + ", " + dim + ", " + srid + ", " + GeoDB.str(type) + ")");
        }
        finally {
            st.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void DropGeometryColumn(Connection cx, String schema, String table, String column) throws SQLException {
        Statement st = cx.createStatement();
        try {
            boolean isView = false;
            ResultSet tables = cx.getMetaData().getTables(null, schema, table, new String[]{"VIEW"});
            try {
                isView = tables.next();
            }
            finally {
                tables.close();
            }
            schema = schema != null ? schema : "PUBLIC";
            st.execute("ALTER TABLE " + GeoDB.tbl(schema, table) + " DROP CONSTRAINT IF EXISTS " + GeoDB.esc(GeoDB.geotypeConstraint(schema, table, column)));
            if (!isView) {
                st.execute("ALTER TABLE " + GeoDB.tbl(schema, table) + " DROP COLUMN " + GeoDB.esc(column));
            }
            st.execute("DELETE FROM geometry_columns WHERE f_table_schema = " + GeoDB.str(schema) + " AND f_table_name = " + GeoDB.str(table) + " AND f_geometry_column = " + GeoDB.str(column));
        }
        finally {
            st.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void DropGeometryColumns(Connection cx, String schema, String table) throws SQLException {
        Statement st = cx.createStatement();
        try {
            schema = schema != null ? schema : "PUBLIC";
            StringBuffer sql = new StringBuffer();
            sql.append("SELECT f_geometry_column FROM geometry_columns").append(" WHERE f_table_schema = '").append(schema).append("'").append(" AND f_table_name = '").append(table).append("'");
            ResultSet columns = st.executeQuery(sql.toString());
            while (columns.next()) {
                String column = columns.getString(1);
                GeoDB.DropGeometryColumn(cx, schema, table, column);
            }
        }
        finally {
            st.close();
        }
    }

    public static String ST_AsText(byte[] wkb) {
        if (wkb == null) {
            return null;
        }
        return GeoDB.gToWKT(GeoDB.gFromWKB(wkb));
    }

    public static String ST_AsEWKT(byte[] wkb) {
        if (wkb == null) {
            return null;
        }
        Geometry g = GeoDB.gFromWKB(wkb);
        return GeoDB.gToEWKT(g);
    }

    public static byte[] ST_AsEWKB(byte[] wkb) {
        return wkb;
    }

    public static String ST_AsHexEWKB(byte[] wkb) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < wkb.length; ++i) {
            sb.append(Integer.toString((wkb[i] & 0xFF) + 256, 16).substring(1));
        }
        return sb.toString();
    }

    public static String ST_GeoHash(byte[] wkb) {
        if (wkb == null) {
            return null;
        }
        Geometry g = GeoDB.gFromWKB(wkb);
        Envelope e = g.getEnvelopeInternal();
        GeoString gs1 = new GeoString(e.getMinX(), e.getMinY());
        GeoString gs2 = new GeoString(e.getMaxX(), e.getMaxY());
        return gs1.union(gs2).toString();
    }

    public static byte[] ST_GeomFromEWKB(byte[] wkb) {
        return GeoDB.gToWKB(GeoDB.gFromWKB(wkb));
    }

    public static byte[] ST_GeomFromEWKT(String wkt) {
        if (wkt == null) {
            return null;
        }
        return GeoDB.gToWKB(GeoDB.gFromEWKT(wkt));
    }

    public static byte[] ST_GeomFromText(String wkt, int srid) {
        if (wkt == null) {
            return null;
        }
        Geometry g = GeoDB.gFromWKT(wkt, srid);
        return GeoDB.gToWKB(g);
    }

    public static byte[] ST_GeomFromWKB(byte[] wkb, int srid) {
        if (wkb == null) {
            return null;
        }
        try {
            Geometry g = GeoDB.wkbreader().read(wkb);
            g.setSRID(srid);
            return GeoDB.gToWKB(g);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static byte[] ST_MakePoint(double x, double y) {
        return GeoDB.gToWKB((Geometry)gfactory.createPoint(new Coordinate(x, y)));
    }

    public static byte[] ST_MakeBox2D(byte[] wkb1, byte[] wkb2) {
        if (wkb1 == null || wkb2 == null) {
            return null;
        }
        Point p1 = (Point)GeoDB.gFromWKB(wkb1);
        Point p2 = (Point)GeoDB.gFromWKB(wkb1);
        return GeoDB.ST_MakeBox2D(p1.getX(), p1.getY(), p2.getX(), p2.getY());
    }

    public static byte[] ST_MakeBox2D(double x1, double y1, double x2, double y2) {
        return GeoDB.envToWKB(x1, y1, x2, y2);
    }

    public static String GeometryType(byte[] wkb) {
        if (wkb == null) {
            return null;
        }
        Geometry g = GeoDB.gFromWKB(wkb);
        return g.getGeometryType().toUpperCase();
    }

    public static Envelope ST_Envelope(byte[] wkb) {
        if (wkb == null) {
            return null;
        }
        return GeoDB.gFromWKB(wkb).getEnvelopeInternal();
    }

    public static String EnvelopeAsText(byte[] wkb) {
        Envelope env = GeoDB.ST_Envelope(wkb);
        if (env == null) {
            return null;
        }
        return "(" + env.getMinX() + "," + env.getMinY() + "," + env.getMaxX() + "," + env.getMaxY() + ")";
    }

    public static int ST_SRID(byte[] wkb) {
        if (wkb == null) {
            return -1;
        }
        Geometry g = GeoDB.gFromWKB(wkb);
        return g.getSRID();
    }

    public static boolean ST_IsValid(byte[] wkb) {
        if (wkb == null) {
            return false;
        }
        Geometry g = GeoDB.gFromWKB(wkb);
        return g.isValid();
    }

    public static boolean ST_IsSimple(byte[] wkb) {
        if (wkb == null) {
            return false;
        }
        Geometry g = GeoDB.gFromWKB(wkb);
        return g.isSimple();
    }

    public static boolean ST_IsEmpty(byte[] wkb) {
        if (wkb == null) {
            return false;
        }
        Geometry g = GeoDB.gFromWKB(wkb);
        return g.isEmpty();
    }

    public static double ST_X(byte[] wkb) {
        Geometry g = GeoDB.gFromWKB(wkb);
        return g.getCoordinate().x;
    }

    public static double ST_Y(byte[] wkb) {
        Geometry g = GeoDB.gFromWKB(wkb);
        return g.getCoordinate().y;
    }

    public static byte[] ST_SetSRID(byte[] wkb, int srid) {
        if (wkb == null) {
            return null;
        }
        Geometry g = GeoDB.gFromWKB(wkb);
        g.setSRID(srid);
        return GeoDB.gToWKB(g);
    }

    public static double ST_Area(byte[] wkb) {
        if (wkb == null) {
            return -1.0;
        }
        Geometry g = GeoDB.gFromWKB(wkb);
        return g.getArea();
    }

    public static boolean ST_BBox(byte[] b1, byte[] b2) {
        if (b1 == null || b2 == null) {
            return false;
        }
        Envelope e1 = GeoDB.envFromWKB(b1);
        Envelope e2 = GeoDB.envFromWKB(b2);
        return e1.intersects(e2);
    }

    public static byte[] ST_Centroid(byte[] wkb) {
        if (wkb == null) {
            return null;
        }
        Geometry g = GeoDB.gFromWKB(wkb);
        return GeoDB.gToWKB((Geometry)g.getCentroid());
    }

    public static boolean ST_Crosses(byte[] wkb1, byte[] wkb2) {
        if (wkb1 == null || wkb2 == null) {
            return false;
        }
        Geometry g1 = GeoDB.gFromWKB(wkb1);
        Geometry g2 = GeoDB.gFromWKB(wkb2);
        return g1.crosses(g2);
    }

    public static boolean ST_Contains(byte[] wkb1, byte[] wkb2) {
        if (wkb1 == null || wkb2 == null) {
            return false;
        }
        Geometry g1 = GeoDB.gFromWKB(wkb1);
        Geometry g2 = GeoDB.gFromWKB(wkb2);
        return g1.contains(g2);
    }

    public static boolean ST_Disjoint(byte[] wkb1, byte[] wkb2) {
        if (wkb1 == null || wkb2 == null) {
            return false;
        }
        Geometry g1 = GeoDB.gFromWKB(wkb1);
        Geometry g2 = GeoDB.gFromWKB(wkb2);
        return g1.disjoint(g2);
    }

    public static double ST_Distance(byte[] wkb1, byte[] wkb2) {
        if (wkb1 == null || wkb2 == null) {
            return -1.0;
        }
        Geometry g1 = GeoDB.gFromWKB(wkb1);
        Geometry g2 = GeoDB.gFromWKB(wkb2);
        return g1.distance(g2);
    }

    public static boolean ST_DWithin(byte[] wkb1, byte[] wkb2, double distance) {
        Geometry g2;
        if (wkb1 == null || wkb2 == null) {
            return false;
        }
        Geometry g1 = GeoDB.gFromWKB(wkb1);
        return g1.distance(g2 = GeoDB.gFromWKB(wkb2)) <= distance;
    }

    public static boolean ST_Equals(byte[] wkb1, byte[] wkb2) {
        if (wkb1 == null || wkb2 == null) {
            return false;
        }
        Geometry g1 = GeoDB.gFromWKB(wkb1);
        Geometry g2 = GeoDB.gFromWKB(wkb2);
        return g1.equals(g2);
    }

    public static boolean ST_Intersects(byte[] wkb1, byte[] wkb2) {
        if (wkb1 == null || wkb2 == null) {
            return false;
        }
        Geometry g1 = GeoDB.gFromWKB(wkb1);
        Geometry g2 = GeoDB.gFromWKB(wkb2);
        return g1.intersects(g2);
    }

    public static boolean ST_Overlaps(byte[] wkb1, byte[] wkb2) {
        if (wkb1 == null || wkb2 == null) {
            return false;
        }
        Geometry g1 = GeoDB.gFromWKB(wkb1);
        Geometry g2 = GeoDB.gFromWKB(wkb2);
        return g1.overlaps(g2);
    }

    public static boolean ST_Touches(byte[] wkb1, byte[] wkb2) {
        if (wkb1 == null || wkb2 == null) {
            return false;
        }
        Geometry g1 = GeoDB.gFromWKB(wkb1);
        Geometry g2 = GeoDB.gFromWKB(wkb2);
        return g1.touches(g2);
    }

    public static boolean ST_Within(byte[] wkb1, byte[] wkb2) {
        if (wkb1 == null || wkb2 == null) {
            return false;
        }
        Geometry g1 = GeoDB.gFromWKB(wkb1);
        Geometry g2 = GeoDB.gFromWKB(wkb2);
        return g1.within(g2);
    }

    public static byte[] ST_Buffer(byte[] wkb, double distance) {
        if (wkb == null) {
            return null;
        }
        Geometry g = GeoDB.gFromWKB(wkb);
        return GeoDB.gToWKB(g.buffer(distance));
    }

    public static byte[] ST_Simplify(byte[] wkb, double tol) {
        if (wkb == null) {
            return null;
        }
        Geometry g = GeoDB.gFromWKB(wkb);
        return GeoDB.gToWKB(DouglasPeuckerSimplifier.simplify((Geometry)g, (double)tol));
    }

    public static Integer ST_Dimension(byte[] wkb) {
        Geometry geometry = GeoDB.gFromWKB(wkb);
        if (geometry != null) {
            return geometry.getDimension();
        }
        return null;
    }

    public static byte[] ST_Boundary(byte[] wkb) {
        Geometry boundary;
        Geometry geometry = GeoDB.gFromWKB(wkb);
        if (geometry != null && (boundary = geometry.getBoundary()) != null) {
            return GeoDB.gToWKB(boundary);
        }
        return null;
    }

    public static boolean ST_Relate(byte[] wkb1, byte[] wkb2, String intersectionPattern) {
        Geometry geometry1 = GeoDB.gFromWKB(wkb1);
        Geometry geometry2 = GeoDB.gFromWKB(wkb1);
        if (geometry1 != null && geometry2 != null) {
            return geometry1.relate(geometry2, intersectionPattern);
        }
        return false;
    }

    public static String ST_Relate(byte[] wkb1, byte[] wkb2) {
        Geometry geometry1 = GeoDB.gFromWKB(wkb1);
        Geometry geometry2 = GeoDB.gFromWKB(wkb1);
        if (geometry1 != null && geometry2 != null) {
            IntersectionMatrix result = geometry1.relate(geometry2);
            return result.toString();
        }
        return null;
    }

    public static byte[] ST_ConvexHull(byte[] wkb) {
        Geometry boundary;
        Geometry geometry = GeoDB.gFromWKB(wkb);
        if (geometry != null && (boundary = geometry.convexHull()) != null) {
            return GeoDB.gToWKB(boundary);
        }
        return null;
    }

    public static byte[] ST_Difference(byte[] wkb1, byte[] wkb2) {
        if (wkb1 == null) {
            return null;
        }
        if (wkb2 == null) {
            return wkb1;
        }
        Geometry geometry1 = GeoDB.gFromWKB(wkb1);
        Geometry geometry2 = GeoDB.gFromWKB(wkb2);
        if (geometry1 == null) {
            return null;
        }
        if (geometry2 == null) {
            return wkb1;
        }
        return GeoDB.gToWKB(geometry1.difference(geometry2));
    }

    public static byte[] ST_Intersection(byte[] wkb1, byte[] wkb2) {
        if (wkb1 == null || wkb2 == null) {
            return null;
        }
        Geometry geometry1 = GeoDB.gFromWKB(wkb1);
        Geometry geometry2 = GeoDB.gFromWKB(wkb2);
        if (geometry1 == null || geometry2 == null) {
            return null;
        }
        return GeoDB.gToWKB(geometry1.intersection(geometry2));
    }

    public static byte[] ST_SymDifference(byte[] wkb1, byte[] wkb2) {
        if (wkb1 == null) {
            return wkb2;
        }
        if (wkb2 == null) {
            return wkb1;
        }
        Geometry geometry1 = GeoDB.gFromWKB(wkb1);
        Geometry geometry2 = GeoDB.gFromWKB(wkb2);
        if (geometry1 == null) {
            return GeoDB.gToWKB(geometry2);
        }
        if (geometry2 == null) {
            return GeoDB.gToWKB(geometry1);
        }
        return GeoDB.gToWKB(geometry1.symDifference(geometry2));
    }

    public static byte[] ST_Union(byte[] wkb1, byte[] wkb2) {
        if (wkb1 == null) {
            return wkb2;
        }
        if (wkb2 == null) {
            return wkb1;
        }
        Geometry geometry1 = GeoDB.gFromWKB(wkb1);
        Geometry geometry2 = GeoDB.gFromWKB(wkb2);
        if (geometry1 == null) {
            return GeoDB.gToWKB(geometry2);
        }
        if (geometry2 == null) {
            return GeoDB.gToWKB(geometry1);
        }
        return GeoDB.gToWKB(geometry1.union(geometry2));
    }

    public static void CreateSpatialIndex(Connection cx, String schemaName, String tableName, String columnName, String srid) throws SQLException {
        HashMap<String, String> args = new HashMap<String, String>();
        if (schemaName == null) {
            schemaName = "PUBLIC";
        }
        args.put("s", schemaName);
        args.put("t", tableName);
        args.put("geom", columnName);
        args.put("srid", srid);
        try {
            CmdLine.spatialize((Connection)cx, args);
            Proc.buildIndex((Connection)cx, (String)schemaName, (String)tableName, (int)10000, null);
        }
        catch (Exception e) {
            throw (SQLException)new SQLException("Error creating spatial index").initCause(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void CreateSpatialIndex_GeoHash(Connection cx, String schemaName, String tableName, String columnName) throws SQLException {
        schemaName = "".equals(schemaName) ? null : schemaName;
        Statement st = cx.createStatement();
        try {
            String table = "\"" + tableName + "\"";
            table = schemaName != null ? "\"" + schemaName + "\"." + table : table;
            String column = "\"_" + columnName + "_GEOHASH\"";
            String sql = "ALTER TABLE " + table + " ADD " + column + " VARCHAR";
            st.execute(sql);
            sql = "UPDATE " + table + " SET " + column + " = ST_GeoHash(\"" + columnName + "\")";
            st.execute(sql);
            sql = "CREATE INDEX \"_" + columnName + "_GEOHASH_INDEX\" ON " + table + "(" + column + ")";
            st.execute(sql);
        }
        finally {
            st.close();
        }
    }

    public static void DropSpatialIndex(Connection cx, String schemaName, String tableName) throws SQLException {
        HashMap<String, String> args = new HashMap<String, String>();
        if (schemaName == null) {
            schemaName = "PUBLIC";
        }
        args.put("s", schemaName);
        args.put("t", tableName);
        try {
            CmdLine.deSpatialize((Connection)cx, args);
        }
        catch (Exception e) {
            throw (SQLException)new SQLException("Error dropping spatial index").initCause(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int GetSRID(Connection cx, String schemaName, String tableName) throws SQLException {
        block15: {
            int n;
            DatabaseMetaData dbmd = cx.getMetaData();
            ResultSet tables = dbmd.getTables(null, schemaName, tableName + "_HATBOX", new String[]{"TABLE"});
            try {
                if (!tables.next()) {
                    int n2 = -1;
                    return n2;
                }
            }
            finally {
                tables.close();
            }
            String table = "";
            if (schemaName != null) {
                table = table + "\"" + schemaName + "\".";
            }
            table = table + "\"" + tableName + "_HATBOX\"";
            PreparedStatement ps = cx.prepareStatement("SELECT NODE_DATA FROM " + table + " WHERE ID = 1");
            try {
                ResultSet rs = ps.executeQuery();
                try {
                    if (!rs.next()) break block15;
                    MetaNode md = new MetaNode(rs.getBytes(1));
                    n = md.getSrid();
                }
                finally {
                    rs.close();
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
                return -1;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            ps.close();
            return n;
        }
        return -1;
    }

    public static byte[] gToWKB(Geometry g) {
        return GeoDB.wkbwriter().write(g);
    }

    public static byte[] gToEWKB(Geometry g) {
        try {
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            GeoDB.wkbwriter().write(g, (OutStream)new OutputStreamOutStream((OutputStream)bytes));
            byte[] b = bytes.toByteArray();
            byte[] ewkb = PRE_JTS12 ? new byte[32 + b.length + 4] : new byte[32 + b.length];
            Envelope bbox = g.getEnvelopeInternal();
            GeoDB.envToWKB(bbox, ewkb, 0);
            if (PRE_JTS12) {
                System.arraycopy(b, 0, ewkb, 32, 5);
                ewkb[33] = (byte)(ewkb[33] | 0x20);
                int srid = g.getSRID();
                ewkb[37] = (byte)(srid >>> 24);
                ewkb[38] = (byte)(srid >> 16 & 0xFF);
                ewkb[39] = (byte)(srid >> 8 & 0xFF);
                ewkb[40] = (byte)(srid & 0xFF);
                System.arraycopy(b, 5, ewkb, 41, b.length - 5);
            } else {
                System.arraycopy(b, 0, ewkb, 32, b.length);
            }
            return ewkb;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static Geometry gFromWKB(byte[] wkb) {
        return GeoDB.gFromWKB(wkb, GeoDB.wkbreader());
    }

    public static Geometry gFromWKB(byte[] wkb, WKBReader wkbreader) {
        try {
            return wkbreader.read(wkb);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public static Geometry gFromEWKB(byte[] wkb) {
        return GeoDB.gFromEWKB(wkb, GeoDB.wkbreader());
    }

    public static Geometry gFromEWKB(byte[] wkb, WKBReader wkbreader) {
        try {
            return wkbreader.read((InStream)new InputStreamInStream((InputStream)new ByteArrayInputStream(wkb, 32, wkb.length - 32)));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] envToWKB(Envelope e) {
        return GeoDB.envToWKB(e.getMinX(), e.getMinY(), e.getMaxX(), e.getMaxY());
    }

    public static byte[] envToWKB(double x1, double y1, double x2, double y2) {
        return GeoDB.envToWKB(x1, y1, x2, y2, new byte[32], 0);
    }

    public static byte[] envToWKB(Envelope e, byte[] wkb, int pos) {
        return GeoDB.envToWKB(e.getMinX(), e.getMinY(), e.getMaxX(), e.getMaxY(), wkb, pos);
    }

    public static byte[] envToWKB(double x1, double y1, double x2, double y2, byte[] wkb, int pos) {
        GeoDB.doubleToBytes(wkb, pos, x1);
        GeoDB.doubleToBytes(wkb, 8, y1);
        GeoDB.doubleToBytes(wkb, 16, x2);
        GeoDB.doubleToBytes(wkb, 24, y2);
        return wkb;
    }

    public static Envelope envFromWKB(byte[] wkb) {
        try {
            return GeoDB.wkbreader().read(wkb).getEnvelopeInternal();
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    static void doubleToBytes(byte[] b, int pos, double d) {
        long l = Double.doubleToRawLongBits(d);
        b[pos] = (byte)(l >>> 56);
        b[pos + 1] = (byte)(l >> 48 & 0xFFL);
        b[pos + 2] = (byte)(l >> 40 & 0xFFL);
        b[pos + 3] = (byte)(l >> 32 & 0xFFL);
        b[pos + 4] = (byte)(l >> 24 & 0xFFL);
        b[pos + 5] = (byte)(l >> 16 & 0xFFL);
        b[pos + 6] = (byte)(l >> 8 & 0xFFL);
        b[pos + 7] = (byte)(l & 0xFFL);
    }

    static double bytesToDouble(byte[] b, int pos) {
        long l = (long)(0xFF & b[pos]) << 56 | (long)(0xFF & b[pos + 1]) << 48 | (long)(0xFF & b[pos + 2]) << 40 | (long)(0xFF & b[pos + 3]) << 32 | (long)(0xFF & b[pos + 4]) << 24 | (long)(0xFF & b[pos + 5]) << 16 | (long)(0xFF & b[pos + 6]) << 8 | (long)(0xFF & b[pos + 7]) << 0;
        return Double.longBitsToDouble(l);
    }

    public static Geometry gFromWKT(String wkt, int srid) {
        try {
            Geometry g = GeoDB.wktreader().read(wkt);
            g.setSRID(srid);
            return g;
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static String gToWKT(Geometry g) {
        return g.toText();
    }

    public static Geometry gFromEWKT(String wkt) {
        wkt = wkt.toUpperCase();
        int srid = -1;
        if (wkt.startsWith("SRID=")) {
            int semi = wkt.indexOf(59);
            if (semi == -1) {
                throw new IllegalArgumentException("Could not read EWKT format, should be 'SRID=<srid>;<WKT>'");
            }
            String s = wkt.substring(0, semi);
            srid = Integer.parseInt(s.substring(5, s.length()));
            wkt = wkt.substring(s.length() + 1);
        }
        return GeoDB.gFromWKT(wkt, srid);
    }

    public static String gToEWKT(Geometry g) {
        return "SRID=" + g.getSRID() + ";" + g.toText();
    }

    private static Geometry fromWKB(byte[] wkb) {
        try {
            ByteArrayInputStream bytes = new ByteArrayInputStream(wkb, 0, wkb.length - 4);
            Geometry g = new WKBReader().read((InStream)new InputStreamInStream((InputStream)bytes));
            int srid = 0;
            srid |= wkb[wkb.length - 4] & 0xFF;
            srid <<= 8;
            srid |= wkb[wkb.length - 3] & 0xFF;
            srid <<= 8;
            srid |= wkb[wkb.length - 2] & 0xFF;
            srid <<= 8;
            g.setSRID(srid |= wkb[wkb.length - 1] & 0xFF);
            return g;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static byte[] toWKB(Geometry g) {
        try {
            WKBWriter w = new WKBWriter();
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            w.write(g, (OutStream)new OutputStreamOutStream((OutputStream)bytes));
            int srid = g.getSRID();
            bytes.write((byte)(srid >>> 24));
            bytes.write((byte)(srid >> 16 & 0xFF));
            bytes.write((byte)(srid >> 8 & 0xFF));
            bytes.write((byte)(srid & 0xFF));
            return bytes.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static String tbl(String schema, String table) {
        return schema != null ? GeoDB.esc(schema) + "." + GeoDB.esc(table) : GeoDB.esc(table);
    }

    static String esc(String s) {
        return "\"" + s + "\"";
    }

    static String str(String s) {
        return "'" + s + "'";
    }

    static String geotypeConstraint(String schema, String table, String column) {
        String name = table + "_" + column;
        if (schema != null) {
            name = schema + "_" + name;
        }
        return "ENFORCE_GEOTYPE_" + name;
    }

    static {
        CmdLine.LOGGER.setLevel(Level.WARNING);
        gfactory = new GeometryFactory();
        boolean pre = false;
        try {
            new WKBWriter(3, true);
        }
        catch (NoSuchMethodError e) {
            pre = true;
        }
        PRE_JTS12 = pre;
    }
}

