/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.netcdf;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.config.impl.GeoServerLifecycleHandler;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.GeoServerResourceLoader;
import org.geoserver.platform.resource.FileSystemResourceStore;
import org.geoserver.platform.resource.Resource;
import org.geotools.imageio.netcdf.NetCDFUnitFormat;
import org.geotools.imageio.netcdf.utilities.NetCDFUtilities;
import org.geotools.util.logging.Logging;

public class NetCDFUnitsConfigurator
implements GeoServerLifecycleHandler {
    static final Logger LOGGER = Logging.getLogger(NetCDFUnitsConfigurator.class);
    public static String NETCDF_UNIT_ALIASES = "NETCDF_UNIT_ALIASES";
    public static String NETCDF_UNIT_REPLACEMENTS = "NETCDF_UNIT_REPLACEMENTS";
    private final GeoServerResourceLoader resourceLoader;

    public NetCDFUnitsConfigurator(GeoServerResourceLoader resourceLoader) throws IOException {
        this.resourceLoader = resourceLoader;
        this.configure();
    }

    private void configure() {
        try {
            LinkedHashMap<String, String> aliases = this.getMapResource(NETCDF_UNIT_ALIASES, "netcdf-unit-aliases.properties");
            if (aliases != null) {
                NetCDFUnitFormat.setAliases(aliases);
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Failed to load NetCDF unit aliases", e);
        }
        try {
            LinkedHashMap<String, String> replacements = this.getMapResource(NETCDF_UNIT_REPLACEMENTS, "netcdf-unit-replacements.properties");
            if (replacements != null) {
                NetCDFUnitFormat.setReplacements(replacements);
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Failed to load NetCDF unit replacements", e);
        }
    }

    private LinkedHashMap<String, String> getMapResource(String absolutePathProperty, String defaultFileName) throws IOException {
        Resource aliasResource = this.getResource(absolutePathProperty, defaultFileName);
        if (aliasResource != null) {
            try (InputStream is = aliasResource.in();){
                LinkedHashMap linkedHashMap = NetCDFUnitFormat.loadPropertiesOrdered((InputStream)is);
                return linkedHashMap;
            }
        }
        return null;
    }

    private Resource getResource(String absolutePathProperty, String defaultFileName) {
        String source = GeoServerExtensions.getProperty((String)absolutePathProperty);
        Resource resource = this.getResourceForPath(source);
        if (resource == null && NetCDFUtilities.EXTERNAL_DATA_DIR != null) {
            source = new File(NetCDFUtilities.EXTERNAL_DATA_DIR, defaultFileName).getPath();
            resource = this.getResourceForPath(source);
        }
        if (resource == null && (resource = this.resourceLoader.get("netcdf-unit-aliases.properties")).getType() != Resource.Type.RESOURCE) {
            resource = null;
        }
        return resource;
    }

    private Resource getResourceForPath(String path) {
        Resource resource = null;
        if (path != null) {
            File resourceFile = new File(path);
            if (resourceFile.exists()) {
                FileSystemResourceStore store = new FileSystemResourceStore(resourceFile.getParentFile());
                resource = store.get(resourceFile.getName());
            } else {
                LOGGER.fine("Could not locate " + path + ", moving on");
            }
        }
        return resource;
    }

    public void onReset() {
        NetCDFUtilities.clearCaches();
        this.configure();
    }

    public void onDispose() {
    }

    public void beforeReload() {
        NetCDFUtilities.clearCaches();
        this.configure();
    }

    public void onReload() {
    }
}

