/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.netcdf;

import java.util.Optional;
import org.geoserver.platform.ModuleStatus;
import org.geotools.imageio.netcdf.utilities.NetCDFUtilities;
import org.geotools.util.Version;
import org.geotools.util.factory.GeoTools;
import ucar.nc2.jni.netcdf.Nc4prototypes;

public class NetCDFStatus
implements ModuleStatus {
    public String getModule() {
        return "gs-netcdf";
    }

    public Optional<String> getComponent() {
        return Optional.ofNullable("GridCoverageMultiDimReader");
    }

    public String getName() {
        return "NetCDF Coverage format";
    }

    public Optional<String> getVersion() {
        Version v = GeoTools.getVersion(NetCDFUtilities.class);
        if (v == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(v.toString());
    }

    public boolean isAvailable() {
        return true;
    }

    public boolean isEnabled() {
        return true;
    }

    public Optional<String> getMessage() {
        String message = "NETCDF-4 Binary Available: " + NetCDFUtilities.isNC4CAvailable();
        message = message + "\nNc4prototypes Version: " + GeoTools.getVersion(Nc4prototypes.class);
        return Optional.ofNullable(message);
    }

    public Optional<String> getDocumentation() {
        return Optional.ofNullable("");
    }
}

