/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.io.netcdf.crs;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.measure.Unit;
import javax.measure.quantity.Length;
import org.geotools.api.parameter.ParameterValueGroup;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.crs.CRSAuthorityFactory;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.datum.Ellipsoid;
import org.geotools.coverage.io.netcdf.crs.NetCDFCRSAuthorityFactory;
import org.geotools.coverage.io.netcdf.crs.ProjectionBuilder;
import org.geotools.imageio.netcdf.utilities.NetCDFUtilities;
import org.geotools.referencing.CRS;
import org.geotools.referencing.ReferencingFactoryFinder;
import si.uom.SI;
import ucar.nc2.Attribute;
import ucar.nc2.Variable;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.unidata.geoloc.LatLonPointImpl;

public class NetCDFProjection {
    private static List<CRSAuthorityFactory> crsFactories = new LinkedList<CRSAuthorityFactory>();
    public static final String PARAMS_SEPARATOR = "#";
    private static final Logger LOGGER = Logger.getLogger(NetCDFProjection.class.toString());
    private Map<String, String> netCDFParametersMapping;
    private String name;
    private String ogcName;
    public static final NetCDFProjection ALBERS_EQUAL_AREA;
    public static final NetCDFProjection MERCATOR_1SP;
    public static final NetCDFProjection MERCATOR_2SP;
    public static final NetCDFProjection LAMBERT_AZIMUTHAL_EQUAL_AREA;
    public static final NetCDFProjection TRANSVERSE_MERCATOR;
    public static final NetCDFProjection ORTHOGRAPHIC;
    public static final NetCDFProjection POLAR_STEREOGRAPHIC;
    public static final NetCDFProjection STEREOGRAPHIC;
    public static final NetCDFProjection LAMBERT_CONFORMAL_CONIC_1SP;
    public static final NetCDFProjection LAMBERT_CONFORMAL_CONIC_2SP;
    public static final NetCDFProjection ROTATED_POLE;
    private static final Map<String, NetCDFProjection> supportedProjections;

    public NetCDFProjection(String projectionName, String ogcName, Map<String, String> parametersMapping) {
        this.name = projectionName;
        this.ogcName = ogcName;
        this.netCDFParametersMapping = Collections.unmodifiableMap(parametersMapping);
    }

    public Map<String, String> getParameters() {
        return this.netCDFParametersMapping;
    }

    public String getName() {
        return this.name;
    }

    public String getOGCName() {
        return this.ogcName;
    }

    public ParameterValueGroup getOgcParameters(ParameterValueGroup netcdfParameters) {
        return netcdfParameters;
    }

    public ParameterValueGroup getNetcdfParameters(ParameterValueGroup ogcParameters) {
        return ogcParameters;
    }

    public static NetCDFProjection getSupportedProjection(String projectionName) {
        if (supportedProjections.containsKey(projectionName)) {
            return supportedProjections.get(projectionName);
        }
        LOGGER.severe("The specified projection isn't currently supported: " + projectionName);
        return null;
    }

    public static CoordinateReferenceSystem parseProjection(Variable var) throws FactoryException {
        return NetCDFProjection.parseProjection(var, CRSParser.getCRSParser(var));
    }

    public static CoordinateReferenceSystem parseProjection(Variable var, CRSParser crsParser) throws FactoryException {
        return NetCDFProjection.parseProjection(var, crsParser, Collections.emptyMap());
    }

    public static CoordinateReferenceSystem parseProjection(Variable var, CRSParser crsParser, Map<String, Object> crsProperties) throws FactoryException {
        if (crsParser == null) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("No referencing attributes have been found.\n Unable to parse a CF projection from this variable.\nThis probably means that is WGS84 or unsupported");
            }
            return null;
        }
        return crsParser.parseCoordinateReferenceSystem(var, crsProperties);
    }

    private static void handleParam(Map<String, String> parametersMapping, ParameterValueGroup ogcParameters, String ogcParameterKey, Variable var) {
        String netCDFattributeName = NetCDFProjection.getInputAttribute(parametersMapping.get(ogcParameterKey));
        Double value = null;
        if (ogcParameterKey.equalsIgnoreCase(NetCDFUtilities.STANDARD_PARALLEL_1) || ogcParameterKey.equalsIgnoreCase(NetCDFUtilities.STANDARD_PARALLEL_2)) {
            Attribute attribute = var.findAttribute(netCDFattributeName);
            if (attribute != null) {
                int numValues = attribute.getLength();
                if (numValues > 1) {
                    int index = ogcParameterKey.equalsIgnoreCase(NetCDFUtilities.STANDARD_PARALLEL_1) ? 0 : 1;
                    Number number = (Number)attribute.getValue(index);
                    value = number.doubleValue();
                } else {
                    value = attribute.getNumericValue().doubleValue();
                }
            }
        } else {
            Attribute attribute = var.findAttribute(netCDFattributeName);
            if (attribute != null) {
                value = attribute.getNumericValue().doubleValue();
                if (netCDFattributeName.contains("meridian") || netCDFattributeName.contains("longitude")) {
                    value = value - 360.0 * Math.floor(value / 360.0 + 0.5);
                }
            }
        }
        if (value != null) {
            ogcParameters.parameter(ogcParameterKey).setValue(value);
        }
    }

    private static String getInputAttribute(String cfParam) {
        if (cfParam != null) {
            return cfParam.contains(PARAMS_SEPARATOR) ? cfParam.split(PARAMS_SEPARATOR)[0] : cfParam;
        }
        return null;
    }

    private static Ellipsoid buildEllipsoid(Variable gridMappingVariable, Unit<Length> linearUnit) {
        Attribute semiMinorAxisAttribute;
        Number semiMajorAxis = null;
        Number semiMinorAxis = null;
        Double inverseFlattening = Double.NEGATIVE_INFINITY;
        HashMap<String, Number> ellipsoidParams = new HashMap<String, Number>();
        Attribute semiMajorAxisAttribute = gridMappingVariable.findAttribute("semi_major_axis");
        if (semiMajorAxisAttribute != null) {
            semiMajorAxis = semiMajorAxisAttribute.getNumericValue();
            ellipsoidParams.put(NetCDFUtilities.SEMI_MAJOR, semiMajorAxis);
        }
        if (semiMajorAxis == null && (semiMajorAxisAttribute = gridMappingVariable.findAttribute("earth_radius")) != null) {
            semiMajorAxis = semiMajorAxisAttribute.getNumericValue();
            ellipsoidParams.put(NetCDFUtilities.SEMI_MAJOR, semiMajorAxis);
        }
        if ((semiMinorAxisAttribute = gridMappingVariable.findAttribute("semi_minor_axis")) != null) {
            semiMinorAxis = semiMinorAxisAttribute.getNumericValue();
            ellipsoidParams.put(NetCDFUtilities.SEMI_MINOR, semiMinorAxis);
        }
        if (semiMinorAxis == null) {
            Attribute inverseFlatteningAttribute = gridMappingVariable.findAttribute("inverse_flattening");
            if (inverseFlatteningAttribute != null) {
                inverseFlattening = inverseFlatteningAttribute.getNumericValue().doubleValue();
            }
            ellipsoidParams.put("inverse_flattening", inverseFlattening);
        }
        return ProjectionBuilder.createEllipsoid("unknown", ellipsoidParams);
    }

    private static String getProjectionName(String mappingName, Variable var) {
        Object projectionName = mappingName;
        if (mappingName.equalsIgnoreCase("lambert_conformal_conic")) {
            Attribute standardParallel = var.findAttribute("standard_parallel");
            projectionName = "lambert_conformal_conic" + (standardParallel.getLength() == 1 ? "_1SP" : "_2SP");
        } else if (mappingName.equalsIgnoreCase("mercator")) {
            Attribute standardParallel = var.findAttribute("standard_parallel");
            projectionName = "mercator" + (standardParallel == null ? "_2SP" : "_1SP");
        }
        return projectionName;
    }

    public static CoordinateReferenceSystem parseProjection(NetcdfDataset dataset) {
        Attribute attribute = dataset.findAttribute("spatial_ref");
        return CRSParser.parseWKT(attribute);
    }

    public static CoordinateReferenceSystem lookupForCustomEpsg(CoordinateReferenceSystem crs) throws FactoryException {
        if (!crsFactories.isEmpty()) {
            for (CRSAuthorityFactory crsFactory : crsFactories) {
                Set codes = crsFactory.getAuthorityCodes(CoordinateReferenceSystem.class);
                for (String code : codes) {
                    CoordinateReferenceSystem decodedCRS = CRS.decode((String)("EPSG:" + code));
                    if (!CRS.equalsIgnoreMetadata((Object)decodedCRS, (Object)crs)) continue;
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine("Found valid epsgCode for the custom CRS: " + code);
                    }
                    return decodedCRS;
                }
            }
        }
        return crs;
    }

    public static CoordinateReferenceSystem lookForVariableCRS(NetcdfDataset dataset, CoordinateReferenceSystem defaultCrs) throws FactoryException {
        return NetCDFProjection.lookForVariableCRS(dataset, defaultCrs, Collections.emptyMap());
    }

    public static CoordinateReferenceSystem lookForVariableCRS(NetcdfDataset dataset, CoordinateReferenceSystem defaultCrs, Map<String, Object> crsProperties) throws FactoryException {
        List variables = dataset.getVariables();
        CoordinateReferenceSystem crs = defaultCrs;
        for (Variable variable : variables) {
            CRSParser attrib = CRSParser.getCRSParser(variable);
            if (attrib == null) continue;
            crs = NetCDFProjection.parseProjection(variable, attrib, crsProperties);
            if (!LOGGER.isLoggable(Level.FINE)) break;
            LOGGER.fine("Detected NetCDFProjection through gridMapping variable: " + (crs != null ? crs.toWKT() : "null"));
            break;
        }
        return crs;
    }

    public static CoordinateReferenceSystem lookForDatasetCRS(NetcdfDataset dataset) {
        CoordinateReferenceSystem projection = NetCDFProjection.parseProjection(dataset);
        if (projection != null && LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Detected NetCDFProjection through spatial_ref attribute: " + projection.toWKT());
        }
        return projection;
    }

    static {
        supportedProjections = new HashMap<String, NetCDFProjection>();
        HashMap<String, String> alberseq_mapping = new HashMap<String, String>();
        alberseq_mapping.put(NetCDFUtilities.CENTRAL_MERIDIAN, "longitude_of_central_meridian");
        alberseq_mapping.put(NetCDFUtilities.LATITUDE_OF_ORIGIN, "latitude_of_projection_origin");
        alberseq_mapping.put(NetCDFUtilities.STANDARD_PARALLEL_1, "standard_parallel");
        alberseq_mapping.put(NetCDFUtilities.STANDARD_PARALLEL_2, "standard_parallel");
        alberseq_mapping.put(NetCDFUtilities.FALSE_EASTING, "false_easting");
        alberseq_mapping.put(NetCDFUtilities.FALSE_NORTHING, "false_northing");
        ALBERS_EQUAL_AREA = new NetCDFProjection("albers_conical_equal_area", "Albers_Conic_Equal_Area", alberseq_mapping);
        HashMap<String, String> lazeq_mapping = new HashMap<String, String>();
        lazeq_mapping.put(NetCDFUtilities.CENTRAL_MERIDIAN, "longitude_of_projection_origin");
        lazeq_mapping.put(NetCDFUtilities.LATITUDE_OF_ORIGIN, "latitude_of_projection_origin");
        lazeq_mapping.put(NetCDFUtilities.FALSE_EASTING, "false_easting");
        lazeq_mapping.put(NetCDFUtilities.FALSE_NORTHING, "false_northing");
        LAMBERT_AZIMUTHAL_EQUAL_AREA = new NetCDFProjection("lambert_azimuthal_equal_area", "lambert_azimuthal_equal_area", lazeq_mapping);
        HashMap<String, String> tm_mapping = new HashMap<String, String>();
        tm_mapping.put(NetCDFUtilities.SCALE_FACTOR, "scale_factor_at_central_meridian");
        tm_mapping.put(NetCDFUtilities.CENTRAL_MERIDIAN, "longitude_of_central_meridian");
        tm_mapping.put(NetCDFUtilities.LATITUDE_OF_ORIGIN, "latitude_of_projection_origin");
        tm_mapping.put(NetCDFUtilities.FALSE_EASTING, "false_easting");
        tm_mapping.put(NetCDFUtilities.FALSE_NORTHING, "false_northing");
        TRANSVERSE_MERCATOR = new NetCDFProjection("transverse_mercator", "transverse_mercator", tm_mapping);
        HashMap<String, String> ortho_mapping = new HashMap<String, String>();
        ortho_mapping.put(NetCDFUtilities.CENTRAL_MERIDIAN, "longitude_of_projection_origin");
        ortho_mapping.put(NetCDFUtilities.LATITUDE_OF_ORIGIN, "latitude_of_projection_origin");
        ortho_mapping.put(NetCDFUtilities.FALSE_EASTING, "false_easting");
        ortho_mapping.put(NetCDFUtilities.FALSE_NORTHING, "false_northing");
        ORTHOGRAPHIC = new NetCDFProjection("orthographic", "orthographic", ortho_mapping);
        HashMap<String, String> polarstereo_mapping = new HashMap<String, String>();
        polarstereo_mapping.put(NetCDFUtilities.CENTRAL_MERIDIAN, "straight_vertical_longitude_from_pole");
        polarstereo_mapping.put(NetCDFUtilities.LATITUDE_OF_ORIGIN, "latitude_of_projection_origin");
        polarstereo_mapping.put(NetCDFUtilities.SCALE_FACTOR, "scale_factor_at_projection_origin");
        polarstereo_mapping.put(NetCDFUtilities.FALSE_EASTING, "false_easting");
        polarstereo_mapping.put(NetCDFUtilities.FALSE_NORTHING, "false_northing");
        POLAR_STEREOGRAPHIC = new NetCDFProjection("polar_stereographic", "polar_stereographic", polarstereo_mapping);
        HashMap<String, String> stereo_mapping = new HashMap<String, String>();
        stereo_mapping.put(NetCDFUtilities.CENTRAL_MERIDIAN, "longitude_of_projection_origin");
        stereo_mapping.put(NetCDFUtilities.LATITUDE_OF_ORIGIN, "latitude_of_projection_origin");
        stereo_mapping.put(NetCDFUtilities.SCALE_FACTOR, "scale_factor_at_projection_origin");
        stereo_mapping.put(NetCDFUtilities.FALSE_EASTING, "false_easting");
        stereo_mapping.put(NetCDFUtilities.FALSE_NORTHING, "false_northing");
        STEREOGRAPHIC = new NetCDFProjection("stereographic", "stereographic", stereo_mapping);
        HashMap<String, String> lcc_mapping = new HashMap<String, String>();
        lcc_mapping.put(NetCDFUtilities.CENTRAL_MERIDIAN, "longitude_of_central_meridian");
        lcc_mapping.put(NetCDFUtilities.LATITUDE_OF_ORIGIN, "latitude_of_projection_origin");
        lcc_mapping.put(NetCDFUtilities.FALSE_EASTING, "false_easting");
        lcc_mapping.put(NetCDFUtilities.FALSE_NORTHING, "false_northing");
        HashMap<String, String> lcc_1sp_mapping = new HashMap<String, String>();
        lcc_1sp_mapping.putAll(lcc_mapping);
        lcc_1sp_mapping.put(NetCDFUtilities.LATITUDE_OF_ORIGIN, "latitude_of_projection_origin#standard_parallel");
        LAMBERT_CONFORMAL_CONIC_1SP = new NetCDFProjection("lambert_conformal_conic", "lambert_conformal_conic_1SP", lcc_1sp_mapping);
        HashMap<String, String> lcc_2sp_mapping = new HashMap<String, String>();
        lcc_2sp_mapping.putAll(lcc_mapping);
        lcc_2sp_mapping.put(NetCDFUtilities.STANDARD_PARALLEL_1, "standard_parallel");
        lcc_2sp_mapping.put(NetCDFUtilities.STANDARD_PARALLEL_2, "standard_parallel");
        LAMBERT_CONFORMAL_CONIC_2SP = new NetCDFProjection("lambert_conformal_conic", "lambert_conformal_conic_2SP", lcc_2sp_mapping);
        HashMap<String, String> mercator_mapping = new HashMap<String, String>();
        mercator_mapping.put(NetCDFUtilities.CENTRAL_MERIDIAN, "longitude_of_central_meridian");
        mercator_mapping.put(NetCDFUtilities.LATITUDE_OF_ORIGIN, "latitude_of_projection_origin");
        mercator_mapping.put(NetCDFUtilities.FALSE_EASTING, "false_easting");
        mercator_mapping.put(NetCDFUtilities.FALSE_NORTHING, "false_northing");
        HashMap<String, String> mercator_1sp_mapping = new HashMap<String, String>();
        mercator_1sp_mapping.putAll(mercator_mapping);
        mercator_1sp_mapping.put(NetCDFUtilities.SCALE_FACTOR, "scale_factor_at_projection_origin");
        MERCATOR_1SP = new NetCDFProjection("mercator", "mercator_1SP", mercator_1sp_mapping);
        HashMap<String, String> mercator_2sp_mapping = new HashMap<String, String>();
        mercator_2sp_mapping.putAll(mercator_mapping);
        mercator_2sp_mapping.put(NetCDFUtilities.STANDARD_PARALLEL_1, "standard_parallel");
        MERCATOR_2SP = new NetCDFProjection("mercator", "mercator_2SP", mercator_2sp_mapping);
        HashMap<String, String> rotated_pole_mapping = new HashMap<String, String>();
        rotated_pole_mapping.put(NetCDFUtilities.CENTRAL_MERIDIAN, "grid_north_pole_longitude");
        rotated_pole_mapping.put(NetCDFUtilities.LATITUDE_OF_ORIGIN, "grid_north_pole_latitude");
        ROTATED_POLE = new NetCDFProjection("rotated_latitude_longitude", "Rotated_Pole", rotated_pole_mapping){

            @Override
            public ParameterValueGroup getOgcParameters(ParameterValueGroup netcdfParameters) {
                double lonNorthPole = (Double)netcdfParameters.parameter(NetCDFUtilities.CENTRAL_MERIDIAN).getValue();
                double latNorthPole = (Double)netcdfParameters.parameter(NetCDFUtilities.LATITUDE_OF_ORIGIN).getValue();
                if (latNorthPole >= 90.0 || latNorthPole <= 0.0) {
                    throw new RuntimeException("Unexpected north pole latitude: " + latNorthPole);
                }
                double lonOrigin = LatLonPointImpl.lonNormal((double)(lonNorthPole + 180.0));
                double latOrigin = 90.0 - latNorthPole;
                ParameterValueGroup ogcParameters = netcdfParameters.clone();
                ogcParameters.parameter(NetCDFUtilities.CENTRAL_MERIDIAN).setValue(lonOrigin);
                ogcParameters.parameter(NetCDFUtilities.LATITUDE_OF_ORIGIN).setValue(latOrigin);
                return ogcParameters;
            }

            @Override
            public ParameterValueGroup getNetcdfParameters(ParameterValueGroup ogcParameters) {
                double lonOrigin = (Double)ogcParameters.parameter(NetCDFUtilities.CENTRAL_MERIDIAN).getValue();
                double latOrigin = (Double)ogcParameters.parameter(NetCDFUtilities.LATITUDE_OF_ORIGIN).getValue();
                if (latOrigin >= 90.0 || latOrigin <= 0.0) {
                    throw new RuntimeException("Unexpected latitude of origin: " + latOrigin);
                }
                double lonNorthPole = LatLonPointImpl.lonNormal((double)(lonOrigin + 180.0));
                double latNorthPole = 90.0 - latOrigin;
                ParameterValueGroup netcdfParameters = ogcParameters.clone();
                netcdfParameters.parameter(NetCDFUtilities.CENTRAL_MERIDIAN).setValue(lonNorthPole);
                netcdfParameters.parameter(NetCDFUtilities.LATITUDE_OF_ORIGIN).setValue(latNorthPole);
                return netcdfParameters;
            }
        };
        supportedProjections.put("albers_conical_equal_area", ALBERS_EQUAL_AREA);
        supportedProjections.put("mercator_1SP", MERCATOR_1SP);
        supportedProjections.put("mercator_1SP", MERCATOR_2SP);
        supportedProjections.put(NetCDFProjection.TRANSVERSE_MERCATOR.name, TRANSVERSE_MERCATOR);
        supportedProjections.put("lambert_conformal_conic_1SP", LAMBERT_CONFORMAL_CONIC_1SP);
        supportedProjections.put("lambert_conformal_conic_2SP", LAMBERT_CONFORMAL_CONIC_2SP);
        supportedProjections.put(NetCDFProjection.LAMBERT_AZIMUTHAL_EQUAL_AREA.name, LAMBERT_AZIMUTHAL_EQUAL_AREA);
        supportedProjections.put(NetCDFProjection.ORTHOGRAPHIC.name, ORTHOGRAPHIC);
        supportedProjections.put(NetCDFProjection.POLAR_STEREOGRAPHIC.name, POLAR_STEREOGRAPHIC);
        supportedProjections.put(NetCDFProjection.STEREOGRAPHIC.name, STEREOGRAPHIC);
        supportedProjections.put(NetCDFProjection.ROTATED_POLE.name, ROTATED_POLE);
        for (CRSAuthorityFactory factory : ReferencingFactoryFinder.getCRSAuthorityFactories(null)) {
            CRSAuthorityFactory f = factory;
            if (!(f instanceof NetCDFCRSAuthorityFactory)) continue;
            crsFactories.add(f);
            if (!LOGGER.isLoggable(Level.INFO)) continue;
            LOGGER.info("NetCDF CRS Factory found: " + f);
        }
    }

    static abstract class CRSParser {
        protected Attribute attribute;

        private CRSParser(Attribute attribute) {
            this.attribute = attribute;
        }

        abstract CoordinateReferenceSystem parseCoordinateReferenceSystem(Variable var1, Map<String, Object> var2) throws FactoryException;

        private static CoordinateReferenceSystem parseWKT(Attribute wktAttribute) {
            CoordinateReferenceSystem crs;
            block3: {
                crs = null;
                if (wktAttribute != null) {
                    String wkt = wktAttribute.getStringValue();
                    try {
                        crs = CRS.parseWKT((String)wkt);
                    }
                    catch (FactoryException e) {
                        if (!LOGGER.isLoggable(Level.WARNING)) break block3;
                        LOGGER.warning("Unable to setup a CRS from the specified WKT: " + wkt);
                    }
                }
            }
            return crs;
        }

        public static CRSParser getCRSParser(Variable var) {
            if (var != null) {
                Attribute attr = null;
                attr = var.findAttribute("esri_pe_string");
                if (attr != null) {
                    return new WKTCRSParser(attr);
                }
                attr = var.findAttribute("spatial_ref");
                if (attr != null) {
                    return new WKTCRSParser(attr);
                }
                attr = var.findAttribute("grid_mapping_name");
                if (attr != null) {
                    return new GridMappingCRSParser(attr);
                }
            }
            return null;
        }

        static class GridMappingCRSParser
        extends CRSParser {
            public GridMappingCRSParser(Attribute attribute) {
                super(attribute);
            }

            @Override
            public CoordinateReferenceSystem parseCoordinateReferenceSystem(Variable var, Map<String, Object> crsProperties) throws FactoryException {
                String mappingName = this.attribute.getStringValue();
                String projectionName = NetCDFProjection.getProjectionName(mappingName, var);
                NetCDFProjection projection = supportedProjections.get(projectionName);
                if (projection == null) {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine("Unsupported grid_mapping_name: " + projectionName);
                    }
                    return null;
                }
                String ogcName = projection.getOGCName();
                ParameterValueGroup netcdfParameters = ProjectionBuilder.getDefaultparameters(ogcName);
                Map<String, String> paramsMapping = projection.getParameters();
                Set<String> keys = paramsMapping.keySet();
                for (String ogcParameterKey : keys) {
                    NetCDFProjection.handleParam(paramsMapping, netcdfParameters, ogcParameterKey, var);
                }
                HashMap<String, Object> map = new HashMap<String, Object>(crsProperties);
                map.put("name", projectionName);
                return ProjectionBuilder.buildCRS(map, projection.getOgcParameters(netcdfParameters), NetCDFProjection.buildEllipsoid(var, (Unit<Length>)SI.METRE));
            }
        }

        static class WKTCRSParser
        extends CRSParser {
            public WKTCRSParser(Attribute attribute) {
                super(attribute);
            }

            @Override
            public CoordinateReferenceSystem parseCoordinateReferenceSystem(Variable variable, Map<String, Object> crsProperties) {
                return CRSParser.parseWKT(this.attribute);
            }
        }
    }
}

