/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.io.netcdf;

import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.api.feature.type.Name;
import org.geotools.api.parameter.ParameterDescriptor;
import org.geotools.api.referencing.ReferenceIdentifier;
import org.geotools.api.util.ProgressListener;
import org.geotools.coverage.io.CoverageReadRequest;
import org.geotools.coverage.io.CoverageResponse;
import org.geotools.coverage.io.CoverageSource;
import org.geotools.coverage.io.impl.DefaultCoverageSource;
import org.geotools.coverage.io.netcdf.NetCDFRequest;
import org.geotools.coverage.io.netcdf.NetCDFResponse;
import org.geotools.imageio.netcdf.NetCDFImageReader;
import org.geotools.parameter.DefaultParameterDescriptor;
import org.geotools.util.logging.Logging;

public class NetCDFSource
extends DefaultCoverageSource {
    private static final Logger LOGGER = Logging.getLogger(NetCDFSource.class);
    NetCDFImageReader reader;
    Set<ParameterDescriptor<List>> dynamicParameters = null;

    public NetCDFSource(NetCDFImageReader reader, Name name) {
        super(name, reader.getCoverageDescriptor(name));
        this.reader = reader;
    }

    @Override
    public CoverageResponse read(CoverageReadRequest request, ProgressListener listener) throws IOException {
        this.ensureNotDisposed();
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Reading NetCDFSource with request: " + request);
        }
        NetCDFRequest coverageRequest = new NetCDFRequest(this, request);
        NetCDFResponse netCDFresponse = new NetCDFResponse(coverageRequest);
        return netCDFresponse.createResponse();
    }

    public boolean isParameterSupported(ReferenceIdentifier name) throws IOException {
        this.getDynamicParameters();
        if (this.dynamicParameters != null && !this.dynamicParameters.isEmpty()) {
            for (ParameterDescriptor<List> desc : this.dynamicParameters) {
                if (!desc.getName().equals(name)) continue;
                return true;
            }
        }
        return false;
    }

    public Set<ParameterDescriptor<List>> getDynamicParameters() throws IOException {
        if (this.dynamicParameters == null) {
            this.dynamicParameters = new HashSet<ParameterDescriptor<List>>();
            List<CoverageSource.AdditionalDomain> domains = this.getAdditionalDomains();
            if (domains != null && !domains.isEmpty()) {
                for (CoverageSource.AdditionalDomain domain : domains) {
                    this.dynamicParameters.add((ParameterDescriptor<List>)DefaultParameterDescriptor.create((String)domain.getName().toUpperCase(), (CharSequence)("Additional " + domain.getName() + " domain"), List.class, null, (boolean)false));
                }
            }
        }
        return this.dynamicParameters;
    }
}

