/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.service.wmts;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.geowebcache.filter.parameters.ParameterFilter;
import org.geowebcache.layer.TileLayer;
import org.geowebcache.mime.MimeType;

final class WMTSUtils {
    private WMTSUtils() {
    }

    protected static List<String> getLayerFormats(TileLayer layer) throws IOException {
        return layer.getMimeTypes().stream().map(MimeType::getFormat).collect(Collectors.toList());
    }

    protected static List<String> getLayerFormatsExtensions(TileLayer layer) throws IOException {
        return layer.getMimeTypes().stream().map(MimeType::getFileExtension).collect(Collectors.toList());
    }

    public static List<String> getInfoFormats(TileLayer layer) {
        return layer.getInfoMimeTypes().stream().map(MimeType::getFormat).collect(Collectors.toList());
    }

    public static List<ParameterFilter> getLayerDimensions(List<ParameterFilter> filters) {
        List<Object> dimensions = new ArrayList<ParameterFilter>(0);
        if (filters != null) {
            dimensions = filters.stream().filter(filter -> !"STYLES".equalsIgnoreCase(filter.getKey()) && filter.getLegalValues() != null).collect(Collectors.toList());
        }
        return dimensions;
    }

    public static String getKvpServiceMetadataURL(String baseUrl) {
        String base = baseUrl;
        String anchor = "";
        if (base.indexOf(35) != -1) {
            anchor = base.substring(base.indexOf(35));
            base = base.substring(0, base.indexOf(35));
        }
        for (int l = base.length(); l > 0 && (base.charAt(l - 1) == '?' || base.charAt(l - 1) == '&'); --l) {
            base = base.substring(0, l - 1);
        }
        base = base.indexOf(63) == -1 ? base + "?" : base + "&";
        return base + "SERVICE=wmts&REQUEST=getcapabilities&VERSION=1.0.0" + anchor;
    }
}

