/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geopkg.mosaic;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.MemoryCacheImageInputStream;

class TileImageReader {
    List<ImageReader> readersCache = new ArrayList<ImageReader>();
    ImageReader lastReader;

    TileImageReader() {
    }

    public BufferedImage read(byte[] data) throws IOException {
        if (this.lastReader != null) {
            this.lastReader.reset();
            this.lastReader.setInput(this.getImageInputStream(data));
        }
        if (this.lastReader == null || !this.lastReader.getOriginatingProvider().canDecodeInput(this.getImageInputStream(data))) {
            boolean found = false;
            for (ImageReader ir : this.readersCache) {
                if (ir == this.lastReader) continue;
                ir.reset();
                ir.setInput(this.getImageInputStream(data));
                if (!ir.canReadRaster()) continue;
                this.lastReader = ir;
                found = true;
            }
            if (!found) {
                Iterator<ImageReader> readers = ImageIO.getImageReaders(this.getImageInputStream(data));
                if (!readers.hasNext()) {
                    throw new IOException("Unexpected, cannot find a reader for the current tile image format");
                }
                this.lastReader = readers.next();
                this.lastReader.setInput(this.getImageInputStream(data));
                this.readersCache.add(this.lastReader);
            }
        }
        ImageReadParam param = this.lastReader.getDefaultReadParam();
        return this.lastReader.read(0, param);
    }

    ImageInputStream getImageInputStream(byte[] data) {
        ByteArrayInputStream bis = new ByteArrayInputStream(data);
        return new MemoryCacheImageInputStream(bis);
    }
}

