/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.ldap;

import java.util.function.Supplier;
import javax.naming.directory.DirContext;
import org.geoserver.security.ldap.LDAPBaseSecurityServiceConfig;
import org.springframework.ldap.NamingException;
import org.springframework.ldap.core.AuthenticationSource;
import org.springframework.ldap.core.ContextSource;
import org.springframework.ldap.core.support.AbstractContextSource;
import org.springframework.ldap.core.support.DefaultTlsDirContextAuthenticationStrategy;
import org.springframework.ldap.core.support.DirContextAuthenticationStrategy;
import org.springframework.ldap.core.support.LdapContextSource;
import org.springframework.security.ldap.DefaultSpringSecurityContextSource;
import org.springframework.security.ldap.SpringSecurityLdapTemplate;
import org.springframework.security.ldap.authentication.SpringSecurityAuthenticationSource;

public class LDAPUtils {
    public static LdapContextSource createLdapContext(LDAPBaseSecurityServiceConfig ldapConfig) {
        DefaultSpringSecurityContextSource ldapContext = new DefaultSpringSecurityContextSource(ldapConfig.getServerURL());
        ldapContext.setCacheEnvironmentProperties(false);
        ldapContext.setAuthenticationSource((AuthenticationSource)new SpringSecurityAuthenticationSource());
        if (ldapConfig.isUseTLS().booleanValue()) {
            ldapContext.setPooled(false);
            DefaultTlsDirContextAuthenticationStrategy tls = new DefaultTlsDirContextAuthenticationStrategy();
            tls.setHostnameVerifier((hostname, session) -> true);
            ldapContext.setAuthenticationStrategy((DirContextAuthenticationStrategy)tls);
        }
        return ldapContext;
    }

    public static SpringSecurityLdapTemplate getLdapTemplateInContext(final DirContext ctx, SpringSecurityLdapTemplate template) {
        SpringSecurityLdapTemplate authTemplate;
        if (ctx == null) {
            authTemplate = template;
            ((AbstractContextSource)authTemplate.getContextSource()).setAnonymousReadOnly(true);
        } else {
            authTemplate = new SpringSecurityLdapTemplate(new ContextSource(){

                public DirContext getReadOnlyContext() throws NamingException {
                    return ctx;
                }

                public DirContext getReadWriteContext() throws NamingException {
                    return ctx;
                }

                public DirContext getContext(String principal, String credentials) throws NamingException {
                    return ctx;
                }
            });
        }
        return authTemplate;
    }

    public static SpringSecurityLdapTemplate getLdapTemplateInContext(final Supplier<DirContext> ctxSupplier, SpringSecurityLdapTemplate template) {
        SpringSecurityLdapTemplate authTemplate;
        if (ctxSupplier == null) {
            authTemplate = template;
            ((AbstractContextSource)authTemplate.getContextSource()).setAnonymousReadOnly(true);
        } else {
            authTemplate = new SpringSecurityLdapTemplate(new ContextSource(){

                public DirContext getReadOnlyContext() throws NamingException {
                    return (DirContext)ctxSupplier.get();
                }

                public DirContext getReadWriteContext() throws NamingException {
                    return (DirContext)ctxSupplier.get();
                }

                public DirContext getContext(String principal, String credentials) throws NamingException {
                    return (DirContext)ctxSupplier.get();
                }
            });
        }
        return authTemplate;
    }
}

