/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.ldap;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import javax.naming.Context;
import javax.naming.directory.DirContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.mutable.MutableObject;
import org.geoserver.security.GeoServerRoleService;
import org.geoserver.security.GeoServerRoleStore;
import org.geoserver.security.config.SecurityNamedServiceConfig;
import org.geoserver.security.event.RoleLoadedListener;
import org.geoserver.security.impl.GeoServerRole;
import org.geoserver.security.ldap.LDAPBaseSecurityService;
import org.geoserver.security.ldap.LDAPRoleServiceConfig;
import org.geoserver.security.ldap.LDAPUtils;
import org.geotools.util.logging.Logging;
import org.springframework.ldap.CommunicationException;
import org.springframework.ldap.core.DirContextOperations;
import org.springframework.security.ldap.LdapUtils;
import org.springframework.security.ldap.SpringSecurityLdapTemplate;
import org.springframework.util.Assert;

public class LDAPRoleService
extends LDAPBaseSecurityService
implements GeoServerRoleService {
    private static final SortedSet<String> emptyStringSet = Collections.unmodifiableSortedSet(new TreeSet());
    private static final Map<String, String> emptyMap = Collections.emptyMap();
    static Logger LOGGER = Logging.getLogger((String)"org.geoserver.security.ldap");
    protected Set<RoleLoadedListener> listeners = Collections.synchronizedSet(new HashSet());
    private String rolePrefix = "ROLE_";
    private boolean convertToUpperCase = true;
    private String adminGroup;
    private String groupAdminGroup;

    @Override
    public void initializeFromConfig(SecurityNamedServiceConfig config) throws IOException {
        super.initializeFromConfig(config);
        LDAPRoleServiceConfig ldapConfig = (LDAPRoleServiceConfig)config;
        if (!LDAPRoleService.isEmpty(ldapConfig.getAdminGroup())) {
            this.adminGroup = ldapConfig.getAdminGroup();
        }
        if (!LDAPRoleService.isEmpty(ldapConfig.getGroupAdminGroup())) {
            this.groupAdminGroup = ldapConfig.getGroupAdminGroup();
        }
        this.rolePrefix = ldapConfig.getRolePrefix() != null ? ldapConfig.getRolePrefix().trim() : "";
        if (ldapConfig.getConvertToUpperCase() != null) {
            this.convertToUpperCase = ldapConfig.getConvertToUpperCase();
        }
    }

    public boolean canCreateStore() {
        return false;
    }

    public GeoServerRoleStore createStore() throws IOException {
        return null;
    }

    public void registerRoleLoadedListener(RoleLoadedListener listener) {
        this.listeners.add(listener);
    }

    public void unregisterRoleLoadedListener(RoleLoadedListener listener) {
        this.listeners.remove(listener);
    }

    public SortedSet<String> getGroupNamesForRole(GeoServerRole role) throws IOException {
        return emptyStringSet;
    }

    public SortedSet<String> getUserNamesForRole(GeoServerRole role) throws IOException {
        TreeSet<String> users = new TreeSet<String>();
        this.authenticateIfNeeded((ctx, ldapEntryIdentification) -> this.fillUsersForRole(ctx, users, role));
        if (this.useNestedGroups) {
            Set<GeoServerRole> childrenRoles = this.getChildrenRoles(role);
            HashSet<GeoServerRole> navigatedRoles = new HashSet<GeoServerRole>();
            navigatedRoles.add(role);
            for (GeoServerRole erole : childrenRoles) {
                SortedSet<String> userNamesForRole = this.getUserNamesForRoleNested(erole, navigatedRoles, 1);
                users.addAll(userNamesForRole);
            }
        }
        return Collections.unmodifiableSortedSet(users);
    }

    private SortedSet<String> getUserNamesForRoleNested(GeoServerRole role, Set<GeoServerRole> navigatedRoles, int depth) throws IOException {
        TreeSet<String> users = new TreeSet<String>();
        if (this.isOutOfDepthBounds(depth)) {
            return users;
        }
        this.authenticateIfNeeded((ctx, ldapEntryIdentification) -> this.fillUsersForRole(ctx, users, role));
        if (this.useNestedGroups) {
            Set<GeoServerRole> childrenRoles = this.getChildrenRoles(role);
            for (GeoServerRole erole : childrenRoles) {
                if (navigatedRoles.contains(erole)) continue;
                navigatedRoles.add(role);
                SortedSet<String> userNamesForRole = this.getUserNamesForRoleNested(erole, navigatedRoles, depth + 1);
                users.addAll(userNamesForRole);
            }
        }
        return users;
    }

    public SortedSet<GeoServerRole> getRolesForUser(String username) throws IOException {
        TreeSet<GeoServerRole> roles = new TreeSet<GeoServerRole>();
        String userDn = this.lookupDn(username);
        this.authenticateIfNeeded((ctx, ldapEntryIdentification) -> this.fillRolesForUser(ctx, username, userDn, roles));
        if (this.useNestedGroups) {
            TreeSet parentRoles = new TreeSet(roles);
            for (GeoServerRole erole : parentRoles) {
                this.searchNestedParentRoles(erole, roles, 1);
            }
        }
        return Collections.unmodifiableSortedSet(roles);
    }

    private void searchNestedParentRoles(GeoServerRole role, Set<GeoServerRole> roles, int depth) {
        if (this.isOutOfDepthBounds(depth)) {
            return;
        }
        for (GeoServerRole erole : this.getParentRolesbyMember(role)) {
            if (roles.contains(erole)) continue;
            roles.add(erole);
            this.searchNestedParentRoles(erole, roles, depth + 1);
        }
    }

    public SortedSet<GeoServerRole> getRolesForGroup(String groupname) throws IOException {
        TreeSet<GeoServerRole> set = new TreeSet<GeoServerRole>();
        GeoServerRole role = this.getRoleByName(groupname);
        if (role != null) {
            set.add(role);
        }
        return Collections.unmodifiableSortedSet(set);
    }

    public SortedSet<GeoServerRole> getRoles() throws IOException {
        TreeSet roles = new TreeSet();
        try {
            this.authenticateIfNeeded((ctx, ldapEntryIdentification) -> this.fillAllRoles(ctx, roles));
            return Collections.unmodifiableSortedSet(roles);
        }
        catch (CommunicationException ex) {
            throw new IOException(ex);
        }
    }

    private void fillAllRoles(DirContext ctx, SortedSet<GeoServerRole> roles) {
        Set roleNames = LDAPUtils.getLdapTemplateInContext(ctx, this.template).searchForSingleAttributeValues(this.groupSearchBase, this.allGroupsSearchFilter, (Object[])new String[0], this.groupNameAttribute);
        this.addRolesToSet(roles, roleNames);
    }

    private void fillUsersForRole(DirContext ctx, SortedSet<String> users, GeoServerRole role) {
        Object[] usernames;
        String roleStr = this.normalizeGroupName(role.toString());
        String roleDn = this.getRoleDn(role);
        DirContextOperations roleObj = LDAPUtils.getLdapTemplateInContext(ctx, this.template).searchForSingleEntry(this.groupSearchBase, this.groupNameFilter, (Object[])new String[]{roleStr, roleDn});
        if (roleObj != null && (usernames = roleObj.getObjectAttributes(this.groupMembershipAttribute)) != null) {
            for (Object username : usernames) {
                String user = username.toString();
                Matcher m = this.userMembershipPattern.matcher(user);
                if (m.matches()) {
                    user = m.group(1);
                }
                if (this.useNestedGroups && !StringUtils.containsIgnoreCase((CharSequence)username.toString(), (CharSequence)this.userSearchBase)) continue;
                user = this.removeBaseDN(user);
                users.add(this.getUserNameFromMembership(user));
            }
        }
    }

    private String removeBaseDN(String user) {
        DirContext baseCtx = this.template.getContextSource().getReadOnlyContext();
        try {
            user = LdapUtils.getRelativeName((String)user, (Context)baseCtx);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return user;
    }

    private void addRolesToSet(SortedSet<GeoServerRole> roles, Set<String> roleNames) {
        for (String roleName : roleNames) {
            try {
                roles.add(this.createRoleObject(roleName));
            }
            catch (IOException e) {
                LOGGER.log(Level.SEVERE, "Error adding a new role from LDAP", e);
            }
        }
    }

    private void fillRolesForUser(DirContext ctx, String username, String userDn, SortedSet<GeoServerRole> roles) {
        Set roleNames = LDAPUtils.getLdapTemplateInContext(ctx, this.template).searchForSingleAttributeValues(this.groupSearchBase, this.groupMembershipFilter, (Object[])new String[]{username, userDn}, this.groupNameAttribute);
        this.addRolesToSet(roles, roleNames);
    }

    public Map<String, String> getParentMappings() throws IOException {
        return emptyMap;
    }

    public GeoServerRole createRoleObject(String role) throws IOException {
        return new GeoServerRole(this.rolePrefix + (this.convertToUpperCase ? role.toUpperCase() : role));
    }

    public GeoServerRole getParentRole(GeoServerRole role) throws IOException {
        return null;
    }

    public GeoServerRole getRoleByName(String role) throws IOException {
        if (role.startsWith(this.rolePrefix)) {
            role = role.substring(this.rolePrefix.length());
        }
        String roleName = role;
        TreeSet roles = new TreeSet();
        this.authenticateIfNeeded((ctx, ldapEntryIdentification) -> roles.addAll(LDAPUtils.getLdapTemplateInContext(ctx, this.template).searchForSingleAttributeValues(this.groupSearchBase, this.groupNameFilter, (Object[])new String[]{roleName}, this.groupNameAttribute)));
        if (roles.size() == 1) {
            return this.createRoleObject(role);
        }
        return null;
    }

    public void load() throws IOException {
    }

    public Properties personalizeRoleParams(String roleName, Properties roleParams, String userName, Properties userProps) throws IOException {
        return null;
    }

    public GeoServerRole getAdminRole() {
        if (this.adminGroup == null) {
            return null;
        }
        try {
            return this.getRoleByName(this.adminGroup);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public GeoServerRole getGroupAdminRole() {
        if (this.groupAdminGroup == null) {
            return null;
        }
        try {
            return this.getRoleByName(this.groupAdminGroup);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public int getRoleCount() throws IOException {
        AtomicInteger count = new AtomicInteger(0);
        this.authenticateIfNeeded((ctx, ldapEntryIdentification) -> LDAPUtils.getLdapTemplateInContext(ctx, this.template).search(this.groupSearchBase, this.allGroupsSearchFilter, this.counter(count)));
        return count.get();
    }

    private String normalizeGroupName(String role) {
        if (role.startsWith(this.rolePrefix)) {
            role = role.substring(this.rolePrefix.length());
        }
        return role;
    }

    private Set<GeoServerRole> getChildrenRoles(GeoServerRole role) {
        Assert.notNull((Object)role, (String)"Geoserver role shouldn't be null.");
        String roleName = this.normalizeGroupName(role.getAuthority());
        String roleDn = this.getRoleDn(role);
        HashSet membersDns = new HashSet();
        HashSet<GeoServerRole> childs = new HashSet<GeoServerRole>();
        this.authenticateIfNeeded((ctx, ldapEntryIdentification) -> {
            SpringSecurityLdapTemplate authTemplate = LDAPUtils.getLdapTemplateInContext(ctx, this.template);
            membersDns.addAll(authTemplate.searchForSingleAttributeValues(this.groupSearchBase, this.groupNameFilter, (Object[])new String[]{roleName, roleDn}, this.groupMembershipAttribute).stream().filter(x -> x.contains(this.groupSearchBase)).collect(Collectors.toSet()));
        });
        for (String dn : membersDns) {
            String cnFromDn = this.extractGroupCnFromDn(dn);
            if (!StringUtils.isNotBlank((CharSequence)cnFromDn)) continue;
            try {
                childs.add(this.createRoleObject(cnFromDn));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return childs;
    }

    private Set<GeoServerRole> getParentRolesbyMember(GeoServerRole role) {
        if (role == null) {
            return Collections.emptySet();
        }
        HashSet<GeoServerRole> parents = new HashSet<GeoServerRole>();
        String roleDn = this.getRoleDn(role);
        String roleName = this.normalizeGroupName(role.getAuthority());
        this.authenticateIfNeeded((ctx, ldapEntryIdentification) -> {
            SpringSecurityLdapTemplate authTemplate = LDAPUtils.getLdapTemplateInContext(ctx, this.template);
            Set parentGroupsNames = authTemplate.searchForSingleAttributeValues(this.groupSearchBase, this.nestedGroupSearchFilter, (Object[])new String[]{roleName, roleDn}, this.groupNameAttribute);
            for (String eparent : parentGroupsNames) {
                try {
                    parents.add(this.createRoleObject(eparent));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        });
        return parents;
    }

    private String getRoleDn(GeoServerRole role) {
        String roleName = this.normalizeGroupName(role.getAuthority());
        MutableObject roleDnReference = new MutableObject(null);
        this.authenticateIfNeeded((ctx, ldapEntryIdentification) -> {
            String dn = LDAPUtils.getLdapTemplateInContext(ctx, this.template).searchForSingleEntry(this.groupSearchBase, this.groupNameFilter, (Object[])new String[]{roleName}).getNameInNamespace();
            roleDnReference.setValue((Object)dn);
        });
        return (String)roleDnReference.getValue();
    }
}

