/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.jdbc.config;

import org.geoserver.security.config.BaseSecurityNamedServiceConfig;

public abstract class JDBCSecurityServiceConfig
extends BaseSecurityNamedServiceConfig {
    private static final long serialVersionUID = 1L;
    private String propertyFileNameDDL;
    private String propertyFileNameDML;
    private String jndiName;
    private boolean jndi;
    private String driverClassName;
    private String connectURL;
    private String userName;
    private String password;
    private boolean creatingTables;

    public JDBCSecurityServiceConfig() {
    }

    public JDBCSecurityServiceConfig(JDBCSecurityServiceConfig other) {
        super((BaseSecurityNamedServiceConfig)other);
        this.propertyFileNameDDL = other.getPropertyFileNameDDL();
        this.propertyFileNameDML = other.getPropertyFileNameDML();
        this.jndiName = other.getJndiName();
        this.jndi = other.isJndi();
        this.driverClassName = other.getClassName();
        this.connectURL = other.getConnectURL();
        this.userName = other.getUserName();
        this.password = other.getPassword();
    }

    public boolean isJndi() {
        return this.jndi;
    }

    public void setJndi(boolean jndi) {
        this.jndi = jndi;
    }

    public String getJndiName() {
        return this.jndiName;
    }

    public void setJndiName(String jndiName) {
        this.jndiName = jndiName;
    }

    public String getPropertyFileNameDDL() {
        return this.propertyFileNameDDL;
    }

    public void setPropertyFileNameDDL(String propertyFileNameDDL) {
        this.propertyFileNameDDL = propertyFileNameDDL;
    }

    public String getPropertyFileNameDML() {
        return this.propertyFileNameDML;
    }

    public void setPropertyFileNameDML(String propertyFileNameDML) {
        this.propertyFileNameDML = propertyFileNameDML;
    }

    public String getDriverClassName() {
        return this.driverClassName;
    }

    public void setDriverClassName(String driverClassName) {
        this.driverClassName = driverClassName;
    }

    public String getConnectURL() {
        return this.connectURL;
    }

    public void setConnectURL(String connectURL) {
        this.connectURL = connectURL;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public boolean isCreatingTables() {
        return this.creatingTables;
    }

    public void setCreatingTables(boolean creatingTables) {
        this.creatingTables = creatingTables;
    }

    protected boolean isMySQL() {
        return "com.mysql.jdbc.Driver".equals(this.driverClassName);
    }

    public void initBeforeSave() {
        if (this.propertyFileNameDDL == null) {
            String string = this.propertyFileNameDDL = this.isMySQL() ? this.defaultDDLFilenameMySQL() : this.defaultDDLFilename();
        }
        if (this.propertyFileNameDML == null) {
            this.propertyFileNameDML = this.isMySQL() ? this.defaultDMLFilenameMySQL() : this.defaultDMLFilename();
        }
    }

    protected abstract String defaultDDLFilename();

    protected abstract String defaultDDLFilenameMySQL();

    protected abstract String defaultDMLFilename();

    protected abstract String defaultDMLFilenameMySQL();
}

