/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.xs.bindings;

import java.math.BigDecimal;
import javax.xml.namespace.QName;
import org.apache.commons.lang3.StringUtils;
import org.geotools.xs.XS;
import org.geotools.xsd.InstanceComponent;
import org.geotools.xsd.SimpleBinding;

public class XSDecimalBinding
implements SimpleBinding {
    @Override
    public QName getTarget() {
        return XS.DECIMAL;
    }

    @Override
    public int getExecutionMode() {
        return 0;
    }

    public Class getType() {
        return BigDecimal.class;
    }

    @Override
    public Object parse(InstanceComponent instance, Object value) throws Exception {
        String text = (String)value;
        if (text.startsWith("+")) {
            text = text.substring(1);
        } else if (StringUtils.isBlank((CharSequence)text)) {
            return null;
        }
        BigDecimal decimal = new BigDecimal(text);
        return decimal;
    }

    @Override
    public String encode(Object object, String value) {
        BigDecimal decimal = (BigDecimal)object;
        return decimal.toPlainString();
    }
}

