/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wfs.servlets;

import com.google.common.annotations.VisibleForTesting;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64;
import org.geoserver.config.GeoServer;
import org.geoserver.ows.util.ResponseUtils;
import org.geoserver.platform.GeoServerExtensions;
import org.geotools.util.logging.Logging;

public class TestWfsPost
extends HttpServlet {
    static final String TEST_WFS_POST_PATH = "/TestWfsPost";
    static final Logger LOGGER = Logging.getLogger(TestWfsPost.class);

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
    }

    public void destroy() {
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    public String getServletInfo() {
        return "Tests a WFS post request using a form entry.";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        block34: {
            boolean doGet;
            String requestString = request.getParameter("body");
            String urlString = request.getParameter("url");
            boolean bl = doGet = requestString == null || requestString.trim().equals("");
            if (urlString == null) {
                PrintWriter out = response.getWriter();
                StringBuffer urlInfo = request.getRequestURL();
                if (urlInfo.indexOf("?") != -1) {
                    urlInfo.delete(urlInfo.indexOf("?"), urlInfo.length());
                }
                String geoserverUrl = urlInfo.substring(0, urlInfo.indexOf("/", 8)) + request.getContextPath();
                response.setContentType("text/html");
                out.println("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0 Transitional//EN\">");
                out.println("<html>");
                out.println("<head>");
                out.println("<title>TestWfsPost</title>");
                out.println("</head>");
                out.println("<script language=\"JavaScript\">");
                out.println("function doNothing() {");
                out.println("}");
                out.println("function sendRequest() {");
                out.println("  if (checkURL()==true) {");
                out.print("    document.frm.action = \"");
                out.print(urlInfo.toString());
                out.print("\";\n");
                out.println("    document.frm.target = \"_blank\";");
                out.println("    document.frm.submit();");
                out.println("  }");
                out.println("}");
                out.println("function checkURL() {");
                out.println("  if (document.frm.url.value==\"\") {");
                out.println("    alert(\"Please give URL before you sumbit this form!\");");
                out.println("    return false;");
                out.println("  } else {");
                out.println("    return true;");
                out.println("  }");
                out.println("}");
                out.println("function clearRequest() {");
                out.println("document.frm.body.value = \"\";");
                out.println("}");
                out.println("</script>");
                out.println("<body>");
                out.println("<form name=\"frm\" action=\"JavaScript:doNothing()\" method=\"POST\">");
                out.println("<table align=\"center\" cellspacing=\"2\" cellpadding=\"2\" border=\"0\">");
                out.println("<tr>");
                out.println("<td><b>URL:</b></td>");
                out.print("<td><input name=\"url\" value=\"");
                out.print(geoserverUrl);
                out.print("/wfs/GetFeature\" size=\"70\" MAXLENGTH=\"100\"/></td>\n");
                out.println("</tr>");
                out.println("<tr>");
                out.println("<td><b>Request:</b></td>");
                out.println("<td><textarea cols=\"60\" rows=\"24\" name=\"body\"></textarea></td>");
                out.println("</tr>");
                out.println("</table>");
                out.println("<table align=\"center\">");
                out.println("<tr>");
                out.println("<td><input type=\"button\" value=\"Clear\" onclick=\"clearRequest()\"></td>");
                out.println("<td><input type=\"button\" value=\"Submit\" onclick=\"sendRequest()\"></td>");
                out.println("<td></td>");
                out.println("</tr>");
                out.println("</table>");
                out.println("</form>");
                out.println("</body>");
                out.println("</html>");
                out.close();
            } else {
                PrintWriter out;
                response.setContentType("application/xml");
                PrintWriter xmlOut = null;
                try {
                    URL u = new URL(urlString);
                    this.validateURL(request, urlString, this.getProxyBaseURL());
                    HttpURLConnection acon = (HttpURLConnection)u.openConnection();
                    acon.setAllowUserInteraction(false);
                    if (!doGet) {
                        acon.setRequestMethod("POST");
                        acon.setRequestProperty("Content-Type", "application/xml");
                    } else {
                        acon.setRequestMethod("GET");
                    }
                    acon.setDoOutput(true);
                    acon.setDoInput(true);
                    acon.setUseCaches(false);
                    String username = request.getParameter("username");
                    if (username != null && !username.trim().equals("")) {
                        String password = request.getParameter("password");
                        String up = username + ":" + password;
                        byte[] encoded = Base64.encodeBase64((byte[])up.getBytes());
                        String authHeader = "Basic " + new String(encoded);
                        acon.setRequestProperty("Authorization", authHeader);
                    }
                    if (!doGet) {
                        xmlOut = new PrintWriter(new BufferedWriter(new OutputStreamWriter(acon.getOutputStream())));
                        xmlOut = new PrintWriter(acon.getOutputStream());
                        xmlOut.write(requestString);
                        xmlOut.flush();
                    }
                    if (acon.getResponseCode() >= 400) {
                        StringBuilder responseContent = new StringBuilder();
                        responseContent.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
                        responseContent.append("<servlet-exception>\n");
                        responseContent.append("HTTP response: ");
                        responseContent.append(acon.getResponseCode());
                        responseContent.append("\n");
                        if (acon.getResponseMessage() != null) {
                            responseContent.append(URLDecoder.decode(acon.getResponseMessage(), "UTF-8"));
                        }
                        responseContent.append("</servlet-exception>\n");
                        PrintWriter out2 = response.getWriter();
                        out2.print(responseContent.toString());
                        break block34;
                    }
                    response.setContentType(acon.getContentType());
                    response.setHeader("Content-disposition", acon.getHeaderField("Content-disposition"));
                    ServletOutputStream output = response.getOutputStream();
                    try (InputStream in = acon.getInputStream();){
                        int c;
                        while ((c = in.read()) != -1) {
                            output.write(c);
                        }
                    }
                }
                catch (Exception e) {
                    LOGGER.log(Level.FINE, "Failure dealing with the request", e);
                    out = response.getWriter();
                    out.print(this.errorResponse(e));
                }
                finally {
                    try {
                        if (xmlOut != null) {
                            xmlOut.close();
                        }
                    }
                    catch (Exception e2) {
                        LOGGER.log(Level.FINE, "Internal failure dealing with the request", e2);
                        out = response.getWriter();
                        out.print(this.errorResponse(e2));
                    }
                }
            }
        }
    }

    public String errorResponse(Exception e) {
        StringBuilder responseContent = new StringBuilder();
        responseContent.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        responseContent.append("<servlet-exception>\n");
        responseContent.append(ResponseUtils.encodeXML((String)e.toString()));
        responseContent.append("</servlet-exception>\n");
        return responseContent.toString();
    }

    String getProxyBaseURL() {
        GeoServer geoServer = this.getGeoServer();
        if (geoServer != null) {
            return geoServer.getGlobal().getSettings().getProxyBaseUrl();
        }
        return null;
    }

    @VisibleForTesting
    protected GeoServer getGeoServer() {
        return (GeoServer)GeoServerExtensions.bean((String)"geoServer");
    }

    void validateURL(HttpServletRequest request, String urlString, String proxyBase) {
        URL requestUrl;
        URL url;
        try {
            url = new URL(urlString);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Invalid url requested; not a URL: " + urlString, e);
        }
        String requestString = request.getRequestURL().toString();
        requestString = requestString.substring(0, requestString.lastIndexOf(TEST_WFS_POST_PATH));
        try {
            requestUrl = new URL(requestString);
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException("Invalid request url; not a URL: " + requestString, e);
        }
        if (!request.getServletPath().equals(TEST_WFS_POST_PATH)) {
            throw new IllegalStateException("Unepected, the TestWfsPost was accessed by a path not ending with TestWfsPost: " + requestString);
        }
        if (null != requestUrl.getQuery()) {
            throw new IllegalStateException("Unepected, the TestWfsPost was accessed by a path not ending with TestWfsPost: " + requestString);
        }
        if (!request.getContextPath().equals(this.getServletContext().getContextPath())) {
            throw new IllegalStateException("Unepected, the TestWfsPost was accessed by a path from a different servlet context: " + requestString);
        }
        if (!url.getProtocol().equalsIgnoreCase("http") && !url.getProtocol().equalsIgnoreCase("https")) {
            throw new IllegalArgumentException("Invalid url requested; not an HTTP or HTTPS URL: " + urlString);
        }
        for (String path : url.getPath().split("/")) {
            if (!path.equals("..") && !ResponseUtils.urlDecode((String)path).equals("..")) continue;
            throw new IllegalArgumentException("Invalid url requested; illegal sequence '..' in URL: " + urlString);
        }
        String baseUrlString = requestString;
        URL baseUrl = requestUrl;
        if (proxyBase != null) {
            try {
                baseUrlString = proxyBase;
                baseUrl = new URL(proxyBase);
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException("Invalid Proxy Base URL; not a URL: " + proxyBase, e);
            }
        }
        String urlPath = url.getPath();
        urlPath = urlPath + (urlPath.endsWith("/") ? "" : "/");
        String baseUrlPath = baseUrl.getPath();
        baseUrlPath = baseUrlPath + (baseUrlPath.endsWith("/") ? "" : "/");
        if (!(url.getProtocol().equals(baseUrl.getProtocol()) && url.getHost().equals(baseUrl.getHost()) && url.getPort() == baseUrl.getPort() && urlPath.startsWith(baseUrlPath))) {
            throw new IllegalArgumentException("Invalid url requested, the demo requests should be hitting: " + baseUrlString);
        }
    }
}

