/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.xml.v1_1_0;

import java.util.Map;
import java.util.logging.Logger;
import net.opengis.wfs.WfsFactory;
import org.geoserver.catalog.Catalog;
import org.geoserver.config.GeoServer;
import org.geoserver.ows.xml.v1_0.OWSConfiguration;
import org.geoserver.wfs.CatalogFeatureTypeCache;
import org.geoserver.wfs.xml.FeatureTypeSchemaBuilder;
import org.geoserver.wfs.xml.PropertyTypePropertyExtractor;
import org.geoserver.wfs.xml.WFSHandlerFactory;
import org.geoserver.wfs.xml.WFSXmlUtils;
import org.geoserver.wfs.xml.XSQNameBinding;
import org.geoserver.wfs.xml.filter.v1_1.FilterTypeBinding;
import org.geoserver.wfs.xml.filter.v1_1.PropertyNameTypeBinding;
import org.geoserver.wfs.xml.gml3.CircleTypeBinding;
import org.geoserver.wfs.xml.v1_1_0.ActionTypeBinding;
import org.geoserver.wfs.xml.v1_1_0.AllSomeTypeBinding;
import org.geoserver.wfs.xml.v1_1_0.BaseRequestTypeBinding;
import org.geoserver.wfs.xml.v1_1_0.Base_TypeNameListTypeBinding;
import org.geoserver.wfs.xml.v1_1_0.DeleteElementTypeBinding;
import org.geoserver.wfs.xml.v1_1_0.DescribeFeatureTypeTypeBinding;
import org.geoserver.wfs.xml.v1_1_0.FeatureCollectionTypeBinding;
import org.geoserver.wfs.xml.v1_1_0.FeatureReferenceTypeBinding;
import org.geoserver.wfs.xml.v1_1_0.FeatureTypeListTypeBinding;
import org.geoserver.wfs.xml.v1_1_0.FeatureTypeTypeBinding;
import org.geoserver.wfs.xml.v1_1_0.FeaturesLockedTypeBinding;
import org.geoserver.wfs.xml.v1_1_0.FeaturesNotLockedTypeBinding;
import org.geoserver.wfs.xml.v1_1_0.GMLObjectTypeListTypeBinding;
import org.geoserver.wfs.xml.v1_1_0.GMLObjectTypeTypeBinding;
import org.geoserver.wfs.xml.v1_1_0.GetCapabilitiesTypeBinding;
import org.geoserver.wfs.xml.v1_1_0.GetFeatureTypeBinding;
import org.geoserver.wfs.xml.v1_1_0.GetFeatureWithLockTypeBinding;
import org.geoserver.wfs.xml.v1_1_0.GetGmlObjectTypeBinding;
import org.geoserver.wfs.xml.v1_1_0.IdentifierGenerationOptionTypeBinding;
import org.geoserver.wfs.xml.v1_1_0.InsertElementTypeBinding;
import org.geoserver.wfs.xml.v1_1_0.InsertResultTypeBinding;
import org.geoserver.wfs.xml.v1_1_0.InsertedFeatureTypeBinding;
import org.geoserver.wfs.xml.v1_1_0.LockFeatureResponseTypeBinding;
import org.geoserver.wfs.xml.v1_1_0.LockFeatureTypeBinding;
import org.geoserver.wfs.xml.v1_1_0.LockTypeBinding;
import org.geoserver.wfs.xml.v1_1_0.MetadataURLTypeBinding;
import org.geoserver.wfs.xml.v1_1_0.NativeTypeBinding;
import org.geoserver.wfs.xml.v1_1_0.OperationTypeBinding;
import org.geoserver.wfs.xml.v1_1_0.OperationsTypeBinding;
import org.geoserver.wfs.xml.v1_1_0.OutputFormatListTypeBinding;
import org.geoserver.wfs.xml.v1_1_0.PropertyTypeBinding;
import org.geoserver.wfs.xml.v1_1_0.QueryTypeBinding;
import org.geoserver.wfs.xml.v1_1_0.ResultTypeTypeBinding;
import org.geoserver.wfs.xml.v1_1_0.TransactionResponseTypeBinding;
import org.geoserver.wfs.xml.v1_1_0.TransactionResultsTypeBinding;
import org.geoserver.wfs.xml.v1_1_0.TransactionSummaryTypeBinding;
import org.geoserver.wfs.xml.v1_1_0.TransactionTypeBinding;
import org.geoserver.wfs.xml.v1_1_0.TypeNameListTypeBinding;
import org.geoserver.wfs.xml.v1_1_0.UpdateElementTypeBinding;
import org.geoserver.wfs.xml.v1_1_0.WFS;
import org.geoserver.wfs.xml.v1_1_0.WFS_CapabilitiesTypeBinding;
import org.geoserver.wfs.xml.v1_1_0.XlinkPropertyNameBinding;
import org.geotools.filter.v1_0.OGCBBOXTypeBinding;
import org.geotools.filter.v1_1.OGC;
import org.geotools.filter.v1_1.OGCConfiguration;
import org.geotools.geometry.jts.CurvedGeometryFactory;
import org.geotools.gml2.FeatureTypeCache;
import org.geotools.gml2.SrsSyntax;
import org.geotools.gml3.GML;
import org.geotools.gml3.GMLConfiguration;
import org.geotools.util.logging.Logging;
import org.geotools.xs.XS;
import org.geotools.xsd.Configuration;
import org.geotools.xsd.OptionalComponentParameter;
import org.geotools.xsd.XSD;
import org.locationtech.jts.geom.GeometryFactory;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.Parameter;
import org.picocontainer.defaults.SetterInjectionComponentAdapter;

public class WFSConfiguration
extends Configuration {
    static Logger LOGGER = Logging.getLogger((String)"org.geoserver.wfs");
    protected Catalog catalog;
    protected FeatureTypeSchemaBuilder schemaBuilder;

    public WFSConfiguration(GeoServer geoServer, FeatureTypeSchemaBuilder schemaBuilder, WFS wfs) {
        super((XSD)wfs);
        this.catalog = geoServer.getCatalog();
        this.schemaBuilder = schemaBuilder;
        this.addDependency((Configuration)new OGCConfiguration());
        this.addDependency((Configuration)new OWSConfiguration());
        this.addDependency((Configuration)new GMLConfiguration());
        CurvedGeometryFactory gf = new CurvedGeometryFactory(Double.MAX_VALUE);
        for (Object configuration : this.allDependencies()) {
            if (!(configuration instanceof GMLConfiguration)) continue;
            GMLConfiguration gml = (GMLConfiguration)configuration;
            gml.setGeometryFactory((GeometryFactory)gf);
        }
    }

    public void setSrsSyntax(SrsSyntax srsSyntax) {
        WFSXmlUtils.setSrsSyntax(this, srsSyntax);
    }

    public SrsSyntax getSrsSyntax() {
        return WFSXmlUtils.getSrsSyntax(this);
    }

    protected void registerBindings(MutablePicoContainer container) {
        container.registerComponentImplementation((Object)WFS.ACTIONTYPE, ActionTypeBinding.class);
        container.registerComponentImplementation((Object)WFS.ALLSOMETYPE, AllSomeTypeBinding.class);
        container.registerComponentImplementation((Object)WFS.BASE_TYPENAMELISTTYPE, Base_TypeNameListTypeBinding.class);
        container.registerComponentImplementation((Object)WFS.BASEREQUESTTYPE, BaseRequestTypeBinding.class);
        container.registerComponentImplementation((Object)WFS.DELETEELEMENTTYPE, DeleteElementTypeBinding.class);
        container.registerComponentImplementation((Object)WFS.DESCRIBEFEATURETYPETYPE, DescribeFeatureTypeTypeBinding.class);
        container.registerComponentImplementation((Object)WFS.FEATURECOLLECTIONTYPE, FeatureCollectionTypeBinding.class);
        container.registerComponentImplementation((Object)WFS.FEATURESLOCKEDTYPE, FeaturesLockedTypeBinding.class);
        container.registerComponentImplementation((Object)WFS.FEATURESNOTLOCKEDTYPE, FeaturesNotLockedTypeBinding.class);
        container.registerComponentImplementation((Object)WFS.FEATURETYPELISTTYPE, FeatureTypeListTypeBinding.class);
        container.registerComponentImplementation((Object)WFS.FEATURETYPETYPE, FeatureTypeTypeBinding.class);
        container.registerComponentImplementation((Object)WFS.GETCAPABILITIESTYPE, GetCapabilitiesTypeBinding.class);
        container.registerComponentImplementation((Object)WFS.GETFEATURETYPE, GetFeatureTypeBinding.class);
        container.registerComponentImplementation((Object)WFS.GETFEATUREWITHLOCKTYPE, GetFeatureWithLockTypeBinding.class);
        container.registerComponentImplementation((Object)WFS.GETGMLOBJECTTYPE, GetGmlObjectTypeBinding.class);
        container.registerComponentImplementation((Object)WFS.GMLOBJECTTYPELISTTYPE, GMLObjectTypeListTypeBinding.class);
        container.registerComponentImplementation((Object)WFS.GMLOBJECTTYPETYPE, GMLObjectTypeTypeBinding.class);
        container.registerComponentImplementation((Object)WFS.IDENTIFIERGENERATIONOPTIONTYPE, IdentifierGenerationOptionTypeBinding.class);
        container.registerComponentImplementation((Object)WFS.INSERTEDFEATURETYPE, InsertedFeatureTypeBinding.class);
        container.registerComponentImplementation((Object)WFS.INSERTELEMENTTYPE, InsertElementTypeBinding.class);
        container.registerComponentImplementation((Object)WFS.INSERTRESULTSTYPE, InsertResultTypeBinding.class);
        container.registerComponentImplementation((Object)WFS.LOCKFEATURERESPONSETYPE, LockFeatureResponseTypeBinding.class);
        container.registerComponentImplementation((Object)WFS.LOCKFEATURETYPE, LockFeatureTypeBinding.class);
        container.registerComponentImplementation((Object)WFS.LOCKTYPE, LockTypeBinding.class);
        container.registerComponentImplementation((Object)WFS.METADATAURLTYPE, MetadataURLTypeBinding.class);
        container.registerComponentImplementation((Object)WFS.NATIVETYPE, NativeTypeBinding.class);
        container.registerComponentImplementation((Object)WFS.OPERATIONSTYPE, OperationsTypeBinding.class);
        container.registerComponentImplementation((Object)WFS.OPERATIONTYPE, OperationTypeBinding.class);
        container.registerComponentImplementation((Object)WFS.OUTPUTFORMATLISTTYPE, OutputFormatListTypeBinding.class);
        container.registerComponentImplementation((Object)WFS.PROPERTYTYPE, PropertyTypeBinding.class);
        container.registerComponentImplementation((Object)WFS.QUERYTYPE, QueryTypeBinding.class);
        container.registerComponentImplementation((Object)WFS.RESULTTYPETYPE, ResultTypeTypeBinding.class);
        container.registerComponentImplementation((Object)WFS.TRANSACTIONRESPONSETYPE, TransactionResponseTypeBinding.class);
        container.registerComponentImplementation((Object)WFS.TRANSACTIONRESULTSTYPE, TransactionResultsTypeBinding.class);
        container.registerComponentImplementation((Object)WFS.TRANSACTIONSUMMARYTYPE, TransactionSummaryTypeBinding.class);
        container.registerComponentImplementation((Object)WFS.TRANSACTIONTYPE, TransactionTypeBinding.class);
        container.registerComponentImplementation((Object)WFS.TYPENAMELISTTYPE, TypeNameListTypeBinding.class);
        container.registerComponentImplementation((Object)WFS.UPDATEELEMENTTYPE, UpdateElementTypeBinding.class);
        container.registerComponentImplementation((Object)WFS.WFS_CAPABILITIESTYPE, WFS_CapabilitiesTypeBinding.class);
        container.registerComponentImplementation((Object)WFS.XLINKPROPERTYNAME, XlinkPropertyNameBinding.class);
        container.registerComponentImplementation((Object)FeatureReferenceTypeBinding.FeatureReferenceType, FeatureReferenceTypeBinding.class);
    }

    public Catalog getCatalog() {
        return this.catalog;
    }

    public void addDependency(Configuration dependency) {
        super.addDependency(dependency);
    }

    protected void configureContext(MutablePicoContainer context) {
        super.configureContext(context);
        context.registerComponentInstance((Object)WfsFactory.eINSTANCE);
        context.registerComponentInstance((Object)new WFSHandlerFactory(this.catalog, this.schemaBuilder));
        context.registerComponentInstance((Object)this.catalog);
        context.registerComponentImplementation(PropertyTypePropertyExtractor.class);
        context.registerComponentInstance((Object)this.getSrsSyntax());
        context.registerComponentInstance(FeatureTypeCache.class, (Object)new CatalogFeatureTypeCache(this.getCatalog()));
        context.registerComponentInstance((Object)new CurvedGeometryFactory(Double.MAX_VALUE));
    }

    protected void configureBindings(Map bindings) {
        bindings.put(OGC.FilterType, FilterTypeBinding.class);
        bindings.put(OGC.PropertyNameType, PropertyNameTypeBinding.class);
        bindings.put(GML.CircleType, CircleTypeBinding.class);
        WFSXmlUtils.registerAbstractGeometryTypeBinding(this, bindings, GML.AbstractGeometryType);
        bindings.put(OGC.BBOXType, new SetterInjectionComponentAdapter((Object)OGC.BBOXType, OGCBBOXTypeBinding.class, new Parameter[]{new OptionalComponentParameter(CoordinateReferenceSystem.class)}));
        bindings.put(XS.QNAME, XSQNameBinding.class);
    }

    public FeatureTypeSchemaBuilder getSchemaBuilder() {
        return this.schemaBuilder;
    }
}

