/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.xml;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import org.geotools.feature.type.ProfileImpl;
import org.opengis.feature.type.AttributeType;
import org.opengis.feature.type.Name;
import org.opengis.feature.type.Schema;

public class TypeMappingProfile {
    Set<Schema> profiles;

    public TypeMappingProfile(Set<Schema> profiles) {
        this.profiles = profiles;
    }

    public AttributeType type(Class<?> clazz) {
        ArrayList<AttributeType> assignable = new ArrayList<AttributeType>();
        for (Schema o : this.profiles) {
            ProfileImpl profile = (ProfileImpl)o;
            for (AttributeType type : profile.values()) {
                if (type.getBinding().isAssignableFrom(clazz)) {
                    assignable.add(type);
                }
                if (!clazz.equals(type.getBinding())) continue;
                return type;
            }
        }
        if (assignable.isEmpty()) {
            return null;
        }
        if (assignable.size() == 1) {
            return (AttributeType)assignable.get(0);
        }
        Comparator comparator = (a1, a2) -> {
            Class c2;
            Class c1 = a1.getBinding();
            if (c1.equals(c2 = a2.getBinding())) {
                return 0;
            }
            if (c1.isAssignableFrom(c2)) {
                return 1;
            }
            return -1;
        };
        Collections.sort(assignable, comparator);
        if (!((AttributeType)assignable.get(0)).equals(assignable.get(1))) {
            return (AttributeType)assignable.get(0);
        }
        return null;
    }

    public Name name(Class<?> clazz) {
        ArrayList<Map.Entry> assignable = new ArrayList<Map.Entry>();
        for (Schema o : this.profiles) {
            ProfileImpl profile = (ProfileImpl)o;
            for (Map.Entry nameAttributeTypeEntry : profile.entrySet()) {
                Map.Entry entry = nameAttributeTypeEntry;
                AttributeType type = (AttributeType)entry.getValue();
                if (type.getBinding().isAssignableFrom(clazz)) {
                    assignable.add(entry);
                }
                if (!clazz.equals(type.getBinding())) continue;
                return (Name)entry.getKey();
            }
        }
        if (assignable.isEmpty()) {
            return null;
        }
        if (assignable.size() == 1) {
            return (Name)((Map.Entry)assignable.get(0)).getKey();
        }
        Comparator comparator = (e1, e2) -> {
            Class c2;
            AttributeType a1 = (AttributeType)e1.getValue();
            AttributeType a2 = (AttributeType)e2.getValue();
            Class c1 = a1.getBinding();
            if (c1.equals(c2 = a2.getBinding())) {
                return 0;
            }
            if (c1.isAssignableFrom(c2)) {
                return 1;
            }
            return -1;
        };
        Collections.sort(assignable, comparator);
        Map.Entry e12 = (Map.Entry)assignable.get(0);
        Map.Entry e22 = (Map.Entry)assignable.get(1);
        AttributeType a1 = (AttributeType)e12.getValue();
        AttributeType a2 = (AttributeType)e22.getValue();
        if (!a1.equals(a2)) {
            return (Name)e12.getKey();
        }
        return null;
    }
}

