/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.xml;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import net.opengis.wfs.FeatureCollectionType;
import org.eclipse.xsd.XSDSchema;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.ows.Dispatcher;
import org.geoserver.ows.Request;
import org.geoserver.ows.URLMangler;
import org.geoserver.ows.util.ResponseUtils;
import org.geoserver.platform.Operation;
import org.geoserver.platform.ServiceException;
import org.geoserver.wfs.WFSException;
import org.geoserver.wfs.WFSGetFeatureOutputFormat;
import org.geoserver.wfs.WFSInfo;
import org.geoserver.wfs.request.FeatureCollectionResponse;
import org.geoserver.wfs.request.GetFeatureRequest;
import org.geoserver.wfs.request.Query;
import org.geoserver.wfs.request.RequestObject;
import org.geoserver.wfs.response.ComplexFeatureAwareFormat;
import org.geoserver.wfs.xml.ApplicationSchemaXSD1;
import org.geoserver.wfs.xml.FeatureTypeSchemaBuilder;
import org.geoserver.wfs.xml.v1_1_0.WFS;
import org.geoserver.wfs.xml.v1_1_0.WFSConfiguration;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.NameImpl;
import org.geotools.feature.simple.SimpleFeatureTypeImpl;
import org.geotools.gml3.GMLConfiguration;
import org.geotools.xsd.Configuration;
import org.geotools.xsd.Encoder;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.Name;
import org.w3c.dom.Document;

public class GML3OutputFormat
extends WFSGetFeatureOutputFormat
implements ComplexFeatureAwareFormat {
    public static final boolean OPTIMIZED_ENCODING = Boolean.parseBoolean(System.getProperty("GML_OPTIMIZED_ENCODING", "true"));
    GeoServer geoServer;
    Catalog catalog;
    WFSConfiguration configuration;
    protected static DOMSource xslt;

    public GML3OutputFormat(GeoServer geoServer, WFSConfiguration configuration) {
        this(new HashSet<String>(Arrays.asList("gml3", "text/xml; subtype=gml/3.1.1")), geoServer, configuration);
    }

    public GML3OutputFormat(Set<String> outputFormats, GeoServer geoServer, WFSConfiguration configuration) {
        super(geoServer, outputFormats);
        this.geoServer = geoServer;
        this.catalog = geoServer.getCatalog();
        this.configuration = configuration;
    }

    @Override
    public String getMimeType(Object value, Operation operation) {
        return "text/xml; subtype=gml/3.1.1";
    }

    @Override
    public String getCapabilitiesElementName() {
        return "GML3";
    }

    @Override
    protected void write(FeatureCollectionResponse results, OutputStream output, Operation getFeature) throws ServiceException, IOException, UnsupportedEncodingException {
        List<FeatureCollection> featureCollections = results.getFeature();
        int numDecimals = this.getNumDecimals(featureCollections, this.geoServer, this.catalog);
        boolean padWithZeros = this.getPadWithZeros(featureCollections, this.geoServer, this.catalog);
        boolean forcedDecimal = this.getForcedDecimal(featureCollections, this.geoServer, this.catalog);
        GetFeatureRequest request = GetFeatureRequest.adapt(getFeature.getParameters()[0]);
        HashMap<String, Set<ResourceInfo>> ns2metas = new HashMap<String, Set<ResourceInfo>>();
        for (int fcIndex = 0; fcIndex < featureCollections.size(); ++fcIndex) {
            if (request != null) {
                List<Query> queries = request.getQueries();
                Query queryType = queries.get(fcIndex);
                for (QName name : queryType.getTypeNames()) {
                    NameImpl featureTypeName = new NameImpl(name.getNamespaceURI(), name.getLocalPart());
                    ResourceInfo meta = this.catalog.getResourceByName((Name)featureTypeName, ResourceInfo.class);
                    if (meta == null) {
                        throw new WFSException((RequestObject)request, "Could not find feature type " + featureTypeName + " in the GeoServer catalog");
                    }
                    HashSet<ResourceInfo> metas = (HashSet<ResourceInfo>)ns2metas.get(featureTypeName.getNamespaceURI());
                    if (metas == null) {
                        metas = new HashSet<ResourceInfo>();
                        ns2metas.put(featureTypeName.getNamespaceURI(), metas);
                    }
                    metas.add(meta);
                }
                continue;
            }
            FeatureType featureType = featureCollections.get(fcIndex).getSchema();
            String namespaceURI = featureType.getName().getNamespaceURI();
            FeatureTypeInfo meta = this.catalog.getFeatureTypeByName(featureType.getName());
            if (meta == null) {
                throw new WFSException((RequestObject)request, "Could not find feature type " + featureType.getName() + " in the GeoServer catalog");
            }
            HashSet<FeatureTypeInfo> metas = (HashSet<FeatureTypeInfo>)ns2metas.get(namespaceURI);
            if (metas == null) {
                metas = new HashSet<FeatureTypeInfo>();
                ns2metas.put(namespaceURI, metas);
            }
            metas.add(meta);
        }
        WFSInfo wfs = this.getInfo();
        if (wfs.isFeatureBounding()) {
            this.configuration.getProperties().remove(GMLConfiguration.NO_FEATURE_BOUNDS);
        } else {
            this.configuration.getProperties().add(GMLConfiguration.NO_FEATURE_BOUNDS);
        }
        if (wfs.isCiteCompliant()) {
            this.configuration.getProperties().add(GMLConfiguration.NO_SRS_DIMENSION);
        } else {
            this.configuration.getProperties().remove(GMLConfiguration.NO_SRS_DIMENSION);
        }
        if (OPTIMIZED_ENCODING) {
            this.configuration.getProperties().add(GMLConfiguration.OPTIMIZED_ENCODING);
        } else {
            this.configuration.getProperties().remove(GMLConfiguration.OPTIMIZED_ENCODING);
        }
        this.configuration.setSrsSyntax(wfs.getGML().get((Object)WFSInfo.Version.V_11).getSrsNameStyle().toSrsSyntax());
        if (wfs.isEncodeFeatureMember()) {
            this.configuration.getProperties().add(GMLConfiguration.ENCODE_FEATURE_MEMBER);
        } else {
            this.configuration.getProperties().remove(GMLConfiguration.ENCODE_FEATURE_MEMBER);
        }
        Object gft = getFeature.getParameters()[0];
        Configuration configuration = this.customizeConfiguration(this.configuration, ns2metas, gft);
        boolean encodeMeasures = this.encodeMeasures(featureCollections, this.catalog);
        this.updateConfiguration(configuration, numDecimals, padWithZeros, forcedDecimal, encodeMeasures);
        Encoder encoder = this.createEncoder(configuration, ns2metas, gft);
        encoder.setEncoding(Charset.forName(this.geoServer.getSettings().getCharset()));
        if (wfs.isVerbose() || this.geoServer.getSettings().isVerbose()) {
            encoder.setIndenting(true);
        } else {
            encoder.setIndenting(false);
        }
        Request dispatcherRequest = (Request)Dispatcher.REQUEST.get();
        if (dispatcherRequest != null) {
            encoder.setOmitXMLDeclaration(dispatcherRequest.isSOAP());
        }
        if (wfs.isCanonicalSchemaLocation()) {
            encoder.setSchemaLocation(this.getWfsNamespace(), this.getCanonicalWfsSchemaLocation());
        } else {
            encoder.setSchemaLocation(this.getWfsNamespace(), ResponseUtils.buildSchemaURL((String)request.getBaseURL(), (String)this.getRelativeWfsSchemaLocation()));
        }
        Map params = ResponseUtils.params((String[])new String[]{"service", "WFS", "version", request.getVersion(), "request", "DescribeFeatureType"});
        Iterator<Map.Entry<String, Set<ResourceInfo>>> iterator = ns2metas.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Set<ResourceInfo>> stringSetEntry;
            Map.Entry<String, Set<ResourceInfo>> entry = stringSetEntry = iterator.next();
            String namespaceURI = entry.getKey();
            Set<ResourceInfo> metas = entry.getValue();
            StringBuffer typeNames = new StringBuffer();
            Iterator<ResourceInfo> m = metas.iterator();
            while (m.hasNext()) {
                ResourceInfo ri = m.next();
                if (ri instanceof FeatureTypeInfo) {
                    FeatureTypeInfo meta = (FeatureTypeInfo)ri;
                    FeatureType featureType = meta.getFeatureType();
                    Object userSchemaLocation = featureType.getUserData().get("schemaURI");
                    if (userSchemaLocation != null && userSchemaLocation instanceof Map) {
                        Map schemaURIs = (Map)userSchemaLocation;
                        for (String namespace : schemaURIs.keySet()) {
                            encoder.setSchemaLocation(namespace, (String)schemaURIs.get(namespace));
                        }
                        continue;
                    }
                    typeNames.append(meta.prefixedName());
                    if (!m.hasNext()) continue;
                    typeNames.append(",");
                    continue;
                }
                encoder.getNamespaces().declarePrefix(ri.getStore().getWorkspace().getName(), namespaceURI);
            }
            if (typeNames.length() <= 0) continue;
            params.put("typeName", typeNames.toString());
            String schemaLocation = ResponseUtils.buildURL((String)request.getBaseURL(), (String)"wfs", (Map)params, (URLMangler.URLType)URLMangler.URLType.SERVICE);
            LOGGER.finer("Unable to find user-defined schema location for: " + namespaceURI + ". Using a built schema location by default: " + schemaLocation);
            encoder.setSchemaLocation(namespaceURI, schemaLocation);
        }
        this.setAdditionalSchemaLocations(encoder, request, wfs);
        if (GML3OutputFormat.isComplexFeature(results)) {
            this.complexFeatureStreamIntercept(results, output, encoder);
        } else {
            this.encode(results, output, encoder);
        }
    }

    protected void updateConfiguration(Configuration configuration, int numDecimals, boolean padWithZeros, boolean forcedDecimal, boolean encodeMeasures) {
        GMLConfiguration gml31 = (GMLConfiguration)configuration.getDependency(GMLConfiguration.class);
        if (gml31 != null) {
            gml31.setNumDecimals(numDecimals);
            gml31.setPadWithZeros(padWithZeros);
            gml31.setForceDecimalEncoding(forcedDecimal);
            gml31.setEncodeMeasures(encodeMeasures);
            return;
        }
        org.geotools.gml3.v3_2.GMLConfiguration gml32 = (org.geotools.gml3.v3_2.GMLConfiguration)configuration.getDependency(org.geotools.gml3.v3_2.GMLConfiguration.class);
        if (gml32 != null) {
            gml32.setNumDecimals(numDecimals);
            gml32.setPadWithZeros(padWithZeros);
            gml32.setForceDecimalEncoding(forcedDecimal);
            gml32.setEncodeMeasures(encodeMeasures);
        }
    }

    protected Configuration customizeConfiguration(Configuration configuration, Map<String, Set<ResourceInfo>> resources, Object request) {
        return configuration;
    }

    protected Encoder createEncoder(Configuration configuration, Map<String, Set<ResourceInfo>> resources, Object request) {
        FeatureTypeSchemaBuilder schemaBuilder = configuration instanceof WFSConfiguration ? ((WFSConfiguration)configuration).getSchemaBuilder() : new FeatureTypeSchemaBuilder.GML3(this.geoServer);
        ApplicationSchemaXSD1 schema = new ApplicationSchemaXSD1(schemaBuilder);
        schema.setBaseURL(GetFeatureRequest.adapt(request).getBaseURL());
        schema.setResources(resources);
        if (schema.getFeatureTypes().isEmpty()) {
            XSDSchema result;
            try {
                result = configuration.getXSD().getSchema();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return new Encoder(configuration, result);
        }
        try {
            return new Encoder(configuration, schema.getSchema());
        }
        catch (IOException exception) {
            throw new RuntimeException("Error generating the XSD schema during the encoder instantiation.", exception);
        }
    }

    protected void setAdditionalSchemaLocations(Encoder encoder, GetFeatureRequest request, WFSInfo wfs) {
    }

    protected void encode(FeatureCollectionResponse results, OutputStream output, Encoder encoder) throws IOException {
        encoder.encode(results.unadapt(FeatureCollectionType.class), WFS.FEATURECOLLECTION, output);
    }

    protected DOMSource getXSLT() {
        return xslt;
    }

    private void complexFeatureStreamIntercept(FeatureCollectionResponse results, OutputStream output, Encoder encoder) throws IOException {
        if (this.getXSLT() == null) {
            throw new FileNotFoundException("Unable to locate xslt resource file");
        }
        File featureOut = File.createTempFile(output.hashCode() + "_dump", ".xml");
        try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(featureOut));
             BufferedInputStream in = new BufferedInputStream(new FileInputStream(featureOut));){
            this.encode(results, out, encoder);
            this.transform(in, this.getXSLT(), output);
        }
        catch (TransformerException e) {
            throw (IOException)new IOException(e.getMessage()).initCause(e);
        }
        finally {
            featureOut.delete();
        }
    }

    protected String getWfsNamespace() {
        return "http://www.opengis.net/wfs";
    }

    protected String getCanonicalWfsSchemaLocation() {
        return "http://schemas.opengis.net/wfs/1.1.0/wfs.xsd";
    }

    protected String getRelativeWfsSchemaLocation() {
        return "wfs/1.1.0/wfs.xsd";
    }

    public static boolean isComplexFeature(FeatureCollectionResponse results) {
        boolean hasComplex = false;
        for (int fcIndex = 0; fcIndex < results.getFeature().size(); ++fcIndex) {
            if (results.getFeature().get(fcIndex).getSchema() instanceof SimpleFeatureTypeImpl) continue;
            hasComplex = true;
            break;
        }
        return hasComplex;
    }

    public void transform(InputStream in, DOMSource xslt, OutputStream out) throws TransformerException {
        TransformerFactory factory = TransformerFactory.newInstance();
        Transformer transformer = xslt == null ? factory.newTransformer() : factory.newTransformer(xslt);
        transformer.setErrorListener(new TransformerErrorListener());
        transformer.transform(new StreamSource(in), new StreamResult(out));
    }

    @Override
    public boolean supportsComplexFeatures(Object value, Operation operation) {
        return true;
    }

    static {
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        docFactory.setNamespaceAware(true);
        Document xsdDocument = null;
        try {
            xsdDocument = docFactory.newDocumentBuilder().parse(GML3OutputFormat.class.getResourceAsStream("/ChangeNumberOfFeature.xslt"));
            xslt = new DOMSource(xsdDocument);
        }
        catch (Exception e) {
            xslt = null;
            LOGGER.log(Level.INFO, e.getMessage(), e);
        }
    }

    private class TransformerErrorListener
    implements ErrorListener {
        private TransformerErrorListener() {
        }

        @Override
        public void error(TransformerException exception) throws TransformerException {
            throw exception;
        }

        @Override
        public void fatalError(TransformerException exception) throws TransformerException {
            throw exception;
        }

        @Override
        public void warning(TransformerException exception) throws TransformerException {
            throw exception;
        }
    }
}

