/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.xml;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.xml.transform.TransformerException;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.config.GeoServerInfo;
import org.geoserver.config.SettingsInfo;
import org.geoserver.ows.URLMangler;
import org.geoserver.ows.util.ResponseUtils;
import org.geoserver.platform.Operation;
import org.geoserver.platform.ServiceException;
import org.geoserver.wfs.GMLInfo;
import org.geoserver.wfs.WFSGetFeatureOutputFormat;
import org.geoserver.wfs.WFSInfo;
import org.geoserver.wfs.request.FeatureCollectionResponse;
import org.geoserver.wfs.request.GetFeatureRequest;
import org.geoserver.wfs.request.Query;
import org.geoserver.wfs.response.ComplexFeatureAwareFormat;
import org.geotools.feature.FeatureCollection;
import org.geotools.gml.producer.FeatureTransformer;
import org.geotools.gml2.bindings.GML2EncodingUtils;
import org.geotools.referencing.CRS;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class GML2OutputFormat
extends WFSGetFeatureOutputFormat
implements ComplexFeatureAwareFormat {
    private static final int NO_FORMATTING = -1;
    private static final int INDENT_SIZE = 2;
    public static final String formatName = "GML2";
    public static final String MIME_TYPE = "text/xml; subtype=gml/2.1.2";
    private FeatureTransformer transformer;
    private GeoServer geoServer;
    protected Catalog catalog;

    public GML2OutputFormat(GeoServer geoServer) {
        super(geoServer, new HashSet<String>(Arrays.asList(formatName, MIME_TYPE)));
        this.geoServer = geoServer;
        this.catalog = geoServer.getCatalog();
    }

    @Override
    public String getMimeType(Object value, Operation operation) throws ServiceException {
        return MIME_TYPE;
    }

    @Override
    public String getCapabilitiesElementName() {
        return formatName;
    }

    public void prepare(String outputFormat, FeatureCollectionResponse results, GetFeatureRequest request) throws IOException {
        WFSInfo wfs;
        this.transformer = this.createTransformer();
        FeatureTransformer.FeatureTypeNamespaces ftNames = this.transformer.getFeatureTypeNamespaces();
        HashMap<String, String> ftNamespaces = new HashMap<String, String>();
        int srs = -1;
        int numDecimals = -1;
        boolean padWithZeros = false;
        boolean forcedDecimal = false;
        for (int i = 0; i < results.getFeature().size(); ++i) {
            boolean force;
            boolean pad;
            String location;
            FeatureCollection features = results.getFeature().get(i);
            SimpleFeatureType featureType = (SimpleFeatureType)features.getSchema();
            ResourceInfo meta = this.catalog.getResourceByName(featureType.getName(), ResourceInfo.class);
            String prefix = meta.getNamespace().getPrefix();
            String uri = meta.getNamespace().getURI();
            ftNames.declareNamespace(features.getSchema(), prefix, uri);
            if (ftNamespaces.containsKey(uri)) {
                location = (String)ftNamespaces.get(uri);
                ftNamespaces.put(uri, location + "," + ResponseUtils.urlEncode((String)meta.prefixedName(), (char[])new char[0]));
            } else if (meta instanceof FeatureTypeInfo) {
                location = this.typeSchemaLocation(this.geoServer.getGlobal(), (FeatureTypeInfo)meta, request.getBaseUrl());
                ftNamespaces.put(uri, location);
            }
            Query query = request.getQueries().get(i);
            try {
                String srsName;
                String string = srsName = query.getSrsName() != null ? query.getSrsName().toString() : null;
                if (srsName == null) {
                    srsName = meta.getSRS();
                }
                if (srsName != null) {
                    CoordinateReferenceSystem crs = CRS.decode((String)srsName);
                    String epsgCode = GML2EncodingUtils.epsgCode((CoordinateReferenceSystem)crs);
                    srs = Integer.parseInt(epsgCode);
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Problem encoding:" + query.getSrsName(), e);
            }
            if (!(meta instanceof FeatureTypeInfo)) continue;
            int ftiDecimals = ((FeatureTypeInfo)meta).getNumDecimals();
            if (ftiDecimals > 0) {
                int n = numDecimals = numDecimals == -1 ? ftiDecimals : Math.max(numDecimals, ftiDecimals);
            }
            if (pad = ((FeatureTypeInfo)meta).getPadWithZeros()) {
                padWithZeros = true;
            }
            if (!(force = ((FeatureTypeInfo)meta).getForcedDecimal())) continue;
            forcedDecimal = true;
        }
        SettingsInfo settings = this.geoServer.getSettings();
        if (numDecimals == -1) {
            numDecimals = settings.getNumDecimals();
        }
        this.transformer.setIndentation((wfs = this.getInfo()).isVerbose() ? 2 : -1);
        this.transformer.setNumDecimals(numDecimals);
        this.transformer.setPadWithZeros(padWithZeros);
        this.transformer.setForceDecimalEncoding(forcedDecimal);
        this.transformer.setFeatureBounding(wfs.isFeatureBounding());
        this.transformer.setCollectionBounding(wfs.isFeatureBounding());
        this.transformer.setEncoding(Charset.forName(settings.getCharset()));
        if (wfs.isCanonicalSchemaLocation()) {
            this.transformer.addSchemaLocation("http://www.opengis.net/wfs", this.wfsCanonicalSchemaLocation());
        } else {
            String wfsSchemaloc = this.wfsSchemaLocation(request.getBaseUrl());
            this.transformer.addSchemaLocation("http://www.opengis.net/wfs", wfsSchemaloc);
        }
        for (Object o : ftNamespaces.keySet()) {
            String uri = (String)o;
            this.transformer.addSchemaLocation(uri, (String)ftNamespaces.get(uri));
        }
        GMLInfo gml = wfs.getGML().get((Object)WFSInfo.Version.V_10);
        this.transformer.setGmlPrefixing(wfs.isCiteCompliant() || gml.getOverrideGMLAttributes() == false);
        if (results.getLockId() != null) {
            this.transformer.setLockId(results.getLockId());
        }
        if (srs != -1) {
            this.transformer.setSrsName(gml.getSrsNameStyle().getPrefix() + srs);
        }
    }

    public void encode(OutputStream output, FeatureCollectionResponse results, GetFeatureRequest request) throws ServiceException, IOException {
        if (results == null) {
            throw new IllegalStateException("It seems prepare() has not been called or has not succeed");
        }
        List<FeatureCollection> resultsList = results.getFeature();
        FeatureCollection[] featureResults = resultsList.toArray(new FeatureCollection[resultsList.size()]);
        try {
            this.transformer.transform((Object)featureResults, output);
        }
        catch (TransformerException gmlException) {
            String msg = " error:" + gmlException.getMessage();
            throw new ServiceException(msg, (Throwable)gmlException);
        }
    }

    @Override
    protected void write(FeatureCollectionResponse featureCollection, OutputStream output, Operation getFeature) throws IOException, ServiceException {
        GetFeatureRequest request = GetFeatureRequest.adapt(getFeature.getParameters()[0]);
        this.prepare(request.getOutputFormat(), featureCollection, request);
        this.encode(output, featureCollection, request);
    }

    protected FeatureTransformer createTransformer() {
        return new FeatureTransformer();
    }

    protected String wfsSchemaLocation(String baseUrl) {
        return ResponseUtils.buildSchemaURL((String)baseUrl, (String)"wfs/1.0.0/WFS-basic.xsd");
    }

    protected String wfsCanonicalSchemaLocation() {
        return "http://schemas.opengis.net/wfs/1.0.0/WFS-basic.xsd";
    }

    protected String typeSchemaLocation(GeoServerInfo global, FeatureTypeInfo meta, String baseUrl) {
        Map params = ResponseUtils.params((String[])new String[]{"service", "WFS", "version", "1.0.0", "request", "DescribeFeatureType", "typeName", meta.prefixedName()});
        return ResponseUtils.buildURL((String)baseUrl, (String)"wfs", (Map)params, (URLMangler.URLType)URLMangler.URLType.SERVICE);
    }

    @Override
    public boolean supportsComplexFeatures(Object value, Operation operation) {
        return true;
    }
}

