/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.xml;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xsd.XSDFactory;
import org.eclipse.xsd.XSDImport;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.impl.XSDSchemaImpl;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.ows.URLMangler;
import org.geoserver.ows.util.ResponseUtils;
import org.geoserver.wfs.xml.FeatureTypeSchemaBuilder;
import org.geotools.wfs.v1_1.WFS;
import org.geotools.xsd.XSD;
import org.opengis.feature.simple.SimpleFeatureType;

public class ApplicationSchemaXSD1
extends XSD {
    FeatureTypeSchemaBuilder schemaBuilder;
    Map<String, Set<FeatureTypeInfo>> featureTypes;
    String baseURL;

    public ApplicationSchemaXSD1(FeatureTypeSchemaBuilder schemaBuilder) {
        this(schemaBuilder, Collections.emptyMap());
    }

    public ApplicationSchemaXSD1(FeatureTypeSchemaBuilder schemaBuilder, Map<String, Set<FeatureTypeInfo>> featureTypes) {
        this.schemaBuilder = schemaBuilder;
        this.featureTypes = featureTypes;
    }

    public void setBaseURL(String baseURL) {
        this.baseURL = baseURL;
    }

    public String getBaseURL() {
        return this.baseURL;
    }

    public void setResources(Map<String, Set<ResourceInfo>> resources) {
        HashMap<String, Set<FeatureTypeInfo>> featureTypes = new HashMap<String, Set<FeatureTypeInfo>>();
        for (Map.Entry<String, Set<ResourceInfo>> entry : resources.entrySet()) {
            HashSet<FeatureTypeInfo> fts = new HashSet<FeatureTypeInfo>();
            for (ResourceInfo ri : entry.getValue()) {
                if (!(ri instanceof FeatureTypeInfo)) continue;
                fts.add((FeatureTypeInfo)ri);
            }
            if (fts.isEmpty()) continue;
            featureTypes.put(entry.getKey(), fts);
        }
        this.featureTypes = featureTypes;
    }

    public Map<String, Set<FeatureTypeInfo>> getFeatureTypes() {
        return this.featureTypes;
    }

    public String getNamespaceURI() {
        if (this.featureTypes.size() == 1) {
            return this.featureTypes.keySet().iterator().next();
        }
        return null;
    }

    public String getSchemaLocation() {
        StringBuilder sb = new StringBuilder();
        for (Set<FeatureTypeInfo> fts : this.featureTypes.values()) {
            for (FeatureTypeInfo ft : fts) {
                sb.append(ft.prefixedName()).append(",");
            }
        }
        sb.setLength(sb.length() - 1);
        HashMap<String, String> kvp = new HashMap<String, String>();
        kvp.putAll(this.schemaBuilder.getDescribeFeatureTypeParams());
        kvp.put("typename", sb.toString());
        return ResponseUtils.buildURL((String)this.baseURL, (String)"wfs", kvp, (URLMangler.URLType)URLMangler.URLType.SERVICE);
    }

    protected XSDSchema buildSchema() throws IOException {
        XSDSchema schema;
        FeatureTypeInfo[] types = (FeatureTypeInfo[])this.featureTypes.values().stream().flatMap(Collection::stream).toArray(FeatureTypeInfo[]::new);
        if (ApplicationSchemaXSD1.containsComplexTypes(types)) {
            schema = this.schemaBuilder.build(new FeatureTypeInfo[0], this.baseURL, true, true);
            this.schemaBuilder.addApplicationTypes(schema);
        } else {
            schema = this.schemaBuilder.build(types, this.baseURL, true, true);
        }
        return ApplicationSchemaXSD1.importWfsSchema(schema);
    }

    private static boolean containsComplexTypes(FeatureTypeInfo[] featureTypes) {
        for (FeatureTypeInfo featureType : featureTypes) {
            try {
                if (featureType.getFeatureType() instanceof SimpleFeatureType) continue;
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static XSDSchema importWfsSchema(XSDSchema schema) throws IOException {
        XSDSchema wfsSchema = WFS.getInstance().getSchema();
        if (wfsSchema == null || !(wfsSchema instanceof XSDSchemaImpl)) {
            return schema;
        }
        XSDImport wfsImport = XSDFactory.eINSTANCE.createXSDImport();
        wfsImport.setNamespace("http://www.opengis.net/wfs");
        wfsImport.setResolvedSchema(wfsSchema);
        schema.getContents().add((Object)wfsImport);
        schema.getQNamePrefixToNamespaceMap().put("wfs", "http://www.opengis.net/wfs");
        EList eList = wfsSchema.eAdapters();
        synchronized (eList) {
            ((XSDSchemaImpl)wfsSchema).imported(wfsImport);
        }
        schema.getQNamePrefixToNamespaceMap().put("gml", "http://www.opengis.net/gml");
        return schema;
    }
}

