/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.xml;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xsd.XSDComplexTypeContent;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDCompositor;
import org.eclipse.xsd.XSDDerivationMethod;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDFactory;
import org.eclipse.xsd.XSDForm;
import org.eclipse.xsd.XSDImport;
import org.eclipse.xsd.XSDModelGroup;
import org.eclipse.xsd.XSDParticle;
import org.eclipse.xsd.XSDParticleContent;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSchemaContent;
import org.eclipse.xsd.XSDTypeDefinition;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.ows.URLMangler;
import org.geoserver.ows.util.ResponseUtils;
import org.geoserver.platform.resource.Resource;
import org.geoserver.wfs.xml.TypeMappingProfile;
import org.geotools.util.logging.Logging;
import org.geotools.wfs.WFS;
import org.geotools.xsd.SchemaIndex;
import org.geotools.xsd.SchemaLocator;
import org.geotools.xsd.Schemas;
import org.geotools.xsd.XSD;
import org.geotools.xsd.impl.SchemaIndexImpl;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.Name;
import org.opengis.feature.type.Schema;

public class ApplicationSchemaXSD
extends XSD {
    static Logger LOGGER = Logging.getLogger((String)"org.geoserver.wfs");
    NamespaceInfo ns;
    Catalog catalog;
    String baseURL;
    WFS wfs;
    Collection<FeatureTypeInfo> types;
    TypeMappingProfile typeMappingProfile;

    public ApplicationSchemaXSD(NamespaceInfo ns, Catalog catalog, String baseURL, WFS wfs) {
        this(ns, catalog, baseURL, wfs, Collections.emptyList());
    }

    public ApplicationSchemaXSD(NamespaceInfo ns, Catalog catalog, String baseURL, WFS wfs, Collection<FeatureTypeInfo> types) {
        this.ns = ns;
        this.catalog = catalog;
        this.baseURL = baseURL;
        this.wfs = wfs;
        this.types = types;
        if (this.types == null) {
            types = Collections.emptyList();
        }
        if (this.ns == null && !types.isEmpty()) {
            Iterator<FeatureTypeInfo> i = types.iterator();
            NamespaceInfo namespace = i.next().getNamespace();
            while (i.hasNext()) {
                FeatureTypeInfo type = i.next();
                if (namespace.equals((Object)type.getNamespace())) continue;
                namespace = null;
                break;
            }
            if (namespace != null) {
                this.ns = namespace;
            }
        }
        LinkedHashSet<Schema> profiles = new LinkedHashSet<Schema>();
        for (XSD xsd : wfs.getAllDependencies()) {
            profiles.add(xsd.getTypeMappingProfile());
        }
        this.typeMappingProfile = new TypeMappingProfile(profiles);
    }

    protected void addDependencies(Set<XSD> dependencies) {
        dependencies.add((XSD)this.wfs);
    }

    public String getNamespaceURI() {
        if (this.ns != null) {
            return this.ns.getURI();
        }
        return null;
    }

    public String getSchemaLocation() {
        String schemaLocation = ResponseUtils.appendQueryString((String)ResponseUtils.appendPath((String[])new String[]{this.baseURL, "wfs"}), (String)("request=DescribeFeatureType&service=WFS&version=" + this.wfs.getVersion()));
        if (this.types.isEmpty()) {
            schemaLocation = ResponseUtils.appendQueryString((String)schemaLocation, (String)("namespace=" + this.ns.getURI()));
        } else {
            StringBuffer sb = new StringBuffer("typeName=");
            for (FeatureTypeInfo type : this.types) {
                sb.append(type.prefixedName()).append(",");
            }
            sb.setLength(sb.length() - 1);
            schemaLocation = ResponseUtils.appendQueryString((String)schemaLocation, (String)sb.toString());
        }
        return schemaLocation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected XSDSchema buildSchema() throws IOException {
        XSDFactory factory = XSDFactory.eINSTANCE;
        XSDSchema schema = factory.createXSDSchema();
        schema.setSchemaForSchemaQNamePrefix("xsd");
        schema.getQNamePrefixToNamespaceMap().put("xsd", "http://www.w3.org/2001/XMLSchema");
        schema.setElementFormDefault(XSDForm.get((int)0));
        if (this.ns == null) {
            if (this.types.isEmpty()) {
                this.buildSchemaImports(this.catalog.getNamespaces(), schema, factory);
                return schema;
            } else {
                HashSet<NamespaceInfo> namespaces = new HashSet<NamespaceInfo>();
                for (FeatureTypeInfo type : this.types) {
                    namespaces.add(type.getNamespace());
                }
                this.buildSchemaImports(namespaces, schema, factory);
            }
            return schema;
        }
        schema.setTargetNamespace(this.ns.getURI());
        schema.getQNamePrefixToNamespaceMap().put(this.ns.getPrefix(), this.ns.getURI());
        schema.getQNamePrefixToNamespaceMap().put("wfs", "http://www.opengis.net/wfs");
        schema.getQNamePrefixToNamespaceMap().put("gml", "http://www.opengis.net/gml");
        Class<Schemas> namespaces = Schemas.class;
        synchronized (Schemas.class) {
            Schemas.importSchema((XSDSchema)schema, (XSDSchema)this.wfs.getSchema());
            // ** MonitorExit[namespaces] (shouldn't be in output)
            schema.resolveElementDeclaration("http://www.opengis.net/wfs", "FeatureCollection");
            List featureTypes = this.types;
            if (featureTypes == null || featureTypes.isEmpty()) {
                featureTypes = this.catalog.getFeatureTypesByNamespace(this.ns);
            }
            SchemaIndexImpl index = new SchemaIndexImpl(new XSDSchema[]{schema});
            for (FeatureTypeInfo featureType : featureTypes) {
                this.buildSchemaContent(featureType, schema, factory, (SchemaIndex)index);
            }
            return schema;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    void buildSchemaImports(Collection<NamespaceInfo> namespaces, XSDSchema schema, XSDFactory factory) {
        Map params = ResponseUtils.params((String[])new String[]{"service", "wfs", "request", "DescribeFeatureType", "version", this.wfs.getVersion()});
        Iterator<NamespaceInfo> iterator = namespaces.iterator();
        while (iterator.hasNext()) {
            NamespaceInfo namespace = iterator.next();
            XSDImport imprt = factory.createXSDImport();
            imprt.setNamespace(namespace.getURI());
            params.put("namespace", namespace.getPrefix());
            imprt.setSchemaLocation(ResponseUtils.buildURL((String)this.baseURL, (String)"wfs", (Map)params, (URLMangler.URLType)URLMangler.URLType.SERVICE));
            Class<Schemas> clazz = Schemas.class;
            // MONITORENTER : org.geotools.xsd.Schemas.class
            schema.getContents().add((Object)imprt);
            // MONITOREXIT : clazz
        }
    }

    void buildSchemaContent(FeatureTypeInfo featureTypeInfo, XSDSchema schema, XSDFactory factory, SchemaIndex index) throws IOException {
        String prefix = featureTypeInfo.getNamespace().getPrefix();
        String store = featureTypeInfo.getStore().getName();
        String name = featureTypeInfo.getName();
        Resource schemaFile = this.catalog.getResourceLoader().get("workspaces/" + prefix + "/" + store + "/" + name + "/schema.xsd");
        if (schemaFile.getType() == Resource.Type.RESOURCE) {
            ArrayList<SchemaLocator> locators = new ArrayList<SchemaLocator>();
            for (XSD xsd : this.wfs.getAllDependencies()) {
                locators.add(xsd.createSchemaLocator());
            }
            XSDSchema ftSchema = null;
            try {
                ftSchema = Schemas.parse((String)schemaFile.file().getAbsolutePath(), locators, null);
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "Unable to parse schema: " + schemaFile.file().getAbsolutePath(), e);
            }
            if (ftSchema != null) {
                EList contents = ftSchema.getContents();
                for (XSDSchemaContent content : contents) {
                    content.setElement(null);
                }
                schema.getContents().addAll((Collection)contents);
                schema.updateElement();
                return;
            }
        }
        SimpleFeatureType featureType = (SimpleFeatureType)featureTypeInfo.getFeatureType();
        XSDComplexTypeDefinition complexType = factory.createXSDComplexTypeDefinition();
        complexType.setName(name + "Type");
        complexType.setDerivationMethod(XSDDerivationMethod.EXTENSION_LITERAL);
        complexType.setBaseTypeDefinition((XSDTypeDefinition)schema.resolveComplexTypeDefinition("http://www.opengis.net/gml", "AbstractFeatureType"));
        XSDModelGroup group = factory.createXSDModelGroup();
        group.setCompositor(XSDCompositor.SEQUENCE_LITERAL);
        List attributes = featureType.getAttributeDescriptors();
        for (Object o : attributes) {
            AttributeDescriptor attribute = (AttributeDescriptor)o;
            if (this.filterAttributeType(attribute)) continue;
            XSDElementDeclaration element = factory.createXSDElementDeclaration();
            element.setName(attribute.getLocalName());
            element.setNillable(attribute.isNillable());
            Class binding = attribute.getType().getBinding();
            Name typeName = this.findTypeName(binding);
            if (typeName == null) {
                throw new NullPointerException("Could not find a type for property: " + attribute.getName() + " of type: " + binding.getName());
            }
            XSDTypeDefinition type = index.getTypeDefinition(new QName(typeName.getNamespaceURI(), typeName.getLocalPart()));
            if (type == null) {
                throw new IllegalStateException("Could not find type: " + typeName);
            }
            element.setTypeDefinition(type);
            XSDParticle particle = factory.createXSDParticle();
            particle.setMinOccurs(attribute.getMinOccurs());
            particle.setMaxOccurs(attribute.getMaxOccurs());
            particle.setContent((XSDParticleContent)element);
            group.getContents().add((Object)particle);
        }
        XSDParticle particle = factory.createXSDParticle();
        particle.setContent((XSDParticleContent)group);
        complexType.setContent((XSDComplexTypeContent)particle);
        schema.getContents().add((Object)complexType);
        XSDElementDeclaration element = factory.createXSDElementDeclaration();
        element.setName(name);
        element.setSubstitutionGroupAffiliation(schema.resolveElementDeclaration("http://www.opengis.net/gml", "_Feature"));
        element.setTypeDefinition((XSDTypeDefinition)complexType);
        schema.getContents().add((Object)element);
        schema.updateElement();
    }

    boolean filterAttributeType(AttributeDescriptor attribute) {
        return "name".equals(attribute.getName().getLocalPart()) || "description".equals(attribute.getName().getLocalPart()) || "boundedBy".equals(attribute.getName().getLocalPart());
    }

    Name findTypeName(Class<?> binding) {
        return this.typeMappingProfile.name(binding);
    }
}

