/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.response.v2_0;

import java.io.IOException;
import java.io.OutputStream;
import javax.xml.namespace.QName;
import net.opengis.wfs20.GetPropertyValueType;
import net.opengis.wfs20.QueryType;
import net.opengis.wfs20.ValueCollectionType;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.ows.LocalWorkspace;
import org.geoserver.platform.Operation;
import org.geoserver.platform.ServiceException;
import org.geoserver.wfs.response.v2_0.WFSResponse;
import org.geotools.feature.NameImpl;
import org.geotools.wfs.v2_0.WFS;
import org.geotools.xsd.Encoder;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.Name;

public class GetPropertyValueResponse
extends WFSResponse {
    public GetPropertyValueResponse(GeoServer gs) {
        super(gs, ValueCollectionType.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void encode(Encoder encoder, Object value, OutputStream output, Operation op) throws IOException, ServiceException {
        GetPropertyValueType request = (GetPropertyValueType)op.getParameters()[0];
        QueryType query = (QueryType)request.getAbstractQueryExpression();
        QName typeName = (QName)query.getTypeNames().get(0);
        Catalog catalog = this.gs.getCatalog();
        boolean isSimple = true;
        NameImpl featureTypeName = new NameImpl(typeName.getNamespaceURI(), typeName.getLocalPart());
        FeatureTypeInfo ftInfo = catalog.getFeatureTypeByName((Name)featureTypeName);
        if (ftInfo != null) {
            try {
                isSimple = ftInfo.getFeatureType() instanceof SimpleFeatureType;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (isSimple) {
            NamespaceInfo ns = catalog.getNamespaceByURI(typeName.getNamespaceURI());
            encoder.getNamespaces().declarePrefix(ns.getPrefix(), ns.getURI());
        } else {
            WorkspaceInfo localWorkspace = LocalWorkspace.get();
            if (localWorkspace != null) {
                LocalWorkspace.remove();
            }
            try {
                for (NamespaceInfo nameSpaceinfo : catalog.getNamespaces()) {
                    if (encoder.getNamespaces().getURI(nameSpaceinfo.getPrefix()) != null) continue;
                    encoder.getNamespaces().declarePrefix(nameSpaceinfo.getPrefix(), nameSpaceinfo.getURI());
                }
            }
            finally {
                LocalWorkspace.set((WorkspaceInfo)localWorkspace);
            }
        }
        encoder.encode(value, WFS.ValueCollection, output);
    }
}

