/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.response;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import net.opengis.wfs.ActionType;
import net.opengis.wfs.InsertResultsType;
import net.opengis.wfs.InsertedFeatureType;
import net.opengis.wfs.TransactionResponseType;
import net.opengis.wfs.TransactionResultsType;
import net.opengis.wfs.TransactionType;
import org.eclipse.xsd.XSDSchema;
import org.geoserver.catalog.Catalog;
import org.geoserver.config.GeoServer;
import org.geoserver.ows.util.ResponseUtils;
import org.geoserver.platform.Operation;
import org.geoserver.platform.ServiceException;
import org.geoserver.wfs.WFSException;
import org.geoserver.wfs.response.WFSResponse;
import org.geoserver.wfs.xml.v1_1_0.WFS;
import org.geoserver.wfs.xml.v1_1_0.WFSConfiguration;
import org.geotools.util.Version;
import org.geotools.xsd.Configuration;
import org.geotools.xsd.Encoder;
import org.opengis.filter.identity.FeatureId;

public class TransactionResponse
extends WFSResponse {
    private boolean verbose = false;
    private String indent = " ";
    private String offset = "";
    Catalog catalog;
    WFSConfiguration configuration;

    public TransactionResponse(GeoServer gs, WFSConfiguration configuration) {
        super(gs, TransactionResponseType.class);
        this.catalog = gs.getCatalog();
        this.configuration = configuration;
    }

    public String getMimeType(Object value, Operation operation) throws ServiceException {
        return "text/xml";
    }

    public void write(Object value, OutputStream output, Operation operation) throws IOException, ServiceException {
        TransactionResponseType response = (TransactionResponseType)value;
        if (new Version("1.0.0").equals((Object)operation.getService().getVersion())) {
            this.v_1_0(response, output, operation);
        } else {
            this.v_1_1(response, output, operation);
        }
    }

    public void v_1_0(TransactionResponseType response, OutputStream output, Operation operation) throws IOException, ServiceException {
        TransactionResultsType result = response.getTransactionResults();
        Charset charset = Charset.forName(this.getInfo().getGeoServer().getSettings().getCharset());
        Writer writer = new OutputStreamWriter(output, charset);
        writer = new BufferedWriter(writer);
        String encoding = charset.name();
        String xmlHeader = "<?xml version=\"1.0\" encoding=\"" + encoding + "\"?>";
        writer.write(xmlHeader);
        if (this.verbose) {
            writer.write("\n");
        }
        writer.write("<wfs:WFS_TransactionResponse");
        writer.write(this.indent + "version=\"1.0.0\"");
        writer.write(this.indent + "xmlns:wfs=\"http://www.opengis.net/wfs\"");
        writer.write(this.indent + "xmlns:ogc=\"http://www.opengis.net/ogc\"");
        writer.write(this.indent + "xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"");
        writer.write(this.indent);
        writer.write("xsi:schemaLocation=\"http://www.opengis.net/wfs ");
        TransactionType req = (TransactionType)operation.getParameters()[0];
        String baseUrl = ResponseUtils.buildSchemaURL((String)req.getBaseUrl(), (String)"wfs/1.0.0/WFS-transaction.xsd");
        writer.write(baseUrl);
        writer.write("\">");
        InsertResultsType insertResults = response.getInsertResults();
        String lastHandle = null;
        boolean first = true;
        if (insertResults != null) {
            for (Object value : insertResults.getFeature()) {
                InsertedFeatureType insertedFeature = (InsertedFeatureType)value;
                String handle = insertedFeature.getHandle();
                if (first || lastHandle == null && handle != null || lastHandle != null && handle != null && handle.equals(lastHandle)) {
                    if (!first) {
                        writer.write("</wfs:InsertResult>");
                    }
                    writer.write("<wfs:InsertResult");
                    if (insertedFeature.getHandle() != null) {
                        writer.write(" handle=\"" + insertedFeature.getHandle() + "\"");
                    }
                    writer.write(">");
                }
                for (Object o : insertedFeature.getFeatureId()) {
                    FeatureId featureId = (FeatureId)o;
                    writer.write("<ogc:FeatureId fid=\"" + featureId.toString() + "\"/>");
                }
                first = false;
                lastHandle = handle;
            }
            writer.write("</wfs:InsertResult>");
        }
        writer.write(this.indent + "<wfs:TransactionResult");
        if (result.getHandle() != null) {
            writer.write(" handle=\"" + result.getHandle() + "\"");
        }
        writer.write(">");
        writer.write(this.indent + this.offset + "<wfs:Status>");
        writer.write(this.indent + this.offset + this.offset);
        if (!result.getAction().isEmpty()) {
            writer.write("<wfs:FAILED/>");
        } else {
            writer.write("<wfs:SUCCESS/>");
        }
        writer.write(this.indent + this.offset + "</wfs:Status>");
        if (!result.getAction().isEmpty()) {
            ActionType action = (ActionType)result.getAction().get(0);
            if (action.getLocator() != null) {
                writer.write(this.indent + this.offset + "<wfs:Locator>");
                writer.write(action.getLocator() + "</wfs:Locator>");
            }
            if (action.getMessage() != null) {
                writer.write(this.indent + this.offset + "<wfs:Message>");
                ResponseUtils.writeEscapedString((Writer)writer, (String)action.getMessage());
                writer.write("</wfs:Message>");
            }
        }
        writer.write(this.indent + "</wfs:TransactionResult>");
        if (this.verbose) {
            writer.write("\n");
        }
        writer.write("</wfs:WFS_TransactionResponse>");
        writer.flush();
    }

    public void v_1_1(TransactionResponseType response, OutputStream output, Operation operation) throws IOException, ServiceException {
        XSDSchema result;
        if (!response.getTransactionResults().getAction().isEmpty()) {
            ActionType action = (ActionType)response.getTransactionResults().getAction().iterator().next();
            throw new WFSException(action.getMessage(), action.getCode(), action.getLocator());
        }
        try {
            result = this.configuration.getXSD().getSchema();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        Encoder encoder = new Encoder((Configuration)this.configuration, result);
        encoder.setEncoding(Charset.forName(this.getInfo().getGeoServer().getSettings().getCharset()));
        TransactionType req = (TransactionType)operation.getParameters()[0];
        encoder.setSchemaLocation("http://www.opengis.net/wfs", ResponseUtils.buildSchemaURL((String)req.getBaseUrl(), (String)"wfs/1.1.0/wfs.xsd"));
        encoder.encode((Object)response, WFS.TRANSACTIONRESPONSE, output);
    }
}

