/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.response;

import com.google.common.escape.Escaper;
import com.google.common.escape.Escapers;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.security.InvalidParameterException;
import java.sql.Date;
import java.sql.Time;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xsd.XSDElementDeclaration;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.feature.FlatteningFeatureCollection;
import org.geoserver.platform.Operation;
import org.geoserver.platform.ServiceException;
import org.geoserver.wfs.WFSGetFeatureOutputFormat;
import org.geoserver.wfs.request.FeatureCollectionResponse;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.type.DateUtil;
import org.geotools.xsd.EMFUtils;
import org.opengis.feature.Feature;
import org.opengis.feature.Property;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.PropertyDescriptor;

public class CSVOutputFormat
extends WFSGetFeatureOutputFormat {
    static Pattern CSV_ESCAPES;
    private static AttrFormatter juDateFormatter;
    private static AttrFormatter sqlDateFormatter;
    private static AttrFormatter sqlTimeFormatter;
    private static AttrFormatter defaultFormatter;
    private static Escaper escaper;

    public CSVOutputFormat(GeoServer gs) {
        super(gs, new LinkedHashSet<String>(Arrays.asList("csv", "text/csv")));
    }

    @Override
    public String getMimeType(Object value, Operation operation) throws ServiceException {
        return "text/csv";
    }

    @Override
    protected String getExtension(FeatureCollectionResponse response) {
        return "csv";
    }

    public String getPreferredDisposition(Object value, Operation operation) {
        return "attachment";
    }

    @Override
    protected void write(FeatureCollectionResponse featureCollection, OutputStream output, Operation getFeature) throws IOException, ServiceException {
        Object o = getFeature.getParameters()[0];
        String csvSeparator = this.getCsvSeparator(o);
        CSV_ESCAPES = Pattern.compile("[\"\n\r\t" + csvSeparator + "]");
        BufferedWriter w = new BufferedWriter(new OutputStreamWriter(output, this.gs.getGlobal().getSettings().getCharset()));
        FeatureCollection fc = featureCollection.getFeature().get(0);
        if (fc.getSchema() instanceof SimpleFeatureType) {
            fc = FlatteningFeatureCollection.flatten((SimpleFeatureCollection)((SimpleFeatureCollection)fc));
            SimpleFeatureType ft = (SimpleFeatureType)fc.getSchema();
            w.write("FID" + csvSeparator);
            for (int i = 0; i < ft.getAttributeCount(); ++i) {
                AttributeDescriptor ad = ft.getDescriptor(i);
                w.write(CSVOutputFormat.prepCSVField(ad.getLocalName()));
                if (i >= ft.getAttributeCount() - 1) continue;
                w.write(csvSeparator);
            }
        } else {
            w.write("gml:id" + csvSeparator);
            int i = 0;
            for (PropertyDescriptor att : fc.getSchema().getDescriptors()) {
                if (att.getName().getLocalPart().startsWith("FEATURE_LINK")) continue;
                if (i > 0) {
                    w.write(csvSeparator);
                }
                String elName = att.getName().toString();
                Object xsd = att.getUserData().get(XSDElementDeclaration.class);
                if (xsd instanceof XSDElementDeclaration) {
                    XSDElementDeclaration xsdEl = (XSDElementDeclaration)xsd;
                    elName = xsdEl.getQName();
                }
                elName = this.resolveNamespacePrefixName(elName);
                w.write(CSVOutputFormat.prepCSVField(elName));
                ++i;
            }
        }
        w.write("\r\n");
        NumberFormat coordFormatter = NumberFormat.getInstance(Locale.US);
        coordFormatter.setMaximumFractionDigits(this.getInfo().getGeoServer().getSettings().getNumDecimals());
        coordFormatter.setGroupingUsed(false);
        AttrFormatter[] formatters = this.getFormatters(fc.getSchema());
        try (FeatureIterator i = fc.features();){
            while (i.hasNext()) {
                Feature f = i.next();
                w.write(CSVOutputFormat.prepCSVField(f.getIdentifier().getID()));
                w.write(csvSeparator);
                if (f instanceof SimpleFeature) {
                    for (int j = 0; j < ((SimpleFeature)f).getAttributeCount(); ++j) {
                        Object att = ((SimpleFeature)f).getAttribute(j);
                        if (att != null) {
                            String value = formatters[j].format(att);
                            w.write(value);
                        }
                        if (j >= ((SimpleFeature)f).getAttributeCount() - 1) continue;
                        w.write(csvSeparator);
                    }
                } else {
                    Iterator descriptors = fc.getSchema().getDescriptors().iterator();
                    int j = 0;
                    while (descriptors.hasNext()) {
                        PropertyDescriptor desc = (PropertyDescriptor)descriptors.next();
                        if (desc.getName().getLocalPart().startsWith("FEATURE_LINK")) continue;
                        if (j > 0) {
                            w.write(csvSeparator);
                        }
                        ++j;
                        Collection values = f.getProperties(desc.getName());
                        if (values.size() > 1) {
                            StringBuilder sb = new StringBuilder();
                            for (Property property : values) {
                                Object att = property.getValue();
                                String value = this.formatToString(att, coordFormatter);
                                sb.append(value).append(",");
                            }
                            sb.setLength(sb.length() - 1);
                            w.write(CSVOutputFormat.prepCSVField(sb.toString()));
                            continue;
                        }
                        Object att = null;
                        if (!values.isEmpty()) {
                            att = ((Property)values.iterator().next()).getValue();
                        }
                        if (att == null) continue;
                        String value = this.formatToString(att, coordFormatter);
                        w.write(CSVOutputFormat.prepCSVField(value));
                    }
                }
                w.write("\r\n");
            }
        }
        w.flush();
    }

    private String getCsvSeparator(Object o) {
        String separator = null;
        if (EMFUtils.has((EObject)((EObject)o), (String)"formatOptions")) {
            HashMap hashMap = (HashMap)EMFUtils.get((EObject)((EObject)o), (String)"formatOptions");
            separator = (String)hashMap.get("CSVSEPARATOR");
        }
        if (StringUtils.isEmpty(separator)) {
            separator = ",";
        } else if (separator.equalsIgnoreCase("space")) {
            separator = " ";
        } else if (separator.equalsIgnoreCase("tab")) {
            separator = "\t";
        } else if (separator.equalsIgnoreCase("semicolon")) {
            separator = ";";
        } else if (separator.equals("\"")) {
            throw new InvalidParameterException("A double quote is not allowed as a CSV separator");
        }
        return separator;
    }

    private AttrFormatter[] getFormatters(FeatureType schema) {
        if (schema instanceof SimpleFeatureType) {
            NumberFormat coordFormatter = NumberFormat.getInstance(Locale.US);
            coordFormatter.setMaximumFractionDigits(this.getInfo().getGeoServer().getSettings().getNumDecimals());
            coordFormatter.setGroupingUsed(false);
            SimpleFeatureType sft = (SimpleFeatureType)schema;
            AttrFormatter[] formatters = new AttrFormatter[sft.getAttributeCount()];
            int i = 0;
            for (AttributeDescriptor attributeDescriptor : sft.getAttributeDescriptors()) {
                Class binding = attributeDescriptor.getType().getBinding();
                formatters[i] = Number.class.isAssignableFrom(binding) ? new NumberFormatter(coordFormatter) : (Date.class.isAssignableFrom(binding) ? sqlDateFormatter : (Time.class.isAssignableFrom(binding) ? sqlTimeFormatter : (java.util.Date.class.isAssignableFrom(binding) ? juDateFormatter : defaultFormatter)));
                ++i;
            }
            return formatters;
        }
        return null;
    }

    private String formatToString(Object att, NumberFormat coordFormatter) {
        String value = att instanceof Number ? coordFormatter.format(att) : (att instanceof java.util.Date ? (att instanceof Date ? DateUtil.serializeSqlDate((Date)((Date)att)) : (att instanceof Time ? DateUtil.serializeSqlTime((Time)((Time)att)) : DateUtil.serializeDateTime((java.util.Date)((java.util.Date)att)))) : att.toString());
        return value;
    }

    private static String prepCSVField(String field) {
        String mod = escaper.escape(field);
        if (CSV_ESCAPES.matcher(mod).find()) {
            mod = "\"" + mod + "\"";
        }
        return mod;
    }

    @Override
    public String getCapabilitiesElementName() {
        return "CSV";
    }

    public String getCharset(Operation operation) {
        return this.gs.getGlobal().getSettings().getCharset();
    }

    String resolveNamespacePrefixName(String attributeName) {
        if (StringUtils.isBlank((CharSequence)attributeName) || !attributeName.contains(":") || attributeName.endsWith(":")) {
            return attributeName;
        }
        int lastIndexOfSeparator = attributeName.lastIndexOf(":");
        String namespaceUri = attributeName.substring(0, lastIndexOfSeparator);
        NamespaceInfo namespace = this.gs.getCatalog().getNamespaceByURI(namespaceUri);
        if (namespace != null) {
            String localName = attributeName.substring(lastIndexOfSeparator + 1, attributeName.length());
            return namespace.getPrefix() + ":" + localName;
        }
        return attributeName;
    }

    static {
        juDateFormatter = new JUDateFormatter();
        sqlDateFormatter = new SQLDateFormatter();
        sqlTimeFormatter = new SQLTimeFormatter();
        defaultFormatter = new DefaultFormatter();
        escaper = Escapers.builder().addEscape('\"', "\"\"").build();
    }

    private static class DefaultFormatter
    implements AttrFormatter {
        private DefaultFormatter() {
        }

        @Override
        public String format(Object att) {
            return CSVOutputFormat.prepCSVField(att.toString());
        }
    }

    private static class SQLTimeFormatter
    implements AttrFormatter {
        private SQLTimeFormatter() {
        }

        @Override
        public String format(Object att) {
            return CSVOutputFormat.prepCSVField(DateUtil.serializeSqlTime((Time)((Time)att)));
        }
    }

    private static class SQLDateFormatter
    implements AttrFormatter {
        private SQLDateFormatter() {
        }

        @Override
        public String format(Object att) {
            return CSVOutputFormat.prepCSVField(DateUtil.serializeSqlDate((Date)((Date)att)));
        }
    }

    private static class JUDateFormatter
    implements AttrFormatter {
        private JUDateFormatter() {
        }

        @Override
        public String format(Object att) {
            return CSVOutputFormat.prepCSVField(DateUtil.serializeDateTime((java.util.Date)((java.util.Date)att)));
        }
    }

    private static class NumberFormatter
    implements AttrFormatter {
        private final NumberFormat coordFormatter;

        public NumberFormatter(NumberFormat coordFormatter) {
            this.coordFormatter = coordFormatter;
        }

        @Override
        public String format(Object att) {
            if (this.coordFormatter.format(att).contains("-")) {
                return CSVOutputFormat.prepCSVField(this.coordFormatter.format(att));
            }
            return this.coordFormatter.format(att);
        }
    }

    private static interface AttrFormatter {
        public String format(Object var1);
    }
}

