/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.kvp.v2_0;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.opengis.wfs20.LockFeatureType;
import net.opengis.wfs20.ParameterExpressionType;
import net.opengis.wfs20.ParameterType;
import net.opengis.wfs20.StoredQueryType;
import net.opengis.wfs20.Wfs20Factory;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.geoserver.config.GeoServer;
import org.geoserver.wfs.StoredQuery;
import org.geoserver.wfs.StoredQueryProvider;
import org.geoserver.wfs.WFSException;
import org.geoserver.wfs.kvp.BaseFeatureKvpRequestReader;
import org.geoserver.wfs.request.LockFeatureRequest;
import org.geoserver.wfs.request.Query;
import org.geoserver.wfs.request.RequestObject;
import org.geotools.xsd.EMFUtils;
import org.opengis.filter.FilterFactory;

public class LockFeatureKvpRequestReader
extends BaseFeatureKvpRequestReader {
    public LockFeatureKvpRequestReader(GeoServer geoServer, FilterFactory filterFactory) {
        super(LockFeatureType.class, (EFactory)Wfs20Factory.eINSTANCE, geoServer, filterFactory);
    }

    @Override
    protected <T> void querySet(EObject request, String property, List<T> values) throws WFSException {
        if (values == null) {
            return;
        }
        LockFeatureRequest req = LockFeatureRequest.adapt(request);
        if ("typeName".equals(property)) {
            property = "typeNames";
        }
        List<EObject> query = req.getAdaptedQueries();
        int m = values.size();
        int n = query.size();
        if (m == 1 && n > 1) {
            EMFUtils.set(query, (String)property, values.get(0));
            return;
        }
        if (m > n) {
            if (n == 0) {
                for (int i = 0; i < m; ++i) {
                    query.add(req.createQuery().getAdaptee());
                }
            } else {
                if (n == 1) {
                    EObject q = query.get(0);
                    for (int i = 1; i < m; ++i) {
                        query.add(EMFUtils.clone((EObject)q, (EFactory)req.getFactory(), (boolean)false));
                    }
                    return;
                }
                String msg = "Specified " + m + " " + property + " for " + n + " queries.";
                throw new WFSException(request, msg);
            }
        }
        if (m < n) {
            ArrayList<T> newValues = new ArrayList<T>();
            newValues.addAll(values);
            for (int i = 0; i < n - m; ++i) {
                newValues.add(null);
            }
            values = newValues;
        }
        EMFUtils.set(query, (String)property, values);
    }

    @Override
    protected void buildStoredQueries(EObject request, List<URI> storedQueryIds, Map<String, Object> kvp) {
        LockFeatureRequest req = LockFeatureRequest.adapt(request);
        if (!(req instanceof LockFeatureRequest.WFS20)) {
            throw new WFSException((RequestObject)req, "Stored queries only supported in WFS 2.0+");
        }
        StoredQueryProvider sqp = new StoredQueryProvider(this.catalog, this.getWFS(), this.geoServer.getGlobal().isAllowStoredQueriesPerWorkspace());
        for (URI storedQueryId : storedQueryIds) {
            StoredQuery sq = sqp.getStoredQuery(storedQueryId.toString());
            if (sq == null) {
                WFSException exception = new WFSException((RequestObject)req, "No such stored query: " + storedQueryId, "InvalidParameterValue");
                exception.setLocator("STOREDQUERY_ID");
                throw exception;
            }
            Wfs20Factory factory = (Wfs20Factory)req.getFactory();
            StoredQueryType storedQuery = factory.createStoredQueryType();
            storedQuery.setId(storedQueryId.toString());
            for (ParameterExpressionType p : sq.getQuery().getParameter()) {
                if (!kvp.containsKey(p.getName())) continue;
                ParameterType param = factory.createParameterType();
                param.setName(p.getName());
                param.setValue(kvp.get(p.getName()).toString());
                storedQuery.getParameter().add((Object)param);
            }
            req.getAdaptedQueries().add((EObject)storedQuery);
        }
    }

    @Override
    protected List<Query> getQueries(EObject eObject) {
        return LockFeatureRequest.adapt(eObject).getQueries();
    }
}

