/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.kvp;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import net.opengis.wfs.WfsFactory;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.wfs.WFSException;
import org.geoserver.wfs.WFSInfo;
import org.geoserver.wfs.kvp.QNameKvpParser;
import org.geoserver.wfs.kvp.SRSEnvelope;
import org.geoserver.wfs.kvp.WFSKvpRequestReader;
import org.geoserver.wfs.request.GetFeatureRequest;
import org.geoserver.wfs.request.Query;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.geometry.jts.ReferencedEnvelope3D;
import org.geotools.gml2.bindings.GML2EncodingUtils;
import org.locationtech.jts.geom.Envelope;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.Id;
import org.opengis.filter.identity.FeatureId;
import org.opengis.filter.spatial.BBOX;
import org.opengis.geometry.BoundingBox3D;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.xml.sax.helpers.NamespaceSupport;

public abstract class BaseFeatureKvpRequestReader
extends WFSKvpRequestReader {
    protected Catalog catalog;
    protected FilterFactory filterFactory;
    protected GeoServer geoServer;
    protected final QNameKvpParser qNameParser;

    public BaseFeatureKvpRequestReader(Class<?> requestBean, GeoServer geoServer, FilterFactory filterFactory) {
        this(requestBean, (EFactory)WfsFactory.eINSTANCE, geoServer, filterFactory);
    }

    public BaseFeatureKvpRequestReader(Class<?> requestBean, EFactory factory, GeoServer geoServer, FilterFactory filterFactory) {
        super(requestBean, factory);
        this.catalog = geoServer.getCatalog();
        this.geoServer = geoServer;
        this.filterFactory = filterFactory;
        this.qNameParser = new QNameKvpParser("typeName", this.catalog);
    }

    protected WFSInfo getWFS() {
        return (WFSInfo)this.geoServer.getService(WFSInfo.class);
    }

    public Object read(Object request, Map<String, Object> kvp, Map<String, Object> rawKvp) throws Exception {
        List filter;
        request = super.read(request, kvp, rawKvp);
        EObject eObject = (EObject)request;
        this.ensureMutuallyExclusive(kvp, new String[]{"featureId", "resourceId", "filter", "bbox", "cql_filter"}, eObject);
        NamespaceSupport namespaces = null;
        if (kvp.containsKey("namespace") || kvp.containsKey("namespaces")) {
            if (kvp.get("namespace") instanceof NamespaceSupport) {
                namespaces = (NamespaceSupport)kvp.get("namespace");
            } else if (kvp.get("namespaces") instanceof NamespaceSupport) {
                namespaces = (NamespaceSupport)kvp.get("namespaces");
            } else {
                LOGGER.warning("There's a namespace parameter but it seems it wasn't parsed to a " + NamespaceSupport.class.getName() + ": " + kvp.get("namespace"));
            }
        }
        List<List<QName>> typeNames = null;
        if ((kvp.containsKey("typeName") || kvp.containsKey("typeNames")) && !kvp.containsKey("STOREDQUERY_ID")) {
            typeNames = this.getTypeNames(kvp);
            ArrayList<List<QName>> list = new ArrayList<List<QName>>();
            for (List<QName> obj : typeNames) {
                if (obj instanceof QName) {
                    QName qName = (QName)((Object)obj);
                    qName = this.checkTypeName(qName, namespaces, eObject);
                    ArrayList<QName> l = new ArrayList<QName>();
                    l.add(qName);
                    list.add(l);
                    continue;
                }
                List qNames = obj;
                for (int i = 0; i < qNames.size(); ++i) {
                    qNames.set(i, this.checkTypeName((QName)qNames.get(i), namespaces, eObject));
                }
                list.add(qNames);
            }
            kvp.put("typeName", list);
            this.querySet(eObject, "typeName", list);
            typeNames = list;
        } else if (kvp.containsKey("featureId") || kvp.containsKey("resourceId")) {
            List featureId = (List)kvp.get("featureId");
            featureId = featureId != null ? featureId : (List)kvp.get("resourceId");
            HashSet<List<QName>> hTypeNames = new HashSet<List<QName>>();
            for (Object o : featureId) {
                QName typeName = this.getTypeNameFromFeatureId((String)o);
                if (typeName == null) continue;
                hTypeNames.add(Arrays.asList(typeName));
            }
            ArrayList derivedTypeNames = new ArrayList(hTypeNames);
            this.querySet(eObject, "typeName", derivedTypeNames);
        } else {
            List<URI> storedQueryId = this.getStoredQueryId(kvp);
            if (storedQueryId != null) {
                this.buildStoredQueries(eObject, storedQueryId, rawKvp);
            } else {
                throw new WFSException(eObject, "The query should specify either typeName, featureId filter, or a stored query id", "MissingParameterValue");
            }
        }
        if (kvp.containsKey("filter")) {
            filter = (List)kvp.get("filter");
            this.querySet(eObject, "filter", filter);
        } else if (kvp.containsKey("cql_filter")) {
            filter = (List)kvp.get("cql_filter");
            this.querySet(eObject, "filter", filter);
        } else if (kvp.containsKey("featureId") || kvp.containsKey("resourceId")) {
            List featureIdList = (List)kvp.get("featureId");
            boolean isFeatureId = featureIdList != null;
            featureIdList = isFeatureId ? featureIdList : (List)kvp.get("resourceId");
            HashSet<FeatureId> ids = new HashSet<FeatureId>();
            for (Object o : featureIdList) {
                QName qName;
                String fid = (String)o;
                if (this.getWFS().isCiteCompliant() && typeNames != null && !typeNames.isEmpty() && (qName = this.getTypeNameFromFeatureId(fid)) != null && !typeNames.stream().flatMap(Collection::stream).anyMatch(q -> this.typeNameMatch(qName, (QName)q))) {
                    String locator = isFeatureId ? "FEATUREID" : "RESOURCEID";
                    WFSException exception = new WFSException(eObject, "ResourceId is incosistent with typenames");
                    exception.setCode("InvalidParameterValue");
                    exception.setLocator(locator);
                    throw exception;
                }
                FeatureId featureId = this.filterFactory.featureId(fid);
                ids.add(featureId);
            }
            List<Id> filters = Collections.singletonList(this.filterFactory.id(ids));
            this.querySet(eObject, "filter", filters);
        } else if (kvp.containsKey("bbox")) {
            this.handleBBOX(kvp, eObject);
        }
        return request;
    }

    private List<URI> getStoredQueryId(Map<String, Object> kvp) {
        List storedQueryId = null;
        if (kvp.containsKey("storedQuery_Id")) {
            storedQueryId = (List)kvp.get("storedQuery_Id");
        }
        if (storedQueryId == null && kvp.containsKey("storedQueryId")) {
            storedQueryId = (List)kvp.get("storedQueryId");
        }
        return storedQueryId;
    }

    private List<List<QName>> getTypeNames(Map<String, Object> kvp) {
        List typeNames = (List)kvp.get("typeName");
        if (typeNames == null) {
            typeNames = (List)kvp.get("typeNames");
        }
        return typeNames;
    }

    protected void handleBBOX(Map kvp, EObject eObject) throws Exception {
        Envelope bbox = (Envelope)kvp.get("bbox");
        List<Query> queries = this.getQueries(eObject);
        ArrayList<BBOX> filters = new ArrayList<BBOX>();
        for (Query q : queries) {
            BBOX filter;
            List<QName> typeName = q.getTypeNames();
            int typeNameSize = typeName.size();
            if (typeNameSize > 1) {
                ArrayList<BBOX> and = new ArrayList<BBOX>(typeNameSize);
                for (int i = 0; i < typeNameSize; ++i) {
                    and.add(this.bboxFilter(bbox));
                }
                filter = this.filterFactory.and(and);
            } else {
                filter = this.bboxFilter(bbox);
            }
            filters.add(filter);
        }
        this.querySet(eObject, "filter", filters);
    }

    protected List<Query> getQueries(EObject eObject) {
        return GetFeatureRequest.adapt(eObject).getQueries();
    }

    public boolean typeNameMatch(QName maybeUnqualified, QName qualified) {
        return maybeUnqualified.equals(qualified) || (maybeUnqualified.getNamespaceURI() == null || maybeUnqualified.getNamespaceURI().isEmpty()) && qualified.getLocalPart().equals(maybeUnqualified.getLocalPart());
    }

    QName getTypeNameFromFeatureId(String fid) throws Exception {
        int pos = fid.indexOf(".");
        if (pos != -1) {
            String typeName = fid.substring(0, fid.lastIndexOf("."));
            List parsed = (List)this.qNameParser.parse(typeName);
            return (QName)parsed.get(0);
        }
        return null;
    }

    protected void ensureMutuallyExclusive(Map kvp, String[] keys, EObject request) {
        for (int i = 0; i < keys.length; ++i) {
            if (!kvp.containsKey(keys[i])) continue;
            for (int j = i + 1; j < keys.length; ++j) {
                if (!kvp.containsKey(keys[j])) continue;
                String msg = keys[i] + " and " + keys[j] + " both specified but are mutually exclusive";
                throw new WFSException(request, msg);
            }
        }
    }

    QName checkTypeName(QName qName, NamespaceSupport namespaces, EObject request) {
        String namespaceURI = qName.getNamespaceURI();
        String localPart = qName.getLocalPart();
        String prefix = qName.getPrefix();
        if (namespaces != null) {
            if ("".equals(prefix)) {
                String uri = namespaces.getURI("");
                if (!"".equals(uri)) {
                    namespaceURI = uri;
                }
            } else if (namespaces.getURI(prefix) != null) {
                namespaceURI = namespaces.getURI(qName.getPrefix());
            }
            NamespaceInfo ns = this.catalog.getNamespaceByURI(namespaceURI);
            if (ns == null) {
                throw new WFSException("Unknown namespace [" + qName.getPrefix() + "]", "InvalidParameterValue", "namespace");
            }
            prefix = ns.getPrefix();
            qName = new QName(namespaceURI, localPart, prefix);
        }
        if (!"".equals(qName.getPrefix()) && this.catalog.getNamespaceByPrefix(qName.getPrefix()) == null) {
            throw new WFSException("Unknown namespace [" + qName.getPrefix() + "]", "InvalidParameterValue", "namespace");
        }
        if (this.catalog.getFeatureTypeByName(namespaceURI, localPart) == null) {
            String name = qName.getPrefix() + ":" + qName.getLocalPart();
            throw new WFSException("Feature type " + name + " unknown", "InvalidParameterValue", "typeName");
        }
        return qName;
    }

    protected BBOX bboxFilter(Envelope bbox) {
        CoordinateReferenceSystem crs;
        String name = "";
        if (bbox instanceof ReferencedEnvelope3D) {
            return this.filterFactory.bbox(name, (BoundingBox3D)((ReferencedEnvelope3D)bbox));
        }
        String epsgCode = null;
        if (bbox instanceof SRSEnvelope) {
            SRSEnvelope se = (SRSEnvelope)bbox;
            epsgCode = se.getSrs();
        } else if (bbox instanceof ReferencedEnvelope && (crs = ((ReferencedEnvelope)bbox).getCoordinateReferenceSystem()) != null) {
            epsgCode = GML2EncodingUtils.toURI((CoordinateReferenceSystem)crs);
        }
        return this.filterFactory.bbox(name, bbox.getMinX(), bbox.getMinY(), bbox.getMaxX(), bbox.getMaxY(), epsgCode);
    }

    protected abstract <T> void querySet(EObject var1, String var2, List<T> var3);

    protected abstract void buildStoredQueries(EObject var1, List<URI> var2, Map<String, Object> var3);
}

