/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.json;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Writer;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletResponse;
import net.sf.json.JSONException;
import net.sf.json.util.JSONBuilder;
import org.geoserver.ows.Request;
import org.geoserver.ows.util.OwsUtils;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.ServiceException;

public enum JSONType {
    JSONP,
    JSON;

    public static final String CALLBACK_FUNCTION_KEY = "callback";
    public static final String ID_POLICY = "id_policy";
    public static final String CALLBACK_FUNCTION = "parseResponse";
    public static final String json = "application/json";
    public static final String simple_json = "json";
    public static final String jsonp = "text/javascript";
    public static final String ENABLE_JSONP_KEY = "ENABLE_JSONP";
    private static boolean jsonpEnabled;
    private static ReadWriteLock lock;

    public static boolean isJsonpMimeType(String type) {
        return jsonp.equalsIgnoreCase(type);
    }

    public static boolean useJsonp(String type) {
        return JSONType.isJsonpEnabled() && JSONType.isJsonpMimeType(type);
    }

    public static boolean isJsonpEnabled() {
        lock.readLock().lock();
        try {
            boolean bl = jsonpEnabled;
            return bl;
        }
        finally {
            lock.readLock().unlock();
        }
    }

    public static void setJsonpEnabled(boolean jsonpEnabled) {
        if (jsonpEnabled != JSONType.jsonpEnabled) {
            lock.writeLock().lock();
            try {
                JSONType.jsonpEnabled = jsonpEnabled;
            }
            finally {
                lock.writeLock().unlock();
            }
        }
    }

    private static boolean isJsonpPropertyEnabled() {
        String jsonp = GeoServerExtensions.getProperty((String)ENABLE_JSONP_KEY);
        return Boolean.parseBoolean(jsonp);
    }

    public static boolean isJsonMimeType(String type) {
        return json.equalsIgnoreCase(type) || simple_json.equalsIgnoreCase(type);
    }

    public static JSONType getJSONType(String mime) {
        if (json.equalsIgnoreCase(mime) || simple_json.equalsIgnoreCase(mime)) {
            return JSON;
        }
        if (jsonp.equalsIgnoreCase(mime)) {
            return JSONP;
        }
        return null;
    }

    public String getMimeType() {
        switch (this) {
            case JSON: {
                return json;
            }
            case JSONP: {
                return jsonp;
            }
        }
        return null;
    }

    public static String[] getSupportedTypes() {
        if (JSONType.isJsonpEnabled()) {
            return new String[]{json, simple_json, jsonp};
        }
        return new String[]{json, simple_json};
    }

    public static String getCallbackFunction(Map kvp) {
        if (!(kvp.get("FORMAT_OPTIONS") instanceof Map)) {
            return CALLBACK_FUNCTION;
        }
        Map map = (Map)kvp.get("FORMAT_OPTIONS");
        String callback = (String)map.get(CALLBACK_FUNCTION_KEY);
        if (callback != null) {
            return callback;
        }
        return CALLBACK_FUNCTION;
    }

    public static String getIdPolicy(Map kvp) {
        if (!(kvp.get("FORMAT_OPTIONS") instanceof Map)) {
            return null;
        }
        Map formatOptions = (Map)kvp.get("FORMAT_OPTIONS");
        if (formatOptions == null || formatOptions.isEmpty()) {
            return null;
        }
        String id_policy = (String)formatOptions.get(ID_POLICY);
        if (id_policy == null || "true".equals(id_policy)) {
            return null;
        }
        if ("false".equals(id_policy) || id_policy.length() == 0) {
            return "";
        }
        return id_policy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void handleJsonException(Logger LOGGER, ServiceException exception, Request request, String charset, boolean verbose, boolean isJsonp) {
        block11: {
            HttpServletResponse response = request.getHttpResponse();
            response.setCharacterEncoding(charset);
            try {
                if (isJsonp) {
                    response.setContentType(jsonp);
                    JSONType.writeJsonpException(exception, request, (OutputStream)response.getOutputStream(), charset, verbose);
                    break block11;
                }
                OutputStreamWriter outWriter = null;
                try {
                    outWriter = new OutputStreamWriter((OutputStream)response.getOutputStream(), charset);
                    response.setContentType(json);
                    JSONType.writeJsonException(exception, request, outWriter, verbose);
                }
                finally {
                    if (outWriter != null) {
                        try {
                            outWriter.flush();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
            catch (Exception e) {
                if (LOGGER == null || !LOGGER.isLoggable(Level.SEVERE)) break block11;
                LOGGER.severe(e.getLocalizedMessage());
            }
        }
    }

    private static void writeJsonpException(ServiceException exception, Request request, OutputStream out, String charset, boolean verbose) throws IOException {
        OutputStreamWriter outWriter = new OutputStreamWriter(out, charset);
        String callback = request == null ? CALLBACK_FUNCTION : JSONType.getCallbackFunction(request.getKvp());
        outWriter.write(callback + "(");
        JSONType.writeJsonException(exception, request, outWriter, verbose);
        outWriter.write(")");
        outWriter.flush();
    }

    private static void writeJsonException(ServiceException exception, Request request, OutputStreamWriter outWriter, boolean verbose) throws IOException {
        try {
            JSONBuilder json = new JSONBuilder((Writer)outWriter);
            json.object().key("version").value((Object)(request != null ? request.getVersion() : "")).key("exceptions").array().object().key("code").value((Object)(exception.getCode() == null ? "noApplicableCode" : exception.getCode())).key("locator").value((Object)(exception.getLocator() == null ? "noLocator" : exception.getLocator())).key("text");
            if (exception.getMessage() != null) {
                StringBuffer sb = new StringBuffer(exception.getMessage().length());
                OwsUtils.dumpExceptionMessages((Throwable)exception, (StringBuffer)sb, (boolean)false);
                if (verbose) {
                    try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
                        exception.printStackTrace(new PrintStream(bos));
                        sb.append("\nDetails:\n");
                        sb.append(new String(bos.toByteArray()));
                    }
                }
                json.value((Object)sb.toString());
            }
            json.endObject().endArray().endObject();
        }
        catch (JSONException jsonException) {
            ServiceException serviceException = new ServiceException("Error: " + jsonException.getMessage());
            serviceException.initCause((Throwable)jsonException);
            throw serviceException;
        }
    }

    static {
        jsonpEnabled = JSONType.isJsonpPropertyEnabled();
        lock = new ReentrantReadWriteLock(true);
    }
}

