/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.json;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.sql.Date;
import java.sql.Time;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.ows.Dispatcher;
import org.geoserver.ows.Request;
import org.geoserver.platform.Operation;
import org.geoserver.platform.ServiceException;
import org.geoserver.wfs.WFSDescribeFeatureTypeOutputFormat;
import org.geoserver.wfs.json.GeoJSONBuilder;
import org.geoserver.wfs.json.JSONType;
import org.locationtech.jts.geom.Geometry;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;

public class JSONDescribeFeatureTypeResponse
extends WFSDescribeFeatureTypeOutputFormat {
    public JSONDescribeFeatureTypeResponse(GeoServer gs, String mime) {
        super(gs, mime);
    }

    @Override
    protected void write(FeatureTypeInfo[] featureTypeInfos, OutputStream output, Operation describeFeatureType) throws IOException {
        if (featureTypeInfos.length == 0) {
            throw new IOException("Unable to write an empty feature info array.");
        }
        try (OutputStreamWriter osw = new OutputStreamWriter(output, this.gs.getSettings().getCharset());
             BufferedWriter outWriter = new BufferedWriter(osw);){
            boolean jsonp = JSONType.useJsonp(this.getMimeType(featureTypeInfos, describeFeatureType));
            if (jsonp) {
                outWriter.write(this.getCallbackFunction() + "(");
            }
            GeoJSONBuilder jw = new GeoJSONBuilder(outWriter);
            jw.object();
            jw.key("elementFormDefault");
            jw.value("qualified");
            jw.key("targetNamespace");
            NamespaceInfo nsInfo = featureTypeInfos[0].getNamespace();
            jw.value(nsInfo.getURI());
            jw.key("targetPrefix");
            jw.value(nsInfo.getName());
            jw.key("featureTypes");
            jw.array();
            for (FeatureTypeInfo ft : featureTypeInfos) {
                jw.object();
                jw.key("typeName").value((Object)ft.getName());
                SimpleFeatureType schema = (SimpleFeatureType)ft.getFeatureType();
                jw.key("properties");
                jw.array();
                for (AttributeDescriptor ad : schema.getAttributeDescriptors()) {
                    if (ad == schema.getGeometryDescriptor()) {
                        JSONDescribeFeatureTypeResponse.describeProperty(ad.getLocalName(), ad, jw, true);
                        continue;
                    }
                    JSONDescribeFeatureTypeResponse.describeProperty(ad.getLocalName(), ad, jw, false);
                }
                jw.endArray();
                jw.endObject();
            }
            jw.endArray();
            jw.endObject();
            if (jsonp) {
                outWriter.write(")");
            }
            ((Writer)outWriter).flush();
        }
    }

    private String getCallbackFunction() {
        Request request = (Request)Dispatcher.REQUEST.get();
        if (request == null) {
            return "parseResponse";
        }
        return JSONType.getCallbackFunction(request.getKvp());
    }

    private static void describeProperty(String name, AttributeDescriptor ad, GeoJSONBuilder jw, boolean isGeometry) {
        jw.object();
        jw.key("name").value((Object)name);
        jw.key("maxOccurs").value((long)ad.getMaxOccurs());
        jw.key("minOccurs").value((long)ad.getMinOccurs());
        jw.key("nillable").value(ad.getMinOccurs() <= 0);
        Class binding = ad.getType().getBinding();
        if (isGeometry) {
            jw.key("type").value((Object)("gml:" + JSONDescribeFeatureTypeResponse.mapToJsonType(binding)));
        } else {
            jw.key("type").value((Object)("xsd:" + JSONDescribeFeatureTypeResponse.mapToJsonType(binding)));
        }
        jw.key("localType").value((Object)JSONDescribeFeatureTypeResponse.mapToJsonType(binding));
        jw.endObject();
    }

    private static String mapToJsonType(Class<?> binding) {
        if (Long.class.isAssignableFrom(binding) || Integer.class.isAssignableFrom(binding) || Short.class.isAssignableFrom(binding) || Byte.class.isAssignableFrom(binding)) {
            return "int";
        }
        if (Number.class.isAssignableFrom(binding)) {
            return "number";
        }
        if (Boolean.class.isAssignableFrom(binding)) {
            return "boolean";
        }
        if (Geometry.class.isAssignableFrom(binding)) {
            return binding.getSimpleName();
        }
        if (Date.class.isAssignableFrom(binding)) {
            return "date";
        }
        if (Time.class.isAssignableFrom(binding)) {
            return "time";
        }
        if (java.util.Date.class.isAssignableFrom(binding)) {
            return "date-time";
        }
        return "string";
    }

    public String getMimeType(Object value, Operation operation) throws ServiceException {
        return this.getOutputFormats().isEmpty() ? null : (String)this.getOutputFormats().iterator().next();
    }
}

