/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.json;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.math.BigInteger;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.json.JSONException;
import org.geoserver.config.GeoServer;
import org.geoserver.data.util.TemporalUtils;
import org.geoserver.ows.Dispatcher;
import org.geoserver.ows.Request;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.Operation;
import org.geoserver.platform.ServiceException;
import org.geoserver.util.ISO8601Formatter;
import org.geoserver.wfs.WFSGetFeatureOutputFormat;
import org.geoserver.wfs.WFSInfo;
import org.geoserver.wfs.json.ComplexGeoJsonWriter;
import org.geoserver.wfs.json.ComplexGeoJsonWriterOptions;
import org.geoserver.wfs.json.DefaultComplexGeoJsonWriterOptions;
import org.geoserver.wfs.json.GeoJSONBuilder;
import org.geoserver.wfs.json.JSONType;
import org.geoserver.wfs.request.FeatureCollectionResponse;
import org.geoserver.wfs.response.ComplexFeatureAwareFormat;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.gml2.SrsSyntax;
import org.geotools.referencing.CRS;
import org.geotools.referencing.NamedIdentifier;
import org.geotools.util.logging.Logging;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.opengis.feature.Feature;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class GeoJSONGetFeatureResponse
extends WFSGetFeatureOutputFormat
implements ComplexFeatureAwareFormat {
    private final Logger LOGGER = Logging.getLogger(this.getClass());
    protected final boolean jsonp;

    public GeoJSONGetFeatureResponse(GeoServer gs, String format) {
        super(gs, format);
        this.jsonp = JSONType.isJsonpMimeType(format);
    }

    protected GeoJSONGetFeatureResponse(GeoServer gs, String format, boolean jsonp) {
        super(gs, format);
        this.jsonp = jsonp;
    }

    @Override
    public String getCapabilitiesElementName() {
        return JSONType.getJSONType(this.getOutputFormats().isEmpty() ? null : (String)this.getOutputFormats().iterator().next()).toString();
    }

    @Override
    public String getMimeType(Object value, Operation operation) throws ServiceException {
        if (this.jsonp) {
            return JSONType.JSONP.getMimeType();
        }
        return JSONType.JSON.getMimeType();
    }

    protected static boolean isComplexFeature(FeatureCollectionResponse results) {
        for (FeatureCollection featureCollection : results.getFeatures()) {
            if (featureCollection.getSchema() instanceof SimpleFeatureType) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void write(FeatureCollectionResponse featureCollection, OutputStream output, Operation operation) throws IOException {
        BigInteger totalNumberOfFeatures;
        if (this.LOGGER.isLoggable(Level.INFO)) {
            this.LOGGER.info("about to encode JSON");
        }
        BigInteger featureCount = (totalNumberOfFeatures = featureCollection.getTotalNumberOfFeatures()) != null && totalNumberOfFeatures.longValue() < 0L ? null : totalNumberOfFeatures;
        try {
            OutputStreamWriter osw = new OutputStreamWriter(output, this.gs.getGlobal().getSettings().getCharset());
            BufferedWriter outWriter = new BufferedWriter(osw);
            if (this.jsonp) {
                outWriter.write(this.getCallbackFunction() + "(");
            }
            boolean isComplex = GeoJSONGetFeatureResponse.isComplexFeature(featureCollection);
            if (featureCount != null && isComplex && featureCount.equals(BigInteger.ZERO)) {
                featureCount = null;
            }
            GeoJSONBuilder jsonWriter = this.getGeoJSONBuilder(featureCollection, outWriter);
            jsonWriter.object().key("type").value((Object)"FeatureCollection");
            jsonWriter.key("features");
            jsonWriter.array();
            List<FeatureCollection> resultsList = featureCollection.getFeature();
            FeaturesInfo featuresInfo = this.writeFeatures(resultsList, operation, isComplex, jsonWriter);
            jsonWriter.endArray();
            boolean hasGeom = featuresInfo.hasGeometry;
            CoordinateReferenceSystem crs = featuresInfo.crs;
            long numberReturned = featuresInfo.featureCount;
            this.writeCollectionCounts(featureCount, numberReturned, jsonWriter);
            this.writeCollectionTimeStamp(jsonWriter);
            this.writePagingLinks(featureCollection, operation, jsonWriter);
            this.writeCollectionCRS(jsonWriter, crs);
            this.writeCollectionBounds(this.isFeatureBounding(), jsonWriter, resultsList, hasGeom);
            this.writeExtraCollectionProperties(featureCollection, operation, jsonWriter);
            jsonWriter.endObject();
            if (this.jsonp) {
                outWriter.write(")");
            }
            ((Writer)outWriter).flush();
        }
        catch (JSONException jsonException) {
            ServiceException serviceException = new ServiceException("Error: " + jsonException.getMessage());
            serviceException.initCause((Throwable)jsonException);
            throw serviceException;
        }
    }

    protected GeoJSONBuilder getGeoJSONBuilder(FeatureCollectionResponse featureCollection, Writer outWriter) {
        GeoJSONBuilder jsonWriter = new GeoJSONBuilder(outWriter);
        int numDecimals = this.getNumDecimals(featureCollection.getFeature(), this.gs, this.gs.getCatalog());
        jsonWriter.setNumberOfDecimals(numDecimals);
        jsonWriter.setEncodeMeasures(this.encodeMeasures(featureCollection.getFeature(), this.gs.getCatalog()));
        return jsonWriter;
    }

    protected boolean isFeatureBounding() {
        WFSInfo wfs = this.getInfo();
        return wfs.isFeatureBounding();
    }

    public FeaturesInfo writeFeatures(List<FeatureCollection> resultsList, final Operation operation, boolean isComplex, final GeoJSONBuilder jsonWriter) {
        FeaturesInfo featuresInfo;
        if (!isComplex) {
            featuresInfo = this.encodeSimpleFeatures(jsonWriter, resultsList, this.isFeatureBounding(), operation);
        } else {
            ComplexGeoJsonWriterOptions complexWriterOptions = this.getComplexGeoJsonWriterOptions(resultsList);
            ComplexGeoJsonWriter complexWriter = new ComplexGeoJsonWriter(jsonWriter, complexWriterOptions){

                @Override
                protected void writeExtraFeatureProperties(Feature feature, boolean topLevelFeature) {
                    if (topLevelFeature) {
                        GeoJSONGetFeatureResponse.this.writeExtraFeatureProperties(feature, operation, jsonWriter);
                    }
                }
            };
            complexWriter.write(resultsList);
            featuresInfo = new FeaturesInfo(complexWriter.foundCrs(), complexWriter.geometryFound(), complexWriter.getFeaturesCount());
        }
        return featuresInfo;
    }

    protected void writeCollectionTimeStamp(GeoJSONBuilder jw) {
        jw.key("timeStamp").value((Object)new ISO8601Formatter().format(new Date()));
    }

    protected void writeCollectionCounts(BigInteger featureCount, long numberReturned, GeoJSONBuilder jsonWriter) {
        if (featureCount != null) {
            jsonWriter.key("totalFeatures").value((Object)featureCount);
            jsonWriter.key("numberMatched").value((Object)featureCount);
        } else {
            jsonWriter.key("totalFeatures").value((Object)"unknown");
        }
        jsonWriter.key("numberReturned").value(numberReturned);
    }

    protected void writeCollectionBounds(boolean featureBounding, GeoJSONBuilder jsonWriter, List<FeatureCollection> resultsList, boolean hasGeom) {
        if (hasGeom && featureBounding) {
            CoordinateReferenceSystem crs = null;
            ReferencedEnvelope e = null;
            for (FeatureCollection collection : resultsList) {
                FeatureType schema = collection.getSchema();
                if (crs == null && schema.getGeometryDescriptor() != null) {
                    crs = schema.getGeometryDescriptor().getCoordinateReferenceSystem();
                }
                if (e == null) {
                    e = collection.getBounds();
                    continue;
                }
                e.expandToInclude((Envelope)collection.getBounds());
            }
            if (e != null) {
                jsonWriter.setAxisOrder(CRS.getAxisOrder(crs));
                jsonWriter.writeBoundingBox((Envelope)e);
            }
        }
    }

    protected void writeCollectionCRS(GeoJSONBuilder jsonWriter, CoordinateReferenceSystem crs) throws IOException {
        try {
            if ("true".equals(GeoServerExtensions.getProperty((String)"GEOSERVER_GEOJSON_LEGACY_CRS"))) {
                this.writeCrsLegacy(jsonWriter, crs);
            } else {
                this.writeCrs(jsonWriter, crs);
            }
        }
        catch (FactoryException e) {
            throw (IOException)new IOException("Error looking up crs identifier").initCause(e);
        }
    }

    protected void writePagingLinks(FeatureCollectionResponse response, Operation operation, GeoJSONBuilder jw) {
        if (response.getPrevious() != null || response.getNext() != null) {
            jw.key("links");
            jw.array();
            String mimeType = this.getMimeType(response, operation);
            this.writeLink(jw, "previous page", mimeType, "previous", response.getPrevious());
            this.writeLink(jw, "next page", mimeType, "next", response.getNext());
            jw.endArray();
        }
    }

    protected void writeLink(GeoJSONBuilder jw, String title, String mimeType, String rel, String href) {
        if (href != null) {
            jw.object();
            if (title != null) {
                jw.key("title").value((Object)title);
            }
            if (mimeType != null) {
                jw.key("type").value((Object)mimeType);
            }
            if (rel != null) {
                jw.key("rel").value((Object)rel);
            }
            jw.key("href").value((Object)href);
            jw.endObject();
        }
    }

    protected void writeExtraCollectionProperties(FeatureCollectionResponse response, Operation operation, GeoJSONBuilder jw) {
    }

    protected FeaturesInfo encodeSimpleFeatures(GeoJSONBuilder jsonWriter, List<FeatureCollection> resultsList, boolean featureBounding, Operation operation) {
        String id_option = this.getIdOption();
        CoordinateReferenceSystem crs = null;
        boolean hasGeom = false;
        long featureCount = 0L;
        for (FeatureCollection collection : resultsList) {
            FeatureIterator iterator = collection.features();
            Throwable throwable = null;
            try {
                while (iterator.hasNext()) {
                    SimpleFeature simpleFeature = (SimpleFeature)iterator.next();
                    ++featureCount;
                    jsonWriter.object();
                    jsonWriter.key("type").value((Object)"Feature");
                    SimpleFeatureType fType = simpleFeature.getFeatureType();
                    List types = fType.getAttributeDescriptors();
                    if (id_option == null) {
                        jsonWriter.key("id").value((Object)simpleFeature.getID());
                    } else if (id_option.length() != 0) {
                        Object value = simpleFeature.getAttribute(id_option);
                        jsonWriter.key("id").value(value);
                    }
                    GeometryDescriptor defaultGeomType = fType.getGeometryDescriptor();
                    if (defaultGeomType != null) {
                        CoordinateReferenceSystem featureCrs = defaultGeomType.getCoordinateReferenceSystem();
                        jsonWriter.setAxisOrder(CRS.getAxisOrder((CoordinateReferenceSystem)featureCrs));
                        if (crs == null) {
                            crs = featureCrs;
                        }
                    } else {
                        jsonWriter.setAxisOrder(CRS.AxisOrder.EAST_NORTH);
                    }
                    Geometry aGeom = (Geometry)simpleFeature.getDefaultGeometry();
                    if (aGeom != null || this.writeNullGeometries()) {
                        jsonWriter.key("geometry");
                        if (aGeom != null) {
                            jsonWriter.writeGeom(aGeom);
                            hasGeom = true;
                        } else {
                            jsonWriter.value(null);
                        }
                        if (defaultGeomType != null) {
                            jsonWriter.key("geometry_name").value((Object)defaultGeomType.getLocalName());
                        }
                    }
                    jsonWriter.key("properties");
                    jsonWriter.object();
                    for (int j = 0; j < types.size(); ++j) {
                        Object value = simpleFeature.getAttribute(j);
                        AttributeDescriptor ad = (AttributeDescriptor)types.get(j);
                        if (id_option != null && id_option.equals(ad.getLocalName())) continue;
                        if (ad instanceof GeometryDescriptor) {
                            if (ad.equals(defaultGeomType)) continue;
                            if (value == null) {
                                jsonWriter.key(ad.getLocalName());
                                jsonWriter.value(null);
                                continue;
                            }
                            jsonWriter.key(ad.getLocalName());
                            jsonWriter.writeGeom((Geometry)value);
                            continue;
                        }
                        if (Date.class.isAssignableFrom(ad.getType().getBinding()) && TemporalUtils.isDateTimeFormatEnabled()) {
                            jsonWriter.key(ad.getLocalName());
                            jsonWriter.value(TemporalUtils.printDate((Date)((Date)value)));
                            continue;
                        }
                        jsonWriter.key(ad.getLocalName());
                        if (value instanceof Double && Double.isNaN((Double)value) || value instanceof Float && Float.isNaN(((Float)value).floatValue())) {
                            jsonWriter.value(null);
                            continue;
                        }
                        if (value instanceof Double && (Double)value == Double.POSITIVE_INFINITY || value instanceof Float && ((Float)value).floatValue() == Float.POSITIVE_INFINITY) {
                            jsonWriter.value("Infinity");
                            continue;
                        }
                        if (value instanceof Double && (Double)value == Double.NEGATIVE_INFINITY || value instanceof Float && ((Float)value).floatValue() == Float.NEGATIVE_INFINITY) {
                            jsonWriter.value("-Infinity");
                            continue;
                        }
                        jsonWriter.value(value);
                    }
                    jsonWriter.endObject();
                    ReferencedEnvelope refenv = ReferencedEnvelope.reference((org.opengis.geometry.Envelope)simpleFeature.getBounds());
                    if (featureBounding && !refenv.isEmpty()) {
                        jsonWriter.writeBoundingBox((Envelope)refenv);
                    }
                    this.writeExtraFeatureProperties((Feature)simpleFeature, operation, jsonWriter);
                    jsonWriter.endObject();
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (iterator == null) continue;
                if (throwable != null) {
                    try {
                        iterator.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                iterator.close();
            }
        }
        return new FeaturesInfo(crs, hasGeom, featureCount);
    }

    protected boolean writeNullGeometries() {
        return true;
    }

    protected String getIdOption() {
        String id_option = null;
        Request request = (Request)Dispatcher.REQUEST.get();
        if (request != null) {
            id_option = JSONType.getIdPolicy(request.getKvp());
        }
        return id_option;
    }

    protected void writeExtraFeatureProperties(Feature feature, Operation operation, GeoJSONBuilder jsonWriter) {
    }

    private void writeCrs(GeoJSONBuilder jsonWriter, CoordinateReferenceSystem crs) throws FactoryException {
        if (crs != null) {
            String identifier = null;
            Integer code = CRS.lookupEpsgCode((CoordinateReferenceSystem)crs, (boolean)true);
            if (code != null) {
                if (code != null) {
                    identifier = SrsSyntax.OGC_URN.getPrefix() + code;
                }
            } else {
                identifier = CRS.lookupIdentifier((IdentifiedObject)crs, (boolean)true);
            }
            jsonWriter.key("crs");
            jsonWriter.object();
            jsonWriter.key("type").value((Object)"name");
            jsonWriter.key("properties");
            jsonWriter.object();
            jsonWriter.key("name");
            jsonWriter.value(identifier);
            jsonWriter.endObject();
            jsonWriter.endObject();
        } else {
            jsonWriter.key("crs");
            jsonWriter.value(null);
        }
    }

    private void writeCrsLegacy(GeoJSONBuilder jsonWriter, CoordinateReferenceSystem crs) {
        NamedIdentifier namedIdent;
        String csStr;
        Set ids;
        if (crs != null && (ids = crs.getIdentifiers()) != null && !ids.isEmpty() && (csStr = (namedIdent = (NamedIdentifier)ids.iterator().next()).getCodeSpace().toUpperCase()).equals("EPSG")) {
            jsonWriter.key("crs");
            jsonWriter.object();
            jsonWriter.key("type").value((Object)csStr);
            jsonWriter.key("properties");
            jsonWriter.object();
            jsonWriter.key("code");
            jsonWriter.value(namedIdent.getCode());
            jsonWriter.endObject();
            jsonWriter.endObject();
        }
    }

    private String getCallbackFunction() {
        Request request = (Request)Dispatcher.REQUEST.get();
        if (request == null) {
            return "parseResponse";
        }
        return JSONType.getCallbackFunction(request.getKvp());
    }

    public String getCharset(Operation operation) {
        return this.gs.getGlobal().getSettings().getCharset();
    }

    @Override
    protected String getExtension(FeatureCollectionResponse response) {
        return "json";
    }

    private ComplexGeoJsonWriterOptions getComplexGeoJsonWriterOptions(List<FeatureCollection> resultsList) {
        List settings = GeoServerExtensions.extensions(ComplexGeoJsonWriterOptions.class);
        ComplexGeoJsonWriterOptions chosen = null;
        for (ComplexGeoJsonWriterOptions setting : settings) {
            if (!setting.canHandle(resultsList)) continue;
            chosen = setting;
        }
        if (chosen == null) {
            chosen = new DefaultComplexGeoJsonWriterOptions();
        }
        if (this.LOGGER.isLoggable(Level.FINE)) {
            this.LOGGER.log(Level.FINE, "Chosen ComplexGeoJsonWriterOptions " + chosen.getClass());
        }
        return chosen;
    }

    protected class FeaturesInfo {
        final CoordinateReferenceSystem crs;
        final boolean hasGeometry;
        public long featureCount;

        protected FeaturesInfo(CoordinateReferenceSystem crs, boolean hasGeometry, long featureCount) {
            this.crs = crs;
            this.hasGeometry = hasGeometry;
            this.featureCount = featureCount;
        }
    }
}

