/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.json;

import java.io.Writer;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONException;
import net.sf.json.util.JSONBuilder;
import org.geoserver.wfs.json.RoundingUtil;
import org.geotools.referencing.CRS;
import org.geotools.util.Converters;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;

public class GeoJSONBuilder
extends JSONBuilder {
    private CRS.AxisOrder axisOrder = CRS.AxisOrder.EAST_NORTH;
    private int numDecimals = 6;
    private boolean encodeMeasures = false;
    protected static final int POINT = 1;
    protected static final int LINESTRING = 2;
    protected static final int POLYGON = 3;
    protected static final int MULTIPOINT = 4;
    protected static final int MULTILINESTRING = 5;
    protected static final int MULTIPOLYGON = 6;
    protected static final int MULTIGEOMETRY = 7;

    public GeoJSONBuilder(Writer w) {
        super(w);
    }

    public JSONBuilder writeGeom(Geometry geometry) throws JSONException {
        this.object();
        this.key("type");
        this.value(GeoJSONBuilder.getGeometryName(geometry));
        int geometryType = GeoJSONBuilder.getGeometryType(geometry);
        if (geometryType != 7) {
            this.key("coordinates");
            switch (geometryType) {
                case 1: {
                    Point point = (Point)geometry;
                    this.writeCoordinate(point);
                    break;
                }
                case 2: {
                    this.writeCoordinates(((LineString)geometry).getCoordinateSequence());
                    break;
                }
                case 4: {
                    this.array();
                    int n = geometry.getNumGeometries();
                    for (int i = 0; i < n; ++i) {
                        this.writeCoordinate((Point)geometry.getGeometryN(i));
                    }
                    this.endArray();
                    break;
                }
                case 3: {
                    this.writePolygon((Polygon)geometry);
                    break;
                }
                case 5: {
                    this.array();
                    int n = geometry.getNumGeometries();
                    for (int i = 0; i < n; ++i) {
                        this.writeCoordinates(((LineString)geometry.getGeometryN(i)).getCoordinateSequence());
                    }
                    this.endArray();
                    break;
                }
                case 6: {
                    this.array();
                    int n = geometry.getNumGeometries();
                    for (int i = 0; i < n; ++i) {
                        this.writePolygon((Polygon)geometry.getGeometryN(i));
                    }
                    this.endArray();
                }
            }
        } else {
            this.writeGeomCollection((GeometryCollection)geometry);
        }
        return this.endObject();
    }

    private JSONBuilder writeGeomCollection(GeometryCollection collection) {
        this.key("geometries");
        this.array();
        int n = collection.getNumGeometries();
        for (int i = 0; i < n; ++i) {
            this.writeGeom(collection.getGeometryN(i));
        }
        return this.endArray();
    }

    private JSONBuilder writeCoordinate(Point point) throws JSONException {
        CoordinateSequence coordinates = point.getCoordinateSequence();
        double m = this.encodeMeasures ? coordinates.getM(0) : Double.NaN;
        return this.writeCoordinate(coordinates.getX(0), coordinates.getY(0), coordinates.getZ(0), m);
    }

    private JSONBuilder writeCoordinates(CoordinateSequence coordinates) throws JSONException {
        this.array();
        for (int i = 0; i < coordinates.size(); ++i) {
            double m = this.encodeMeasures ? coordinates.getM(i) : Double.NaN;
            this.writeCoordinate(coordinates.getX(i), coordinates.getY(i), coordinates.getZ(i), m);
        }
        return this.endArray();
    }

    private JSONBuilder writeCoordinate(double x, double y, double z, double m) {
        this.array();
        if (this.axisOrder == CRS.AxisOrder.NORTH_EAST) {
            if (!Double.isNaN(y)) {
                this.roundedValue(y);
            }
            this.roundedValue(x);
        } else {
            this.roundedValue(x);
            if (!Double.isNaN(y)) {
                this.roundedValue(y);
            }
        }
        double d = z = Double.isNaN(z) && !Double.isNaN(m) ? 0.0 : z;
        if (!Double.isNaN(z)) {
            this.roundedValue(z);
        }
        if (!Double.isNaN(m)) {
            this.roundedValue(m);
        }
        return this.endArray();
    }

    private void roundedValue(double value) {
        super.value(RoundingUtil.round(value, this.numDecimals));
    }

    protected JSONBuilder writeBoundingBox(Envelope env) {
        this.key("bbox");
        this.array();
        if (this.axisOrder == CRS.AxisOrder.NORTH_EAST) {
            this.roundedValue(env.getMinY());
            this.roundedValue(env.getMinX());
            this.roundedValue(env.getMaxY());
            this.roundedValue(env.getMaxX());
        } else {
            this.roundedValue(env.getMinX());
            this.roundedValue(env.getMinY());
            this.roundedValue(env.getMaxX());
            this.roundedValue(env.getMaxY());
        }
        return this.endArray();
    }

    private void writePolygon(Polygon geometry) throws JSONException {
        this.array();
        this.writeCoordinates(geometry.getExteriorRing().getCoordinateSequence());
        int ii = geometry.getNumInteriorRing();
        for (int i = 0; i < ii; ++i) {
            this.writeCoordinates(geometry.getInteriorRingN(i).getCoordinateSequence());
        }
        this.endArray();
    }

    public static String getGeometryName(Geometry geometry) {
        if (geometry instanceof Point) {
            return "Point";
        }
        if (geometry instanceof LineString) {
            return "LineString";
        }
        if (geometry instanceof Polygon) {
            return "Polygon";
        }
        if (geometry instanceof MultiPoint) {
            return "MultiPoint";
        }
        if (geometry instanceof MultiLineString) {
            return "MultiLineString";
        }
        if (geometry instanceof MultiPolygon) {
            return "MultiPolygon";
        }
        if (geometry instanceof GeometryCollection) {
            return "GeometryCollection";
        }
        throw new IllegalArgumentException("Unknown geometry type " + geometry.getClass());
    }

    public static int getGeometryType(Geometry geometry) {
        if (geometry instanceof Point) {
            return 1;
        }
        if (geometry instanceof LineString) {
            return 2;
        }
        if (geometry instanceof Polygon) {
            return 3;
        }
        if (geometry instanceof MultiPoint) {
            return 4;
        }
        if (geometry instanceof MultiLineString) {
            return 5;
        }
        if (geometry instanceof MultiPolygon) {
            return 6;
        }
        if (geometry instanceof GeometryCollection) {
            return 7;
        }
        throw new IllegalArgumentException("Unable to determine geometry type " + geometry.getClass());
    }

    public JSONBuilder writeList(List list) {
        this.array();
        for (Object o : list) {
            this.value(o);
        }
        return this.endArray();
    }

    public JSONBuilder writeMap(Map map) {
        this.object();
        for (Object k : map.keySet()) {
            this.key(k.toString());
            this.value(map.get(k));
        }
        return this.endObject();
    }

    public GeoJSONBuilder value(Object value) {
        if (value == null) {
            super.value(value);
        } else if (value instanceof Geometry) {
            this.writeGeom((Geometry)value);
        } else if (value instanceof List) {
            this.writeList((List)value);
        } else if (value instanceof Map) {
            this.writeMap((Map)value);
        } else {
            if (value instanceof Date || value instanceof Calendar) {
                value = Converters.convert((Object)value, String.class);
            }
            super.value(value);
        }
        return this;
    }

    public void setAxisOrder(CRS.AxisOrder axisOrder) {
        this.axisOrder = axisOrder;
    }

    public void setNumberOfDecimals(int numberOfDecimals) {
        this.numDecimals = numberOfDecimals;
    }

    public void setEncodeMeasures(boolean encodeMeasures) {
        this.encodeMeasures = encodeMeasures;
    }
}

