/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs;

import com.google.common.base.Strings;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import org.eclipse.emf.ecore.EObject;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.catalog.PublishedInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.ows.Request;
import org.geoserver.ows.WorkspaceQualifyingCallback;
import org.geoserver.ows.util.KvpUtils;
import org.geoserver.ows.util.OwsUtils;
import org.geoserver.platform.Operation;
import org.geoserver.platform.Service;
import org.geoserver.wfs.WFSException;
import org.geoserver.wfs.request.DescribeFeatureTypeRequest;
import org.geoserver.wfs.request.GetCapabilitiesRequest;
import org.geoserver.wfs.request.GetFeatureRequest;
import org.geoserver.wfs.request.Insert;
import org.geoserver.wfs.request.Lock;
import org.geoserver.wfs.request.LockFeatureRequest;
import org.geoserver.wfs.request.Query;
import org.geoserver.wfs.request.Replace;
import org.geoserver.wfs.request.RequestObject;
import org.geoserver.wfs.request.TransactionElement;
import org.geoserver.wfs.request.TransactionRequest;
import org.opengis.feature.Feature;
import org.opengis.feature.type.Name;

public class WFSWorkspaceQualifier
extends WorkspaceQualifyingCallback {
    public WFSWorkspaceQualifier(Catalog catalog) {
        super(catalog);
    }

    protected void qualifyRequest(WorkspaceInfo localWorkspace, PublishedInfo localLayer, Service service, Request request) {
        Objects.requireNonNull(localWorkspace);
        Objects.requireNonNull(service);
        Objects.requireNonNull(request);
        if (request.getContext() == null) {
            return;
        }
        NamespaceInfo ns = this.catalog.getNamespaceByPrefix(localWorkspace.getName());
        if (ns == null) {
            return;
        }
        Map kvp = request.getKvp();
        if (kvp.containsKey("TYPENAME")) {
            Collection typeNames = (Collection)kvp.get("TYPENAME");
            List<QName> qualifiedNames = this.qualifyTypeNames(request, ns, typeNames);
            kvp.put("TYPENAME", qualifiedNames);
        } else if (kvp.containsKey("TYPENAMES")) {
            Collection nestedTypeNames = (Collection)kvp.get("TYPENAMES");
            List qualifiedNames = nestedTypeNames.stream().map(l -> this.qualifyTypeNames(request, ns, (Collection<QName>)l)).collect(Collectors.toList());
            kvp.put("TYPENAMES", qualifiedNames);
        }
    }

    private List<QName> qualifyTypeNames(Request request, NamespaceInfo ns, Collection<QName> typeNames) {
        return typeNames.stream().map(name -> this.qualifyTypeName(request, ns, (QName)name)).collect(Collectors.toList());
    }

    private QName qualifyTypeName(Request request, NamespaceInfo ns, QName typeName) {
        if (Strings.isNullOrEmpty((String)typeName.getNamespaceURI())) {
            return new QName(ns.getURI(), typeName.getLocalPart());
        }
        if (!typeName.getNamespaceURI().equals(ns.getURI())) {
            return this.checkOriginallyUnqualified(request, ns, typeName);
        }
        return typeName;
    }

    private QName checkOriginallyUnqualified(Request request, NamespaceInfo ns, QName typeName) {
        Map rawKvp = request.getRawKvp();
        String rawNames = (String)rawKvp.get("TYPENAME");
        if (rawNames == null) {
            rawNames = (String)rawKvp.get("TYPENAMES");
        }
        List rawTypeNames = KvpUtils.readFlat((String)rawNames);
        for (String rawTypeName : rawTypeNames) {
            if (!rawTypeName.equals(typeName.getLocalPart())) continue;
            typeName = new QName(ns.getURI(), typeName.getLocalPart());
            break;
        }
        return typeName;
    }

    protected void qualifyRequest(WorkspaceInfo workspace, PublishedInfo layer, Operation operation, Request request) {
        NamespaceInfo ns = this.catalog.getNamespaceByPrefix(workspace.getName());
        GetCapabilitiesRequest caps = GetCapabilitiesRequest.adapt(OwsUtils.parameter((Object[])operation.getParameters(), EObject.class));
        if (caps != null) {
            caps.setNamespace(workspace.getName());
            return;
        }
        DescribeFeatureTypeRequest dft = DescribeFeatureTypeRequest.adapt(OwsUtils.parameter((Object[])operation.getParameters(), EObject.class));
        if (dft != null) {
            this.qualifyTypeNames(dft.getTypeNames(), workspace, ns);
            return;
        }
        GetFeatureRequest gf = GetFeatureRequest.adapt(OwsUtils.parameter((Object[])operation.getParameters(), EObject.class));
        if (gf != null) {
            for (Query q : gf.getQueries()) {
                if (q.getTypeNames() == null) continue;
                this.qualifyTypeNames(q.getTypeNames(), workspace, ns);
            }
            return;
        }
        LockFeatureRequest lf = LockFeatureRequest.adapt(OwsUtils.parameter((Object[])operation.getParameters(), EObject.class));
        if (lf != null) {
            for (Lock lock : lf.getLocks()) {
                lock.setTypeName(this.qualifyTypeName(lock.getTypeName(), workspace, ns));
            }
            return;
        }
        TransactionRequest t = TransactionRequest.adapt(OwsUtils.parameter((Object[])operation.getParameters(), EObject.class));
        if (t != null) {
            for (TransactionElement el : t.getElements()) {
                List features;
                if (el instanceof Insert) {
                    Insert in = (Insert)el;
                    features = in.getFeatures();
                    this.ensureFeatureNamespaceUriMatches(features, ns, t);
                    continue;
                }
                if (el instanceof Replace) {
                    Replace rep = (Replace)el;
                    features = rep.getFeatures();
                    this.ensureFeatureNamespaceUriMatches(features, ns, t);
                    continue;
                }
                el.setTypeName(this.qualifyTypeName(el.getTypeName(), workspace, ns));
            }
        }
    }

    private void ensureFeatureNamespaceUriMatches(List features, NamespaceInfo ns, TransactionRequest t) {
        for (Object next : features) {
            Feature f;
            Name n;
            if (!(next instanceof Feature) || (n = (f = (Feature)next).getType().getName()).getNamespaceURI() == null || ns.getURI().equals(n.getNamespaceURI())) continue;
            throw new WFSException((RequestObject)t, "No such feature type " + n);
        }
    }

    void qualifyTypeNames(List<QName> names, WorkspaceInfo ws, NamespaceInfo ns) {
        if (names != null) {
            for (int i = 0; i < names.size(); ++i) {
                QName name = names.get(i);
                names.set(i, this.qualifyTypeName(name, ws, ns));
            }
        }
    }

    QName qualifyTypeName(QName name, WorkspaceInfo ws, NamespaceInfo ns) {
        if (name != null) {
            return new QName(ns.getURI(), name.getLocalPart(), ws.getName());
        }
        return null;
    }
}

