/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs;

import org.geoserver.wfs.WFSException;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.spatial.DefaultCRSFilterVisitor;
import org.geotools.filter.spatial.ReprojectingFilterVisitor;
import org.geotools.gml2.bindings.GML2EncodingUtils;
import org.geotools.referencing.CRS;
import org.geotools.util.factory.GeoTools;
import org.geotools.util.factory.Hints;
import org.opengis.feature.type.FeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.FilterVisitor;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

class WFSReprojectionUtil {
    static FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2((Hints)GeoTools.getDefaultHints());

    WFSReprojectionUtil() {
    }

    public static CoordinateReferenceSystem getDeclaredCrs(CoordinateReferenceSystem nativeCRS, String wfsVersion) {
        try {
            if (nativeCRS == null) {
                return null;
            }
            if (wfsVersion.equals("1.0.0")) {
                return nativeCRS;
            }
            String code = GML2EncodingUtils.epsgCode((CoordinateReferenceSystem)nativeCRS);
            if (code == null) {
                return nativeCRS;
            }
            return CRS.decode((String)("urn:x-ogc:def:crs:EPSG:6.11.2:" + code));
        }
        catch (Exception e) {
            throw new WFSException("We have had issues trying to flip axis of " + nativeCRS, (Throwable)e);
        }
    }

    public static CoordinateReferenceSystem getDeclaredCrs(FeatureType schema, String wfsVersion) {
        if (schema == null) {
            return null;
        }
        CoordinateReferenceSystem crs = schema.getGeometryDescriptor() != null ? schema.getGeometryDescriptor().getCoordinateReferenceSystem() : null;
        return WFSReprojectionUtil.getDeclaredCrs(crs, wfsVersion);
    }

    public static Filter applyDefaultCRS(Filter filter, CoordinateReferenceSystem defaultCRS) {
        DefaultCRSFilterVisitor defaultVisitor = new DefaultCRSFilterVisitor(ff, defaultCRS);
        return (Filter)filter.accept((FilterVisitor)defaultVisitor, null);
    }

    public static Filter reprojectFilter(Filter filter, FeatureType schema) {
        ReprojectingFilterVisitor visitor = new ReprojectingFilterVisitor(ff, schema);
        return (Filter)filter.accept((FilterVisitor)visitor, null);
    }

    public static Filter reprojectFilter(Filter filter, FeatureType schema, CoordinateReferenceSystem targetCrs) {
        ReprojectingFilterVisitor visitor = new ReprojectingFilterVisitor(ff, schema, targetCrs);
        return (Filter)filter.accept((FilterVisitor)visitor, null);
    }

    public static Filter normalizeFilterCRS(Filter filter, FeatureType schema, CoordinateReferenceSystem defaultCRS) {
        Filter defaulted = WFSReprojectionUtil.applyDefaultCRS(filter, defaultCRS);
        return WFSReprojectionUtil.reprojectFilter(defaulted, schema);
    }

    public static Filter normalizeFilterCRS(Filter filter, FeatureType schema, CoordinateReferenceSystem defaultCRS, CoordinateReferenceSystem targetCRS) {
        Filter defaulted = WFSReprojectionUtil.applyDefaultCRS(filter, defaultCRS);
        return WFSReprojectionUtil.reprojectFilter(defaulted, schema, targetCRS);
    }
}

