/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.geotools.data.DataUtilities;
import org.geotools.data.FeatureSource;
import org.geotools.data.Query;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.collection.DecoratingSimpleFeatureCollection;
import org.opengis.feature.Feature;
import org.opengis.feature.FeatureVisitor;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.FeatureType;

public class FeatureSizeFeatureCollection
extends DecoratingSimpleFeatureCollection {
    public static final int DEFAULT_CACHE_SIZE = 0;
    protected SimpleFeatureSource featureSource;
    private List<SimpleFeature> featureCache;
    private Query query;
    private static int FEATURE_CACHE_LIMIT = Integer.valueOf(System.getProperty("org.geoserver.wfs.getfeature.cachelimit", String.valueOf(0)));

    public static void setFeatureCacheLimit(int featureCacheLimit) {
        FEATURE_CACHE_LIMIT = featureCacheLimit;
    }

    public FeatureSizeFeatureCollection(SimpleFeatureCollection delegate, SimpleFeatureSource source, Query query) {
        super(delegate);
        this.featureSource = source;
        this.query = query;
    }

    static FeatureCollection<? extends FeatureType, ? extends Feature> wrap(FeatureCollection<? extends FeatureType, ? extends Feature> features, FeatureSource<? extends FeatureType, ? extends Feature> source, Query gtQuery) {
        if (FEATURE_CACHE_LIMIT > 0 && features.getSchema() instanceof SimpleFeatureType) {
            return new FeatureSizeFeatureCollection((SimpleFeatureCollection)features, DataUtilities.simple(source), gtQuery);
        }
        return features;
    }

    public SimpleFeatureIterator features() {
        if (this.featureCache != null) {
            return new CachedWrappingFeatureIterator(this.featureCache);
        }
        return super.features();
    }

    protected boolean canDelegate(FeatureVisitor visitor) {
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int size() {
        if (this.featureCache != null) {
            return this.featureCache.size();
        }
        if (FEATURE_CACHE_LIMIT <= 0) return super.size();
        try {
            int count = this.featureSource.getCount(this.query);
            if (count == 0) {
                this.featureCache = new ArrayList<SimpleFeature>();
                return count;
            }
            if (count > 0) {
                return count;
            }
            ArrayList<SimpleFeature> tempFeatureCache = new ArrayList<SimpleFeature>();
            try (SimpleFeatureIterator it = this.featureSource.getFeatures(this.query).features();){
                count = 0;
                while (it.hasNext()) {
                    SimpleFeature feature = (SimpleFeature)it.next();
                    if (tempFeatureCache.size() < FEATURE_CACHE_LIMIT) {
                        tempFeatureCache.add(feature);
                    }
                    ++count;
                }
                if (count <= FEATURE_CACHE_LIMIT) {
                    this.featureCache = tempFeatureCache;
                } else {
                    tempFeatureCache.clear();
                }
                int n = count;
                return n;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    class CachedWrappingFeatureIterator
    implements SimpleFeatureIterator {
        private List<SimpleFeature> featureCache;
        private int featureIndex = 0;

        public CachedWrappingFeatureIterator(List<SimpleFeature> featureCache) {
            this.featureCache = featureCache;
        }

        public boolean hasNext() {
            return this.featureIndex < this.featureCache.size();
        }

        public SimpleFeature next() {
            return this.featureCache.get(this.featureIndex++);
        }

        public void close() {
            this.featureIndex = 0;
        }
    }
}

