/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs;

import java.io.IOException;
import java.math.BigInteger;
import java.util.HashSet;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.geoserver.config.GeoServer;
import org.geoserver.wfs.AbstractTransactionElementHandler;
import org.geoserver.wfs.TransactionEvent;
import org.geoserver.wfs.TransactionEventType;
import org.geoserver.wfs.TransactionListener;
import org.geoserver.wfs.WFSException;
import org.geoserver.wfs.WFSInfo;
import org.geoserver.wfs.WFSReprojectionUtil;
import org.geoserver.wfs.WFSTransactionException;
import org.geoserver.wfs.request.Delete;
import org.geoserver.wfs.request.RequestObject;
import org.geoserver.wfs.request.TransactionElement;
import org.geoserver.wfs.request.TransactionRequest;
import org.geoserver.wfs.request.TransactionResponse;
import org.geotools.data.DataStore;
import org.geotools.data.DataUtilities;
import org.geotools.data.FeatureLockException;
import org.geotools.data.FeatureLocking;
import org.geotools.data.FeatureStore;
import org.geotools.data.FeatureWriter;
import org.geotools.data.Query;
import org.geotools.data.simple.SimpleFeatureLocking;
import org.geotools.data.simple.SimpleFeatureStore;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.util.logging.Logging;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.identity.FeatureId;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class DeleteElementHandler
extends AbstractTransactionElementHandler {
    static Logger LOGGER = Logging.getLogger((String)"org.geoserver.wfs");
    FilterFactory factory = CommonFactoryFinder.getFilterFactory(null);

    public DeleteElementHandler(GeoServer gs) {
        super(gs);
    }

    public Class<Delete> getElementClass() {
        return Delete.class;
    }

    @Override
    public QName[] getTypeNames(TransactionRequest request, TransactionElement element) throws WFSTransactionException {
        return new QName[]{element.getTypeName()};
    }

    public void checkValidity(TransactionElement delete, Map featureTypeInfos) throws WFSTransactionException {
        if (!this.getInfo().getServiceLevel().getOps().contains((Object)WFSInfo.Operation.TRANSACTION_DELETE)) {
            throw new WFSException((RequestObject)delete, "Transaction Delete support is not enabled");
        }
        Filter f = delete.getFilter();
        if (f == null || Filter.INCLUDE.equals(f)) {
            throw new WFSTransactionException("Must specify filter for delete", "MissingParameterValue");
        }
    }

    public void execute(TransactionElement delete, TransactionRequest request, Map featureStores, TransactionResponse response, TransactionListener listener) throws WFSTransactionException {
        long deleted;
        block24: {
            QName elementName = delete.getTypeName();
            String handle = delete.getHandle();
            deleted = response.getTotalDeleted().longValue();
            String msg = "Could not locate FeatureStore for '" + elementName + "'";
            if (!featureStores.containsKey(elementName)) {
                if (LOGGER.isLoggable(Level.FINER)) {
                    LOGGER.finer("failed to find " + elementName + " in:");
                    for (QName key : featureStores.keySet()) {
                        LOGGER.finer("\t" + key.toString());
                    }
                }
                throw new WFSTransactionException(msg, "InvalidParameterValue", handle);
            }
            SimpleFeatureStore store = DataUtilities.simple((FeatureStore)((FeatureStore)featureStores.get(elementName)));
            if (store == null) {
                throw new WFSTransactionException(msg, "InvalidParameterValue", handle);
            }
            String typeName = ((SimpleFeatureType)store.getSchema()).getTypeName();
            LOGGER.finer("Transaction Delete:" + delete);
            try {
                Filter filter = delete.getFilter();
                CoordinateReferenceSystem declaredCRS = WFSReprojectionUtil.getDeclaredCrs(store.getSchema(), request.getVersion());
                filter = WFSReprojectionUtil.normalizeFilterCRS(filter, store.getSchema(), declaredCRS);
                TransactionEvent event = new TransactionEvent(TransactionEventType.PRE_DELETE, request, elementName, store.getFeatures(filter));
                event.setSource(Delete.WFS11.unadapt((Delete)delete));
                listener.dataStoreChange(event);
                ReferencedEnvelope damaged = store.getBounds(new Query(elementName.getLocalPart(), filter));
                if (damaged == null) {
                    damaged = store.getFeatures(filter).getBounds();
                }
                if (request.getLockId() != null && store instanceof FeatureLocking && request.isReleaseActionSome()) {
                    SimpleFeatureLocking locking = (SimpleFeatureLocking)store;
                    DataStore data = (DataStore)store.getDataStore();
                    try (FeatureWriter writer = data.getFeatureWriter(typeName, filter, store.getTransaction());){
                        while (writer.hasNext()) {
                            String fid = ((SimpleFeature)writer.next()).getID();
                            HashSet<FeatureId> featureIds = new HashSet<FeatureId>();
                            featureIds.add(this.factory.featureId(fid));
                            locking.unLockFeatures((Filter)this.factory.id(featureIds));
                            writer.remove();
                            ++deleted;
                        }
                    }
                    store.removeFeatures(filter);
                    break block24;
                }
                int deletedCount = store.getFeatures(filter).size();
                if (deletedCount > 0) {
                    deleted += (long)deletedCount;
                }
                store.removeFeatures(filter);
            }
            catch (IOException e) {
                String message = e.getMessage();
                String eHandle = delete.getHandle();
                String code = null;
                if (e instanceof FeatureLockException) {
                    code = "MissingParameterValue";
                }
                throw new WFSTransactionException(message, e, code, eHandle, handle);
            }
        }
        response.setTotalDeleted(BigInteger.valueOf(deleted));
    }
}

