/*
 * Decompiled with CFR 0.152.
 */
package ar.com.hjg.pngj;

import ar.com.hjg.pngj.FilterType;
import ar.com.hjg.pngj.IFilterWriteStrategy;
import ar.com.hjg.pngj.ImageInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilterWriteStrategy
implements IFilterWriteStrategy {
    final ImageInfo imgInfo;
    private FilterType configuredType;
    private FilterType computedType;
    private int lastRowTested = -1000000;
    private double[] lastSums = new double[5];
    private double[] preference;
    private int discoverEachLines = -1;
    private List<FilterType> toTest;

    public FilterWriteStrategy(ImageInfo imgInfo, FilterType ctype) {
        double[] dArray;
        this.imgInfo = imgInfo;
        if (imgInfo.indexed || imgInfo.packed) {
            double[] dArray2 = new double[5];
            dArray2[0] = 1.2;
            dArray2[1] = 1.1;
            dArray2[2] = 1.1;
            dArray2[3] = 1.0;
            dArray = dArray2;
            dArray2[4] = 1.1;
        } else {
            double[] dArray3 = new double[5];
            dArray3[0] = 1.3;
            dArray3[1] = 1.1;
            dArray3[2] = 1.1;
            dArray3[3] = 1.1;
            dArray = dArray3;
            dArray3[4] = 1.2;
        }
        this.preference = dArray;
        this.toTest = new ArrayList<FilterType>(Arrays.asList(FilterType.getAllStandard()));
        this.configuredType = ctype;
        this.computedType = FilterType.FILTER_NONE;
    }

    public FilterWriteStrategy(ImageInfo imgInfo) {
        this(imgInfo, FilterType.FILTER_DEFAULT);
    }

    void setConfiguredType(FilterType cType) {
        this.configuredType = cType;
        this.discoverEachLines = 0;
        if (this.configuredType.val >= 0) {
            this.computedType = this.configuredType;
        } else {
            this.computedType = FilterType.FILTER_PAETH;
            if (this.configuredType == FilterType.FILTER_AGGRESSIVE) {
                this.discoverEachLines = 8;
            }
            if (this.configuredType == FilterType.FILTER_VERYAGGRESSIVE) {
                this.discoverEachLines = 1;
            }
            if (this.configuredType == FilterType.FILTER_DEFAULT) {
                this.computedType = this.imgInfo.rows < 8 && this.imgInfo.cols < 8 || this.imgInfo.indexed || this.imgInfo.bitDepth < 8 ? FilterType.FILTER_NONE : FilterType.FILTER_PAETH;
            }
        }
    }

    @Override
    public List<FilterType> shouldTest(int rown) {
        if (this.discoverEachLines > 0 && this.lastRowTested + this.discoverEachLines <= rown) {
            return this.toTest;
        }
        return Collections.emptyList();
    }

    public void setPreference(double none, double sub, double up, double ave, double paeth) {
        this.preference = new double[]{none, sub, up, ave, paeth};
    }

    public boolean computesStatistics() {
        return this.discoverEachLines > 0;
    }

    @Override
    public void reportResultsForFilter(int rown, FilterType type, byte[] rowbfilter, boolean tentative) {
        if (!this.computesStatistics()) {
            return;
        }
        int sum = 0;
        for (int i = 1; i <= this.imgInfo.bytesPerRow; ++i) {
            byte val = rowbfilter[i];
            if (val < 0) {
                sum -= val;
                continue;
            }
            sum += val;
        }
        this.lastRowTested = rown;
        this.lastSums[type.val] = sum;
    }

    @Override
    public FilterType preferedType(int rown) {
        if (this.configuredType == null || this.configuredType.val < 0) {
            if (rown == 0) {
                this.computedType = FilterType.FILTER_NONE;
            } else if (this.configuredType == FilterType.FILTER_CYCLIC) {
                this.computedType = FilterType.getByVal((this.computedType.val + 1) % 5);
            } else {
                double bestval = Double.MAX_VALUE;
                for (int i = 0; i < 5; ++i) {
                    double val = this.lastSums[i];
                    if (!((val /= this.preference[i]) <= bestval)) continue;
                    bestval = val;
                    this.computedType = FilterType.getByVal(i);
                }
            }
        }
        return this.computedType;
    }
}

