/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wcs.web.demo;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;
import javax.xml.transform.TransformerException;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.form.AjaxSubmitLink;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.geoserver.ows.URLMangler;
import org.geoserver.ows.util.ResponseUtils;
import org.geoserver.wcs.responses.CoverageResponseDelegateFinder;
import org.geoserver.wcs.web.demo.GetCoverageRequest;
import org.geoserver.wcs.web.demo.WCS10GetCoverageTransformer;
import org.geoserver.wcs.web.demo.WCS11GetCoverageTransformer;
import org.geoserver.wcs.web.demo.WCSRequestBuilderPanel;
import org.geoserver.web.GeoServerApplication;
import org.geoserver.web.GeoServerBasePage;
import org.geoserver.web.demo.DemoRequest;
import org.geoserver.web.demo.DemoRequestResponse;
import org.geoserver.web.demo.PlainCodePage;
import org.geotools.xml.transform.TransformerBase;

public class WCSRequestBuilder
extends GeoServerBasePage {
    ModalWindow responseWindow;
    WCSRequestBuilderPanel builder;

    public WCSRequestBuilder() {
        Form form = new Form("form");
        this.add(new Component[]{form});
        this.builder = new WCSRequestBuilderPanel("requestBuilder", new GetCoverageRequest());
        form.add(new Component[]{this.builder});
        final ModalWindow xmlWindow = new ModalWindow("xmlWindow");
        this.add(new Component[]{xmlWindow});
        xmlWindow.setPageCreator((ModalWindow.PageCreator & Serializable)() -> new PlainCodePage(xmlWindow, this.responseWindow, this.getRequestXML()));
        this.responseWindow = new ModalWindow("responseWindow");
        this.add(new Component[]{this.responseWindow});
        this.responseWindow.setCookieName("demoResponse");
        this.responseWindow.setPageCreator((ModalWindow.PageCreator & Serializable)() -> {
            DemoRequest request = new DemoRequest(null);
            HttpServletRequest http = GeoServerApplication.get().servletRequest();
            String url = ResponseUtils.buildURL((String)ResponseUtils.baseURL((HttpServletRequest)http), (String)"ows", Collections.singletonMap("strict", "true"), (URLMangler.URLType)URLMangler.URLType.SERVICE);
            request.setRequestUrl(url);
            request.setRequestBody((String)this.responseWindow.getDefaultModelObject());
            return new DemoRequestResponse((IModel)new Model((Serializable)request));
        });
        form.add(new Component[]{new AjaxSubmitLink("execute"){

            protected void onSubmit(AjaxRequestTarget target, Form form) {
                WCSRequestBuilder.this.responseWindow.setDefaultModel((IModel)new Model((Serializable)((Object)WCSRequestBuilder.this.getRequestXML())));
                WCSRequestBuilder.this.responseWindow.show((IPartialPageRequestHandler)target);
            }

            protected void onError(AjaxRequestTarget target, Form form) {
                super.onError(target, form);
                target.add(new Component[]{WCSRequestBuilder.this.builder.getFeedbackPanel()});
            }
        }});
        form.add(new Component[]{new AjaxSubmitLink("executeXML"){

            protected void onSubmit(AjaxRequestTarget target, Form form) {
                try {
                    WCSRequestBuilder.this.getRequestXML();
                    xmlWindow.show((IPartialPageRequestHandler)target);
                }
                catch (Exception e) {
                    this.error((Serializable)((Object)e.getMessage()));
                    WCSRequestBuilder.this.addFeedbackPanels(target);
                }
            }

            protected void onError(AjaxRequestTarget target, Form form) {
                WCSRequestBuilder.this.addFeedbackPanels(target);
            }
        }});
    }

    String getRequestXML() {
        TransformerBase tx;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        if (this.builder.getCoverage.version == GetCoverageRequest.Version.v1_0_0) {
            tx = new WCS10GetCoverageTransformer(this.getCatalog());
        } else {
            CoverageResponseDelegateFinder responseFactory = (CoverageResponseDelegateFinder)this.getGeoServerApplication().getBean("coverageResponseDelegateFactory");
            tx = new WCS11GetCoverageTransformer(this.getCatalog(), responseFactory);
        }
        try {
            tx.setIndentation(2);
            tx.transform((Object)this.builder.getCoverageRequest(), (OutputStream)out);
        }
        catch (TransformerException e) {
            LOGGER.log(Level.SEVERE, "Error generating xml request", e);
            this.error(e);
        }
        return out.toString();
    }
}

