/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wcs.web;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.PublishedInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.config.ServiceInfo;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.Service;
import org.geoserver.wcs.WCSInfo;
import org.geoserver.wcs.WebCoverageService100;
import org.geoserver.wcs.WebCoverageService111;
import org.geoserver.wcs2_0.WebCoverageService20;
import org.geoserver.web.ServiceDescription;
import org.geoserver.web.ServiceDescriptionProvider;
import org.geoserver.web.ServiceLinkDescription;
import org.geotools.util.logging.Logging;

public class WCSServiceDescriptionProvider
extends ServiceDescriptionProvider {
    static final Logger LOGGER = Logging.getLogger(WCSServiceDescriptionProvider.class);
    public static final String SERVICE_TYPE = "WCS";
    GeoServer geoserver;
    Catalog catalog;

    public WCSServiceDescriptionProvider(GeoServer gs) {
        this.geoserver = gs;
        this.catalog = gs.getCatalog();
    }

    protected WCSInfo info(WorkspaceInfo workspaceInfo, PublishedInfo layerInfo) {
        WCSInfo info = null;
        if (workspaceInfo != null) {
            info = (WCSInfo)this.geoserver.getService(workspaceInfo, WCSInfo.class);
        }
        if (info == null) {
            info = (WCSInfo)this.geoserver.getService(WCSInfo.class);
        }
        return info;
    }

    public List<ServiceDescription> getServices(WorkspaceInfo workspaceInfo, PublishedInfo layerInfo) {
        ArrayList<ServiceDescription> descriptions = new ArrayList<ServiceDescription>();
        WCSInfo info = this.info(workspaceInfo, layerInfo);
        if (workspaceInfo != null || this.geoserver.getGlobal().isGlobalServices().booleanValue()) {
            descriptions.add(this.description(SERVICE_TYPE, (ServiceInfo)info, workspaceInfo, layerInfo));
        }
        return descriptions;
    }

    protected String getVersionParameterName(Service service) {
        if (service.getVersion().getMajor().toString().equals("2")) {
            return "acceptversions";
        }
        return "version";
    }

    public List<ServiceLinkDescription> getServiceLinks(WorkspaceInfo workspaceInfo, PublishedInfo layerInfo) {
        ArrayList<ServiceLinkDescription> links = new ArrayList<ServiceLinkDescription>();
        if (workspaceInfo == null && !this.geoserver.getGlobal().isGlobalServices().booleanValue()) {
            return links;
        }
        List extensions = GeoServerExtensions.extensions(Service.class);
        for (Service service : extensions) {
            if (!(service.getService() instanceof WebCoverageService111) && !(service.getService() instanceof WebCoverageService100) && !(service.getService() instanceof WebCoverageService20)) continue;
            String link = null;
            if (service.getOperations().contains("GetCapabilities")) {
                link = this.getCapabilitiesURL(workspaceInfo, layerInfo, service);
            } else if (service.getCustomCapabilitiesLink() != null) {
                link = service.getCustomCapabilitiesLink();
            }
            if (link == null) continue;
            links.add(new ServiceLinkDescription(SERVICE_TYPE, service.getVersion(), link, workspaceInfo != null ? workspaceInfo.getName() : null, layerInfo != null ? layerInfo.getName() : null));
        }
        return links;
    }
}

