/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.sld.bindings;

import javax.xml.namespace.QName;
import org.geotools.sld.CssParameter;
import org.geotools.sld.bindings.SLD;
import org.geotools.styling.ContrastEnhancement;
import org.geotools.styling.ImageOutline;
import org.geotools.styling.RasterSymbolizer;
import org.geotools.styling.StyleFactory;
import org.geotools.xsd.AbstractComplexBinding;
import org.geotools.xsd.ElementInstance;
import org.geotools.xsd.Node;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.PropertyName;
import org.opengis.style.ChannelSelection;
import org.opengis.style.ColorMap;
import org.opengis.style.OverlapBehavior;
import org.opengis.style.ShadedRelief;
import org.opengis.style.Symbolizer;
import org.picocontainer.MutablePicoContainer;

public class SLDRasterSymbolizerBinding
extends AbstractComplexBinding {
    StyleFactory styleFactory;

    public SLDRasterSymbolizerBinding(StyleFactory styleFactory) {
        this.styleFactory = styleFactory;
    }

    public QName getTarget() {
        return SLD.RASTERSYMBOLIZER;
    }

    public int getExecutionMode() {
        return 0;
    }

    public Class getType() {
        return RasterSymbolizer.class;
    }

    public void initialize(ElementInstance instance, Node node, MutablePicoContainer context) {
    }

    public Object parse(ElementInstance instance, Node node, Object value) throws Exception {
        RasterSymbolizer rs = this.styleFactory.createRasterSymbolizer();
        if (node.hasChild("Geometry")) {
            Expression geometry = (Expression)node.getChildValue("Geometry");
            if (geometry instanceof PropertyName) {
                PropertyName propertyName = (PropertyName)geometry;
                rs.setGeometryPropertyName(propertyName.getPropertyName());
            } else {
                rs.setGeometry(geometry);
            }
        }
        if (node.hasChild("Opacity")) {
            rs.setOpacity((Expression)node.getChildValue("Opacity"));
        }
        if (node.hasChild("ChannelSelection")) {
            rs.setChannelSelection((ChannelSelection)((org.geotools.styling.ChannelSelection)node.getChildValue("ChannelSelection")));
        }
        if (node.hasChild("OverlapBehavior")) {
            rs.setOverlapBehavior((OverlapBehavior)node.getChildValue("OverlapBehavior"));
        }
        if (node.hasChild("ColorMap")) {
            rs.setColorMap((ColorMap)((org.geotools.styling.ColorMap)node.getChildValue("ColorMap")));
        }
        if (node.hasChild("ContrastEnhancement")) {
            rs.setContrastEnhancement((org.opengis.style.ContrastEnhancement)((ContrastEnhancement)node.getChildValue("ContrastEnhancement")));
        }
        if (node.hasChild("ShadedRelief")) {
            rs.setShadedRelief((ShadedRelief)((org.geotools.styling.ShadedRelief)node.getChildValue("ShadedRelief")));
        }
        if (node.hasChild("ImageOutline")) {
            ImageOutline imageOutput = (ImageOutline)node.getChildValue("ImageOutline");
            rs.setImageOutline((Symbolizer)imageOutput.getSymbolizer());
        }
        for (CssParameter param : node.getChildValues(CssParameter.class)) {
            rs.getOptions().put(param.getName(), param.getExpression().evaluate(null, String.class));
        }
        return rs;
    }
}

