/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.sld.bindings;

import javax.xml.namespace.QName;
import org.geotools.sld.CssParameter;
import org.geotools.sld.bindings.SLD;
import org.geotools.styling.Fill;
import org.geotools.styling.PolygonSymbolizer;
import org.geotools.styling.StyleFactory;
import org.geotools.xsd.AbstractComplexBinding;
import org.geotools.xsd.ElementInstance;
import org.geotools.xsd.Node;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.PropertyName;
import org.opengis.style.Stroke;
import org.picocontainer.MutablePicoContainer;

public class SLDPolygonSymbolizerBinding
extends AbstractComplexBinding {
    StyleFactory styleFactory;

    public SLDPolygonSymbolizerBinding(StyleFactory styleFactory) {
        this.styleFactory = styleFactory;
    }

    public QName getTarget() {
        return SLD.POLYGONSYMBOLIZER;
    }

    public int getExecutionMode() {
        return 0;
    }

    public Class getType() {
        return PolygonSymbolizer.class;
    }

    public void initialize(ElementInstance instance, Node node, MutablePicoContainer context) {
    }

    public Object parse(ElementInstance instance, Node node, Object value) throws Exception {
        PolygonSymbolizer ps = this.styleFactory.createPolygonSymbolizer();
        if (node.hasChild("Geometry")) {
            Expression geometry = (Expression)node.getChildValue("Geometry");
            if (geometry instanceof PropertyName) {
                PropertyName propertyName = (PropertyName)geometry;
                ps.setGeometryPropertyName(propertyName.getPropertyName());
            } else {
                ps.setGeometry(geometry);
            }
        }
        if (node.hasChild(Fill.class)) {
            ps.setFill((org.opengis.style.Fill)node.getChildValue(Fill.class));
        }
        if (node.hasChild(org.geotools.styling.Stroke.class)) {
            ps.setStroke((Stroke)node.getChildValue(org.geotools.styling.Stroke.class));
        }
        for (CssParameter param : node.getChildValues(CssParameter.class)) {
            ps.getOptions().put(param.getName(), param.getExpression().evaluate(null, String.class));
        }
        return ps;
    }
}

