/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.image;

import com.sun.media.imageioimpl.common.BogusColorSpace;
import com.sun.media.imageioimpl.common.PackageUtil;
import com.sun.media.jai.util.ImageUtil;
import it.geosolutions.jaiext.JAIExt;
import it.geosolutions.jaiext.algebra.AlgebraDescriptor;
import it.geosolutions.jaiext.classifier.ColorMapTransform;
import it.geosolutions.jaiext.colorconvert.IHSColorSpaceJAIExt;
import it.geosolutions.jaiext.colorindexer.ColorIndexer;
import it.geosolutions.jaiext.lookup.LookupTable;
import it.geosolutions.jaiext.lookup.LookupTableFactory;
import it.geosolutions.jaiext.piecewise.PiecewiseTransform1D;
import it.geosolutions.jaiext.range.NoDataContainer;
import it.geosolutions.jaiext.range.Range;
import it.geosolutions.jaiext.range.RangeFactory;
import it.geosolutions.jaiext.rlookup.RangeLookupTable;
import it.geosolutions.jaiext.stats.HistogramWrapper;
import it.geosolutions.jaiext.stats.Statistics;
import it.geosolutions.jaiext.utilities.ImageLayout2;
import it.geosolutions.jaiext.vectorbin.ROIGeometry;
import java.awt.Color;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.color.ColorSpace;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.PackedColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.awt.image.renderable.ParameterBlock;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.IIOException;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.plugins.jpeg.JPEGImageWriteParam;
import javax.imageio.spi.IIORegistry;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.spi.ServiceRegistry;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;
import javax.media.jai.BorderExtender;
import javax.media.jai.ColorCube;
import javax.media.jai.Histogram;
import javax.media.jai.IHSColorSpace;
import javax.media.jai.ImageFunction;
import javax.media.jai.ImageLayout;
import javax.media.jai.Interpolation;
import javax.media.jai.JAI;
import javax.media.jai.KernelJAI;
import javax.media.jai.OperationDescriptor;
import javax.media.jai.OperationRegistry;
import javax.media.jai.ParameterBlockJAI;
import javax.media.jai.ParameterListDescriptor;
import javax.media.jai.PlanarImage;
import javax.media.jai.PropertyGenerator;
import javax.media.jai.ROI;
import javax.media.jai.ROIShape;
import javax.media.jai.RenderedOp;
import javax.media.jai.Warp;
import javax.media.jai.WarpAffine;
import javax.media.jai.WarpGrid;
import javax.media.jai.operator.ConstantDescriptor;
import javax.media.jai.operator.MosaicDescriptor;
import javax.media.jai.operator.MosaicType;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.LiteCoordinateSequence;
import org.geotools.image.GTAffinePropertyGenerator;
import org.geotools.image.GTWarpPropertyGenerator;
import org.geotools.image.io.ImageIOExt;
import org.geotools.image.util.ColorUtilities;
import org.geotools.image.util.ImageUtilities;
import org.geotools.metadata.i18n.Errors;
import org.geotools.referencing.ReferencingFactoryFinder;
import org.geotools.referencing.operation.matrix.AffineTransform2D;
import org.geotools.referencing.operation.transform.WarpBuilder;
import org.geotools.util.Arguments;
import org.geotools.util.factory.Hints;
import org.geotools.util.logging.Logging;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Polygon;
import org.opengis.coverage.processing.OperationNotFoundException;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.TransformException;

public class ImageWorker {
    static final Integer ONE;
    private static final byte[][] IDENTITY_BYTE;
    private static final short[][] IDENTITY_SHORT;
    private static final double[] ROI_BACKGROUND;
    private static final double[][] ROI_THRESHOLDS;
    private static final String OPERATION_CONST_OP_NAME = "operationConst";
    private static final String ALGEBRIC_OP_NAME = "algebric";
    public static final String SCALE_NAME = "Scale";
    public static final String SCALE2_NAME = "Scale2";
    public static final String SCALE_OP_NAME;
    public static final String JAIEXT_ENABLED_KEY = "org.geotools.coverage.jaiext.enabled";
    public static final String USE_JAI_SCALE2_KEY = "it.geosolutions.jaiext.scale2";
    public static final boolean JAIEXT_ENABLED;
    public static final boolean USE_JAI_SCALE2;
    private static final Logger LOGGER;
    private static final boolean CODEC_LIB_AVAILABLE;
    private static final ImageWriterSpi JDK_JPEG_IMAGE_WRITER_SPI;
    private static final ImageWriterSpi IMAGEIO_GIF_IMAGE_WRITER_SPI;
    private static final ImageWriterSpi IMAGEIO_JPEG_IMAGE_WRITER_SPI;
    private static final ImageWriterSpi IMAGEIO_EXT_TIFF_IMAGE_WRITER_SPI;
    private static final ImageWriterSpi CLIB_PNG_IMAGE_WRITER_SPI;
    static final float RS_EPS = 0.01f;
    public static final String WARP_REDUCTION_ENABLED_KEY = "org.geotools.image.reduceWarpAffine";
    static boolean WARP_REDUCTION_ENABLED;
    static final ColorSpace CS_PYCC;
    private static final byte[] ALPHA_LUT;
    public static final Hints.Key TILING_ALLOWED;
    public static final Hints.Key FORCE_MOSAIC_ROI_PROPERTY;
    public static final Hints.Key PRESERVE_CHAINED_AFFINES;
    private static final String EXTREMA = "extrema";
    private static final String HISTOGRAM = "histogram";
    private static final String MEAN = "mean";
    private RenderedImage inheritanceStopPoint;
    protected RenderedImage image;
    private ROI roi;
    private Range nodata;
    private double[] background;
    private RenderingHints commonHints;
    private int tileCacheDisabled = 0;
    private int xPeriod = ONE;
    private int yPeriod = ONE;

    public static boolean isJaiExtEnabled() {
        return JAIEXT_ENABLED;
    }

    static ImageWriterSpi getImageWriterSpi(String className) throws Exception {
        Iterator<ImageWriterSpi> serviceProviders = IIORegistry.lookupProviders(ImageWriterSpi.class);
        while (serviceProviders.hasNext()) {
            ImageWriterSpi serviceProvider = serviceProviders.next();
            if (serviceProvider.getClass().getName() != className) continue;
            return serviceProvider;
        }
        throw new Exception("Class " + className + " not found");
    }

    protected static OperationDescriptor getOperationDescriptor(String name) throws OperationNotFoundException {
        OperationRegistry registry = JAI.getDefaultInstance().getOperationRegistry();
        OperationDescriptor operation = (OperationDescriptor)registry.getDescriptor("rendered", name);
        if (operation != null) {
            return operation;
        }
        throw new OperationNotFoundException(Errors.format((int)152, (Object)name));
    }

    public ImageWorker() {
        this.image = null;
        this.inheritanceStopPoint = null;
    }

    public ImageWorker(RenderingHints hints) {
        this();
        this.setRenderingHints(hints);
    }

    public ImageWorker(File input) throws IOException {
        this(ImageIOExt.read(input));
    }

    public ImageWorker(RenderedImage image) {
        this.setImage(image);
    }

    public int getXPeriod() {
        return this.xPeriod;
    }

    public ImageWorker setXPeriod(int xPeriod) {
        this.xPeriod = xPeriod;
        return this;
    }

    public int getYPeriod() {
        return this.yPeriod;
    }

    public ImageWorker setYPeriod(int yPeriod) {
        this.yPeriod = yPeriod;
        return this;
    }

    public Range extractNoDataProperty(RenderedImage image) {
        Object property = image.getProperty("GC_NODATA");
        if (property != null) {
            if (property instanceof NoDataContainer) {
                return ((NoDataContainer)property).getAsRange();
            }
            if (property instanceof Double) {
                return RangeFactory.create((double)((Double)property), (double)((Double)property));
            }
        }
        return null;
    }

    public final ImageWorker setImage(RenderedImage image) {
        this.inheritanceStopPoint = this.image = image;
        this.setNoData(this.extractNoDataProperty(image));
        return this;
    }

    private ImageWorker fork(RenderedImage image) {
        ImageWorker worker = new ImageWorker(image);
        if (this.commonHints != null && !this.commonHints.isEmpty()) {
            RenderingHints hints = new RenderingHints(null);
            hints.add(worker.commonHints);
            worker.commonHints = hints;
        }
        return worker;
    }

    public final void load(String source, int imageChoice, boolean readMetadata) {
        ParameterBlockJAI pbj = new ParameterBlockJAI("ImageRead");
        pbj.setParameter("Input", (Object)source).setParameter("ImageChoice", (Object)imageChoice).setParameter("ReadMetadata", (Object)readMetadata).setParameter("VerifyInput", (Object)Boolean.TRUE);
        this.image = JAI.create((String)"ImageRead", (ParameterBlock)pbj, (RenderingHints)this.getRenderingHints());
    }

    public final RenderedImage getRenderedImage() {
        return this.image;
    }

    public final BufferedImage getBufferedImage() {
        if (this.image instanceof BufferedImage) {
            return (BufferedImage)this.image;
        }
        return this.getPlanarImage().getAsBufferedImage();
    }

    public final PlanarImage getPlanarImage() {
        return PlanarImage.wrapRenderedImage((RenderedImage)this.getRenderedImage());
    }

    public final RenderedOp getRenderedOperation() {
        RenderedImage image = this.getRenderedImage();
        if (image instanceof RenderedOp) {
            return (RenderedOp)image;
        }
        ParameterBlock pb = new ParameterBlock();
        pb.setSource(image, 0);
        return JAI.create((String)"Null", (ParameterBlock)pb, (RenderingHints)this.getRenderingHints());
    }

    public ImageWorker nullOp() {
        ParameterBlock pb = new ParameterBlock();
        pb.setSource(this.image, 0);
        this.image = JAI.create((String)"Null", (ParameterBlock)pb, (RenderingHints)this.getRenderingHints());
        return this;
    }

    public final ROI getImageAsROI() {
        this.binarize();
        return new ROI(this.getRenderedImage());
    }

    public final ROI getROI() {
        return this.roi;
    }

    public final Range getNoData() {
        return this.nodata;
    }

    public final double[] getDestinationNoData() {
        return this.background;
    }

    public boolean isNoDataNeeded() {
        return this.roi != null || this.nodata != null;
    }

    public final ImageWorker setROI(ROI roi) {
        this.roi = roi;
        PlanarImage pl = this.getPlanarImage();
        if (roi == null) {
            boolean overwriteROI;
            block5: {
                pl.removeProperty("ROI");
                overwriteROI = false;
                try {
                    Object property = pl.getProperty("ROI");
                    overwriteROI = property != null && property != Image.UndefinedProperty;
                }
                catch (Exception e) {
                    overwriteROI = true;
                    if (!LOGGER.isLoggable(Level.FINE)) break block5;
                    LOGGER.log(Level.FINE, "Failure while checking source image ROI during a ROI reset, normally it's safely ignorable", e);
                }
            }
            if (overwriteROI) {
                pl.setProperty("ROI", (Object)new ROIGeometry((Geometry)JTS.toPolygon((Rectangle)new Rectangle(this.image.getMinX(), this.image.getMinY(), this.image.getWidth(), this.image.getHeight()))));
            }
        } else {
            pl.setProperty("ROI", (Object)roi);
        }
        this.image = pl;
        this.invalidateStatistics();
        return this;
    }

    public final ImageWorker setNoData(Range nodata) {
        PlanarImage img;
        Object property;
        this.nodata = nodata;
        if (nodata != null && this.image != null) {
            PlanarImage img2 = this.getPlanarImage();
            img2.setProperty("GC_NODATA", (Object)new NoDataContainer(nodata));
            this.image = img2;
        } else if (this.image != null && (property = (img = this.getPlanarImage()).getProperty("GC_NODATA")) != null && property != Image.UndefinedProperty) {
            img.setProperty("GC_NODATA", new Object());
            this.image = img;
        }
        this.invalidateStatistics();
        return this;
    }

    public final ImageWorker setBackground(double[] background) {
        this.background = background;
        this.invalidateStatistics();
        return this;
    }

    public final Object getRenderingHint(RenderingHints.Key key) {
        return this.commonHints != null ? this.commonHints.get(key) : null;
    }

    public final ImageWorker setRenderingHint(RenderingHints.Key key, Object value) {
        if (this.commonHints == null) {
            this.commonHints = new RenderingHints(null);
        }
        this.commonHints.add(new RenderingHints(key, value));
        return this;
    }

    public final ImageWorker setRenderingHints(RenderingHints hints) {
        if (this.commonHints == null) {
            this.commonHints = new RenderingHints(null);
        }
        if (hints != null) {
            this.commonHints.add(hints);
        }
        return this;
    }

    public final ImageWorker removeRenderingHints() {
        if (this.commonHints != null) {
            this.commonHints = null;
        }
        return this;
    }

    public final ImageWorker removeRenderingHint(RenderingHints.Key key) {
        if (this.commonHints != null) {
            this.commonHints.remove(key);
        }
        return this;
    }

    public final RenderingHints getRenderingHints() {
        RenderingHints hints = ImageUtilities.getRenderingHints(this.image);
        if (hints == null) {
            hints = new RenderingHints(null);
            if (this.commonHints != null) {
                hints.add(this.commonHints);
            }
        } else if (this.commonHints != null) {
            hints.putAll((Map<?, ?>)this.commonHints);
        }
        if (Boolean.FALSE.equals(hints.get(TILING_ALLOWED))) {
            ImageLayout layout = ImageWorker.getImageLayout(hints);
            if (this.commonHints == null || layout != this.commonHints.get(JAI.KEY_IMAGE_LAYOUT)) {
                layout.setTileWidth(this.image.getWidth());
                layout.setTileHeight(this.image.getHeight());
                layout.setTileGridXOffset(this.image.getMinX());
                layout.setTileGridYOffset(this.image.getMinY());
                hints.put(JAI.KEY_IMAGE_LAYOUT, layout);
            }
        }
        if (this.tileCacheDisabled != 0 && this.commonHints != null && !this.commonHints.containsKey(JAI.KEY_TILE_CACHE)) {
            hints.add(new RenderingHints(JAI.KEY_TILE_CACHE, null));
        }
        return hints;
    }

    private final RenderingHints getRenderingHints(int type) {
        RenderingHints hints = this.getRenderingHints();
        ImageLayout layout = ImageWorker.getImageLayout(hints);
        if (layout.isValid(512)) {
            return hints;
        }
        ColorModel oldCm = this.image.getColorModel();
        if (oldCm != null) {
            ComponentColorModel newCm = new ComponentColorModel(oldCm.getColorSpace(), oldCm.hasAlpha(), oldCm.isAlphaPremultiplied(), oldCm.getTransparency(), type);
            layout.setColorModel((ColorModel)newCm);
            layout.setSampleModel(((ColorModel)newCm).createCompatibleSampleModel(this.image.getWidth(), this.image.getHeight()));
        } else {
            int numBands = this.image.getSampleModel().getNumBands();
            ComponentColorModel newCm = new ComponentColorModel((ColorSpace)new BogusColorSpace(numBands), false, false, 1, type);
            layout.setColorModel((ColorModel)newCm);
            layout.setSampleModel(((ColorModel)newCm).createCompatibleSampleModel(this.image.getWidth(), this.image.getHeight()));
        }
        hints.put(JAI.KEY_IMAGE_LAYOUT, layout);
        return hints;
    }

    private static ImageLayout getImageLayout(RenderingHints hints) {
        Object candidate = hints.get(JAI.KEY_IMAGE_LAYOUT);
        if (candidate instanceof ImageLayout) {
            return (ImageLayout)candidate;
        }
        return new ImageLayout();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final ImageWorker tileCacheEnabled(boolean status) {
        if (status) {
            if (this.tileCacheDisabled == 0) throw new IllegalStateException();
            --this.tileCacheDisabled;
            return this;
        } else {
            ++this.tileCacheDisabled;
        }
        return this;
    }

    public final int getNumBands() {
        return this.image.getSampleModel().getNumBands();
    }

    public final int getTransparentPixel() {
        ColorModel cm = this.image.getColorModel();
        return cm instanceof IndexColorModel ? ((IndexColorModel)cm).getTransparentPixel() : -1;
    }

    private Object getComputedProperty(String name) {
        Object value = this.image.getProperty(name);
        return value == this.inheritanceStopPoint.getProperty(name) ? Image.UndefinedProperty : value;
    }

    private double[][] getExtremas() {
        Object extrema = this.getComputedProperty(EXTREMA);
        if (!(extrema instanceof double[][])) {
            ParameterBlock pb = new ParameterBlock();
            pb.setSource(this.image, 0);
            if (JAIExt.isJAIExtOperation((String)"Stats")) {
                Statistics.StatsType[] stats = new Statistics.StatsType[]{Statistics.StatsType.EXTREMA};
                int numBands = this.getNumBands();
                int[] bands = new int[numBands];
                for (int i = 0; i < numBands; ++i) {
                    bands[i] = i;
                }
                pb.set(this.xPeriod, 0);
                pb.set(this.yPeriod, 1);
                pb.set(this.roi, 2);
                pb.set(this.nodata, 3);
                pb.set(bands, 5);
                pb.set(stats, 6);
                this.image = JAI.create((String)"Stats", (ParameterBlock)pb, (RenderingHints)this.getRenderingHints());
                Statistics[][] results = (Statistics[][])this.getComputedProperty("JAI-EXT.stats");
                double[][] ext = new double[2][numBands];
                for (int i = 0; i < numBands; ++i) {
                    double[] extBand = (double[])results[i][0].getResult();
                    ext[0][i] = extBand[0];
                    ext[1][i] = extBand[1];
                }
                if (this.image instanceof PlanarImage) {
                    ((PlanarImage)this.image).setProperty(EXTREMA, (Object)ext);
                } else {
                    PlanarImage p = this.getPlanarImage();
                    p.setProperty(EXTREMA, (Object)ext);
                    this.image = p;
                }
            } else {
                pb.set(this.roi, 0);
                pb.set(this.xPeriod, 1);
                pb.set(this.yPeriod, 2);
                pb.set(ONE, 4);
                this.image = JAI.create((String)"Extrema", (ParameterBlock)pb, (RenderingHints)this.getRenderingHints());
            }
            extrema = this.getComputedProperty(EXTREMA);
        }
        return (double[][])extrema;
    }

    public Histogram getHistogram(int[] numBins, double[] lowValues, double[] highValues) {
        Object histogram = this.getComputedProperty(HISTOGRAM);
        if (histogram instanceof HistogramWrapper) {
            HistogramWrapper wrapper = (HistogramWrapper)histogram;
            double[] prevHighs = wrapper.getHighValue();
            double[] prevLows = wrapper.getLowValue();
            int[] prevNumBins = wrapper.getNumBins();
            if (Arrays.equals(prevHighs, highValues) && Arrays.equals(prevLows, lowValues) && Arrays.equals(prevNumBins, numBins)) {
                return wrapper;
            }
        }
        ParameterBlock pb = new ParameterBlock();
        pb.setSource(this.image, 0);
        if (JAIExt.isJAIExtOperation((String)"Stats")) {
            Statistics.StatsType[] stats = new Statistics.StatsType[]{Statistics.StatsType.HISTOGRAM};
            int numBands = this.getNumBands();
            int[] bands = new int[numBands];
            for (int i = 0; i < numBands; ++i) {
                bands[i] = i;
            }
            pb.set(this.xPeriod, 0);
            pb.set(this.yPeriod, 1);
            pb.set(this.roi, 2);
            pb.set(this.nodata, 3);
            pb.set(bands, 5);
            pb.set(stats, 6);
            pb.set(numBins, 9);
            pb.set(lowValues, 7);
            pb.set(highValues, 8);
            this.image = JAI.create((String)"Stats", (ParameterBlock)pb, (RenderingHints)this.getRenderingHints());
            Statistics[][] results = (Statistics[][])this.getComputedProperty("JAI-EXT.stats");
            int[][] bins = new int[numBands][];
            for (int i = 0; i < results.length; ++i) {
                Statistics stat = results[i][0];
                double[] binsDouble = (double[])stat.getResult();
                bins[i] = new int[binsDouble.length];
                for (int j = 0; j < binsDouble.length; ++j) {
                    bins[i][j] = (int)binsDouble[j];
                }
            }
            ParameterBlock parameterBlock = this.getRenderedOperation().getParameterBlock();
            if (numBins == null) {
                numBins = (int[])parameterBlock.getObjectParameter(9);
            }
            if (lowValues == null) {
                lowValues = (double[])parameterBlock.getObjectParameter(7);
            }
            if (highValues == null) {
                highValues = (double[])parameterBlock.getObjectParameter(8);
            }
            HistogramWrapper wrapper = new HistogramWrapper(numBins, lowValues, highValues, (int[][])bins);
            if (this.image instanceof PlanarImage) {
                ((PlanarImage)this.image).setProperty(HISTOGRAM, (Object)wrapper);
            } else {
                PlanarImage p = this.getPlanarImage();
                p.setProperty(HISTOGRAM, (Object)wrapper);
                this.image = p;
            }
        } else {
            pb.set(this.roi, 0);
            pb.set(this.xPeriod, 1);
            pb.set(this.yPeriod, 2);
            pb.set(numBins, 3);
            pb.set(lowValues, 4);
            pb.set(highValues, 5);
            this.image = JAI.create((String)"Histogram", (ParameterBlock)pb, (RenderingHints)this.getRenderingHints());
        }
        histogram = this.getComputedProperty(HISTOGRAM);
        return (Histogram)histogram;
    }

    public double[] getMean() {
        Object mean = this.getComputedProperty(MEAN);
        if (!(mean instanceof double[])) {
            ParameterBlock pb = new ParameterBlock();
            pb.setSource(this.image, 0);
            if (JAIExt.isJAIExtOperation((String)"Stats")) {
                Statistics.StatsType[] stats = new Statistics.StatsType[]{Statistics.StatsType.MEAN};
                int numBands = this.getNumBands();
                int[] bands = new int[numBands];
                for (int i = 0; i < numBands; ++i) {
                    bands[i] = i;
                }
                pb.set(this.xPeriod, 0);
                pb.set(this.yPeriod, 1);
                pb.set(this.roi, 2);
                pb.set(this.nodata, 3);
                pb.set(bands, 5);
                pb.set(stats, 6);
                this.image = JAI.create((String)"Stats", (ParameterBlock)pb, (RenderingHints)this.getRenderingHints());
                Statistics[][] results = (Statistics[][])this.getComputedProperty("JAI-EXT.stats");
                double[] meanBands = new double[numBands];
                for (int i = 0; i < numBands; ++i) {
                    meanBands[i] = (Double)results[i][0].getResult();
                }
                if (this.image instanceof PlanarImage) {
                    ((PlanarImage)this.image).setProperty(MEAN, (Object)meanBands);
                } else {
                    PlanarImage p = this.getPlanarImage();
                    p.setProperty(MEAN, (Object)meanBands);
                    this.image = p;
                }
            } else {
                pb.set(this.roi, 0);
                pb.set(this.xPeriod, 1);
                pb.set(this.yPeriod, 2);
                this.image = JAI.create((String)"Mean", (ParameterBlock)pb, (RenderingHints)this.getRenderingHints());
            }
            mean = this.getComputedProperty(MEAN);
        }
        return (double[])mean;
    }

    private ImageWorker invalidateStatistics() {
        this.inheritanceStopPoint = this.image;
        return this;
    }

    public final double[] getMinimums() {
        return this.getExtremas()[0];
    }

    public final double[] getMaximums() {
        return this.getExtremas()[1];
    }

    public final boolean isBytes() {
        int[] sampleSize;
        SampleModel sm = this.image.getSampleModel();
        for (int j : sampleSize = sm.getSampleSize()) {
            if (j == 8) continue;
            return false;
        }
        return true;
    }

    public final boolean isBinary() {
        return ImageUtil.isBinary((SampleModel)this.image.getSampleModel());
    }

    public final boolean isIndexed() {
        return this.image.getColorModel() instanceof IndexColorModel;
    }

    public final boolean isColorSpaceRGB() {
        ColorModel cm = this.image.getColorModel();
        if (cm == null) {
            return false;
        }
        return cm.getColorSpace().getType() == 5;
    }

    public final boolean isColorSpaceYCbCr() {
        if (CS_PYCC == null) {
            throw new IllegalStateException("Unable to create an YCbCr profile most like since we are unable to locate the YCbCr color profile. Check the Java installation.");
        }
        ColorModel cm = this.image.getColorModel();
        if (cm == null) {
            return false;
        }
        return cm.getColorSpace().getType() == 3 || cm.getColorSpace().equals(CS_PYCC);
    }

    public final boolean isColorSpaceIHS() {
        ColorModel cm = this.image.getColorModel();
        if (cm == null) {
            return false;
        }
        return cm.getColorSpace() instanceof IHSColorSpace || cm.getColorSpace() instanceof IHSColorSpaceJAIExt;
    }

    public final boolean isColorSpaceGRAYScale() {
        ColorModel cm = this.image.getColorModel();
        if (cm == null) {
            return false;
        }
        return cm.getColorSpace().getType() == 6;
    }

    public final boolean isTranslucent() {
        return this.image.getColorModel().getTransparency() == 3;
    }

    public final ImageWorker rescaleToBytes() {
        if (this.isBytes()) {
            return this;
        }
        this.forceComponentColorModel(true, true);
        if (this.isBytes()) {
            return this;
        }
        double[][] extrema = this.getExtremas();
        int length = extrema[0].length;
        double[] scale = new double[length];
        double[] offset = new double[length];
        double destNodata = this.background != null && this.background.length > 0 ? this.background[0] : (this.nodata != null && !this.nodata.contains(0) ? 0.0 : Double.NaN);
        double offsetAdjustment = Math.abs(destNodata - 0.0) < 1.0E-6 ? 1.0 : 0.0;
        boolean computeRescale = false;
        for (int i = 0; i < length; ++i) {
            double delta = extrema[1][i] - extrema[0][i];
            if (Math.abs(delta) > 1.0E-6 && (extrema[1][i] - 255.0 > 1.0E-6 || extrema[0][i] < -1.0E-6) || offsetAdjustment > 0.0) {
                computeRescale = true;
                scale[i] = (255.0 - offsetAdjustment) / delta;
                offset[i] = -scale[i] * extrema[0][i] + offsetAdjustment;
                continue;
            }
            scale[i] = 1.0;
            offset[i] = 0.0;
        }
        RenderingHints hints = this.getRenderingHints(0);
        if (computeRescale) {
            ParameterBlock pb = new ParameterBlock();
            pb.setSource(this.image, 0);
            pb.set(scale, 0);
            pb.set(offset, 1);
            pb.set(this.roi, 2);
            pb.set(this.nodata, 3);
            if (this.isNoDataNeeded() && !Double.isNaN(destNodata)) {
                pb.set(destNodata, 5);
            }
            this.image = JAI.create((String)"Rescale", (ParameterBlock)pb, (RenderingHints)hints);
            if (!Double.isNaN(destNodata)) {
                this.setNoData(RangeFactory.create((int)((byte)destNodata), (int)0));
            }
        } else {
            ParameterBlock pb = new ParameterBlock();
            pb.setSource(this.image, 0);
            pb.set(0, 0);
            this.image = JAI.create((String)"Format", (ParameterBlock)pb, (RenderingHints)hints);
            this.setNoData(RangeFactory.convert((Range)this.nodata, (int)0));
        }
        this.invalidateStatistics();
        assert (this.isBytes());
        return this;
    }

    public final ImageWorker forceIndexColorModel(boolean error) {
        ColorModel cm = this.image.getColorModel();
        if (cm instanceof IndexColorModel) {
            return this;
        }
        this.tileCacheEnabled(false);
        if (this.getNumBands() % 2 == 0) {
            this.retainBands(this.getNumBands() - 1);
        }
        this.forceColorSpaceRGB();
        RenderingHints hints = this.getRenderingHints();
        if (error) {
            KernelJAI ditherMask = KernelJAI.ERROR_FILTER_FLOYD_STEINBERG;
            ColorCube colorMap = ColorCube.BYTE_496;
            ParameterBlock pb = new ParameterBlock();
            pb.setSource(this.image, 0);
            pb.set(colorMap, 0);
            pb.set(ditherMask, 1);
            pb.set(this.roi, 2);
            pb.set(this.nodata, 3);
            if (this.isNoDataNeeded() && this.background != null && this.background.length > 0) {
                int dest = (int)this.background[0];
                pb.set(dest, 4);
            }
            this.image = JAI.create((String)"ErrorDiffusion", (ParameterBlock)pb, (RenderingHints)hints);
        } else {
            KernelJAI[] ditherMask = KernelJAI.DITHER_MASK_443;
            ColorCube colorMap = ColorCube.BYTE_496;
            ParameterBlock pb = new ParameterBlock();
            pb.setSource(this.image, 0);
            pb.set(colorMap, 0);
            pb.set(ditherMask, 1);
            pb.set(this.roi, 2);
            pb.set(this.nodata, 3);
            if (this.isNoDataNeeded() && this.background != null && this.background.length > 0) {
                int dest = (int)this.background[0];
                pb.set(dest, 4);
            }
            this.image = JAI.create((String)"OrderedDither", (ParameterBlock)pb, (RenderingHints)hints);
        }
        this.tileCacheEnabled(true);
        this.invalidateStatistics();
        assert (this.isIndexed());
        return this;
    }

    public final ImageWorker forceBitmaskIndexColorModel() {
        this.forceBitmaskIndexColorModel(this.getTransparentPixel(), true);
        return this;
    }

    public final ImageWorker forceBitmaskIndexColorModel(int suggestedTransparent, boolean errorDiffusion) {
        ColorModel cm = this.image.getColorModel();
        if (cm instanceof IndexColorModel) {
            LookupTable lookupTable;
            int i;
            Object[] table;
            IndexColorModel oldCM = (IndexColorModel)cm;
            switch (oldCM.getTransparency()) {
                case 1: {
                    return this;
                }
                case 2: {
                    if (oldCM.getTransparentPixel() != suggestedTransparent) break;
                    return this;
                }
            }
            int transparentPixel = ColorUtilities.getTransparentPixel(oldCM);
            int mapSize = oldCM.getMapSize();
            suggestedTransparent = transparentPixel < 0 ? (suggestedTransparent <= mapSize ? mapSize + 1 : suggestedTransparent) : transparentPixel;
            int newSize = Math.max(mapSize, suggestedTransparent);
            int newPixelSize = ColorUtilities.getBitCount(newSize);
            if (newPixelSize > 16) {
                throw new IllegalArgumentException("Unable to create index color model with more than 65536 elements");
            }
            if (newPixelSize <= 8) {
                table = new byte[mapSize];
                for (i = 0; i < mapSize; ++i) {
                    table[i] = (byte)(oldCM.getAlpha(i) == 0 ? suggestedTransparent : i);
                }
                lookupTable = LookupTableFactory.create((byte[])table, (int)this.image.getSampleModel().getDataType());
            } else {
                table = new short[mapSize];
                for (i = 0; i < mapSize; ++i) {
                    table[i] = (short)(oldCM.getAlpha(i) == 0 ? suggestedTransparent : i);
                }
                lookupTable = LookupTableFactory.create((short[])table, (boolean)true);
            }
            byte[][] rgb = new byte[3][newSize];
            oldCM.getReds(rgb[0]);
            oldCM.getGreens(rgb[1]);
            oldCM.getBlues(rgb[2]);
            IndexColorModel newCM = new IndexColorModel(newPixelSize, newSize, rgb[0], rgb[1], rgb[2], suggestedTransparent);
            RenderingHints hints = this.getRenderingHints();
            ImageLayout layout = ImageWorker.getImageLayout(hints);
            layout.setColorModel((ColorModel)newCM);
            hints.put(JAI.KEY_TRANSFORM_ON_COLORMAP, Boolean.FALSE);
            hints.put(JAI.KEY_IMAGE_LAYOUT, layout);
            ParameterBlock pb = new ParameterBlock();
            pb.setSource(this.image, 0);
            pb.set(lookupTable, 0);
            pb.set(this.roi, 2);
            pb.set(this.nodata, 3);
            if (this.isNoDataNeeded() && this.background != null && this.background.length > 0) {
                pb.set(this.background[0], 1);
            }
            this.image = JAI.create((String)"Lookup", (ParameterBlock)pb, (RenderingHints)hints);
            pb = new ParameterBlock();
            pb.setSource(this.image, 0);
            int dataType = this.image.getSampleModel().getDataType();
            pb.set(dataType, 0);
            this.image = JAI.create((String)"Format", (ParameterBlock)pb, (RenderingHints)hints);
            this.setNoData(RangeFactory.convert((Range)this.nodata, (int)dataType));
        } else {
            this.forceComponentColorModel(true);
            if (cm.hasAlpha()) {
                this.tileCacheEnabled(false);
                int numBands = this.getNumBands();
                RenderingHints hints = this.getRenderingHints();
                ParameterBlock pb = new ParameterBlock();
                pb.setSource(this.image, 0);
                pb.set(new int[]{--numBands}, 0);
                RenderedOp alphaChannel = JAI.create((String)"BandSelect", (ParameterBlock)pb, (RenderingHints)hints);
                this.retainBands(numBands);
                this.forceIndexColorModel(errorDiffusion);
                this.tileCacheEnabled(true);
                this.addTransparencyToIndexColorModel((RenderedImage)alphaChannel, false, suggestedTransparent, errorDiffusion);
            } else {
                this.forceIndexColorModel(errorDiffusion);
            }
        }
        assert (this.isIndexed());
        assert (!this.isTranslucent());
        return this;
    }

    public final ImageWorker forceIndexColorModelForGIF(boolean errorDiffusion) {
        ColorModel cm = this.image.getColorModel();
        if (cm instanceof PackedColorModel) {
            this.forceComponentColorModel();
            cm = this.image.getColorModel();
        }
        if (!(cm instanceof IndexColorModel) || cm.getPixelSize() > 8) {
            this.rescaleToBytes();
        }
        if (this.isTranslucent()) {
            this.forceBitmaskIndexColorModel(255, errorDiffusion);
        } else {
            this.forceIndexColorModel(errorDiffusion);
        }
        assert (this.isIndexed());
        assert (!this.isTranslucent());
        return this;
    }

    public final ImageWorker forceComponentColorModel() {
        return this.forceComponentColorModel(false);
    }

    public final ImageWorker forceComponentColorModel(boolean checkTransparent, boolean optimizeGray, boolean omitAlphaOnExpand) {
        ColorModel cm = this.image.getColorModel();
        if (cm instanceof ComponentColorModel) {
            return this;
        }
        if (cm instanceof IndexColorModel) {
            ImageLayout layout;
            boolean alpha;
            IndexColorModel icm = (IndexColorModel)cm;
            SampleModel sm = this.image.getSampleModel();
            int datatype = sm.getDataType();
            Range noData = this.getNoData();
            boolean gray = ColorUtilities.isGrayPalette(icm, checkTransparent) && optimizeGray && noData == null;
            boolean bl = alpha = (icm.hasAlpha() || noData != null) && !omitAlphaOnExpand;
            int numDestinationBands = gray ? (alpha ? 2 : 1) : (alpha ? 4 : 3);
            LookupTable lut = null;
            switch (datatype) {
                case 0: {
                    byte[][] data = new byte[numDestinationBands][256];
                    icm.getReds(data[0]);
                    if (numDestinationBands >= 2) {
                        if (!gray) {
                            icm.getGreens(data[1]);
                        } else {
                            icm.getAlphas(data[1]);
                        }
                    }
                    if (numDestinationBands >= 3) {
                        icm.getBlues(data[2]);
                    }
                    if (numDestinationBands == 4) {
                        icm.getAlphas(data[3]);
                    }
                    if (icm.getMapSize() < 256) {
                        Color bgColor = this.getBackgroundColor();
                        if (bgColor == null) {
                            bgColor = Color.BLACK;
                        }
                        byte r = (byte)(bgColor.getRed() & 0xFF);
                        byte g = (byte)(bgColor.getRed() & 0xFF);
                        byte b = (byte)(bgColor.getBlue() & 0xFF);
                        byte a = (byte)(bgColor.getAlpha() & 0xFF);
                        for (int i = icm.getMapSize(); i < 256; ++i) {
                            data[0][i] = r;
                            if (numDestinationBands >= 2) {
                                data[1][i] = !gray ? g : a;
                            }
                            if (numDestinationBands >= 3) {
                                data[2][i] = b;
                            }
                            if (numDestinationBands != 4) continue;
                            data[3][i] = a;
                        }
                    }
                    if (noData != null && (numDestinationBands == 2 || numDestinationBands == 4)) {
                        int noDataValue = noData.getMin().intValue();
                        for (int i = 0; i < 256; ++i) {
                            if (i != noDataValue) continue;
                            if (numDestinationBands == 2 && gray) {
                                data[1][i] = 0;
                                continue;
                            }
                            if (numDestinationBands != 4) continue;
                            data[3][i] = 0;
                        }
                    }
                    lut = LookupTableFactory.create((byte[][])data, (int)datatype);
                    break;
                }
                case 1: {
                    lut = gray ? this.createGrayLookupTable(icm, numDestinationBands) : this.createRGBLookupTable(icm, numDestinationBands);
                    break;
                }
                default: {
                    throw new IllegalArgumentException(Errors.format((int)58, (Object)"datatype", (Object)datatype));
                }
            }
            if (lut == null) {
                throw new IllegalStateException(Errors.format((int)143, (Object)"lut"));
            }
            RenderingHints hints = this.getRenderingHints();
            Object candidate = hints.get(JAI.KEY_IMAGE_LAYOUT);
            if (candidate instanceof ImageLayout) {
                layout = (ImageLayout)candidate;
            } else {
                layout = new ImageLayout(this.image);
                hints.add(new RenderingHints(JAI.KEY_IMAGE_LAYOUT, layout));
            }
            int[] bits = new int[numDestinationBands];
            for (int i = 0; i < numDestinationBands; ++i) {
                bits[i] = numDestinationBands >= 3 ? 8 : sm.getSampleSize(i);
            }
            ComponentColorModel destinationColorModel = new ComponentColorModel(numDestinationBands >= 3 ? ColorSpace.getInstance(1000) : ColorSpace.getInstance(1003), bits, alpha, cm.isAlphaPremultiplied(), alpha ? 3 : 1, datatype);
            SampleModel destinationSampleModel = destinationColorModel.createCompatibleSampleModel(this.image.getWidth(), this.image.getHeight());
            layout.setColorModel((ColorModel)destinationColorModel);
            layout.setSampleModel(destinationSampleModel);
            ParameterBlock pb = new ParameterBlock();
            pb.setSource(this.image, 0);
            pb.set(lut, 0);
            pb.set(this.roi, 2);
            pb.set(this.nodata, 3);
            if (this.isNoDataNeeded() && this.background != null && this.background.length > 0) {
                pb.set(this.background[0], 1);
            }
            this.image = JAI.create((String)"Lookup", (ParameterBlock)pb, (RenderingHints)hints);
        } else {
            int type = cm instanceof DirectColorModel ? 0 : this.image.getSampleModel().getTransferType();
            RenderingHints hints = this.getRenderingHints(type);
            ParameterBlock pb = new ParameterBlock();
            pb.setSource(this.image, 0);
            pb.set(type, 0);
            this.image = JAI.create((String)"Format", (ParameterBlock)pb, (RenderingHints)hints);
            this.setNoData(RangeFactory.convert((Range)this.nodata, (int)type));
        }
        this.invalidateStatistics();
        assert (this.image.getColorModel() instanceof ComponentColorModel);
        return this;
    }

    private LookupTable createGrayLookupTable(IndexColorModel icm, int numDestinationBands) {
        int mapSize = icm.getMapSize();
        short[][] data = new short[numDestinationBands][mapSize];
        for (int i = 0; i < mapSize; ++i) {
            data[0][i] = (short)(icm.getRed(i) & 0xFF);
            if (numDestinationBands != 2) continue;
            data[1][i] = (short)(icm.getAlpha(i) & 0xFF);
        }
        return LookupTableFactory.create((short[][])data, (boolean)true);
    }

    private LookupTable createRGBLookupTable(IndexColorModel icm, int numDestinationBands) {
        int mapSize = icm.getMapSize();
        byte[][] data = new byte[numDestinationBands][mapSize];
        for (int i = 0; i < mapSize; ++i) {
            data[0][i] = (byte)(icm.getRed(i) & 0xFF);
            data[1][i] = (byte)(icm.getGreen(i) & 0xFF);
            data[2][i] = (byte)(icm.getBlue(i) & 0xFF);
            if (numDestinationBands != 4) continue;
            data[3][i] = (byte)(icm.getAlpha(i) & 0xFF);
        }
        return LookupTableFactory.create((byte[][])data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ImageWorker removeIndexColorModel() {
        if (this.image.getColorModel() instanceof IndexColorModel) {
            LookupTable lut = null;
            SampleModel sampleModel = this.image.getSampleModel();
            int dataType = sampleModel.getDataType();
            switch (dataType) {
                case 0: {
                    lut = LookupTableFactory.create((byte[][])IDENTITY_BYTE);
                    break;
                }
                case 1: {
                    boolean unsigned = dataType == 2;
                    lut = LookupTableFactory.create((short[][])IDENTITY_SHORT, (boolean)unsigned);
                    break;
                }
                default: {
                    throw new IllegalArgumentException(Errors.format((int)58, (Object)"datatype", (Object)dataType));
                }
            }
            ComponentColorModel destinationColorModel = new ComponentColorModel(ColorSpace.getInstance(1003), false, false, 1, dataType);
            SampleModel destinationSampleModel = destinationColorModel.createCompatibleSampleModel(sampleModel.getWidth(), sampleModel.getHeight());
            ImageLayout layout = new ImageLayout(this.image);
            layout.setColorModel((ColorModel)destinationColorModel);
            layout.setSampleModel(destinationSampleModel);
            RenderingHints oldRi = this.getRenderingHints();
            RenderingHints newRi = (RenderingHints)oldRi.clone();
            newRi.add(new RenderingHints(JAI.KEY_IMAGE_LAYOUT, layout));
            try {
                this.setRenderingHints(newRi);
                this.lookup(lut);
            }
            finally {
                this.setRenderingHints(oldRi);
            }
        }
        return this;
    }

    public final ImageWorker forceComponentColorModel(boolean checkTransparent) {
        return this.forceComponentColorModel(checkTransparent, true);
    }

    public final ImageWorker forceComponentColorModel(boolean checkTransparent, boolean optimizeGray) {
        return this.forceComponentColorModel(checkTransparent, optimizeGray, false);
    }

    public final ImageWorker forceColorSpaceRGB() {
        if (!this.isColorSpaceRGB()) {
            ComponentColorModel cm = new ComponentColorModel(ColorSpace.getInstance(1000), false, false, 1, this.image.getSampleModel().getDataType());
            this.forceColorModel(cm);
        }
        assert (this.isColorSpaceRGB());
        return this;
    }

    public final ImageWorker forceColorSpaceYCbCr() {
        if (!this.isColorSpaceYCbCr()) {
            this.forceComponentColorModel();
            ComponentColorModel cm = new ComponentColorModel(CS_PYCC, false, false, 1, this.image.getSampleModel().getDataType());
            this.forceColorModel(cm);
        }
        assert (this.isColorSpaceYCbCr());
        return this;
    }

    public final ImageWorker forceColorSpaceIHS() {
        if (!this.isColorSpaceIHS()) {
            this.forceComponentColorModel();
            IHSColorSpaceJAIExt ihs = ImageWorker.isJaiExtEnabled() ? IHSColorSpaceJAIExt.getInstance() : IHSColorSpace.getInstance();
            int numBits = this.image.getColorModel().getComponentSize(0);
            ComponentColorModel ihsColorModel = new ComponentColorModel((ColorSpace)ihs, new int[]{numBits, numBits, numBits}, false, false, 1, this.image.getSampleModel().getDataType());
            this.forceColorModel(ihsColorModel);
        }
        assert (this.isColorSpaceIHS());
        return this;
    }

    private void forceColorModel(ColorModel cm) {
        ImageLayout2 il = new ImageLayout2(this.image);
        il.setColorModel(cm);
        il.setSampleModel(cm.createCompatibleSampleModel(this.image.getWidth(), this.image.getHeight()));
        RenderingHints oldRi = this.getRenderingHints();
        RenderingHints newRi = (RenderingHints)oldRi.clone();
        newRi.add(new RenderingHints(JAI.KEY_IMAGE_LAYOUT, il));
        this.setRenderingHints(newRi);
        ParameterBlock pb = new ParameterBlock();
        pb.setSource(this.image, 0);
        pb.set(cm, 0);
        pb.set(this.roi, 1);
        pb.set(this.nodata, 2);
        if (this.isNoDataNeeded() && this.background != null && this.background.length > 0) {
            if (this.background.length != cm.getNumColorComponents()) {
                throw new IllegalArgumentException("Wrong DestinationNoData value defined");
            }
            pb.set(this.background, 3);
        }
        this.image = JAI.create((String)"ColorConvert", (ParameterBlock)pb, (RenderingHints)this.getRenderingHints());
        this.setRenderingHints(oldRi);
        this.invalidateStatistics();
    }

    public final ImageWorker bandMerge(int writeband) {
        ParameterBlock pb = new ParameterBlock();
        PlanarImage sourceImage = PlanarImage.wrapRenderedImage((RenderedImage)this.getRenderedImage());
        int numBands = sourceImage.getSampleModel().getNumBands();
        RenderedOp firstBand = JAI.create((String)"bandSelect", (RenderedImage)sourceImage, (Object)new int[]{0});
        int length = writeband - numBands;
        pb.addSource(sourceImage);
        for (int i = 0; i < length; ++i) {
            pb.addSource(firstBand);
        }
        pb.set(new Range[]{this.nodata}, 0);
        if (this.isNoDataNeeded()) {
            if (this.background != null && this.background.length > 0) {
                pb.set(this.background[0], 1);
            } else if (this.nodata != null) {
                pb.set(this.nodata.getMin().doubleValue(), 1);
            }
        }
        pb.set(this.roi, 3);
        sourceImage = JAI.create((String)"bandmerge", (ParameterBlock)pb);
        this.image = sourceImage;
        this.invalidateStatistics();
        assert (this.image.getSampleModel().getNumBands() == writeband);
        return this;
    }

    public final ImageWorker addBand(RenderedImage image, boolean before) {
        return this.addBand(image, before, false, null);
    }

    public final ImageWorker addBand(RenderedImage image, boolean before, boolean addAlpha, Range nodata2) {
        ParameterBlock pb = new ParameterBlock();
        if (before) {
            pb.setSource(image, 0);
            pb.setSource(this.image, 1);
        } else {
            pb.setSource(this.image, 0);
            pb.setSource(image, 1);
        }
        pb.set(new Range[]{this.nodata, nodata2}, 0);
        if (this.isNoDataNeeded() || nodata2 != null) {
            if (this.background != null && this.background.length > 0) {
                pb.set(this.background[0], 1);
            } else if (this.nodata != null) {
                pb.set(this.nodata.getMin().doubleValue(), 1);
            }
        }
        pb.set(this.roi, 3);
        pb.set(addAlpha, 4);
        this.image = JAI.create((String)"BandMerge", (ParameterBlock)pb, (RenderingHints)this.getRenderingHints());
        this.invalidateStatistics();
        return this;
    }

    public final ImageWorker addBands(RenderedImage[] bands, boolean addAlpha, Range[] nodata2) {
        return this.addBands(bands, addAlpha, nodata2, null);
    }

    public final ImageWorker addBands(RenderedImage[] bands, boolean addAlpha, Range[] nodata2, List<AffineTransform> transformationList) {
        ParameterBlock pb = new ParameterBlock();
        for (RenderedImage band : bands) {
            pb.addSource(band);
        }
        Range[] newRange = new Range[bands.length + 1];
        newRange[0] = this.nodata;
        if (nodata2 != null) {
            System.arraycopy(nodata2, 0, newRange, 1, nodata2.length);
        }
        pb.set(newRange, 0);
        if (this.isNoDataNeeded()) {
            if (this.background != null && this.background.length > 0) {
                pb.set(this.background[0], 1);
            } else if (this.nodata != null) {
                pb.set(this.nodata.getMin().doubleValue(), 1);
            }
        }
        pb.set(transformationList, 3);
        pb.set(this.roi, 3);
        pb.set(addAlpha, 4);
        this.image = JAI.create((String)"BandMerge", (ParameterBlock)pb, (RenderingHints)this.getRenderingHints());
        this.invalidateStatistics();
        return this;
    }

    public final ImageWorker forceColorSpaceGRAYScale() {
        if (!this.isColorSpaceRGB()) {
            ComponentColorModel cm = new ComponentColorModel(ColorSpace.getInstance(1003), false, false, 1, 0);
            this.forceColorModel(cm);
            this.invalidateStatistics();
        }
        assert (this.isColorSpaceGRAYScale());
        return this;
    }

    public final ImageWorker intensity() {
        ColorModel cm = this.image.getColorModel();
        ColorSpace cs = cm.getColorSpace();
        if (cs.getType() == 6 || cs instanceof IHSColorSpace) {
            this.retainFirstBand();
            return this;
        }
        if (cm instanceof IndexColorModel) {
            this.forceComponentColorModel();
            cm = this.image.getColorModel();
        }
        int numBands = cm.getNumComponents();
        int numColorBands = cm.getNumColorComponents();
        boolean hasAlpha = cm.hasAlpha();
        if (numBands == 1) {
            return this;
        }
        if (numColorBands == 1 && hasAlpha) {
            this.retainFirstBand();
            return this;
        }
        if (numColorBands != numBands) {
            this.retainBands(numBands);
        }
        double[][] coeff = new double[1][numBands + 1];
        Arrays.fill(coeff[0], 0, numColorBands, 1.0 / (double)numColorBands);
        ParameterBlock pb = new ParameterBlock();
        pb.setSource(this.image, 0);
        pb.set(coeff, 0);
        pb.set(this.roi, 1);
        pb.set(this.nodata, 2);
        if (this.isNoDataNeeded() && this.background != null && this.background.length > 0) {
            pb.set(this.background[0], 3);
        }
        this.image = JAI.create((String)"BandCombine", (ParameterBlock)pb, (RenderingHints)this.getRenderingHints());
        this.invalidateStatistics();
        assert (this.getNumBands() == 1);
        return this;
    }

    public final ImageWorker retainFirstBand() {
        this.retainBands(1);
        assert (this.getNumBands() == 1);
        return this;
    }

    public final ImageWorker retainLastBand() {
        int band = this.getNumBands() - 1;
        if (band != 0) {
            this.retainBands(new int[]{band});
        }
        assert (this.getNumBands() == 1);
        return this;
    }

    public final ImageWorker retainBands(int numBands) {
        if (numBands <= 0) {
            throw new IndexOutOfBoundsException(Errors.format((int)58, (Object)"numBands", (Object)numBands));
        }
        if (this.getNumBands() > numBands) {
            int[] bands = new int[numBands];
            for (int i = 0; i < bands.length; ++i) {
                bands[i] = i;
            }
            ParameterBlock pb = new ParameterBlock();
            pb.setSource(this.image, 0);
            pb.set(bands, 0);
            this.image = JAI.create((String)"BandSelect", (ParameterBlock)pb, (RenderingHints)this.getRenderingHints());
        }
        assert (this.getNumBands() <= numBands);
        return this;
    }

    public final ImageWorker retainBands(int[] bands) {
        ParameterBlock pb = new ParameterBlock();
        pb.setSource(this.image, 0);
        pb.set(bands, 0);
        this.image = JAI.create((String)"BandSelect", (ParameterBlock)pb, (RenderingHints)this.getRenderingHints());
        return this;
    }

    public final ImageWorker format(int dataType) {
        ParameterBlock pb = new ParameterBlock();
        pb.setSource(this.image, 0);
        pb.set(dataType, 0);
        this.image = JAI.create((String)"Format", (ParameterBlock)pb, (RenderingHints)this.getRenderingHints());
        this.setNoData(RangeFactory.convert((Range)this.nodata, (int)dataType));
        assert (this.image.getSampleModel().getDataType() == dataType);
        return this;
    }

    public final ImageWorker binarize() {
        this.binarize(Double.NaN);
        assert (this.isBinary());
        return this;
    }

    public final ImageWorker binarize(double threshold) {
        if (!this.isBinary()) {
            if (Double.isNaN(threshold)) {
                if (this.getNumBands() != 1) {
                    this.tileCacheEnabled(false);
                    this.intensity();
                    this.tileCacheEnabled(true);
                }
                double[][] extremas = this.getExtremas();
                threshold = 0.5 * (extremas[0][0] + extremas[1][0]);
            }
            RenderingHints hints = this.getRenderingHints();
            ParameterBlock pb = new ParameterBlock();
            pb.setSource(this.image, 0);
            pb.set(threshold, 0);
            pb.set(this.roi, 1);
            pb.set(this.nodata, 2);
            this.image = JAI.create((String)"Binarize", (ParameterBlock)pb, (RenderingHints)hints);
            this.setNoData(null);
            this.invalidateStatistics();
        }
        assert (this.isBinary());
        return this;
    }

    public final ImageWorker binarize(int value0, int value1) {
        int max;
        this.tileCacheEnabled(false);
        this.binarize();
        this.tileCacheEnabled(true);
        int min = Math.min(value0, value1);
        LookupTable table = min >= 0 ? ((max = Math.max(value0, value1)) < 256 ? LookupTableFactory.create((byte[])new byte[]{(byte)value0, (byte)value1}, (int)0) : (max < 65536 ? LookupTableFactory.create((short[])new short[]{(short)value0, (short)value1}, (boolean)true) : LookupTableFactory.create((int[])new int[]{value0, value1}))) : LookupTableFactory.create((int[])new int[]{value0, value1}, (int)0);
        ParameterBlock pb = new ParameterBlock();
        pb.setSource(this.image, 0);
        pb.set(table, 0);
        pb.set(this.roi, 2);
        pb.set(this.nodata, 3);
        if (this.isNoDataNeeded() && this.background != null && this.background.length > 0) {
            pb.set(this.background[0], 1);
        }
        this.image = JAI.create((String)"Lookup", (ParameterBlock)pb, (RenderingHints)this.getRenderingHints());
        this.invalidateStatistics();
        return this;
    }

    public final ImageWorker makeColorTransparent(Color transparentColor) throws IllegalStateException {
        if (transparentColor == null) {
            throw new IllegalArgumentException(Errors.format((int)143, (Object)"transparentColor"));
        }
        ColorModel cm = this.image.getColorModel();
        if (cm instanceof IndexColorModel) {
            return this.maskIndexColorModel(transparentColor);
        }
        if (cm instanceof ComponentColorModel) {
            switch (this.image.getSampleModel().getDataType()) {
                case 0: {
                    return this.maskComponentColorModelByte(transparentColor);
                }
            }
        }
        throw new IllegalStateException(Errors.format((int)198));
    }

    private final ImageWorker maskIndexColorModel(Color transparentColor) {
        int found;
        int transpColor;
        assert (this.image.getColorModel() instanceof IndexColorModel);
        IndexColorModel cm = (IndexColorModel)this.image.getColorModel();
        int numComponents = cm.getNumComponents();
        int transparency = cm.getTransparency();
        int transparencyIndex = cm.getTransparentPixel();
        int mapSize = cm.getMapSize();
        int transparentRGB = transparentColor.getRGB() & 0xFFFFFF;
        if (transparency == 2 && transparencyIndex != -1 && (transpColor = cm.getRGB(transparencyIndex) & 0xFFFFFF) == transparentRGB) {
            return this;
        }
        ArrayList<Integer> transparentPixelsIndexes = new ArrayList<Integer>();
        for (int i = 0; i < mapSize; ++i) {
            int color = cm.getRGB(i) & 0xFFFFFF;
            if (transparentRGB != color) continue;
            transparentPixelsIndexes.add(i);
            if (2 == transparency) break;
        }
        if ((found = transparentPixelsIndexes.size()) == 1) {
            transparencyIndex = (Integer)transparentPixelsIndexes.get(0);
            transparency = 2;
        } else {
            if (found == 0) {
                return this;
            }
            transparencyIndex = -1;
            transparency = 3;
        }
        byte[][] rgb = new byte[4][mapSize];
        cm.getReds(rgb[0]);
        cm.getGreens(rgb[1]);
        cm.getBlues(rgb[2]);
        if (numComponents == 4) {
            cm.getAlphas(rgb[3]);
        } else {
            Arrays.fill(rgb[3], (byte)-1);
        }
        if (transparency != 3) {
            cm = new IndexColorModel(cm.getPixelSize(), mapSize, rgb[0], rgb[1], rgb[2], transparencyIndex);
        } else {
            for (Integer transparentPixelsIndex : transparentPixelsIndexes) {
                rgb[3][transparentPixelsIndex.intValue()] = 0;
            }
            cm = new IndexColorModel(cm.getPixelSize(), mapSize, rgb[0], rgb[1], rgb[2], rgb[3]);
        }
        ImageLayout layout = new ImageLayout(this.image);
        layout.setColorModel((ColorModel)cm);
        RenderingHints hints = this.getRenderingHints();
        hints.add(new RenderingHints(JAI.KEY_IMAGE_LAYOUT, layout));
        hints.add(new RenderingHints(JAI.KEY_REPLACE_INDEX_COLOR_MODEL, Boolean.FALSE));
        ParameterBlock pb = new ParameterBlock();
        pb.setSource(this.image, 0);
        pb.set(this.image.getSampleModel().getDataType(), 0);
        this.image = JAI.create((String)"Format", (ParameterBlock)pb, (RenderingHints)hints);
        this.setNoData(RangeFactory.convert((Range)this.nodata, (int)this.image.getSampleModel().getDataType()));
        this.invalidateStatistics();
        return this;
    }

    private final ImageWorker maskComponentColorModelByte(Color transparentColor) {
        boolean singleStep;
        assert (this.image.getColorModel() instanceof ComponentColorModel);
        assert (this.image.getSampleModel().getDataType() == 0);
        int numBands = this.image.getSampleModel().getNumBands();
        int numColorBands = this.image.getColorModel().getNumColorComponents();
        RenderingHints hints = this.getRenderingHints();
        if (numColorBands != numBands) {
            int[] opaqueBands = new int[numColorBands];
            for (int i = 0; i < opaqueBands.length; ++i) {
                opaqueBands[i] = i;
            }
            ParameterBlock pb = new ParameterBlock();
            pb.setSource(this.image, 0);
            pb.set(opaqueBands, 0);
            this.image = JAI.create((String)"BandSelect", (ParameterBlock)pb, (RenderingHints)hints);
            numBands = numColorBands;
        }
        byte[][] tableData = new byte[numColorBands][256];
        boolean bl = singleStep = numColorBands == 1;
        if (singleStep) {
            byte[] data = tableData[0];
            Arrays.fill(data, (byte)-1);
            data[transparentColor.getRed()] = 0;
        } else {
            switch (numColorBands) {
                case 3: {
                    Arrays.fill(tableData[2], (byte)-1);
                    tableData[2][transparentColor.getBlue()] = 0;
                }
                case 2: {
                    Arrays.fill(tableData[1], (byte)-1);
                    tableData[1][transparentColor.getGreen()] = 0;
                }
                case 1: {
                    Arrays.fill(tableData[0], (byte)-1);
                    tableData[0][transparentColor.getRed()] = 0;
                }
            }
        }
        LookupTable table = LookupTableFactory.create((byte[][])tableData, (int)this.image.getSampleModel().getDataType());
        hints.put(JAI.KEY_TRANSFORM_ON_COLORMAP, Boolean.FALSE);
        ParameterBlock pb = new ParameterBlock();
        pb.setSource(this.image, 0);
        pb.set(table, 0);
        pb.set(this.roi, 2);
        pb.set(this.nodata, 3);
        if (this.isNoDataNeeded() && this.background != null && this.background.length > 0) {
            pb.set(this.background[0], 1);
        }
        RenderedOp luImage = JAI.create((String)"Lookup", (ParameterBlock)pb, (RenderingHints)hints);
        if (!singleStep) {
            double[][] matrix = new double[1][4];
            Arrays.fill(matrix[0], 0, 3, 1.0);
            pb = new ParameterBlock();
            pb.setSource(luImage, 0);
            pb.set(matrix, 0);
            pb.set(this.roi, 1);
            pb.set(this.nodata, 2);
            if (this.background != null && this.background.length > 0) {
                pb.set(this.background[0], 3);
            }
            luImage = JAI.create((String)"BandCombine", (ParameterBlock)pb, (RenderingHints)this.getRenderingHints());
        }
        pb = new ParameterBlock();
        pb.setSource(this.image, 0);
        pb.setSource(luImage, 1);
        pb.set(new Range[]{this.nodata}, 0);
        if (this.isNoDataNeeded() && this.background != null && this.background.length > 0) {
            double dest = this.background[0];
            pb.set(dest, 1);
        }
        pb.set(this.roi, 3);
        pb.set(true, 4);
        this.image = JAI.create((String)"BandMerge", (ParameterBlock)pb, (RenderingHints)hints);
        this.invalidateStatistics();
        return this;
    }

    public final ImageWorker invert() {
        ParameterBlock pb = new ParameterBlock();
        pb.setSource(this.image, 0);
        if (JAIExt.isJAIExtOperation((String)ALGEBRIC_OP_NAME)) {
            pb.set(AlgebraDescriptor.Operator.INVERT, 0);
            pb.set(this.roi, 1);
            pb.set(this.nodata, 2);
            if (this.isNoDataNeeded() && this.background != null && this.background.length > 0) {
                double dest = this.background[0];
                pb.set(dest, 3);
            }
            this.image = JAI.create((String)ALGEBRIC_OP_NAME, (ParameterBlock)pb, (RenderingHints)this.getRenderingHints());
        } else {
            this.image = JAI.create((String)"Invert", (ParameterBlock)pb, (RenderingHints)this.getRenderingHints());
        }
        this.invalidateStatistics();
        return this;
    }

    public final ImageWorker mask(RenderedImage mask, boolean maskValue, int newValue) {
        ParameterBlock pb;
        this.tileCacheEnabled(false);
        this.forceIndexColorModel(true);
        RenderingHints hints = new RenderingHints(JAI.KEY_TILE_CACHE, null);
        if (newValue == 255 && !maskValue) {
            byte[] lutData = new byte[256];
            Arrays.fill(lutData, (byte)0);
            lutData[0] = -1;
            LookupTable lut = LookupTableFactory.create((byte[])lutData, (int)mask.getSampleModel().getDataType());
            ParameterBlock pb2 = new ParameterBlock();
            pb2.setSource(mask, 0);
            pb2.set(lut, 0);
            if (this.background != null && this.background.length > 0) {
                pb2.set(this.background[0], 1);
            }
            pb2.set(this.roi, 2);
            mask = JAI.create((String)"Lookup", (ParameterBlock)pb2, (RenderingHints)hints);
            pb2 = new ParameterBlock();
            pb2.setSource(this.image, 0);
            pb2.setSource(mask, 1);
            if (JAIExt.isJAIExtOperation((String)ALGEBRIC_OP_NAME)) {
                this.prepareAlgebricOperation(AlgebraDescriptor.Operator.SUM, pb2, this.roi, this.nodata, true);
                this.image = JAI.create((String)ALGEBRIC_OP_NAME, (ParameterBlock)pb2, (RenderingHints)this.getRenderingHints());
            } else {
                this.image = JAI.create((String)"Add", (ParameterBlock)pb2, (RenderingHints)this.getRenderingHints());
            }
            this.tileCacheEnabled(true);
            this.invalidateStatistics();
            return this;
        }
        if (!this.isBinary()) {
            this.binarize();
        }
        boolean algebricJAIExt = JAIExt.isJAIExtOperation((String)ALGEBRIC_OP_NAME);
        boolean opConstJAIExt = JAIExt.isJAIExtOperation((String)OPERATION_CONST_OP_NAME);
        RenderingHints renderingHints = new RenderingHints(JAI.KEY_REPLACE_INDEX_COLOR_MODEL, Boolean.FALSE);
        if (maskValue) {
            pb = new ParameterBlock();
            pb.setSource(mask, 0);
            if (algebricJAIExt) {
                this.prepareAlgebricOperation(AlgebraDescriptor.Operator.NOT, pb, this.roi, null, false);
                mask = JAI.create((String)ALGEBRIC_OP_NAME, (ParameterBlock)pb, (RenderingHints)renderingHints);
            } else {
                mask = JAI.create((String)"Not", (ParameterBlock)pb, (RenderingHints)renderingHints);
            }
        }
        this.tileCacheEnabled(false);
        pb = new ParameterBlock();
        pb.setSource(mask, 0);
        pb.setSource(this.image, 1);
        if (algebricJAIExt) {
            this.prepareAlgebricOperation(AlgebraDescriptor.Operator.AND, pb, this.roi, this.nodata, true);
            this.image = JAI.create((String)ALGEBRIC_OP_NAME, (ParameterBlock)pb, (RenderingHints)this.getRenderingHints());
        } else {
            this.image = JAI.create((String)"And", (ParameterBlock)pb, (RenderingHints)this.getRenderingHints());
        }
        pb = new ParameterBlock();
        pb.setSource(mask, 0);
        if (opConstJAIExt) {
            this.prepareOpConstOperation(AlgebraDescriptor.Operator.SUM, new double[]{newValue}, pb, this.roi, null, false);
            this.image = JAI.create((String)OPERATION_CONST_OP_NAME, (ParameterBlock)pb, (RenderingHints)renderingHints);
        } else {
            this.image = JAI.create((String)"AddConst", (ParameterBlock)pb, (RenderingHints)renderingHints);
        }
        pb = new ParameterBlock();
        pb.setSource(mask, 0);
        pb.setSource(this.image, 1);
        if (algebricJAIExt) {
            this.prepareAlgebricOperation(AlgebraDescriptor.Operator.SUM, pb, this.roi, this.nodata, true);
            this.image = JAI.create((String)ALGEBRIC_OP_NAME, (ParameterBlock)pb, (RenderingHints)this.getRenderingHints());
        } else {
            this.image = JAI.create((String)"Add", (ParameterBlock)pb, (RenderingHints)this.getRenderingHints());
        }
        this.tileCacheEnabled(true);
        this.invalidateStatistics();
        return this;
    }

    private void prepareAlgebricOperation(AlgebraDescriptor.Operator op, ParameterBlock pb, ROI roi, Range nodata, boolean setDestNoData) {
        pb.set(op, 0);
        pb.set(roi, 1);
        pb.set(nodata, 2);
        if (this.background != null && this.background.length > 0) {
            pb.set(this.background[0], 3);
            if (setDestNoData && roi != null && nodata != null) {
                this.setNoData(RangeFactory.create((double)this.background[0], (double)this.background[0]));
            }
        }
    }

    private void prepareOpConstOperation(AlgebraDescriptor.Operator op, double[] values, ParameterBlock pb, ROI roi, Range nodata, boolean setDestNoData) {
        pb.set(op, 1);
        pb.set(values, 0);
        pb.set(roi, 2);
        pb.set(nodata, 3);
        if (this.background != null && this.background.length > 0) {
            pb.set(this.background[0], 4);
            if (setDestNoData && roi != null && nodata != null) {
                this.setNoData(RangeFactory.create((double)this.background[0], (double)this.background[0]));
            }
        }
    }

    public final ImageWorker addImage(RenderedImage renderedImage) {
        ParameterBlock pb = new ParameterBlock();
        pb.setSource(this.image, 0);
        pb.setSource(renderedImage, 1);
        if (JAIExt.isJAIExtOperation((String)ALGEBRIC_OP_NAME)) {
            this.prepareAlgebricOperation(AlgebraDescriptor.Operator.SUM, pb, this.roi, this.nodata, true);
            this.image = JAI.create((String)ALGEBRIC_OP_NAME, (ParameterBlock)pb, (RenderingHints)this.getRenderingHints());
        } else {
            this.image = JAI.create((String)"Add", (ParameterBlock)pb, (RenderingHints)this.getRenderingHints());
        }
        this.invalidateStatistics();
        return this;
    }

    public final ImageWorker multiplyConst(double[] inValues) {
        ParameterBlock pb = new ParameterBlock();
        pb.setSource(this.image, 0);
        if (JAIExt.isJAIExtOperation((String)OPERATION_CONST_OP_NAME)) {
            this.prepareOpConstOperation(AlgebraDescriptor.Operator.MULTIPLY, inValues, pb, this.roi, this.nodata, true);
            this.image = JAI.create((String)OPERATION_CONST_OP_NAME, (ParameterBlock)pb, (RenderingHints)this.getRenderingHints());
        } else {
            this.image = JAI.create((String)"MultiplyConst", (ParameterBlock)pb, (RenderingHints)this.getRenderingHints());
        }
        this.invalidateStatistics();
        return this;
    }

    public final ImageWorker multiply(RenderedImage renderedImage) {
        ParameterBlock pb = new ParameterBlock();
        pb.setSource(this.image, 0);
        pb.setSource(renderedImage, 1);
        if (JAIExt.isJAIExtOperation((String)ALGEBRIC_OP_NAME)) {
            this.prepareAlgebricOperation(AlgebraDescriptor.Operator.MULTIPLY, pb, this.roi, this.nodata, true);
            this.image = JAI.create((String)ALGEBRIC_OP_NAME, (ParameterBlock)pb, (RenderingHints)this.getRenderingHints());
        } else {
            this.image = JAI.create((String)"Multiply", (ParameterBlock)pb, (RenderingHints)this.getRenderingHints());
        }
        this.invalidateStatistics();
        return this;
    }

    public final ImageWorker xorConst(int[] values) {
        ParameterBlock pb = new ParameterBlock();
        pb.setSource(this.image, 0);
        if (JAIExt.isJAIExtOperation((String)OPERATION_CONST_OP_NAME)) {
            double[] valuesD = new double[values.length];
            for (int i = 0; i < values.length; ++i) {
                valuesD[i] = values[i];
            }
            this.prepareOpConstOperation(AlgebraDescriptor.Operator.XOR, valuesD, pb, this.roi, this.nodata, true);
            this.image = JAI.create((String)OPERATION_CONST_OP_NAME, (ParameterBlock)pb, (RenderingHints)this.getRenderingHints());
        } else {
            this.image = JAI.create((String)"XorConst", (ParameterBlock)pb, (RenderingHints)this.getRenderingHints());
        }
        this.invalidateStatistics();
        return this;
    }

    public final ImageWorker subtract(RenderedImage renderedImage) {
        ParameterBlock pb = new ParameterBlock();
        pb.setSource(this.image, 0);
        pb.setSource(renderedImage, 1);
        if (JAIExt.isJAIExtOperation((String)ALGEBRIC_OP_NAME)) {
            this.prepareAlgebricOperation(AlgebraDescriptor.Operator.SUBTRACT, pb, this.roi, this.nodata, true);
            this.image = JAI.create((String)ALGEBRIC_OP_NAME, (ParameterBlock)pb, (RenderingHints)this.getRenderingHints());
        } else {
            this.image = JAI.create((String)"Subtract", (ParameterBlock)pb, (RenderingHints)this.getRenderingHints());
        }
        this.invalidateStatistics();
        return this;
    }

    public final ImageWorker or(RenderedImage renderedImage) {
        ParameterBlock pb = new ParameterBlock();
        pb.setSource(this.image, 0);
        pb.setSource(renderedImage, 1);
        if (JAIExt.isJAIExtOperation((String)ALGEBRIC_OP_NAME)) {
            this.prepareAlgebricOperation(AlgebraDescriptor.Operator.OR, pb, this.roi, this.nodata, true);
            this.image = JAI.create((String)ALGEBRIC_OP_NAME, (ParameterBlock)pb, (RenderingHints)this.getRenderingHints());
        } else {
            this.image = JAI.create((String)"Or", (ParameterBlock)pb, (RenderingHints)this.getRenderingHints());
        }
        this.invalidateStatistics();
        return this;
    }

    public final ImageWorker artifactsFilter(int threshold, int filterSize) {
        ParameterBlock pb = new ParameterBlock();
        pb.setSource(this.image, 0);
        pb.set(this.roi, 0);
        pb.set(this.background, 1);
        pb.set(threshold, 2);
        pb.set(filterSize, 3);
        pb.set(this.nodata, 4);
        this.invalidateStatistics();
        return this;
    }

    public ImageWorker addTransparencyToIndexColorModel(RenderedImage alphaChannel, boolean errorDiffusion) {
        this.addTransparencyToIndexColorModel(alphaChannel, true, this.getTransparentPixel(), errorDiffusion);
        return this;
    }

    public final ImageWorker addTransparencyToIndexColorModel(RenderedImage alphaChannel, boolean translucent, int transparent, boolean errorDiffusion) {
        boolean forceBitmask;
        this.tileCacheEnabled(false);
        this.forceIndexColorModel(errorDiffusion);
        this.tileCacheEnabled(true);
        ImageWorker worker = this.fork(this.image);
        RenderingHints hints = worker.getRenderingHints();
        IndexColorModel oldCM = (IndexColorModel)this.image.getColorModel();
        int pixelSize = oldCM.getPixelSize();
        boolean bl = forceBitmask = !translucent && oldCM.getTransparency() == 3;
        if (forceBitmask || oldCM.getTransparentPixel() != (transparent &= (1 << pixelSize) - 1)) {
            IndexColorModel newCM;
            int mapSize = Math.max(oldCM.getMapSize(), transparent + 1);
            byte[][] RGBA = new byte[translucent ? 4 : 3][mapSize];
            oldCM.getReds(RGBA[0]);
            oldCM.getGreens(RGBA[1]);
            oldCM.getBlues(RGBA[2]);
            if (translucent) {
                oldCM.getAlphas(RGBA[3]);
                RGBA[3][transparent] = 0;
                newCM = new IndexColorModel(pixelSize, mapSize, RGBA[0], RGBA[1], RGBA[2], RGBA[3]);
            } else {
                newCM = new IndexColorModel(pixelSize, mapSize, RGBA[0], RGBA[1], RGBA[2], transparent);
            }
            ImageLayout layout = ImageWorker.getImageLayout(hints);
            layout.setColorModel((ColorModel)newCM);
            worker.setRenderingHint(JAI.KEY_IMAGE_LAYOUT, layout);
        }
        worker.setRenderingHint(JAI.KEY_REPLACE_INDEX_COLOR_MODEL, Boolean.FALSE);
        worker.mask(alphaChannel, false, transparent);
        this.image = worker.image;
        this.invalidateStatistics();
        assert (this.isIndexed());
        assert (translucent || !this.isTranslucent()) : translucent;
        assert (this.image.getColorModel().getAlpha(transparent) == 0);
        return this;
    }

    public final ImageWorker tile() {
        RenderingHints hints = this.getRenderingHints();
        ImageLayout layout = ImageWorker.getImageLayout(hints);
        if (layout.isValid(64) || layout.isValid(128)) {
            int type = this.image.getSampleModel().getDataType();
            ParameterBlock pb = new ParameterBlock();
            pb.setSource(this.image, 0);
            pb.set(type, 0);
            this.image = JAI.create((String)"Format", (ParameterBlock)pb, (RenderingHints)hints);
            this.setNoData(RangeFactory.convert((Range)this.nodata, (int)type));
        }
        return this;
    }

    public ImageWorker applyOpacity(float opacity) {
        RenderedOp result;
        ColorModel colorModel = this.image.getColorModel();
        if (colorModel instanceof IndexColorModel) {
            IndexColorModel index = (IndexColorModel)colorModel;
            byte[] reds = new byte[index.getMapSize()];
            byte[] greens = new byte[index.getMapSize()];
            byte[] blues = new byte[index.getMapSize()];
            byte[] alphas = new byte[index.getMapSize()];
            index.getReds(reds);
            index.getGreens(greens);
            index.getBlues(blues);
            index.getAlphas(alphas);
            int transparentPixel = index.getTransparentPixel();
            for (int i = 0; i < alphas.length; ++i) {
                alphas[i] = (byte)Math.round((float)(0xFF & alphas[i]) * opacity);
                if (i != transparentPixel) continue;
                alphas[i] = 0;
            }
            IndexColorModel newColorModel = new IndexColorModel(index.getPixelSize(), index.getMapSize(), reds, greens, blues, alphas);
            LookupTable table = this.buildOpacityLookupTable(0.0f, 1, -1, this.image.getSampleModel().getDataType());
            ImageLayout layout = new ImageLayout(this.image);
            layout.setColorModel((ColorModel)newColorModel);
            RenderingHints hints = new RenderingHints(JAI.KEY_IMAGE_LAYOUT, layout);
            ParameterBlock pb = new ParameterBlock();
            pb.setSource(this.image, 0);
            pb.set(table, 0);
            pb.set(this.roi, 2);
            pb.set(this.nodata, 3);
            if (this.isNoDataNeeded() && this.background != null && this.background.length > 0) {
                pb.set(this.background[0], 1);
            }
            result = JAI.create((String)"Lookup", (ParameterBlock)pb, (RenderingHints)hints);
        } else {
            RenderedImage expanded = !(colorModel instanceof ComponentColorModel) ? new ImageWorker(this.image).forceComponentColorModel().getRenderedImage() : this.image;
            if (!expanded.getColorModel().hasAlpha()) {
                byte alpha = (byte)Math.round(255.0f * opacity);
                ImageLayout layout = new ImageLayout(this.image.getMinX(), this.image.getMinY(), this.image.getWidth(), this.image.getHeight());
                RenderedOp alphaBand = ConstantDescriptor.create((Float)Float.valueOf(this.image.getWidth()), (Float)Float.valueOf(this.image.getHeight()), (Number[])new Byte[]{alpha}, (RenderingHints)new RenderingHints(JAI.KEY_IMAGE_LAYOUT, layout));
                ParameterBlock pb = new ParameterBlock();
                pb.setSource(expanded, 0);
                pb.setSource(alphaBand, 1);
                pb.set(new Range[]{this.nodata, this.nodata == null ? null : RangeFactory.create((int)(alpha - 1), (int)(alpha - 1))}, 0);
                if (this.isNoDataNeeded() && this.background != null && this.background.length > 0) {
                    double dest = this.background[0];
                    pb.set(dest, 1);
                }
                pb.set(this.roi, 3);
                pb.set(true, 4);
                result = JAI.create((String)"BandMerge", (ParameterBlock)pb, null);
            } else {
                int bands = expanded.getSampleModel().getNumBands();
                int alphaBand = bands - 1;
                ParameterBlock pb = new ParameterBlock();
                pb.setSource(expanded, 0);
                LookupTable table = this.buildOpacityLookupTable(opacity, bands, alphaBand, expanded.getSampleModel().getDataType());
                pb.set(table, 0);
                pb.set(this.roi, 2);
                pb.set(this.nodata, 3);
                if (this.isNoDataNeeded() && this.background != null && this.background.length > 0) {
                    pb.set(this.background[0], 1);
                }
                result = JAI.create((String)"Lookup", (ParameterBlock)pb, null);
            }
        }
        this.image = result;
        return this;
    }

    LookupTable buildOpacityLookupTable(float opacity, int bands, int alphaBand, int dataType) {
        byte[][] matrix = new byte[bands][256];
        for (int band = 0; band < matrix.length; ++band) {
            int i;
            if (band == alphaBand) {
                for (i = 0; i < 256; ++i) {
                    matrix[band][i] = (byte)Math.round((float)i * opacity);
                }
                continue;
            }
            for (i = 0; i < 256; ++i) {
                matrix[band][i] = (byte)i;
            }
        }
        LookupTable table = LookupTableFactory.create((byte[][])matrix, (int)dataType);
        return table;
    }

    public final ImageWorker write(File output) throws IOException {
        String filename = output.getName();
        int dot = filename.lastIndexOf(46);
        if (dot < 0) {
            throw new IIOException(Errors.format((int)135));
        }
        String extension = filename.substring(dot + 1).trim();
        this.write(output, ImageIO.getImageWritersBySuffix(extension));
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void writePNG(Object destination, String compression, float compressionRate, boolean nativeAcc, boolean paletted) throws IOException {
        IndexColorModel icm;
        boolean hasColorModel;
        boolean hasPalette = this.image.getColorModel() instanceof IndexColorModel;
        boolean bl = hasColorModel = hasPalette ? false : this.image.getColorModel() instanceof ComponentColorModel;
        if (paletted && !hasPalette) {
            this.forceIndexColorModelForGIF(true);
        } else if (!hasColorModel && !hasPalette) {
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.fine("Forcing input image to be compatible with PNG: No palette, no component color model");
            }
            this.forceComponentColorModel();
        }
        if (hasPalette && (icm = (IndexColorModel)this.image.getColorModel()).getMapSize() > 256) {
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.fine("Forcing input image to be compatible with PNG: Palette with > 256 color is not supported.");
            }
            this.rescaleToBytes();
            if (paletted) {
                this.forceIndexColorModelForGIF(true);
            }
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Encoded input image for png writer");
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Getting a writer");
        }
        ImageWriter writer = null;
        Object originatingProvider = null;
        if (nativeAcc) {
            if (CLIB_PNG_IMAGE_WRITER_SPI != null) {
                if (CLIB_PNG_IMAGE_WRITER_SPI.canEncodeImage(new ImageTypeSpecifier(this.image))) {
                    writer = CLIB_PNG_IMAGE_WRITER_SPI.createWriterInstance();
                    originatingProvider = CLIB_PNG_IMAGE_WRITER_SPI;
                } else {
                    LOGGER.fine("The ImageIO PNG native encode cannot encode this image!");
                    writer = null;
                    originatingProvider = null;
                }
            } else {
                LOGGER.fine("Unable to use Native ImageIO PNG writer.");
            }
        }
        if (!nativeAcc || writer == null) {
            Iterator<ImageWriter> it = ImageIO.getImageWriters(new ImageTypeSpecifier(this.image), "PNG");
            if (!it.hasNext()) {
                throw new IllegalStateException(Errors.format((int)135));
            }
            while (it.hasNext()) {
                writer = it.next();
                originatingProvider = writer.getOriginatingProvider();
                if (CLIB_PNG_IMAGE_WRITER_SPI != null && originatingProvider.getClass().equals(CLIB_PNG_IMAGE_WRITER_SPI.getClass())) {
                    if (it.hasNext()) {
                        writer = it.next();
                        originatingProvider = writer.getOriginatingProvider();
                    } else {
                        LOGGER.fine("Unable to use PNG writer different than ImageIO CLib one");
                    }
                }
                if (((ImageWriterSpi)originatingProvider).canEncodeImage(new ImageTypeSpecifier(this.image))) break;
                writer = null;
                originatingProvider = null;
            }
        }
        if (writer == null) {
            List providers = com.sun.media.imageioimpl.common.ImageUtil.getJDKImageReaderWriterSPI((ServiceRegistry)IIORegistry.getDefaultInstance(), (String)"PNG", (boolean)false);
            if (providers == null || providers.isEmpty()) {
                throw new IllegalStateException("Unable to find JDK Png encoder!");
            }
            originatingProvider = (ImageWriterSpi)providers.get(0);
            writer = ((ImageWriterSpi)originatingProvider).createWriterInstance();
            this.forceComponentColorModel(true, true);
            this.rescaleToBytes();
            if (!((ImageWriterSpi)originatingProvider).canEncodeImage(this.image)) {
                throw new IllegalArgumentException("Unable to find a valid PNG Encoder! And believe me, we tried hard!");
            }
        }
        LOGGER.fine("Using ImageIO Writer with SPI: " + originatingProvider.getClass().getCanonicalName());
        LOGGER.fine("Setting write parameters for this writer");
        ImageWriteParam iwp = null;
        try (ImageOutputStream memOutStream = ImageIOExt.createImageOutputStream(this.image, destination);){
            if (memOutStream == null) {
                throw new IIOException(Errors.format((int)143, (Object)"stream"));
            }
            if (CLIB_PNG_IMAGE_WRITER_SPI != null && originatingProvider.getClass().equals(CLIB_PNG_IMAGE_WRITER_SPI.getClass())) {
                LOGGER.fine("Writer is native");
                iwp = writer.getDefaultWriteParam();
                iwp.setCompressionMode(2);
                iwp.setCompressionType(compression);
                iwp.setCompressionQuality(compressionRate);
                iwp.setDestinationType(new ImageTypeSpecifier(this.image.getColorModel(), this.image.getSampleModel()));
            } else {
                LOGGER.fine("Writer is NOT native");
                iwp = new PNGImageWriteParam();
                iwp.setCompressionMode(1);
            }
            LOGGER.fine("About to write png image");
            try {
                writer.setOutput(memOutStream);
                writer.write(null, new IIOImage(this.image, null, null), iwp);
            }
            finally {
                block46: {
                    try {
                        writer.dispose();
                    }
                    catch (Throwable e) {
                        if (!LOGGER.isLoggable(Level.FINEST)) break block46;
                        LOGGER.log(Level.FINEST, e.getLocalizedMessage(), e);
                    }
                }
            }
        }
    }

    public final ImageWorker writeGIF(Object destination, String compression, float compressionRate) throws IOException {
        this.forceIndexColorModelForGIF(true);
        if (IMAGEIO_GIF_IMAGE_WRITER_SPI == null) {
            throw new IIOException(Errors.format((int)135));
        }
        try (ImageOutputStream stream = ImageIOExt.createImageOutputStream(this.image, destination);){
            if (stream == null) {
                throw new IIOException(Errors.format((int)143, (Object)"stream"));
            }
            ImageWriter writer = IMAGEIO_GIF_IMAGE_WRITER_SPI.createWriterInstance();
            ImageWriteParam param = writer.getDefaultWriteParam();
            param.setCompressionMode(2);
            param.setCompressionType(compression);
            param.setCompressionQuality(compressionRate);
            writer.setOutput(stream);
            writer.write(null, new IIOImage(this.image, null, null), param);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void writeJPEG(Object destination, String compression, float compressionRate, boolean nativeAcc) throws IOException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Encoding input image to write out as JPEG.");
        }
        ColorModel cm = this.image.getColorModel();
        boolean hasAlpha = cm.hasAlpha();
        this.forceComponentColorModel(false, true, true);
        cm = this.image.getColorModel();
        this.rescaleToBytes();
        cm = this.image.getColorModel();
        int numBands = this.image.getSampleModel().getNumBands();
        if (hasAlpha) {
            this.retainBands(numBands - 1);
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Getting a JPEG writer and configuring it.");
        }
        ImageWriter writer = null;
        if (nativeAcc && CODEC_LIB_AVAILABLE && IMAGEIO_JPEG_IMAGE_WRITER_SPI != null) {
            try {
                writer = IMAGEIO_JPEG_IMAGE_WRITER_SPI.createWriterInstance();
            }
            catch (Exception e) {
                if (LOGGER.isLoggable(Level.INFO)) {
                    LOGGER.log(Level.INFO, "Unable to instantiate CLIB JPEG ImageWriter", e);
                }
                writer = null;
            }
        }
        if (writer == null) {
            if (JDK_JPEG_IMAGE_WRITER_SPI == null) {
                throw new IllegalStateException(Errors.format((int)61, (Object)"Unable to find JDK JPEG Writer"));
            }
            writer = JDK_JPEG_IMAGE_WRITER_SPI.createWriterInstance();
        }
        ImageWriteParam iwp = writer.getDefaultWriteParam();
        try (ImageOutputStream outStream = ImageIOExt.createImageOutputStream(this.image, destination);){
            if (outStream == null) {
                throw new IIOException(Errors.format((int)143, (Object)"stream"));
            }
            iwp.setCompressionMode(2);
            iwp.setCompressionType(compression);
            iwp.setCompressionQuality(compressionRate);
            if (iwp instanceof JPEGImageWriteParam) {
                JPEGImageWriteParam param = (JPEGImageWriteParam)iwp;
                param.setOptimizeHuffmanTables(true);
                try {
                    param.setProgressiveMode(1);
                }
                catch (UnsupportedOperationException e) {
                    throw new IOException(e);
                }
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Writing out...");
            }
            try {
                writer.setOutput(outStream);
                if (!nativeAcc && (this.image.getMinX() != 0 || this.image.getMinY() != 0) || nativeAcc && (this.image.getNumXTiles() > 1 || this.image.getNumYTiles() > 1)) {
                    BufferedImage finalImage = new BufferedImage(this.image.getColorModel(), ((WritableRaster)this.image.getData()).createWritableTranslatedChild(0, 0), this.image.getColorModel().isAlphaPremultiplied(), null);
                    writer.write(null, new IIOImage(finalImage, null, null), iwp);
                } else {
                    writer.write(null, new IIOImage(this.image, null, null), iwp);
                }
            }
            finally {
                block37: {
                    try {
                        writer.dispose();
                    }
                    catch (Throwable e) {
                        if (!LOGGER.isLoggable(Level.FINEST)) break block37;
                        LOGGER.log(Level.FINEST, e.getLocalizedMessage(), e);
                    }
                }
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Writing out... Done!");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void writeTIFF(Object destination, String compression, float compressionRate, int tileSizeX, int tileSizeY) throws IOException {
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer("Encoding input image to write out as TIFF.");
        }
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer("Getting a TIFF writer and configuring it.");
        }
        ImageWriter writer = null;
        if (IMAGEIO_EXT_TIFF_IMAGE_WRITER_SPI == null) {
            LOGGER.finer("Unable to find ImageIO-Ext Tiff Writer, looking for another one");
            Iterator<ImageWriter> it = ImageIO.getImageWritersByFormatName("TIFF");
            if (!it.hasNext()) {
                throw new IllegalStateException(Errors.format((int)135));
            }
            writer = it.next();
        } else {
            writer = IMAGEIO_EXT_TIFF_IMAGE_WRITER_SPI.createWriterInstance();
        }
        if (writer == null) {
            throw new IllegalStateException("Unable to find Tiff ImageWriter!");
        }
        ImageWriteParam iwp = writer.getDefaultWriteParam();
        try (ImageOutputStream outStream = ImageIOExt.createImageOutputStream(this.image, destination);){
            if (outStream == null) {
                throw new IIOException(Errors.format((int)143, (Object)"stream"));
            }
            if (compression != null) {
                iwp.setCompressionMode(2);
                iwp.setCompressionType(compression);
                iwp.setCompressionQuality(compressionRate);
            } else {
                iwp.setCompressionMode(1);
            }
            if (tileSizeX > 0 && tileSizeY > 0) {
                iwp.setTilingMode(2);
                iwp.setTiling(tileSizeX, tileSizeY, 0, 0);
            }
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer("Writing out...");
            }
            try {
                writer.setOutput(outStream);
                writer.write(null, new IIOImage(this.image, null, null), iwp);
            }
            finally {
                block31: {
                    try {
                        writer.dispose();
                    }
                    catch (Throwable e) {
                        if (!LOGGER.isLoggable(Level.FINEST)) break block31;
                        LOGGER.log(Level.FINEST, e.getLocalizedMessage(), e);
                    }
                }
            }
        }
    }

    public ImageWorker affine(AffineTransform tx, Interpolation interpolation, double[] bgValues) {
        boolean nonNegativeScaleY;
        boolean hasTranslateY;
        int size = Math.max(this.image.getWidth(), this.image.getHeight());
        boolean hasScaleX = Math.abs(tx.getScaleX() - 1.0) * (double)size > (double)0.01f;
        boolean hasScaleY = Math.abs(tx.getScaleY() - 1.0) * (double)size > (double)0.01f;
        boolean hasShearX = Math.abs(tx.getShearX()) * (double)size > (double)0.01f;
        boolean hasShearY = Math.abs(tx.getShearY()) * (double)size > (double)0.01f;
        boolean hasTranslateX = Math.abs(tx.getTranslateX()) > (double)0.01f;
        boolean bl = hasTranslateY = Math.abs(tx.getTranslateY()) > (double)0.01f;
        if (!(hasScaleX || hasScaleY || hasShearX || hasShearY || hasTranslateX || hasTranslateY)) {
            return this;
        }
        ParameterListDescriptor pld = ImageWorker.getOperationDescriptor("affine").getParameterListDescriptor("rendered");
        if (interpolation == null) {
            interpolation = (Interpolation)pld.getParamDefaultValue("interpolation");
        }
        if (bgValues == null) {
            bgValues = this.background == null || this.background.length <= 0 ? (double[])pld.getParamDefaultValue("backgroundValues") : this.background;
        }
        this.background = bgValues;
        RenderedImage source = this.image;
        if (this.image instanceof RenderedOp) {
            RenderedOp op = (RenderedOp)this.image;
            Object mtProperty = op.getProperty("MathTransform");
            Object sourceBoundsProperty = op.getProperty("SourceBoundingBox");
            String opName = op.getOperationName();
            ParameterBlock sourceParamBlock = op.getParameterBlock();
            boolean preserveChainedAffines = false;
            Object preserveHints = this.getRenderingHint((RenderingHints.Key)PRESERVE_CHAINED_AFFINES);
            if (preserveHints != null && preserveHints instanceof Boolean) {
                preserveChainedAffines = (Boolean)preserveHints;
            }
            if (WARP_REDUCTION_ENABLED && "Warp".equals(opName) && mtProperty instanceof MathTransform2D && sourceBoundsProperty instanceof Rectangle && !preserveChainedAffines) {
                try {
                    WarpAffineReducer warpAffineReducer = new WarpAffineReducer(tx, interpolation, bgValues, op).invoke();
                    if (warpAffineReducer.reduced()) {
                        return this;
                    }
                    bgValues = warpAffineReducer.getBgValues();
                }
                catch (Exception e) {
                    LOGGER.log(Level.WARNING, "Failed to squash warp and affine into a single operation, chaining them instead", e);
                }
            }
            if ("Affine".equals(opName) && !preserveChainedAffines) {
                ParameterBlock paramBlock = sourceParamBlock;
                RenderedImage sSource = paramBlock.getRenderedSource(0);
                AffineTransform sTx = (AffineTransform)paramBlock.getObjectParameter(0);
                Interpolation sInterp = (Interpolation)paramBlock.getObjectParameter(1);
                double[] sBgValues = (double[])paramBlock.getObjectParameter(2);
                Range nodata = null;
                ROI r = null;
                boolean similarROI = true;
                boolean hasSameNodata = true;
                if (paramBlock.getNumParameters() > 3) {
                    nodata = (Range)paramBlock.getObjectParameter(6);
                    r = (ROI)paramBlock.getObjectParameter(3);
                    if (r != null) {
                        try {
                            AffineTransform inverse = sTx.createInverse();
                            ROI newROI = this.roi != null ? this.roi.transform(inverse) : null;
                            similarROI = newROI != null && newROI.intersects(r.getBounds());
                        }
                        catch (NoninvertibleTransformException e) {
                            LOGGER.log(Level.SEVERE, e.getMessage(), e);
                        }
                        boolean bl2 = hasSameNodata = nodata == null || sBgValues != null && this.nodata != null && sBgValues.length > 0 && sBgValues[0] == this.nodata.getMin().doubleValue();
                    }
                }
                if (sInterp == interpolation && Arrays.equals(sBgValues, bgValues) && (nodata == null || hasSameNodata) && (r == null || similarROI)) {
                    AffineTransform concat = new AffineTransform(tx);
                    concat.concatenate(sTx);
                    tx = concat;
                    source = sSource;
                    if (similarROI && r != null) {
                        try {
                            AffineTransform inverse = sTx.createInverse();
                            ROI newROI = this.roi != null ? this.roi.transform(inverse) : null;
                            this.roi = newROI != null ? newROI.intersect(r) : null;
                        }
                        catch (NoninvertibleTransformException e) {
                            LOGGER.log(Level.SEVERE, e.getMessage(), e);
                        }
                    }
                    if (hasSameNodata && nodata != null) {
                        this.setNoData(nodata);
                    }
                }
            } else if ((SCALE_NAME.equals(opName) || SCALE2_NAME.equals(opName)) && !preserveChainedAffines) {
                ROI newROI;
                boolean isScale2 = SCALE2_NAME.equals(opName);
                ParameterBlock paramBlock = sourceParamBlock;
                RenderedImage sSource = paramBlock.getRenderedSource(0);
                double[] scalingParams = this.getScalingParams(paramBlock, isScale2);
                Interpolation sInterp = (Interpolation)paramBlock.getObjectParameter(4);
                Range nodata = null;
                ROI r = null;
                boolean similarROI = true;
                boolean hasSameNodata = true;
                int numParameters = paramBlock.getNumParameters();
                if (numParameters > 5) {
                    double[] sBgValues;
                    r = (ROI)paramBlock.getObjectParameter(5);
                    nodata = numParameters > 7 ? (Range)paramBlock.getObjectParameter(7) : null;
                    double[] dArray = sBgValues = numParameters > 8 ? (double[])paramBlock.getObjectParameter(8) : null;
                    if (r != null) {
                        try {
                            newROI = this.computeScaledROI(scalingParams);
                            similarROI = newROI != null && newROI.intersects(r.getBounds());
                        }
                        catch (NoninvertibleTransformException e) {
                            LOGGER.log(Level.SEVERE, e.getMessage(), e);
                        }
                    }
                    boolean bl3 = hasSameNodata = nodata == null || sBgValues != null && this.nodata != null && sBgValues.length > 0 && sBgValues[0] == this.nodata.getMin().doubleValue();
                }
                if (sInterp == interpolation && (nodata == null || hasSameNodata) && (r == null || similarROI)) {
                    AffineTransform concat = new AffineTransform(tx);
                    concat.concatenate(new AffineTransform(scalingParams[0], 0.0, 0.0, scalingParams[1], scalingParams[2], scalingParams[3]));
                    tx = concat;
                    source = sSource;
                    if (similarROI && r != null) {
                        try {
                            newROI = this.computeScaledROI(scalingParams);
                            this.roi = newROI.intersect(r);
                        }
                        catch (NoninvertibleTransformException e) {
                            LOGGER.log(Level.SEVERE, e.getMessage(), e);
                        }
                    }
                    if (hasSameNodata && nodata != null) {
                        this.setNoData(nodata);
                    }
                }
            }
        }
        hasScaleX = Math.abs(tx.getScaleX() - 1.0) * (double)size > (double)0.01f;
        hasScaleY = Math.abs(tx.getScaleY() - 1.0) * (double)size > (double)0.01f;
        hasShearX = Math.abs(tx.getShearX()) * (double)size > (double)0.01f;
        hasShearY = Math.abs(tx.getShearY()) * (double)size > (double)0.01f;
        hasTranslateX = Math.abs(tx.getTranslateX()) > (double)0.01f;
        hasTranslateY = Math.abs(tx.getTranslateY()) > (double)0.01f;
        boolean intTranslateX = Math.abs(tx.getTranslateX() - (double)Math.round(tx.getTranslateX())) < (double)0.01f;
        boolean intTranslateY = Math.abs(tx.getTranslateY() - (double)Math.round(tx.getTranslateY())) < (double)0.01f;
        boolean nonNegativeScaleX = tx.getScaleX() >= 0.0;
        boolean bl4 = nonNegativeScaleY = tx.getScaleY() >= 0.0;
        if (!(hasScaleX || hasScaleY || hasShearX || hasShearY || hasTranslateX || hasTranslateY)) {
            this.image = source;
            return this;
        }
        ParameterBlock pb = new ParameterBlock();
        pb.setSource(source, 0);
        if (!hasShearX && !hasShearY && nonNegativeScaleX && nonNegativeScaleY) {
            if (!hasScaleX && !hasScaleY && intTranslateX && intTranslateY) {
                Hints localHints = new Hints(this.getRenderingHints());
                localHints.remove((Object)JAI.KEY_IMAGE_LAYOUT);
                double[] scalingParams = new double[]{1.0, 1.0, Math.round(tx.getTranslateX()), Math.round(tx.getTranslateY())};
                this.scale(pb, scalingParams, interpolation, (RenderingHints)localHints);
                this.updateNoData(this.background, this.image);
                this.updateROI(false, SCALE_OP_NAME);
            } else {
                double[] scalingParams = new double[]{tx.getScaleX(), tx.getScaleY(), tx.getTranslateX(), tx.getTranslateY()};
                this.scale(pb, scalingParams, interpolation, this.getRenderingHints());
                this.updateNoData(this.background, this.image);
                this.updateROI(false, SCALE_OP_NAME);
            }
        } else {
            pb.set(tx, 0);
            pb.set(interpolation, 1);
            pb.set(bgValues, 2);
            pb.set(this.roi, 3);
            pb.set(true, 5);
            pb.set(this.nodata, 6);
            this.image = JAI.create((String)"Affine", (ParameterBlock)pb, (RenderingHints)this.getRenderingHints());
            this.updateNoData(bgValues, this.image);
            this.updateROI(false, "Affine");
        }
        return this;
    }

    private void scale(ParameterBlock pb, double[] scalingParams, Interpolation interpolation, RenderingHints hints) {
        for (int i = 0; i < 4; ++i) {
            if (USE_JAI_SCALE2) {
                pb.set(scalingParams[i], i);
                continue;
            }
            pb.set((float)scalingParams[i], i);
        }
        RenderedImage sourceImage = pb.getRenderedSource(0);
        ColorModel cm = sourceImage.getColorModel();
        SampleModel sm = sourceImage.getSampleModel();
        int numBands = sm.getNumBands();
        RenderedImage alphaChannel = null;
        if (!(!cm.hasAlpha() || numBands != 2 && numBands != 4 || interpolation == null || interpolation.getWidth() <= 1 && interpolation.getHeight() <= 1)) {
            ImageWorker noAlpha = new ImageWorker(sourceImage).setRenderingHints(hints).retainBands(numBands - 1);
            alphaChannel = new ImageWorker(sourceImage).setRenderingHints(hints).retainLastBand().getRenderedImage();
            pb.setSource(noAlpha.getRenderedImage(), 0);
        }
        pb.set(interpolation, 4);
        pb.set(this.roi, 5);
        pb.set(this.nodata, 7);
        if (this.isNoDataNeeded() && this.background != null && this.background.length > 0) {
            pb.set(this.background, 8);
        }
        RenderedOp scaledImage = JAI.create((String)SCALE_OP_NAME, (ParameterBlock)pb, (RenderingHints)hints);
        this.image = scaledImage;
        if (alphaChannel != null) {
            ParameterBlock pb2 = new ParameterBlock();
            pb2.setSource(alphaChannel, 0);
            for (int i = 0; i < 4; ++i) {
                if (USE_JAI_SCALE2) {
                    pb2.set(scalingParams[i], i);
                    continue;
                }
                pb2.set((float)scalingParams[i], i);
            }
            pb2.set(Interpolation.getInstance((int)0), 4);
            pb2.set(this.roi, 5);
            pb2.set(this.nodata, 7);
            alphaChannel = JAI.create((String)SCALE_OP_NAME, (ParameterBlock)pb2, (RenderingHints)hints);
            ImageWorker merged = this.prepareForScaledAlphaChannel((RenderedImage)scaledImage, hints, cm, sm);
            this.image = merged.addBand(alphaChannel, false, true, null).getRenderedImage();
        }
    }

    ImageWorker prepareForScaledAlphaChannel(RenderedImage scaledImage, RenderingHints hints, ColorModel cm, SampleModel sm) {
        ImageLayout layout;
        ImageWorker merged = new ImageWorker(scaledImage);
        Object candidate = hints.get(JAI.KEY_IMAGE_LAYOUT);
        if (candidate instanceof ImageLayout && (layout = (ImageLayout)candidate).getTileWidth(null) > 0 && layout.getTileHeight(null) > 0) {
            ImageLayout2 layout2 = new ImageLayout2(layout.getTileGridXOffset(null), layout.getTileGridYOffset(null), layout.getTileWidth(null), layout.getTileHeight(null), sm, cm);
            merged.setRenderingHints(new RenderingHints(JAI.KEY_IMAGE_LAYOUT, layout2));
        }
        return merged;
    }

    private void updateROI(boolean forceUpdate, String opName) {
        if (forceUpdate || this.roi != null) {
            Vector<RenderedImage> sources;
            String operationName;
            Object prop = null;
            RenderedImage localImage = this.image;
            if (localImage instanceof RenderedOp && "BandMerge".equalsIgnoreCase(operationName = ((RenderedOp)localImage).getOperationName()) && !(sources = localImage.getSources()).isEmpty()) {
                localImage = (RenderedImage)sources.get(0);
            }
            if (opName != null) {
                PropertyGenerator gen = ImageWorker.getOperationDescriptor(opName).getPropertyGenerators("rendered")[0];
                prop = gen.getProperty("roi", (Object)localImage);
            } else {
                prop = localImage.getProperty("roi");
            }
            if (prop != null && prop instanceof ROI) {
                this.setROI((ROI)prop);
            } else {
                this.setROI(null);
            }
        }
    }

    private ROI computeScaledROI(double[] scalingParams) throws NoninvertibleTransformException {
        ROI newRoi = null;
        if (this.roi != null) {
            AffineTransform sTx = AffineTransform.getScaleInstance(scalingParams[0], scalingParams[1]);
            sTx.concatenate(AffineTransform.getTranslateInstance(scalingParams[2], scalingParams[3]));
            newRoi = this.roi.transform(sTx.createInverse());
        }
        return newRoi;
    }

    private double[] getScalingParams(ParameterBlock paramBlock, boolean isScale2) {
        double[] scalingParams = new double[4];
        for (int i = 0; i < 4; ++i) {
            scalingParams[i] = isScale2 ? paramBlock.getDoubleParameter(i) : (double)paramBlock.getFloatParameter(i);
        }
        return scalingParams;
    }

    private void updateNoData(double[] bgValues, RenderedImage image) {
        Range newNoData;
        if (bgValues != null && bgValues.length > 0 && (newNoData = this.extractNoDataProperty(image)) != null) {
            this.setNoData(newNoData);
        }
    }

    public ImageWorker crop(float x, float y, float width, float height) {
        RenderedOp op;
        if ((float)this.image.getMinX() == x && (float)this.image.getMinY() == y && (float)this.image.getWidth() == width && (float)this.image.getHeight() == height) {
            return this;
        }
        RenderedImage source = this.image;
        if (this.image instanceof RenderedOp && ("Crop".equals((op = (RenderedOp)this.image).getOperationName()) || "GTCrop".equals(op.getOperationName()))) {
            ParameterBlock paramBlock = op.getParameterBlock();
            source = paramBlock.getRenderedSource(0);
            float sx = paramBlock.getFloatParameter(0);
            float sy = paramBlock.getFloatParameter(1);
            float sWidth = paramBlock.getFloatParameter(2);
            float sHeight = paramBlock.getFloatParameter(3);
            Rectangle2D.Float sourceBounds = new Rectangle2D.Float(sx, sy, sWidth, sHeight);
            Rectangle2D.Float bounds = new Rectangle2D.Float(x, y, width, height);
            Rectangle2D intersection = bounds.createIntersection(sourceBounds);
            x = (float)intersection.getMinX();
            y = (float)intersection.getMinY();
            width = (float)intersection.getWidth();
            height = (float)intersection.getHeight();
        }
        ParameterBlock pb = new ParameterBlock();
        pb.setSource(source, 0);
        pb.set(x, 0);
        pb.set(y, 1);
        pb.set(width, 2);
        pb.set(height, 3);
        pb.set(this.roi, 4);
        pb.set(this.nodata, 5);
        if (this.isNoDataNeeded()) {
            double destinationNoData;
            double d = this.nodata != null ? this.nodata.getMin().doubleValue() : (destinationNoData = this.background != null && this.background.length > 0 ? this.background[0] : Double.NaN);
            if (!Double.isNaN(destinationNoData)) {
                pb.set(new double[]{destinationNoData}, 6);
            }
        }
        this.image = JAI.create((String)"Crop", (ParameterBlock)pb, (RenderingHints)this.commonHints);
        this.invalidateStatistics();
        return this;
    }

    public ImageWorker function(ImageFunction function, int w, int h, float xScale, float yScale, float xTrans, float yTrans) {
        if (this.image != null && LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "Input image already present but will be replaced by ImageFunction");
        }
        ParameterBlock pb = new ParameterBlock();
        pb.add(function).add(w).add(h).add(xScale).add(yScale).add(xTrans).add(yTrans).add(this.roi).add(this.nodata);
        if (this.isNoDataNeeded() && this.background != null && this.background.length > 0) {
            pb.add((float)this.background[0]);
        }
        RenderedOp result = JAI.create((String)"ImageFunction", (ParameterBlock)pb, (RenderingHints)this.getRenderingHints());
        this.setImage((RenderedImage)result);
        return this;
    }

    private Color getBackgroundColor() {
        if (this.background == null || this.background.length < 3 || this.background.length > 4) {
            return null;
        }
        for (double component : this.background) {
            if (!(component < 0.0) && !(component > 255.0)) continue;
            return null;
        }
        if (this.background.length == 3) {
            return new Color((int)this.background[0], (int)this.background[1], (int)this.background[2]);
        }
        return new Color((int)this.background[0], (int)this.background[1], (int)this.background[2], (int)this.background[3]);
    }

    public ImageWorker mosaic(RenderedImage[] images, MosaicType type, PlanarImage[] alphas, ROI[] rois, double[][] thresholds, Range[] nodata) {
        double[] background = this.background;
        if (images != null && images.length > 0) {
            ColorModel cmref = images[0].getColorModel();
            Color backgroundColor = this.getBackgroundColor();
            if (cmref instanceof IndexColorModel && (cmref.getTransparency() != 1 || images[0].getProperty("ROI") instanceof ROI) && backgroundColor != null) {
                IndexColorModel icm = (IndexColorModel)cmref;
                int index = ColorUtilities.getColorIndex(icm, backgroundColor, -1);
                Color color = icm.hasAlpha() ? new Color(icm.getRed(index), icm.getGreen(index), icm.getBlue(index)) : new Color(icm.getRed(index), icm.getGreen(index), icm.getBlue(index), icm.getAlpha(index));
                if (color.equals(backgroundColor)) {
                    background = new double[]{index};
                } else {
                    for (int i = 0; i < images.length; ++i) {
                        images[i] = new ImageWorker(images[i]).forceComponentColorModel().getRenderedImage();
                    }
                }
            }
        }
        ParameterBlock pb = new ParameterBlock();
        int srcNum = 0;
        if (images != null && images.length > 0) {
            for (RenderedImage renderedImage : images) {
                if (renderedImage == null) continue;
                pb.addSource(renderedImage);
                ++srcNum;
            }
        }
        ROI[] roisNew = null;
        if (rois != null && srcNum > 0) {
            roisNew = new ROI[srcNum];
            System.arraycopy(rois, 0, roisNew, 0, rois.length);
        }
        PlanarImage[] alphasNew = null;
        if (alphas != null && srcNum > 0) {
            alphasNew = new PlanarImage[srcNum];
            System.arraycopy(alphas, 0, alphasNew, 0, alphas.length);
        }
        Range[] nodataNew = null;
        double[] nodataBackground = null;
        boolean noInternalNoData = true;
        if (nodata != null && srcNum > 0) {
            nodataNew = new Range[srcNum];
            System.arraycopy(nodata, 0, nodataNew, 0, nodata.length);
        } else {
            nodataNew = new Range[srcNum];
            for (int i = 0; i < srcNum; ++i) {
                RenderedImage img = pb.getRenderedSource(i);
                Range nodProp = this.extractNoDataProperty(img);
                if (background == null && nodProp != null && nodataBackground == null) {
                    nodataBackground = new double[]{nodProp.getMax().doubleValue()};
                }
                noInternalNoData &= nodProp == null;
                nodataNew[i] = nodProp;
            }
        }
        if (noInternalNoData && thresholds != null) {
            nodataNew = this.handleMosaicThresholds(thresholds, srcNum);
        }
        pb.add(type);
        pb.add(alphasNew);
        pb.add(roisNew);
        pb.add(thresholds);
        pb.add(background != null ? background : nodataBackground);
        pb.add(nodataNew);
        RenderingHints hints = this.getRenderingHints();
        this.image = JAI.create((String)"Mosaic", (ParameterBlock)pb, (RenderingHints)hints);
        boolean setRoiProperty = false;
        if (hints != null && !hints.isEmpty() && hints.containsKey(FORCE_MOSAIC_ROI_PROPERTY)) {
            setRoiProperty = (Boolean)hints.get(FORCE_MOSAIC_ROI_PROPERTY);
        }
        if (background == null || setRoiProperty) {
            if (roisNew != null) {
                ROI finalROI = this.mosaicROIs(pb.getSources(), roisNew);
                this.setROI(finalROI);
            }
        } else {
            this.setROI(null);
        }
        return this;
    }

    private ROI mosaicROIs(List sources, ROI ... roiArray) {
        int i;
        if (roiArray == null) {
            return null;
        }
        ArrayList<ROI> rois = new ArrayList<ROI>(Arrays.asList(roiArray));
        int numSources = sources.size();
        if (roiArray.length < numSources) {
            for (i = roiArray.length; i < numSources; ++i) {
                RenderedImage img = (RenderedImage)sources.get(i);
                ROI r = this.getImageBoundsROI(img);
                rois.add(r);
            }
        }
        for (i = 0; i < roiArray.length; ++i) {
            ROI roi = roiArray[i];
            if (roi != null) continue;
            RenderedImage img = (RenderedImage)sources.get(i);
            ROI r = this.getImageBoundsROI(img);
            rois.set(i, r);
        }
        if (rois.size() == 1) {
            return (ROI)rois.get(0);
        }
        ArrayList<ROI> rasterROIs = new ArrayList<ROI>();
        ArrayList<ROI> vectorROIs = new ArrayList<ROI>();
        ROI vectorReference = null;
        for (ROI rOI : rois) {
            if (rOI instanceof ROIShape || rOI instanceof ROIGeometry) {
                if (vectorReference == null && rOI instanceof ROIGeometry) {
                    vectorReference = rOI;
                    continue;
                }
                vectorROIs.add(rOI);
                continue;
            }
            rasterROIs.add(rOI);
        }
        if (vectorReference == null && !vectorROIs.isEmpty()) {
            vectorReference = (ROI)vectorROIs.remove(0);
        }
        for (ROI rOI : vectorROIs) {
            vectorReference = vectorReference.add(rOI);
        }
        if (rasterROIs.isEmpty()) {
            return vectorReference;
        }
        if (rasterROIs.size() == 1 && vectorReference == null) {
            return (ROI)rasterROIs.get(0);
        }
        ParameterBlock pb = new ParameterBlock();
        if (vectorReference != null) {
            pb.addSource(vectorReference.getAsImage());
        }
        for (ROI rasterROI : rasterROIs) {
            pb.addSource(rasterROI.getAsImage());
        }
        pb.add(MosaicDescriptor.MOSAIC_TYPE_OVERLAY);
        pb.add(null);
        pb.add(null);
        pb.add(ROI_THRESHOLDS);
        pb.add(ROI_BACKGROUND);
        pb.add(this.handleMosaicThresholds(ROI_THRESHOLDS, rasterROIs.size() + (vectorReference != null ? 1 : 0)));
        RenderedOp renderedOp = JAI.create((String)"Mosaic", (ParameterBlock)pb, (RenderingHints)this.getRenderingHints());
        return new ROI((RenderedImage)renderedOp);
    }

    private ROI getImageBoundsROI(RenderedImage image) {
        int minX = image.getMinX();
        int minY = image.getMinY();
        int maxX = minX + image.getWidth();
        int maxY = minY + image.getHeight();
        LiteCoordinateSequence cs = new LiteCoordinateSequence(new double[]{minX, minY, maxX, minY, maxX, maxY, minX, maxY, minX, minY});
        Polygon footprint = new GeometryFactory().createPolygon((CoordinateSequence)cs);
        return new ROIGeometry((Geometry)footprint);
    }

    private Range[] handleMosaicThresholds(double[][] thresholds, int srcNum) {
        int i;
        Range[] nodata = new Range[srcNum];
        int minSrcNum = Math.min(srcNum, thresholds.length);
        for (i = 0; i < minSrcNum; ++i) {
            double maxValue = Double.NEGATIVE_INFINITY;
            int numBands = thresholds[i].length;
            for (int b = 0; b < numBands; ++b) {
                double bandValue = thresholds[i][b];
                if (!(bandValue > maxValue)) continue;
                maxValue = bandValue;
            }
            nodata[i] = RangeFactory.create((double)Double.NEGATIVE_INFINITY, (boolean)true, (double)maxValue, (boolean)false);
        }
        if (minSrcNum < srcNum) {
            for (i = minSrcNum; i < srcNum; ++i) {
                nodata[i] = nodata[0];
            }
        }
        return nodata;
    }

    public ImageWorker border(int leftPad, int rightPad, int topPad, int bottomPad, BorderExtender ext) {
        ParameterBlock pb = new ParameterBlock();
        pb.addSource(this.image);
        pb.add(leftPad);
        pb.add(rightPad);
        pb.add(topPad);
        pb.add(bottomPad);
        pb.add(ext);
        pb.add(this.nodata);
        if (this.isNoDataNeeded() && this.background != null && this.background.length > 0) {
            pb.add(this.background[0]);
        }
        this.image = JAI.create((String)"Border", (ParameterBlock)pb, (RenderingHints)this.getRenderingHints());
        return this;
    }

    public ImageWorker translate(float xTrans, float yTrans, Interpolation interp) {
        ParameterBlock pb = new ParameterBlock();
        pb.addSource(this.image);
        pb.add(xTrans);
        pb.add(yTrans);
        pb.add(interp);
        this.image = JAI.create((String)"Translate", (ParameterBlock)pb, (RenderingHints)this.commonHints);
        return this;
    }

    public ImageWorker warp(Warp warp, Interpolation interp) {
        ParameterBlock pb = new ParameterBlock();
        pb.setSource(this.image, 0);
        pb.set(warp, 0);
        pb.set(interp, 1);
        pb.set(this.roi, 3);
        pb.set(this.nodata, 4);
        pb.set(this.background, 2);
        this.image = JAI.create((String)"Warp", (ParameterBlock)pb, (RenderingHints)this.getRenderingHints());
        this.updateROI(true, null);
        return this;
    }

    public ImageWorker scale(double xScale, double yScale, double xTrans, double yTrans, Interpolation interp) {
        ParameterBlock pb = new ParameterBlock();
        pb.setSource(this.image, 0);
        double[] scalingParams = new double[]{xScale, yScale, xTrans, yTrans};
        this.scale(pb, scalingParams, interp, this.getRenderingHints());
        this.updateROI(true, SCALE_OP_NAME);
        return this;
    }

    public ImageWorker lookup(LookupTable table) {
        ParameterBlock pb = new ParameterBlock();
        pb.setSource(this.image, 0);
        pb.set(table, 0);
        pb.set(this.roi, 2);
        if (this.nodata != null) {
            this.nodata = RangeFactory.convert((Range)this.nodata, (int)this.image.getSampleModel().getDataType());
        }
        pb.set(this.nodata, 3);
        if (this.isNoDataNeeded() && this.background != null && this.background.length > 0) {
            pb.set(this.background[0], 1);
        }
        this.image = JAI.create((String)"Lookup", (ParameterBlock)pb, (RenderingHints)this.getRenderingHints());
        return this;
    }

    public ImageWorker colorIndex(ColorIndexer indexer) {
        ParameterBlock pb = new ParameterBlock();
        pb.setSource(this.image, 0);
        pb.set(indexer, 0);
        pb.set(this.roi, 1);
        pb.set(this.nodata, 2);
        if (this.isNoDataNeeded() && this.background != null && this.background.length > 0) {
            pb.set(this.background, 3);
        }
        this.image = JAI.create((String)"ColorIndexer", (ParameterBlock)pb, (RenderingHints)this.getRenderingHints());
        return this;
    }

    public ImageWorker classify(ColorMapTransform domain1D, Integer bandIndex) {
        ParameterBlock pb = new ParameterBlock();
        pb.setSource(this.image, 0);
        pb.set(domain1D, 0);
        pb.set(bandIndex, 1);
        pb.set(this.roi, 2);
        pb.set(this.nodata, 3);
        if (this.isNoDataNeeded() && domain1D.hasGaps()) {
            this.setNoData(RangeFactory.create((double)domain1D.getDefaultValue(), (double)domain1D.getDefaultValue()));
        }
        this.image = JAI.create((String)"RasterClassifier", (ParameterBlock)pb, (RenderingHints)this.getRenderingHints());
        return this;
    }

    public ImageWorker piecewise(PiecewiseTransform1D transform, Integer bandIndex) {
        ParameterBlock pb = new ParameterBlock();
        pb.setSource(this.image, 0);
        pb.set(transform, 0);
        pb.set(bandIndex, 1);
        pb.set(this.roi, 2);
        pb.set(this.nodata, 3);
        if (this.isNoDataNeeded() && transform.hasGaps()) {
            this.setNoData(RangeFactory.create((double)transform.getDefaultValue(), (double)transform.getDefaultValue()));
        }
        this.image = JAI.create((String)"GenericPiecewise", (ParameterBlock)pb, (RenderingHints)this.getRenderingHints());
        return this;
    }

    public ImageWorker rescale(double[] scale, double[] offset) {
        ParameterBlock pb = new ParameterBlock();
        pb.setSource(this.image, 0);
        pb.set(scale, 0);
        pb.set(offset, 1);
        pb.set(this.roi, 2);
        pb.set(this.nodata, 3);
        double destNodata = Double.NaN;
        if (this.isNoDataNeeded()) {
            if (this.background != null && this.background.length > 0) {
                destNodata = this.background[0];
            } else if (this.nodata != null) {
                destNodata = this.nodata.getMin().doubleValue();
            }
        }
        if (!Double.isNaN(destNodata)) {
            pb.set(destNodata, 5);
        }
        this.image = JAI.create((String)"Rescale", (ParameterBlock)pb, (RenderingHints)this.getRenderingHints());
        if (!Double.isNaN(destNodata)) {
            this.setNoData(RangeFactory.create((byte)((byte)destNodata), (byte)((byte)destNodata)));
        }
        return this;
    }

    public ImageWorker bandCombine(double[][] coeff) {
        ParameterBlock pb = new ParameterBlock();
        pb.setSource(this.image, 0);
        pb.set(coeff, 0);
        pb.set(this.roi, 1);
        pb.set(this.nodata, 2);
        if (this.isNoDataNeeded() && this.background != null && this.background.length > 0) {
            pb.set(this.background[0], 3);
        }
        this.image = JAI.create((String)"BandCombine", (ParameterBlock)pb, (RenderingHints)this.getRenderingHints());
        return this;
    }

    public ImageWorker rangeLookup(Object rangeLookup) {
        ParameterBlock pb = new ParameterBlock();
        pb.setSource(this.image, 0);
        pb.set(rangeLookup, 0);
        pb.set(this.roi, 2);
        if (this.roi != null && this.background != null && this.background.length > 0) {
            pb.set(this.background[0], 1);
            this.setNoData(RangeFactory.create((double)this.background[0], (double)this.background[0]));
        }
        this.image = JAIExt.isJAIExtOperation((String)"RLookup") ? JAI.create((String)"RLookup", (ParameterBlock)pb, (RenderingHints)this.getRenderingHints()) : JAI.create((String)"RangeLookup", (ParameterBlock)pb, (RenderingHints)this.getRenderingHints());
        return this;
    }

    public ImageWorker prepareForRendering() {
        Object roiCandidate;
        ROI roi = this.getROI();
        if (roi == null && (roiCandidate = this.image.getProperty("roi")) instanceof ROI) {
            roi = (ROI)roiCandidate;
        }
        if (this.nodata == null && roi == null) {
            return this;
        }
        RenderedImage image = this.getRenderedImage();
        ColorModel cm = image.getColorModel();
        double[] bgValues = null;
        PlanarImage[] alphaChannels = null;
        int transparencyType = cm.getTransparency();
        if (cm instanceof IndexColorModel) {
            IndexColorModel icm = (IndexColorModel)cm;
            int bgColorIndex = icm.getTransparentPixel();
            if (bgColorIndex == -1) {
                bgValues = new double[]{0.0, 0.0, 0.0, 0.0};
                if (this.getNoData() != null) {
                    ImageWorker delegate = new ImageWorker(this.getRenderedImage());
                    delegate.setBackground(bgValues);
                    delegate.forceComponentColorModel();
                    this.setImage(delegate.getRenderedImage());
                    this.setNoData(null);
                } else {
                    this.forceComponentColorModel();
                }
                if (!this.getRenderedImage().getColorModel().hasAlpha()) {
                    this.addAlphaChannel();
                }
                image = this.getRenderedImage();
            } else {
                bgValues = new double[]{bgColorIndex};
            }
            if (cm.hasAlpha() && bgColorIndex == -1) {
                this.forceComponentColorModel();
                RenderedImage alpha = new ImageWorker(this.getRenderedImage()).retainLastBand().getRenderedImage();
                alphaChannels = new PlanarImage[]{PlanarImage.wrapRenderedImage((RenderedImage)alpha)};
            }
        } else if (cm instanceof ComponentColorModel) {
            RenderedImage alpha;
            ImageWorker iw;
            ComponentColorModel ccm = (ComponentColorModel)cm;
            boolean hasAlpha = cm.hasAlpha();
            if (ccm.getNumColorComponents() == 1) {
                if (ccm.getTransferType() == 5 || ccm.getTransferType() == 4 || ccm.getTransferType() == 32 || !hasAlpha) {
                    iw = new ImageWorker(image);
                    if (hasAlpha) {
                        alpha = iw.retainLastBand().getRenderedImage();
                        RenderedImage gray = new ImageWorker(image).retainFirstBand().getRenderedImage();
                        image = new ImageWorker(gray).bandMerge(3).addBand(alpha, false).forceComponentColorModel().forceColorSpaceRGB().getRenderedImage();
                    } else {
                        image = iw.bandMerge(3).forceComponentColorModel().forceColorSpaceRGB().getRenderedImage();
                    }
                } else {
                    iw = new ImageWorker(image);
                    alpha = iw.retainLastBand().getRenderedImage();
                    alphaChannels = new PlanarImage[]{PlanarImage.wrapRenderedImage((RenderedImage)alpha)};
                    bgValues = new double[]{0.0, 0.0, 0.0, 0.0};
                }
                cm = image.getColorModel();
                ccm = (ComponentColorModel)cm;
                hasAlpha = cm.hasAlpha();
            }
            if (bgValues == null) {
                if (hasAlpha) {
                    iw = new ImageWorker(image);
                    alpha = iw.retainLastBand().getRenderedImage();
                    alphaChannels = new PlanarImage[]{PlanarImage.wrapRenderedImage((RenderedImage)alpha)};
                    bgValues = new double[]{0.0, 0.0, 0.0, 0.0};
                } else {
                    if (this.nodata != null) {
                        RenderedImage alpha2;
                        RangeLookupTable.Builder builder = new RangeLookupTable.Builder();
                        if (this.nodata.getMin().doubleValue() != Double.NEGATIVE_INFINITY) {
                            builder.add(RangeFactory.create((double)Double.NEGATIVE_INFINITY, (boolean)true, (double)this.nodata.getMin().doubleValue(), (!this.nodata.isMinIncluded() ? 1 : 0) != 0), (Number)-1);
                        }
                        builder.add(this.nodata, (Number)0);
                        if (this.nodata.getMax().doubleValue() != Double.POSITIVE_INFINITY) {
                            builder.add(RangeFactory.create((double)this.nodata.getMax().doubleValue(), (!this.nodata.isMaxIncluded() ? 1 : 0) != 0, (double)Double.POSITIVE_INFINITY, (boolean)false), (Number)-1);
                        }
                        RangeLookupTable lookupTable = builder.build();
                        int numBands = this.image.getSampleModel().getNumBands();
                        if (numBands == 1) {
                            alpha2 = new ImageWorker(this.image).rangeLookup(lookupTable).getRenderedImage();
                        } else {
                            double weight = 1.0 / (double)numBands;
                            double[][] matrix = new double[1][numBands + 1];
                            for (int i = 0; i < numBands; ++i) {
                                matrix[0][i] = weight;
                            }
                            alpha2 = new ImageWorker(this.image).setROI(roi).rangeLookup(lookupTable).bandCombine(matrix).lookup(LookupTableFactory.create((byte[])ALPHA_LUT)).getRenderedImage();
                        }
                        image = new ImageWorker(image).addBand(alpha2, false, true, null).getRenderedImage();
                    } else {
                        image = new ImageWorker(image).addAlphaChannel().getRenderedImage();
                    }
                    bgValues = new double[]{0.0, 0.0, 0.0, 0.0};
                }
            }
        }
        ImageWorker iw = new ImageWorker(image);
        ROI[] rois = new ROI[]{roi};
        double[][] thresholds = new double[][]{{ColorUtilities.getThreshold(image.getSampleModel().getDataType())}};
        iw.setBackground(bgValues);
        iw.mosaic(new RenderedImage[]{image}, alphaChannels != null && transparencyType == 3 ? MosaicDescriptor.MOSAIC_TYPE_BLEND : MosaicDescriptor.MOSAIC_TYPE_OVERLAY, alphaChannels, rois, thresholds, null);
        this.image = iw.getRenderedImage();
        return this;
    }

    private ImageWorker addAlphaChannel() {
        ImageLayout tempLayout = new ImageLayout(this.image);
        tempLayout.unsetValid(512).unsetValid(256);
        RenderedOp alpha = ConstantDescriptor.create((Float)Float.valueOf(this.image.getWidth()), (Float)Float.valueOf(this.image.getHeight()), (Number[])new Byte[]{(byte)-1}, (RenderingHints)new RenderingHints(JAI.KEY_IMAGE_LAYOUT, tempLayout));
        this.addBand((RenderedImage)alpha, false, true, null);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ImageWorker write(Object output, Iterator<? extends ImageWriter> encoders) throws IOException {
        if (encoders != null) {
            while (encoders.hasNext()) {
                Class[] outputTypes;
                ImageWriter writer = encoders.next();
                ImageWriterSpi spi = writer.getOriginatingProvider();
                if (spi == null) {
                    outputTypes = new Class[]{ImageOutputStream.class};
                } else {
                    String[] formats = spi.getFormatNames();
                    if (ImageWorker.containsFormatName(formats, "gif")) {
                        this.forceIndexColorModelForGIF(true);
                    } else {
                        this.tile();
                    }
                    if (!spi.canEncodeImage(this.image)) continue;
                    outputTypes = spi.getOutputTypes();
                }
                ImageInputStream stream = null;
                try {
                    if (ImageWorker.acceptInputType(outputTypes, output.getClass())) {
                        writer.setOutput(output);
                        stream = null;
                    } else {
                        if (!ImageWorker.acceptInputType(outputTypes, ImageOutputStream.class)) continue;
                        stream = ImageIOExt.createImageOutputStream(this.image, output);
                        writer.setOutput(stream);
                    }
                    writer.write(this.image);
                    writer.dispose();
                }
                finally {
                    if (stream == null) continue;
                    stream.close();
                    continue;
                }
                return this;
            }
        }
        throw new IIOException(Errors.format((int)135));
    }

    private static boolean acceptInputType(Class<?>[] types, Class<?> searchFor) {
        int i = types.length;
        while (--i >= 0) {
            if (!searchFor.isAssignableFrom(types[i])) continue;
            return true;
        }
        return false;
    }

    private static boolean containsFormatName(String[] formats, String searchFor) {
        int i = formats.length;
        while (--i >= 0) {
            if (!searchFor.equalsIgnoreCase(formats[i])) continue;
            return true;
        }
        return false;
    }

    public final ImageWorker show() throws HeadlessException {
        Class<?> c;
        try {
            c = Class.forName("org.geotools.gui.swing.image.OperationTreeBrowser");
        }
        catch (ClassNotFoundException cause) {
            HeadlessException e = new HeadlessException("The \"gt2-widgets-swing.jar\" file is required.");
            e.initCause(cause);
            throw e;
        }
        try {
            c.getMethod("show", RenderedImage.class).invoke(null, this.image);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            throw new AssertionError((Object)e);
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
        return this;
    }

    public final void dispose() {
        if (this.commonHints != null) {
            this.commonHints.clear();
        }
        this.commonHints = null;
        this.roi = null;
        if (this.image instanceof PlanarImage) {
            ImageUtilities.disposePlanarImageChain(PlanarImage.wrapRenderedImage((RenderedImage)this.image));
        } else if (this.image instanceof BufferedImage) {
            ((BufferedImage)this.image).flush();
            this.image = null;
        }
    }

    public static void main(String[] args) {
        Arguments arguments = new Arguments(args);
        String operation = arguments.getOptionalString("-operation");
        args = arguments.getRemainingArguments(1);
        if (args.length != 0) {
            try {
                ImageWorker worker = new ImageWorker(new File(args[0]));
                worker.setRenderingHint(JAI.KEY_TILE_CACHE, JAI.getDefaultInstance().getTileCache());
                if (operation != null) {
                    worker.getClass().getMethod(operation, null).invoke((Object)worker, (Object[])null);
                }
                worker.show();
            }
            catch (FileNotFoundException | NoSuchMethodException e) {
                arguments.printSummary(e);
            }
            catch (Exception e) {
                Logger.getGlobal().log(Level.INFO, "", e);
            }
        }
    }

    static {
        ColorSpace cs;
        block18: {
            int i;
            ONE = 1;
            Object data = new byte[1][256];
            for (i = 0; i < 256; ++i) {
                data[0][i] = (byte)(0xFF & i);
            }
            IDENTITY_BYTE = data;
            data = new short[1][65535];
            for (i = 0; i < 65535; ++i) {
                data[0][i] = (short)(0xFFFF & i);
            }
            IDENTITY_SHORT = data;
            ROI_BACKGROUND = new double[]{0.0};
            ROI_THRESHOLDS = new double[][]{{1.0}};
            LOGGER = Logging.getLogger(ImageWorker.class);
            CODEC_LIB_AVAILABLE = PackageUtil.isCodecLibAvailable();
            JAIEXT_ENABLED = Boolean.valueOf(System.getProperty(JAIEXT_ENABLED_KEY, "true"));
            JAIExt.initJAIEXT((boolean)JAIEXT_ENABLED);
            USE_JAI_SCALE2 = Boolean.getBoolean(USE_JAI_SCALE2_KEY) && JAIEXT_ENABLED;
            SCALE_OP_NAME = USE_JAI_SCALE2 ? SCALE2_NAME : SCALE_NAME;
            ImageWriterSpi temp = null;
            try {
                Iterator<ImageWriter> writers = ImageIO.getImageWritersByMIMEType("image/jpeg");
                while (writers.hasNext()) {
                    ImageWriter temp2 = writers.next();
                    if (temp2.getOriginatingProvider().getClass().getName() != "com.sun.imageio.plugins.jpeg.JPEGImageWriterSpi") continue;
                    temp = temp2.getOriginatingProvider();
                    break;
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.FINER, e.getMessage(), e);
                temp = null;
            }
            JDK_JPEG_IMAGE_WRITER_SPI = temp;
            temp = null;
            try {
                temp = ImageWorker.getImageWriterSpi("com.sun.media.imageioimpl.plugins.gif.GIFImageWriterSpi");
            }
            catch (Exception e) {
                LOGGER.log(Level.FINER, e.getMessage(), e);
                temp = null;
            }
            IMAGEIO_GIF_IMAGE_WRITER_SPI = temp;
            temp = null;
            try {
                temp = PackageUtil.isCodecLibAvailable() ? ImageWorker.getImageWriterSpi("com.sun.media.imageioimpl.plugins.jpeg.CLibJPEGImageWriterSpi") : null;
            }
            catch (Exception e) {
                LOGGER.log(Level.FINER, e.getMessage(), e);
                temp = null;
            }
            IMAGEIO_JPEG_IMAGE_WRITER_SPI = temp;
            temp = null;
            try {
                temp = ImageWorker.getImageWriterSpi("it.geosolutions.imageioimpl.plugins.tiff.TIFFImageWriterSpi");
            }
            catch (Exception e) {
                LOGGER.log(Level.FINER, e.getMessage(), e);
                temp = null;
            }
            IMAGEIO_EXT_TIFF_IMAGE_WRITER_SPI = temp;
            temp = null;
            try {
                temp = PackageUtil.isCodecLibAvailable() ? ImageWorker.getImageWriterSpi("com.sun.media.imageioimpl.plugins.png.CLibPNGImageWriterSpi") : null;
            }
            catch (Exception e) {
                LOGGER.log(Level.FINER, e.getMessage(), e);
                temp = null;
            }
            CLIB_PNG_IMAGE_WRITER_SPI = temp;
            WARP_REDUCTION_ENABLED = Boolean.parseBoolean(System.getProperty(WARP_REDUCTION_ENABLED_KEY, "TRUE"));
            cs = null;
            try {
                cs = ColorSpace.getInstance(1002);
            }
            catch (Throwable t) {
                if (!LOGGER.isLoggable(Level.FINE)) break block18;
                LOGGER.log(Level.FINE, t.getLocalizedMessage(), t);
            }
        }
        CS_PYCC = cs;
        ALPHA_LUT = new byte[256];
        for (int i = 1; i < 256; ++i) {
            ImageWorker.ALPHA_LUT[i] = -1;
        }
        TILING_ALLOWED = new Hints.Key(Boolean.class);
        FORCE_MOSAIC_ROI_PROPERTY = new Hints.Key(Boolean.class);
        PRESERVE_CHAINED_AFFINES = new Hints.Key(Boolean.class);
        if (WARP_REDUCTION_ENABLED) {
            GTWarpPropertyGenerator.register(false);
        }
        LOGGER.log(Level.INFO, "Warp/affine reduction enabled: " + WARP_REDUCTION_ENABLED);
        GTAffinePropertyGenerator.register(false);
    }

    private class WarpAffineReducer {
        private boolean reduced;
        private AffineTransform tx;
        private Interpolation interpolation;
        private double[] bgValues;
        private RenderedOp op;

        public WarpAffineReducer(AffineTransform tx, Interpolation interpolation, double[] bgValues, RenderedOp op) {
            this.tx = tx;
            this.interpolation = interpolation;
            this.bgValues = bgValues;
            this.op = op;
        }

        boolean reduced() {
            return this.reduced;
        }

        public double[] getBgValues() {
            return this.bgValues;
        }

        public WarpAffineReducer invoke() throws FactoryException, TransformException {
            MathTransform2D originalTransform = (MathTransform2D)this.op.getProperty("MathTransform");
            ParameterBlock sourceParamBlock = this.op.getParameterBlock();
            MathTransformFactory factory = ReferencingFactoryFinder.getMathTransformFactory(null);
            MathTransform affineMT = factory.createAffineTransform((Matrix)new AffineTransform2D(this.tx));
            MathTransform2D chained = (MathTransform2D)factory.createConcatenatedTransform(affineMT.inverse(), (MathTransform)originalTransform);
            Double tolerance = (Double)ImageWorker.this.getRenderingHint((RenderingHints.Key)Hints.RESAMPLE_TOLERANCE);
            if (tolerance == null) {
                tolerance = (Double)Hints.getSystemDefault((RenderingHints.Key)Hints.RESAMPLE_TOLERANCE);
            }
            if (tolerance == null) {
                tolerance = Hints.DEFAULT_RESAMPLE_TOLERANCE;
            }
            if (this.tx.getScaleX() > 1.0 || this.tx.getScaleY() > 1.0) {
                double factor = Math.max(this.tx.getScaleX(), this.tx.getScaleY());
                tolerance = tolerance / factor;
            }
            WarpBuilder wb = new WarpBuilder(tolerance);
            wb.setMaxPositions(0x400000);
            ParameterBlock pb = new ParameterBlock();
            pb.setSource(this.op, 0);
            pb.set(this.tx, 0);
            pb.set(this.interpolation, 1);
            pb.set(this.bgValues, 2);
            pb.set(ImageWorker.this.roi, 3);
            pb.set(true, 5);
            pb.set(ImageWorker.this.nodata, 6);
            RenderedOp at = JAI.create((String)"Affine", (ParameterBlock)pb, (RenderingHints)ImageWorker.this.getRenderingHints());
            ImageWorker.this.updateNoData(this.bgValues, ImageWorker.this.image);
            Rectangle targetBB = at.getBounds();
            int tileWidth = at.getTileWidth();
            int tileHeight = at.getTileHeight();
            ImageUtilities.disposeSinglePlanarImage((PlanarImage)at);
            Rectangle sourceBB = (Rectangle)this.op.getProperty("SourceBoundingBox");
            Rectangle mappingBB = this.op.getProperty("ROI") instanceof ROI ? sourceBB.union(targetBB) : targetBB;
            Warp warp = wb.buildWarp(chained, mappingBB);
            Warp sourceWarp = (Warp)sourceParamBlock.getObjectParameter(0);
            if (warp instanceof WarpGrid || warp instanceof WarpAffine || !(sourceWarp instanceof WarpGrid) && !(sourceWarp instanceof WarpAffine) || this.tx.getScaleX() > 1.0 || this.tx.getScaleY() > 1.0) {
                AffineTransform inv;
                MathTransform2D inverse;
                ROI reprojectedROI;
                ROI newROI;
                boolean hasSameNodata;
                PlanarImage sourceImage = this.op.getSourceImage(0);
                ParameterBlock paramBlk = new ParameterBlock().addSource(sourceImage);
                Object property = sourceImage.getProperty("ROI");
                boolean canProcessROI = true;
                Range oldNoData = (Range)(sourceParamBlock.getNumParameters() > 3 ? sourceParamBlock.getObjectParameter(4) : null);
                boolean bl = hasSameNodata = oldNoData == null && ImageWorker.this.nodata == null || oldNoData != null && ImageWorker.this.nodata != null && oldNoData.equals((Object)ImageWorker.this.nodata);
                if (property == null || property.equals(Image.UndefinedProperty) || !(property instanceof ROI)) {
                    paramBlk.add(warp).add(this.interpolation).add(this.bgValues);
                    if (oldNoData != null) {
                        paramBlk.set(oldNoData, 4);
                    }
                    newROI = null;
                    if (ImageWorker.this.roi != null) {
                        reprojectedROI = ImageWorker.this.roi;
                        try {
                            inverse = originalTransform.inverse();
                            if (inverse instanceof AffineTransform) {
                                inv = (AffineTransform)inverse;
                                newROI = reprojectedROI.transform(inv);
                            }
                        }
                        catch (Exception e) {
                            if (LOGGER.isLoggable(Level.WARNING)) {
                                LOGGER.log(Level.WARNING, "Unable to compute the inverse of the new ROI provided", e);
                            }
                            canProcessROI = false;
                        }
                    }
                    if (newROI != null) {
                        ImageWorker.this.setROI(newROI);
                        paramBlk.set(newROI, 3);
                    }
                } else {
                    newROI = null;
                    if (ImageWorker.this.roi != null) {
                        reprojectedROI = ImageWorker.this.roi;
                        try {
                            inverse = originalTransform.inverse();
                            if (inverse instanceof AffineTransform) {
                                inv = (AffineTransform)inverse;
                                reprojectedROI = reprojectedROI.transform(inv);
                                newROI = reprojectedROI.intersect((ROI)property);
                            }
                        }
                        catch (Exception e) {
                            if (LOGGER.isLoggable(Level.WARNING)) {
                                LOGGER.log(Level.WARNING, "Unable to compute the inverse of the new ROI provided", e);
                            }
                            canProcessROI = false;
                        }
                    } else {
                        newROI = (ROI)property;
                    }
                    ImageWorker.this.setROI(newROI);
                    paramBlk.add(warp).add(this.interpolation).add(newROI);
                    if (oldNoData != null) {
                        paramBlk.set(oldNoData, 4);
                    }
                }
                if (this.bgValues == null && sourceParamBlock.getNumParameters() > 2) {
                    this.bgValues = (double[])sourceParamBlock.getObjectParameter(2);
                }
                if (this.bgValues != null) {
                    paramBlk.set(this.bgValues, 2);
                }
                if (canProcessROI && hasSameNodata) {
                    Hints localHints = new Hints(ImageWorker.this.getRenderingHints());
                    localHints.remove((Object)JAI.KEY_IMAGE_LAYOUT);
                    ImageLayout il = new ImageLayout();
                    il.setMinX(targetBB.x);
                    il.setMinY(targetBB.y);
                    il.setWidth(targetBB.width);
                    il.setHeight(targetBB.height);
                    il.setTileHeight(tileWidth);
                    il.setTileWidth(tileHeight);
                    il.setTileGridXOffset(0);
                    il.setTileGridYOffset(0);
                    localHints.put((Object)JAI.KEY_IMAGE_LAYOUT, (Object)il);
                    RenderedOp result = JAI.create((String)"Warp", (ParameterBlock)paramBlk, (RenderingHints)localHints);
                    result.setProperty("MathTransform", (Object)chained);
                    ImageWorker.this.image = result;
                    Object prop = result.getProperty("roi");
                    if (prop != null && prop instanceof ROI) {
                        ImageWorker.this.setROI((ROI)prop);
                    } else {
                        ImageWorker.this.setROI(null);
                    }
                    this.reduced = true;
                    return this;
                }
            }
            this.reduced = false;
            return this;
        }
    }

    public static final class PNGImageWriteParam
    extends ImageWriteParam {
        public PNGImageWriteParam() {
            this.canWriteProgressive = true;
            this.canWriteCompressed = true;
            this.locale = Locale.getDefault();
        }
    }
}

