/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.grid;

import java.awt.Color;
import java.awt.RenderingHints;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import javax.measure.Unit;
import org.geotools.coverage.Category;
import org.geotools.coverage.GridSampleDimension;
import org.geotools.coverage.TypeMap;
import org.geotools.metadata.i18n.Errors;
import org.geotools.util.AbstractInternationalString;
import org.geotools.util.NumberRange;
import org.geotools.util.SimpleInternationalString;
import org.geotools.util.factory.Hints;
import org.opengis.coverage.ColorInterpretation;
import org.opengis.coverage.SampleDimensionType;

final class RenderedSampleDimension
extends GridSampleDimension {
    private static final long serialVersionUID = 946331925096804779L;
    private final int band;
    private final int numBands;
    private final SampleDimensionType type;

    private RenderedSampleDimension(GridSampleDimension band, RenderedImage image, int bandNumber) {
        super(band);
        SampleModel model = image.getSampleModel();
        this.band = bandNumber;
        this.numBands = model.getNumBands();
        this.type = TypeMap.getSampleDimensionType(model, bandNumber);
    }

    static boolean create(CharSequence name, RenderedImage image, GridSampleDimension[] src, GridSampleDimension[] dst) {
        int numBands = image.getSampleModel().getNumBands();
        if (src != null && src.length != numBands) {
            throw new IllegalArgumentException(Errors.format((int)148, (Object)numBands, (Object)src.length, (Object)"SampleDimension"));
        }
        if (dst.length != numBands) {
            throw new IllegalArgumentException(Errors.format((int)148, (Object)numBands, (Object)dst.length, (Object)"SampleDimension"));
        }
        int count = 0;
        GridSampleDimension[] defaultSD = null;
        for (int i = 0; i < numBands; ++i) {
            GridSampleDimension sd;
            GridSampleDimension gridSampleDimension = sd = src != null ? src[i] : null;
            if (sd == null) {
                if (defaultSD == null) {
                    defaultSD = new GridSampleDimension[numBands];
                    RenderedSampleDimension.create(name, image.getSampleModel(), null, null, null, null, defaultSD, null);
                }
                sd = defaultSD[i];
            }
            dst[i] = sd = new RenderedSampleDimension(sd, image, i);
            ++count;
        }
        if (count == numBands) {
            return true;
        }
        throw new IllegalArgumentException(Errors.format((int)102));
    }

    static GridSampleDimension[] create(CharSequence name, Raster raster, double[] min, double[] max, Unit<?> units, Color[][] colors, RenderingHints hints) {
        GridSampleDimension[] dst = new GridSampleDimension[raster.getNumBands()];
        RenderedSampleDimension.create(name, raster.getSampleModel(), min, max, units, colors, dst, hints);
        return dst;
    }

    private static void create(CharSequence name, SampleModel model, double[] min, double[] max, Unit<?> units, Color[][] colors, GridSampleDimension[] dst, RenderingHints hints) {
        int numBands = dst.length;
        if (min != null && min.length != numBands) {
            throw new IllegalArgumentException(Errors.format((int)148, (Object)numBands, (Object)min.length, (Object)"min[i]"));
        }
        if (max != null && max.length != numBands) {
            throw new IllegalArgumentException(Errors.format((int)148, (Object)numBands, (Object)max.length, (Object)"max[i]"));
        }
        if (colors != null && colors.length != numBands) {
            throw new IllegalArgumentException(Errors.format((int)148, (Object)numBands, (Object)colors.length, (Object)"colors[i]"));
        }
        SampleDimensionType sourceType = TypeMap.getSampleDimensionType(model, 0);
        SampleDimensionType targetType = null;
        if (hints != null) {
            targetType = (SampleDimensionType)hints.get(Hints.SAMPLE_DIMENSION_TYPE);
        }
        if (targetType == null) {
            targetType = sourceType;
        }
        NumberRange<? extends Number> targetRange = TypeMap.getRange(targetType);
        Category[] categories = new Category[1];
        AbstractInternationalString n = SimpleInternationalString.wrap((CharSequence)name);
        for (int b = 0; b < numBands; ++b) {
            Color[] c = colors != null ? colors[b] : null;
            categories[0] = new Category((CharSequence)n, c, targetRange, true);
            dst[b] = new GridSampleDimension(name, categories, units);
        }
    }

    @Override
    public SampleDimensionType getSampleDimensionType() {
        return this.type;
    }

    @Override
    public ColorInterpretation getColorInterpretation() {
        return TypeMap.getColorInterpretation(this.getColorModel(), this.band);
    }

    @Override
    public ColorModel getColorModel() {
        return this.getColorModel(this.band, this.numBands);
    }
}

