/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wcs2_0.response;

import java.io.IOException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.opengis.wcs20.DimensionSliceType;
import net.opengis.wcs20.DimensionSubsetType;
import net.opengis.wcs20.DimensionTrimType;
import net.opengis.wcs20.GetCoverageType;
import org.eclipse.emf.common.util.EList;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.DimensionInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.util.ReaderDimensionsAccessor;
import org.geoserver.util.NearestMatchFinder;
import org.geoserver.wcs2_0.GetCoverage;
import org.geoserver.wcs2_0.GridCoverageRequest;
import org.geoserver.wcs2_0.WCSEnvelope;
import org.geoserver.wcs2_0.exception.WCS20Exception;
import org.geoserver.wcs2_0.response.DimensionBean;
import org.geoserver.wcs2_0.response.WCSDefaultValuesHelper;
import org.geoserver.wcs2_0.response.WCSDimensionsHelper;
import org.geoserver.wcs2_0.response.WCSDimensionsValueParser;
import org.geoserver.wcs2_0.util.EnvelopeAxesLabelsMapper;
import org.geotools.coverage.grid.io.DimensionDescriptor;
import org.geotools.coverage.grid.io.GranuleSource;
import org.geotools.coverage.grid.io.GridCoverage2DReader;
import org.geotools.coverage.grid.io.StructuredGridCoverage2DReader;
import org.geotools.data.Query;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.referencing.operation.transform.AffineTransform2D;
import org.geotools.renderer.crs.ProjectionHandler;
import org.geotools.renderer.crs.ProjectionHandlerFinder;
import org.geotools.util.DateRange;
import org.geotools.util.NumberRange;
import org.geotools.util.Utilities;
import org.geotools.util.logging.Logging;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Polygon;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.PropertyIsBetween;
import org.opengis.filter.PropertyIsGreaterThanOrEqualTo;
import org.opengis.filter.PropertyIsLessThanOrEqualTo;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.sort.SortBy;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;
import org.vfny.geoserver.util.WCSUtils;

public class WCSDimensionsSubsetHelper {
    public static final Set<String> TIME_NAMES = new HashSet<String>();
    public static final Set<String> ELEVATION_NAMES = new HashSet<String>();
    private static final Logger LOGGER = Logging.getLogger(WCSDimensionsHelper.class);
    private GetCoverageType request;
    private Map<String, DimensionInfo> enabledDimensions;
    private ReaderDimensionsAccessor accessor;
    private DimensionInfo timeDimension;
    private DimensionInfo elevationDimension;
    private CoordinateReferenceSystem subsettingCRS;
    private WCSEnvelope requestedEnvelope;
    private GridCoverage2DReader reader;
    private EnvelopeAxesLabelsMapper envelopeDimensionsMapper;
    private CoverageInfo coverageInfo;
    private GridCoverageRequest gridCoverageRequest;
    private FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2();
    private static final WCSDimensionsValueParser PARSER = new WCSDimensionsValueParser();

    public void setGridCoverageRequest(GridCoverageRequest gridCoverageRequest) {
        this.gridCoverageRequest = gridCoverageRequest;
    }

    public GridCoverageRequest getGridCoverageRequest() {
        return this.gridCoverageRequest;
    }

    public CoverageInfo getCoverageInfo() {
        return this.coverageInfo;
    }

    public void setCoverageInfo(CoverageInfo coverageInfo) {
        this.coverageInfo = coverageInfo;
    }

    public WCSDimensionsSubsetHelper(GridCoverage2DReader reader, GetCoverageType request, CoverageInfo ci, CoordinateReferenceSystem subsettingCRS, EnvelopeAxesLabelsMapper envelopeDimensionsMapper) throws IOException {
        this.request = request;
        this.coverageInfo = ci;
        this.enabledDimensions = WCSDimensionsHelper.getDimensionsFromMetadata(ci.getMetadata());
        this.subsettingCRS = subsettingCRS;
        this.reader = reader;
        this.envelopeDimensionsMapper = envelopeDimensionsMapper;
        this.timeDimension = this.enabledDimensions.get("time");
        this.elevationDimension = this.enabledDimensions.get("elevation");
        if (this.timeDimension != null || this.elevationDimension != null || !this.enabledDimensions.isEmpty()) {
            this.accessor = new ReaderDimensionsAccessor(reader);
        }
    }

    public static String getDimensionName(DimensionSubsetType dim) {
        String dimension = dim.getDimension();
        if (dimension.startsWith("http://www.opengis.net/def/axis/OGC/0/")) {
            dimension = dimension.substring("http://www.opengis.net/def/axis/OGC/0/".length());
        } else if (dimension.startsWith("http://opengis.net/def/axis/OGC/0/")) {
            dimension = dimension.substring("http://opengis.net/def/axis/OGC/0/".length());
        } else if (dimension.startsWith("http://opengis.net/def/crs/ISO/2004/")) {
            dimension = dimension.substring("http://opengis.net/def/crs/ISO/2004/".length());
        }
        if (dimension == null || dimension.length() <= 0) {
            throw new WCS20Exception("Empty/invalid axis label provided: " + dim.getDimension(), WCS20Exception.WCS20ExceptionCode.InvalidAxisLabel, "subset");
        }
        return dimension;
    }

    private WCSEnvelope extractSubsettingEnvelope() {
        EList requestedDimensions;
        CoordinateReferenceSystem sourceCRS = this.coverageInfo.getCRS();
        ReferencedEnvelope envelope = WCSUtils.fitEnvelope((CoverageInfo)this.coverageInfo, (GridCoverage2DReader)this.reader);
        WCSEnvelope sourceEnvelopeInSubsettingCRS = new WCSEnvelope((org.opengis.geometry.Envelope)envelope);
        if (this.subsettingCRS != null && !CRS.equalsIgnoreMetadata((Object)this.subsettingCRS, (Object)sourceCRS)) {
            try {
                sourceEnvelopeInSubsettingCRS = new WCSEnvelope((org.opengis.geometry.Envelope)CRS.transform((org.opengis.geometry.Envelope)this.coverageInfo.getNativeBoundingBox(), (CoordinateReferenceSystem)this.subsettingCRS));
            }
            catch (Exception e) {
                try {
                    ProjectionHandler handler = ProjectionHandlerFinder.getHandler((ReferencedEnvelope)new ReferencedEnvelope(0.0, 1.0, 0.0, 1.0, this.subsettingCRS), (CoordinateReferenceSystem)sourceCRS, (boolean)true);
                    if (handler == null) {
                        throw new WCS20Exception("Unable to initialize subsetting envelope", WCS20Exception.WCS20ExceptionCode.SubsettingCrsNotSupported, this.subsettingCRS.toWKT(), e);
                    }
                    ReferencedEnvelope validArea = handler.getValidAreaBounds();
                    ReferencedEnvelope intersection = validArea.intersection((Envelope)envelope);
                    ReferencedEnvelope re = new ReferencedEnvelope((Envelope)intersection, sourceCRS);
                    sourceEnvelopeInSubsettingCRS = new WCSEnvelope((org.opengis.geometry.Envelope)re.transform(this.subsettingCRS, true));
                }
                catch (Exception e2) {
                    throw new WCS20Exception("Unable to initialize subsetting envelope", WCS20Exception.WCS20ExceptionCode.SubsettingCrsNotSupported, this.subsettingCRS.toWKT(), e2);
                }
            }
        }
        if ((requestedDimensions = this.request.getDimensionSubset()) == null || requestedDimensions.size() <= 0) {
            return sourceEnvelopeInSubsettingCRS;
        }
        int maxDimensions = 2 + this.enabledDimensions.size();
        if (requestedDimensions.size() > maxDimensions) {
            throw new WCS20Exception("Invalid number of dimensions", WCS20Exception.WCS20ExceptionCode.InvalidSubsetting, Integer.toString(requestedDimensions.size()));
        }
        List<String> axesNames = this.envelopeDimensionsMapper.getAxesNames((org.opengis.geometry.Envelope)sourceEnvelopeInSubsettingCRS, true);
        ArrayList<String> foundDimensions = new ArrayList<String>();
        WCSEnvelope subsettingEnvelope = new WCSEnvelope((org.opengis.geometry.Envelope)sourceEnvelopeInSubsettingCRS);
        Set<String> dimensionKeys = this.enabledDimensions.keySet();
        for (DimensionSubsetType dim : requestedDimensions) {
            String dimension = WCSDimensionsSubsetHelper.getDimensionName(dim);
            if (TIME_NAMES.contains(dimension.toLowerCase())) {
                if (dimensionKeys.contains("time")) continue;
                throw new WCS20Exception("Invalid axis label provided: " + dimension, WCS20Exception.WCS20ExceptionCode.InvalidAxisLabel, null);
            }
            if (ELEVATION_NAMES.contains(dimension.toLowerCase())) {
                if (dimensionKeys.contains("elevation")) continue;
                throw new WCS20Exception("Invalid axis label provided: " + dimension, WCS20Exception.WCS20ExceptionCode.InvalidAxisLabel, null);
            }
            boolean isCustomDimension = false;
            for (String dimensionKey : dimensionKeys) {
                if (!dimensionKey.equalsIgnoreCase(dimension)) continue;
                isCustomDimension = true;
                break;
            }
            if (isCustomDimension) continue;
            if (!axesNames.contains(dimension)) {
                throw new WCS20Exception("Invalid axis label provided: " + dimension, WCS20Exception.WCS20ExceptionCode.InvalidAxisLabel, dimension == null ? "Null" : dimension);
            }
            if (foundDimensions.contains(dimension)) {
                throw new WCS20Exception("Axis label already used during subsetting", WCS20Exception.WCS20ExceptionCode.InvalidAxisLabel, dimension);
            }
            foundDimensions.add(dimension);
            if (dim instanceof DimensionTrimType) {
                DimensionTrimType trim = (DimensionTrimType)dim;
                double low = Double.parseDouble(trim.getTrimLow());
                double high = Double.parseDouble(trim.getTrimHigh());
                int axisIndex = this.envelopeDimensionsMapper.getAxisIndex((org.opengis.geometry.Envelope)sourceEnvelopeInSubsettingCRS, dimension);
                if (axisIndex < 0) {
                    throw new WCS20Exception("Invalid axis provided", WCS20Exception.WCS20ExceptionCode.InvalidAxisLabel, dimension);
                }
                if (low > high && !subsettingEnvelope.isLongitude(axisIndex)) {
                    throw new WCS20Exception("Low greater than High", WCS20Exception.WCS20ExceptionCode.InvalidSubsetting, trim.getTrimLow());
                }
                subsettingEnvelope.setRange(axisIndex, low, high);
                continue;
            }
            if (dim instanceof DimensionSliceType) {
                DimensionSliceType slicing = (DimensionSliceType)dim;
                String slicePointS = slicing.getSlicePoint();
                double slicePoint = Double.parseDouble(slicePointS);
                int axisIndex = this.envelopeDimensionsMapper.getAxisIndex((org.opengis.geometry.Envelope)sourceEnvelopeInSubsettingCRS, dimension);
                if (axisIndex < 0) {
                    throw new WCS20Exception("Invalid axis provided", WCS20Exception.WCS20ExceptionCode.InvalidAxisLabel, dimension);
                }
                AffineTransform2D affineTransform = (AffineTransform2D)WCSUtils.fitGridGeometry((CoverageInfo)this.coverageInfo, (GridCoverage2DReader)this.reader).getGridToCRS(PixelInCell.CELL_CENTER);
                double scale = axisIndex == 0 ? affineTransform.getScaleX() : -affineTransform.getScaleY();
                double min = slicePoint - scale * 0.5;
                double max = min + scale;
                subsettingEnvelope.setRange(axisIndex, min, max);
                if (!(sourceEnvelopeInSubsettingCRS.getMinimum(axisIndex) > slicePoint) && !(slicePoint > sourceEnvelopeInSubsettingCRS.getMaximum(axisIndex))) continue;
                throw new WCS20Exception("SlicePoint outside coverage envelope", WCS20Exception.WCS20ExceptionCode.InvalidSubsetting, slicePointS);
            }
            throw new WCS20Exception("Invalid element found while attempting to parse dimension subsetting request", WCS20Exception.WCS20ExceptionCode.InvalidSubsetting, dim.getClass().toString());
        }
        this.requestedEnvelope = new WCSEnvelope((org.opengis.geometry.Envelope)subsettingEnvelope);
        subsettingEnvelope.intersect(new GeneralEnvelope((org.opengis.geometry.Envelope)sourceEnvelopeInSubsettingCRS));
        if (subsettingEnvelope.isEmpty()) {
            throw new WCS20Exception("Empty intersection after subsetting", WCS20Exception.WCS20ExceptionCode.InvalidSubsetting, "");
        }
        return subsettingEnvelope;
    }

    private DateRange extractTemporalSubset() throws IOException {
        DateRange timeSubset = null;
        if (this.timeDimension != null) {
            List<Object> dates;
            for (DimensionSubsetType dim : this.request.getDimensionSubset()) {
                String dimension = WCSDimensionsSubsetHelper.getDimensionName(dim);
                if (!TIME_NAMES.contains(dimension.toLowerCase())) continue;
                if (timeSubset != null) {
                    throw new WCS20Exception("Time dimension trimming/slicing specified twice in the request", WCS20Exception.WCS20ExceptionCode.InvalidSubsetting, "subset");
                }
                timeSubset = this.parseTimeSubset(dim);
            }
            if (!(this.reader instanceof StructuredGridCoverage2DReader) && timeSubset != null && !timeSubset.getMinValue().equals(timeSubset.getMaxValue())) {
                throw new WCS20Exception("Trimming on time is not supported at the moment on not StructuredGridCoverage2DReaders, only slicing is");
            }
            if (timeSubset != null && timeSubset.getMinValue().equals(timeSubset.getMaxValue()) && this.timeDimension.isRawNearestMatchEnabled() && (dates = this.getNearestTimeMatch((ResourceInfo)this.coverageInfo, "time", Collections.singletonList(timeSubset))) != null && !dates.isEmpty()) {
                Object result = dates.get(0);
                timeSubset = result instanceof DateRange ? (DateRange)result : new DateRange((Date)result, (Date)result);
            }
        }
        return timeSubset;
    }

    private DateRange parseTimeSubset(DimensionSubsetType dim) {
        try {
            if (dim instanceof DimensionTrimType) {
                Date high;
                DimensionTrimType trim = (DimensionTrimType)dim;
                Date low = PARSER.parseDateTime(trim.getTrimLow());
                if (low.compareTo(high = PARSER.parseDateTime(trim.getTrimHigh())) > 0) {
                    throw new WCS20Exception("Low greater than High: " + trim.getTrimLow() + ", " + trim.getTrimHigh(), WCS20Exception.WCS20ExceptionCode.InvalidSubsetting, "subset");
                }
                return new DateRange(low, high);
            }
            if (dim instanceof DimensionSliceType) {
                DimensionSliceType slicing = (DimensionSliceType)dim;
                String slicePointS = slicing.getSlicePoint();
                Date slicePoint = PARSER.parseDateTime(slicePointS);
                return new DateRange(slicePoint, slicePoint);
            }
            throw new WCS20Exception("Invalid element found while attempting to parse dimension subsetting request: " + dim.getClass().toString(), WCS20Exception.WCS20ExceptionCode.InvalidSubsetting, "subset");
        }
        catch (IllegalArgumentException e) {
            throw new WCS20Exception("Invalid time subset", WCS20Exception.WCS20ExceptionCode.InvalidEncodingSyntax, "subset", e);
        }
    }

    private List<Object> getNearestTimeMatch(ResourceInfo coverage, String dimensionName, List<Object> queryRanges) throws IOException {
        DimensionInfo dimension = (DimensionInfo)coverage.getMetadata().get(dimensionName, DimensionInfo.class);
        NearestMatchFinder finder = NearestMatchFinder.get((ResourceInfo)coverage, (DimensionInfo)dimension, (String)"time");
        if (finder != null) {
            return finder.getMatches(coverage, dimensionName, queryRanges, -1);
        }
        return Collections.emptyList();
    }

    public WCSEnvelope getRequestedEnvelope() {
        return this.requestedEnvelope;
    }

    private boolean domainContainsPoint(Object slicePoint, TreeSet<Object> domain) {
        block9: {
            block8: {
                if (!(slicePoint instanceof Date)) break block8;
                Date sliceDate = (Date)slicePoint;
                for (Object curr : domain) {
                    if (curr instanceof Date) {
                        Date date = (Date)curr;
                        int result = date.compareTo(sliceDate);
                        if (result > 0) {
                            return false;
                        }
                        if (result != 0) continue;
                        return true;
                    }
                    if (!(curr instanceof DateRange)) continue;
                    DateRange range = (DateRange)curr;
                    if (range.contains((Comparable)sliceDate)) {
                        return true;
                    }
                    if (range.getMaxValue().compareTo(sliceDate) >= 0) continue;
                    return false;
                }
                break block9;
            }
            if (!(slicePoint instanceof Number)) break block9;
            Number sliceNumber = (Number)slicePoint;
            for (Object curr : domain) {
                if (curr instanceof Number) {
                    Double num = (Double)curr;
                    int result = num.compareTo((Double)sliceNumber);
                    if (result > 0) {
                        return false;
                    }
                    if (result != 0) continue;
                    return true;
                }
                if (!(curr instanceof NumberRange)) continue;
                NumberRange range = (NumberRange)curr;
                if (range.contains(sliceNumber)) {
                    return true;
                }
                if (this.compareNumbers(range.getMaxValue(), sliceNumber) >= 0) continue;
                return false;
            }
        }
        return false;
    }

    private int compareNumbers(Comparable maxValue, Number number) {
        return maxValue.compareTo(number);
    }

    private NumberRange extractElevationSubset() throws IOException {
        NumberRange elevationSubset = null;
        if (this.elevationDimension != null) {
            for (DimensionSubsetType dim : this.request.getDimensionSubset()) {
                String dimension = WCSDimensionsSubsetHelper.getDimensionName(dim);
                if (!ELEVATION_NAMES.contains(dimension.toLowerCase())) continue;
                if (elevationSubset != null) {
                    throw new WCS20Exception("Elevation dimension trimming/slicing specified twice in the request", WCS20Exception.WCS20ExceptionCode.InvalidSubsetting, "subset");
                }
                if (dim instanceof DimensionTrimType) {
                    DimensionTrimType trim = (DimensionTrimType)dim;
                    Double low = PARSER.parseDouble(trim.getTrimLow());
                    Double high = PARSER.parseDouble(trim.getTrimHigh());
                    if (low > high) {
                        throw new WCS20Exception("Low greater than High: " + trim.getTrimLow() + ", " + trim.getTrimHigh(), WCS20Exception.WCS20ExceptionCode.InvalidSubsetting, "subset");
                    }
                    elevationSubset = new NumberRange(Double.class, (Number)low, (Number)high);
                    continue;
                }
                if (dim instanceof DimensionSliceType) {
                    DimensionSliceType slicing = (DimensionSliceType)dim;
                    String slicePointS = slicing.getSlicePoint();
                    Double slicePoint = PARSER.parseDouble(slicePointS);
                    elevationSubset = new NumberRange(Double.class, (Number)slicePoint, (Number)slicePoint);
                    continue;
                }
                throw new WCS20Exception("Invalid element found while attempting to parse dimension subsetting request: " + dim.getClass().toString(), WCS20Exception.WCS20ExceptionCode.InvalidSubsetting, "subset");
            }
            if (!(this.reader instanceof StructuredGridCoverage2DReader) && elevationSubset != null && !elevationSubset.getMinValue().equals(elevationSubset.getMaxValue())) {
                throw new WCS20Exception("Trimming on elevation is not supported at the moment on not StructuredGridCoverage2DReaders, only slicing is");
            }
            if (elevationSubset != null && elevationSubset.getMinValue().equals(elevationSubset.getMaxValue())) {
                this.interpolateElevation(elevationSubset, this.accessor);
            }
        }
        return elevationSubset;
    }

    private NumberRange interpolateElevation(NumberRange elevationSubset, ReaderDimensionsAccessor accessor) throws IOException {
        TreeSet domain = accessor.getElevationDomain();
        Double slicePoint = elevationSubset.getMinimum();
        if (!this.domainContainsPoint(slicePoint, domain)) {
            Double previous = null;
            Double newSlicePoint = null;
            TreeSet<Double> domainDates = PARSER.getDomainNumber(domain);
            for (Double curr : domainDates) {
                if (curr.compareTo(slicePoint) > 0) {
                    if (previous == null) {
                        newSlicePoint = curr;
                        break;
                    }
                    double diffPrevious = slicePoint - previous;
                    double diffCurr = curr - slicePoint;
                    if (diffCurr > diffPrevious) {
                        newSlicePoint = curr;
                        break;
                    }
                    newSlicePoint = previous;
                    break;
                }
                previous = curr;
            }
            if (newSlicePoint == null) {
                newSlicePoint = previous;
            }
            elevationSubset = new NumberRange(Double.class, newSlicePoint, newSlicePoint);
        }
        return elevationSubset;
    }

    private Map<String, List<Object>> extractDimensionsSubset() throws IOException {
        HashMap<String, List<Object>> dimensionSubset = new HashMap<String, List<Object>>();
        if (this.enabledDimensions != null && !this.enabledDimensions.isEmpty()) {
            Set<String> dimensionKeys = this.enabledDimensions.keySet();
            for (DimensionSubsetType dim : this.request.getDimensionSubset()) {
                String dimension = WCSDimensionsSubsetHelper.getDimensionName(dim);
                if (ELEVATION_NAMES.contains(dimension.toLowerCase()) || TIME_NAMES.contains(dimension.toLowerCase()) || !dimensionKeys.stream().anyMatch(dimension::equalsIgnoreCase)) continue;
                dimension = dimension.toUpperCase();
                ArrayList<Object> selectedValues = new ArrayList<Object>();
                if (dim instanceof DimensionTrimType) {
                    DimensionTrimType trim = (DimensionTrimType)dim;
                    this.setSubsetRangeValue(dimension, trim.getTrimLow(), trim.getTrimHigh(), selectedValues);
                } else if (dim instanceof DimensionSliceType) {
                    DimensionSliceType slicing = (DimensionSliceType)dim;
                    this.setSubsetValue(dimension, slicing.getSlicePoint(), selectedValues);
                } else {
                    throw new WCS20Exception("Invalid element found while attempting to parse dimension subsetting request: " + dim.getClass().toString(), WCS20Exception.WCS20ExceptionCode.InvalidSubsetting, "subset");
                }
                dimensionSubset.put(dimension, selectedValues);
            }
        }
        return dimensionSubset;
    }

    private void setSubsetRangeValue(String dimensionName, String low, String high, List<Object> selectedValues) throws IOException {
        boolean sliceSet = false;
        String domainDatatype = this.accessor.getDomainDatatype(dimensionName);
        if (domainDatatype != null) {
            PARSER.setRangeValues(low, high, selectedValues, domainDatatype);
        } else {
            if (!sliceSet) {
                sliceSet = PARSER.setAsDateRange(low, high, selectedValues);
            }
            if (!sliceSet) {
                sliceSet = PARSER.setAsIntegerRange(low, high, selectedValues);
            }
            if (!sliceSet) {
                sliceSet = PARSER.setAsDoubleRange(low, high, selectedValues);
            }
            if (!sliceSet) {
                selectedValues.add(low + "/" + high);
            }
        }
    }

    private void setSubsetValue(String dimensionName, String slicePoint, List<Object> selectedValues) throws IOException {
        boolean sliceSet = false;
        String domainDatatype = this.accessor.getDomainDatatype(dimensionName);
        if (domainDatatype != null) {
            PARSER.setValues(slicePoint, selectedValues, domainDatatype);
        } else {
            if (!sliceSet) {
                sliceSet = PARSER.setAsDate(slicePoint, selectedValues);
            }
            if (!sliceSet) {
                sliceSet = PARSER.setAsInteger(slicePoint, selectedValues);
            }
            if (!sliceSet) {
                sliceSet = PARSER.setAsDouble(slicePoint, selectedValues);
            }
            if (!sliceSet) {
                selectedValues.add(slicePoint);
            }
        }
    }

    public GridCoverageRequest createGridCoverageRequestSubset() throws IOException {
        WCSEnvelope spatialSubset = this.extractSubsettingEnvelope();
        assert (spatialSubset != null && !spatialSubset.isEmpty());
        Map<String, List<Object>> dimensionsSubset = null;
        DateRange temporalSubset = null;
        NumberRange elevationSubset = null;
        if (this.enabledDimensions != null && !this.enabledDimensions.isEmpty()) {
            temporalSubset = this.extractTemporalSubset();
            elevationSubset = this.extractElevationSubset();
            dimensionsSubset = this.extractDimensionsSubset();
        }
        GridCoverageRequest subsettingRequest = new GridCoverageRequest();
        subsettingRequest.setSpatialSubset(spatialSubset);
        subsettingRequest.setElevationSubset(elevationSubset);
        subsettingRequest.setTemporalSubset(temporalSubset);
        subsettingRequest.setDimensionsSubset(dimensionsSubset);
        subsettingRequest.setFilter(this.request.getFilter());
        subsettingRequest.setSortBy((List<SortBy>)this.request.getSortBy());
        String coverageName = this.getCoverageName();
        if (!GetCoverage.formatSupportMDOutput(this.request.getFormat())) {
            WCSDefaultValuesHelper defaultValuesHelper = new WCSDefaultValuesHelper(this.reader, this.accessor, this.request, coverageName);
            defaultValuesHelper.setDefaults(subsettingRequest);
        }
        return subsettingRequest;
    }

    private String getCoverageName() throws IOException {
        String nativeName = this.coverageInfo.getNativeCoverageName();
        return nativeName != null ? nativeName : this.reader.getGridCoverageNames()[0];
    }

    public List<GridCoverageRequest> splitRequest() throws UnsupportedOperationException, IOException, MismatchedDimensionException, TransformException, FactoryException {
        StructuredGridCoverage2DReader structuredReader = null;
        if (!(this.reader instanceof StructuredGridCoverage2DReader)) {
            throw new IllegalArgumentException("The method is only supported for StructuredGridCoverage2DReaders");
        }
        structuredReader = (StructuredGridCoverage2DReader)this.reader;
        String coverageName = this.getCoverageName();
        GranuleSource source = structuredReader.getGranules(coverageName, true);
        if (source == null) {
            throw new IllegalArgumentException("No granule source available for that coverageName");
        }
        Query query = this.prepareDimensionsQuery(structuredReader, coverageName, this.gridCoverageRequest, source);
        SimpleFeatureCollection collection = source.getGranules(query);
        ArrayList<GridCoverageRequest> requests = new ArrayList<GridCoverageRequest>();
        try (SimpleFeatureIterator iterator = collection.features();){
            while (iterator.hasNext()) {
                SimpleFeature feature = (SimpleFeature)iterator.next();
                GridCoverageRequest subRequest = new GridCoverageRequest();
                subRequest.setOutputCRS(this.gridCoverageRequest.getOutputCRS());
                subRequest.setSpatialInterpolation(this.gridCoverageRequest.getSpatialInterpolation());
                subRequest.setSpatialSubset(this.gridCoverageRequest.getSpatialSubset());
                subRequest.setTemporalInterpolation(this.gridCoverageRequest.getTemporalInterpolation());
                this.updateDimensions(subRequest, feature, structuredReader, coverageName);
                requests.add(subRequest);
            }
        }
        return requests;
    }

    public Set<GridCoverageRequest> splitRequestToSet() throws MismatchedDimensionException, UnsupportedOperationException, IOException, TransformException, FactoryException {
        List<GridCoverageRequest> list = this.splitRequest();
        LinkedHashSet<GridCoverageRequest> set = new LinkedHashSet<GridCoverageRequest>();
        for (GridCoverageRequest request : list) {
            set.add(request);
        }
        return set;
    }

    private void updateDimensions(GridCoverageRequest subRequest, SimpleFeature feature, StructuredGridCoverage2DReader reader, String coverageName) {
        String startTimeAttribute = null;
        String endTimeAttribute = null;
        DimensionDescriptor timeDescriptor = WCSDimensionsHelper.getDimensionDescriptor(reader, coverageName, "TIME");
        if (timeDescriptor != null) {
            startTimeAttribute = timeDescriptor.getStartAttribute();
            endTimeAttribute = timeDescriptor.getEndAttribute();
            Date startDate = (Date)feature.getAttribute(startTimeAttribute);
            Date endDate = endTimeAttribute != null ? (Date)feature.getAttribute(endTimeAttribute) : startDate;
            DateRange range = new DateRange(startDate, endDate);
            subRequest.setTemporalSubset(range);
        }
        String startElevationAttribute = null;
        String endElevationAttribute = null;
        DimensionDescriptor elevationDescriptor = WCSDimensionsHelper.getDimensionDescriptor(reader, coverageName, "ELEVATION");
        if (elevationDescriptor != null) {
            startElevationAttribute = elevationDescriptor.getStartAttribute();
            endElevationAttribute = elevationDescriptor.getEndAttribute();
            Number startValue = (Number)feature.getAttribute(startElevationAttribute);
            Number endValue = endElevationAttribute != null ? (Number)((Number)feature.getAttribute(endElevationAttribute)) : (Number)startValue;
            NumberRange range = new NumberRange(startValue.getClass(), startValue, endValue);
            subRequest.setElevationSubset(range);
        }
        List customDomains = this.accessor != null ? this.accessor.getCustomDomains() : Collections.emptyList();
        HashMap<String, List<Object>> dimensionsSubset = new HashMap<String, List<Object>>();
        for (String customDomain : customDomains) {
            String startAttribute = null;
            String endAttribute = null;
            DimensionDescriptor descriptor = WCSDimensionsHelper.getDimensionDescriptor(reader, coverageName, customDomain);
            if (descriptor == null) continue;
            startAttribute = descriptor.getStartAttribute();
            endAttribute = descriptor.getEndAttribute();
            DateRange value = feature.getAttribute(startAttribute);
            if (endAttribute != null) {
                Object endValue = feature.getAttribute(endAttribute);
                Class<?> objectClass = endValue.getClass();
                String classDataType = objectClass.toString();
                value = classDataType.endsWith("Timestamp") ? new DateRange(new Date(((Timestamp)value).getTime()), new Date(((Timestamp)endValue).getTime())) : (classDataType.endsWith("Date") ? new DateRange((Date)value, (Date)endValue) : this.newGenericNumberRange(objectClass, (Number)value, (Number)endValue));
            }
            ArrayList<DateRange> dimensionValues = new ArrayList<DateRange>();
            dimensionValues.add(value);
            dimensionsSubset.put(descriptor.getName().toUpperCase(), dimensionValues);
        }
        subRequest.setDimensionsSubset(dimensionsSubset);
    }

    private NumberRange<? extends Number> newGenericNumberRange(Class<?> numberClass, Number start, Number end) {
        return new NumberRange(numberClass, start, end);
    }

    private Query prepareDimensionsQuery(StructuredGridCoverage2DReader reader, String coverageName, GridCoverageRequest gcr, GranuleSource source) throws UnsupportedOperationException, IOException, MismatchedDimensionException, TransformException, FactoryException {
        Filter filter = this.filterSpatial(gcr, source);
        ArrayList<SortBy> sortByList = new ArrayList<SortBy>();
        filter = this.filterTime(filter, gcr, coverageName, reader, sortByList);
        filter = this.filterElevation(filter, gcr, coverageName, reader, sortByList);
        filter = this.filterDimensions(filter, gcr, coverageName, reader, sortByList);
        Query query = new Query(null, filter);
        if (!sortByList.isEmpty()) {
            query.setSortBy((SortBy[])sortByList.stream().toArray(SortBy[]::new));
        }
        return query;
    }

    private Filter filterSpatial(GridCoverageRequest gcr, GranuleSource source) throws IOException, MismatchedDimensionException, TransformException, FactoryException {
        WCSEnvelope envelope = gcr.getSpatialSubset();
        Polygon llPolygon = JTS.toGeometry((ReferencedEnvelope)new ReferencedEnvelope((org.opengis.geometry.Envelope)envelope));
        GeometryDescriptor geom = source.getSchema().getGeometryDescriptor();
        PropertyName geometryProperty = this.ff.property(geom.getLocalName());
        Geometry nativeCRSPolygon = JTS.transform((Geometry)llPolygon, (MathTransform)CRS.findMathTransform((CoordinateReferenceSystem)envelope.getCoordinateReferenceSystem(), (CoordinateReferenceSystem)this.coverageInfo.getCRS()));
        Literal polygonLiteral = this.ff.literal((Object)nativeCRSPolygon);
        return this.ff.intersects((Expression)geometryProperty, (Expression)polygonLiteral);
    }

    private Filter filterElevation(Filter filter, GridCoverageRequest gcr, String coverageName, StructuredGridCoverage2DReader reader, List<SortBy> sortByList) {
        NumberRange<?> elevationRange = gcr.getElevationSubset();
        String startElevation = null;
        String endElevation = null;
        DimensionDescriptor elevationDescriptor = null;
        Filter elevationFilter = filter;
        if (elevationRange != null && filter != Filter.EXCLUDE) {
            elevationDescriptor = WCSDimensionsHelper.getDimensionDescriptor(reader, coverageName, "ELEVATION");
            startElevation = elevationDescriptor.getStartAttribute();
            endElevation = elevationDescriptor.getEndAttribute();
            elevationFilter = this.filter(startElevation, endElevation, elevationRange.getMinValue(), elevationRange.getMaxValue(), filter, sortByList);
        }
        return elevationFilter;
    }

    private Filter filterTime(Filter filter, GridCoverageRequest gcr, String coverageName, StructuredGridCoverage2DReader reader, List<SortBy> sortByList) {
        DateRange timeRange = gcr.getTemporalSubset();
        DimensionDescriptor timeDescriptor = null;
        String startTime = null;
        String endTime = null;
        Filter timeFilter = filter;
        if (timeRange != null && filter != Filter.EXCLUDE) {
            timeDescriptor = WCSDimensionsHelper.getDimensionDescriptor(reader, coverageName, "TIME");
            startTime = timeDescriptor.getStartAttribute();
            endTime = timeDescriptor.getEndAttribute();
            timeFilter = this.filter(startTime, endTime, timeRange.getMinValue(), timeRange.getMaxValue(), filter, sortByList);
        }
        return timeFilter;
    }

    private Filter filterDimensions(Filter filter, GridCoverageRequest gcr, String coverageName, StructuredGridCoverage2DReader reader, List<SortBy> sortByList) {
        Map<String, List<Object>> subset = gcr.getDimensionsSubset();
        Filter dimensionsFilter = filter;
        if (subset != null && !subset.isEmpty()) {
            Set<String> dimensions = subset.keySet();
            for (String dimensionName : dimensions) {
                List<Object> dimensionValues = subset.get(dimensionName);
                if (dimensionValues == null || dimensionValues.isEmpty()) continue;
                DimensionDescriptor dimensionDescriptor = WCSDimensionsHelper.getDimensionDescriptor(reader, coverageName, dimensionName);
                if (dimensionDescriptor != null) {
                    String startAttrib = dimensionDescriptor.getStartAttribute();
                    String endAttrib = dimensionDescriptor.getEndAttribute();
                    dimensionsFilter = this.filterDimension(startAttrib, endAttrib, dimensionValues, dimensionsFilter, sortByList);
                    continue;
                }
                if (!LOGGER.isLoggable(Level.WARNING)) continue;
                LOGGER.warning("The specified dimension " + dimensionName + "has no descriptors in the reader. Skipping it");
            }
        }
        return dimensionsFilter;
    }

    private Filter filterDimension(String startAttribute, String endAttribute, List<Object> dimensionValues, Filter filter, List<SortBy> sortByList) {
        PropertyIsBetween localFilter = null;
        if (dimensionValues != null && !dimensionValues.isEmpty()) {
            Object element = dimensionValues.get(0);
            Object min = null;
            Object max = null;
            if (element instanceof DateRange) {
                DateRange dateRange = (DateRange)element;
                min = dateRange.getMinValue();
                max = dateRange.getMaxValue();
            } else if (element instanceof NumberRange) {
                NumberRange numberRange = (NumberRange)element;
                min = numberRange.getMinValue();
                max = numberRange.getMaxValue();
            } else if (element instanceof Date || element instanceof Number || element instanceof String) {
                min = element;
                max = element;
            } else {
                throw new IllegalArgumentException("Unsupported object type");
            }
            if (endAttribute == null) {
                localFilter = this.ff.between((Expression)this.ff.property(startAttribute), (Expression)this.ff.literal(min), (Expression)this.ff.literal(max));
            } else {
                PropertyIsLessThanOrEqualTo f1 = this.ff.lessOrEqual((Expression)this.ff.property(startAttribute), (Expression)this.ff.literal(max));
                PropertyIsGreaterThanOrEqualTo f2 = this.ff.greaterOrEqual((Expression)this.ff.property(endAttribute), (Expression)this.ff.literal(min));
                localFilter = this.ff.and(Arrays.asList(f1, f2));
            }
            sortByList.add(this.ff.sort(startAttribute, SortBy.NATURAL_ORDER.getSortOrder()));
            filter = filter == null ? localFilter : this.ff.and(filter, (Filter)localFilter);
        }
        return filter;
    }

    private Filter filter(String startAttribute, String endAttribute, Comparable minValue, Comparable maxValue, Filter filter, List<SortBy> sortByList) {
        PropertyIsBetween localFilter = null;
        if (endAttribute == null) {
            localFilter = this.ff.between((Expression)this.ff.property(startAttribute), (Expression)this.ff.literal((Object)minValue), (Expression)this.ff.literal((Object)maxValue));
        } else {
            PropertyIsLessThanOrEqualTo f1 = this.ff.lessOrEqual((Expression)this.ff.property(startAttribute), (Expression)this.ff.literal((Object)maxValue));
            PropertyIsGreaterThanOrEqualTo f2 = this.ff.greaterOrEqual((Expression)this.ff.property(endAttribute), (Expression)this.ff.literal((Object)minValue));
            localFilter = this.ff.and(Arrays.asList(f1, f2));
        }
        sortByList.add(this.ff.sort(startAttribute, SortBy.NATURAL_ORDER.getSortOrder()));
        filter = filter == null ? localFilter : this.ff.and(filter, (Filter)localFilter);
        return filter;
    }

    public List<DimensionBean> setupDimensions() throws IOException {
        DimensionBean elevationD;
        StructuredGridCoverage2DReader structuredReader = null;
        if (!(this.reader instanceof StructuredGridCoverage2DReader)) {
            throw new UnsupportedOperationException("Only structuredGridCoverage2DReaders are currently supported");
        }
        structuredReader = (StructuredGridCoverage2DReader)this.reader;
        ArrayList<DimensionBean> dimensions = new ArrayList<DimensionBean>();
        if (this.accessor == null) {
            return dimensions;
        }
        List customDimensions = this.accessor != null ? this.accessor.getCustomDomains() : Collections.emptyList();
        for (String customDimension : customDimensions) {
            dimensions.add(this.setupDimensionBean(structuredReader, customDimension));
        }
        DimensionBean timeD = this.setupDimensionBean(structuredReader, "TIME");
        if (timeD != null) {
            dimensions.add(timeD);
        }
        if ((elevationD = this.setupDimensionBean(structuredReader, "ELEVATION")) != null) {
            dimensions.add(elevationD);
        }
        return dimensions;
    }

    private DimensionBean setupDimensionBean(StructuredGridCoverage2DReader structuredReader, String dimensionID) throws IOException {
        Utilities.ensureNonNull((String)"structuredReader", (Object)structuredReader);
        String coverageName = this.getCoverageName();
        DimensionDescriptor descriptor = WCSDimensionsHelper.getDimensionDescriptor(structuredReader, coverageName, dimensionID);
        if (descriptor == null) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Unable to find a valid descriptor for the specified dimension ID: " + dimensionID + " for the specified coverage " + coverageName + "\n Returning no DimensionBean");
            }
            return null;
        }
        String dimensionName = descriptor.getName();
        DimensionBean.DimensionType dimensionType = dimensionID.equalsIgnoreCase("TIME") ? DimensionBean.DimensionType.TIME : (dimensionID.equalsIgnoreCase("ELEVATION") ? DimensionBean.DimensionType.ELEVATION : DimensionBean.DimensionType.CUSTOM);
        DimensionInfo info = this.enabledDimensions.get(dimensionID);
        String units = null;
        String symbol = null;
        if (info != null) {
            units = info.getUnits();
            symbol = info.getUnitSymbol();
        }
        if (units == null) {
            units = descriptor.getUnits();
        }
        if (symbol == null) {
            symbol = descriptor.getUnitSymbol();
        }
        return new DimensionBean(dimensionName, units, symbol, this.accessor.getDomainDatatype(dimensionName), dimensionType, descriptor.getEndAttribute() != null);
    }

    public void setCoverageDimensionProperty(Map<String, Object> properties, GridCoverageRequest coverageRequest, DimensionBean coverageDimension) {
        Utilities.ensureNonNull((String)"properties", properties);
        Utilities.ensureNonNull((String)"coverageDimension", (Object)coverageDimension);
        DimensionBean.DimensionType dimensionType = coverageDimension.getDimensionType();
        Object value = null;
        switch (dimensionType) {
            case TIME: {
                value = coverageRequest.getTemporalSubset();
                break;
            }
            case ELEVATION: {
                value = coverageRequest.getElevationSubset();
                break;
            }
            case CUSTOM: {
                List<Object> elements;
                Map<String, List<Object>> dimensionsSubset = coverageRequest.getDimensionsSubset();
                List<Object> list = elements = dimensionsSubset == null ? null : dimensionsSubset.get(coverageDimension.getName().toUpperCase());
                if (elements == null) {
                    throw new IllegalArgumentException("No dimension subset has been found");
                }
                if (elements.size() > 1) {
                    throw new UnsupportedOperationException("Multiple elements in additional dimensions are not supported on splitted requests");
                }
                value = elements.get(0);
            }
        }
        properties.put(coverageDimension.getName(), value);
    }

    static {
        TIME_NAMES.add("t");
        TIME_NAMES.add("time");
        TIME_NAMES.add("temporal");
        TIME_NAMES.add("phenomenontime");
        ELEVATION_NAMES.add("elevation");
    }
}

