/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wcs2_0.response;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.GeoServerResourceLoader;
import org.geoserver.platform.resource.Files;
import org.geoserver.platform.resource.Resource;
import org.geoserver.platform.resource.Resources;
import org.geoserver.wcs2_0.response.CoverageMimeTypeMapper;
import org.geotools.util.logging.Logging;

public class ImgMimeTypeMapper
implements CoverageMimeTypeMapper {
    static final Logger LOGGER = Logging.getLogger(ImgMimeTypeMapper.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getMimeType(CoverageInfo cInfo) throws IOException {
        block41: {
            GeoServerResourceLoader loader = (GeoServerResourceLoader)GeoServerExtensions.bean(GeoServerResourceLoader.class);
            File sourceFile = Resources.find((Resource)Resources.fromURL((Resource)Files.asResource((File)loader.getBaseDirectory()), (String)cInfo.getStore().getURL()), (boolean)true);
            if (sourceFile == null) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Original source is null");
                }
                return null;
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Original source: " + sourceFile.getAbsolutePath());
            }
            ImageReader reader = null;
            try {
                String string;
                try (ImageInputStream inStream = ImageIO.createImageInputStream(sourceFile);){
                    String mime;
                    String lcMime;
                    if (inStream == null) {
                        String string2 = null;
                        return string2;
                    }
                    Iterator<ImageReader> readers = ImageIO.getImageReaders(inStream);
                    if (!readers.hasNext()) break block41;
                    reader = readers.next();
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine("Found reader for format: " + reader.getFormatName());
                    }
                    if (!(lcMime = (mime = reader.getOriginatingProvider().getMIMETypes()[0]).toLowerCase()).contains("jpeg") && !lcMime.contains("mrsid") && !lcMime.contains("ecw")) break block41;
                    string = null;
                }
                return string;
            }
            catch (Exception e) {
                if (LOGGER.isLoggable(Level.WARNING)) {
                    LOGGER.warning("Unable to map mime type for coverage: " + cInfo.toString());
                }
            }
            finally {
                block42: {
                    try {
                        if (reader != null) {
                            reader.dispose();
                        }
                    }
                    catch (Exception e) {
                        if (!LOGGER.isLoggable(Level.FINE)) break block42;
                        LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                    }
                }
            }
        }
        return null;
    }
}

