/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wcs.kvp;

import java.util.Map;
import net.opengis.ows11.BoundingBoxType;
import net.opengis.wcs11.DomainSubsetType;
import net.opengis.wcs11.GetCoverageType;
import net.opengis.wcs11.GridCrsType;
import net.opengis.wcs11.OutputType;
import net.opengis.wcs11.TimeSequenceType;
import net.opengis.wcs11.Wcs111Factory;
import org.eclipse.emf.ecore.EFactory;
import org.geoserver.catalog.Catalog;
import org.geoserver.ows.kvp.EMFKvpRequestReader;
import org.vfny.geoserver.wcs.WcsException;

public class GetCoverageRequestReader
extends EMFKvpRequestReader {
    Catalog catalog;

    public GetCoverageRequestReader(Catalog catalog) {
        super(GetCoverageType.class, (EFactory)Wcs111Factory.eINSTANCE);
        this.catalog = catalog;
    }

    public Object read(Object request, Map<String, Object> kvp, Map<String, Object> rawKvp) throws Exception {
        GetCoverageType getCoverage = (GetCoverageType)super.read(request, kvp, rawKvp);
        if (getCoverage.getIdentifier() == null) {
            throw new WcsException("identifier parameter is mandatory", WcsException.WcsExceptionCode.MissingParameterValue, "identifier");
        }
        getCoverage.setDomainSubset(this.parseDomainSubset(kvp));
        getCoverage.setOutput(this.parseOutputElement(kvp));
        return getCoverage;
    }

    private DomainSubsetType parseDomainSubset(Map kvp) {
        DomainSubsetType domainSubset = Wcs111Factory.eINSTANCE.createDomainSubsetType();
        BoundingBoxType bbox = (BoundingBoxType)kvp.get("BoundingBox");
        TimeSequenceType timeSequence = (TimeSequenceType)kvp.get("TimeSequence");
        if (timeSequence == null && bbox == null) {
            throw new WcsException("Bounding box cannot be null, TimeSequence has not been specified", WcsException.WcsExceptionCode.MissingParameterValue, "BoundingBox");
        }
        domainSubset.setBoundingBox(bbox);
        domainSubset.setTemporalSubset(timeSequence);
        return domainSubset;
    }

    private OutputType parseOutputElement(Map kvp) throws Exception {
        String format;
        OutputType output = Wcs111Factory.eINSTANCE.createOutputType();
        output.setGridCRS(Wcs111Factory.eINSTANCE.createGridCrsType());
        Boolean store = (Boolean)kvp.get("store");
        if (store != null) {
            output.setStore(store.booleanValue());
        }
        if ((format = (String)kvp.get("format")) == null) {
            throw new WcsException("format parameter is mandatory", WcsException.WcsExceptionCode.MissingParameterValue, "format");
        }
        output.setFormat(format);
        GridCrsType gridCRS = output.getGridCRS();
        gridCRS.setGridBaseCRS((String)kvp.get("gridBaseCrs"));
        String gridType = (String)kvp.get("gridType");
        if (gridType == null) {
            gridType = gridCRS.getGridType();
        }
        gridCRS.setGridType(gridType);
        String gridCS = (String)kvp.get("gridCS");
        if (gridCS == null) {
            gridCS = gridCRS.getGridCS();
        }
        gridCRS.setGridCS(gridCS);
        gridCRS.setGridOrigin(kvp.get("GridOrigin"));
        gridCRS.setGridOffsets(kvp.get("GridOffsets"));
        return output;
    }
}

