/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.kml.utils;

import java.util.ArrayList;
import java.util.List;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.visitor.SimplifyingFilterVisitor;
import org.geotools.styling.AbstractStyleVisitor;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.Rule;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.Or;

public class RuleFiltersCollector
extends AbstractStyleVisitor {
    List<Filter> filters = new ArrayList<Filter>();

    public void visit(FeatureTypeStyle fts) {
        for (Rule rule : fts.rules()) {
            if (rule.isElseFilter()) {
                this.filters.add((Filter)Filter.INCLUDE);
                continue;
            }
            Filter filter = rule.getFilter();
            if (filter == null) {
                this.filters.add((Filter)Filter.INCLUDE);
                continue;
            }
            this.filters.add(filter);
        }
    }

    Filter getSummaryFilter() {
        if (this.filters.isEmpty()) {
            return Filter.INCLUDE;
        }
        if (this.filters.size() == 1) {
            return this.filters.get(0);
        }
        FilterFactory ff = CommonFactoryFinder.getFilterFactory();
        Or or = ff.or(this.filters);
        SimplifyingFilterVisitor simplifier = new SimplifyingFilterVisitor();
        return (Filter)or.accept((FilterVisitor)simplifier, null);
    }
}

