/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.kml.utils;

import java.util.Collections;
import java.util.Map;
import org.geoserver.kml.KmlEncodingContext;
import org.geoserver.ows.util.CaseInsensitiveMap;
import org.geoserver.ows.util.KvpMap;

public class KmlCentroidOptions {
    public static final String PREFIX = "kmcentroid";
    public static final String CONTAIN = "kmcentroid_contain";
    public static final String SAMPLE = "kmcentroid_sample";
    public static final String CLIP = "kmcentroid_clip";
    public static final KmlCentroidOptions DEFAULT = new KmlCentroidOptions((Map<String, Object>)new KvpMap());
    static final int DEFAULT_SAMPLES = 5;
    Map<String, Object> raw;

    public static KmlCentroidOptions create(KmlEncodingContext context) {
        return KmlCentroidOptions.create(context != null && context.getRequest() != null ? context.getRequest().getFormatOptions() : Collections.emptyMap());
    }

    public static KmlCentroidOptions create(Map<String, Object> formatOptions) {
        if (formatOptions != null) {
            for (String key : formatOptions.keySet()) {
                if (!key.toString().toLowerCase().startsWith(PREFIX)) continue;
                return new KmlCentroidOptions(CaseInsensitiveMap.wrap(formatOptions));
            }
        }
        return DEFAULT;
    }

    public KmlCentroidOptions(Map<String, Object> raw) {
        this.raw = raw;
    }

    public boolean isContain() {
        return Boolean.valueOf(this.raw.getOrDefault(CONTAIN, "false").toString());
    }

    public boolean isClip() {
        return Boolean.valueOf(this.raw.getOrDefault(CLIP, "false").toString());
    }

    public int getSamples() {
        try {
            return Integer.parseInt(this.raw.getOrDefault(SAMPLE, String.valueOf(5)).toString());
        }
        catch (NumberFormatException e) {
            return 5;
        }
    }
}

