/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.kml.regionate;

import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.kml.regionate.RegionatingStrategy;
import org.geoserver.kml.regionate.Tile;
import org.geoserver.ows.HttpErrorCodeException;
import org.geoserver.platform.GeoServerResourceLoader;
import org.geoserver.platform.ServiceException;
import org.geoserver.platform.resource.Resource;
import org.geoserver.wms.WMSMapContent;
import org.geotools.data.FeatureSource;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.FeatureIterator;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.Layer;
import org.geotools.referencing.CRS;
import org.geotools.referencing.operation.projection.ProjectionException;
import org.geotools.util.CanonicalSet;
import org.geotools.util.SuppressFBWarnings;
import org.geotools.util.logging.Logging;
import org.h2.tools.DeleteDbFiles;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.identity.FeatureId;
import org.opengis.geometry.BoundingBox;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;

public abstract class CachedHierarchyRegionatingStrategy
implements RegionatingStrategy {
    static Logger LOGGER = Logging.getLogger((String)"org.geoserver.geosearch");
    static final double MAX_ERROR = 0.02;
    static final Set<String> NO_FIDS = Collections.emptySet();
    static CanonicalSet<String> canonicalizer = CanonicalSet.newInstance(String.class);
    protected ReferencedEnvelope dataEnvelope;
    protected FeatureTypeInfo featureType;
    protected Integer featuresPerTile;
    protected String tableName;
    protected GeoServer gs;

    protected CachedHierarchyRegionatingStrategy(GeoServer gs) {
        this.gs = gs;
    }

    @Override
    public Filter getFilter(WMSMapContent context, Layer layer) {
        Catalog catalog = this.gs.getCatalog();
        Set<Object> featuresInTile = Collections.emptySet();
        try {
            FeatureSource featureSource = layer.getFeatureSource();
            this.featureType = catalog.getFeatureTypeByName(featureSource.getName());
            String dataDir = catalog.getResourceLoader().getBaseDirectory().getCanonicalPath();
            this.tableName = this.getDatabaseName(context, layer);
            this.featuresPerTile = (Integer)this.featureType.getMetadata().get("kml.regionateFeatureLimit", Integer.class);
            if (this.featuresPerTile == null || this.featuresPerTile <= 1) {
                this.featuresPerTile = 64;
            }
            if (this.featureType.getFeatureType().getGeometryDescriptor() == null) {
                throw new ServiceException(this.featureType.getName() + " is geometryless, cannot generate KML!");
            }
            ReferencedEnvelope requestedEnvelope = context.getRenderingArea().transform(Tile.WGS84, true);
            LOGGER.log(Level.FINE, "Requested tile: {0}", requestedEnvelope);
            this.dataEnvelope = this.featureType.getLatLonBoundingBox();
            CachedTile cachedTile = new CachedTile(requestedEnvelope);
            ReferencedEnvelope tileEnvelope = cachedTile.getEnvelope();
            if (!this.envelopeMatch(tileEnvelope, requestedEnvelope)) {
                throw new ServiceException("Invalid bounding box request, it does not fit the nearest regionating tile. Requested area: " + requestedEnvelope + ", nearest tile: " + tileEnvelope);
            }
            featuresInTile = this.getFeaturesForTile(dataDir, cachedTile);
            LOGGER.log(Level.FINE, "Found " + featuresInTile.size() + " features in tile " + cachedTile.toString());
        }
        catch (Throwable t) {
            LOGGER.log(Level.SEVERE, "Error occurred while pre-processing regionated features", t);
            throw new ServiceException("Failure while pre-processing regionated features", t);
        }
        if (featuresInTile.isEmpty()) {
            throw new HttpErrorCodeException(204);
        }
        FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
        HashSet<FeatureId> ids = new HashSet<FeatureId>();
        for (String string : featuresInTile) {
            ids.add(ff.featureId(string));
        }
        return ff.id(ids);
    }

    @Override
    public void clearCache(FeatureTypeInfo cfg) {
        try {
            GeoServerResourceLoader loader = this.gs.getCatalog().getResourceLoader();
            Resource geosearch = loader.get("geosearch");
            if (geosearch.getType() == Resource.Type.DIRECTORY) {
                File directory = geosearch.dir();
                DeleteDbFiles.execute((String)directory.getCanonicalPath(), (String)("h2cache_" + this.getDatabaseName(cfg)), (boolean)true);
            }
        }
        catch (Exception ioe) {
            LOGGER.severe("Couldn't clear out config dir due to: " + ioe);
        }
    }

    private boolean envelopeMatch(ReferencedEnvelope tileEnvelope, ReferencedEnvelope expectedEnvelope) {
        double widthRatio = Math.abs(1.0 - tileEnvelope.getWidth() / expectedEnvelope.getWidth());
        double heightRatio = Math.abs(1.0 - tileEnvelope.getHeight() / expectedEnvelope.getHeight());
        double xRatio = Math.abs((tileEnvelope.getMinX() - expectedEnvelope.getMinX()) / tileEnvelope.getWidth());
        double yRatio = Math.abs((tileEnvelope.getMinY() - expectedEnvelope.getMinY()) / tileEnvelope.getHeight());
        return widthRatio < 0.02 && heightRatio < 0.02 && xRatio < 0.02 && yRatio < 0.02;
    }

    /*
     * Exception decompiling
     */
    @SuppressFBWarnings(value={"DMI_CONSTANT_DB_PASSWORD"})
    private Set<String> getFeaturesForTile(String dataDir, Tile tile) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set<String> readFeaturesForTile(Tile tile, Connection conn) throws Exception {
        Set<String> fids = this.readCachedTileFids(tile, conn);
        if (fids != null) {
            return fids;
        }
        String tileKey = this.tableName + tile.x + "-" + tile.y + "-" + tile.z;
        canonicalizer.add((Object)tileKey);
        String string = tileKey = (String)canonicalizer.get((Object)tileKey);
        synchronized (string) {
            fids = this.readCachedTileFids(tile, conn);
            if (fids != null) {
                return fids;
            }
            fids = this.computeFids(tile, conn);
            this.storeFids(tile, fids, conn);
            if (fids.size() < this.featuresPerTile) {
                for (Tile child : tile.getChildren()) {
                    this.storeFids(child, NO_FIDS, conn);
                }
            }
        }
        return fids;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeFids(Tile t, Set<String> fids, Connection conn) throws SQLException {
        try {
            String stmt = "INSERT INTO TILECACHE VALUES (" + t.x + ", " + t.y + ", " + t.z + ", ?)";
            try (PreparedStatement ps = conn.prepareStatement(stmt);){
                if (fids.isEmpty()) {
                    ps.setString(1, null);
                    ps.execute();
                } else {
                    conn.setAutoCommit(false);
                    for (String fid : fids) {
                        ps.setString(1, fid);
                        ps.execute();
                    }
                    conn.commit();
                }
            }
        }
        finally {
            conn.setAutoCommit(true);
        }
    }

    private Set<String> computeFids(Tile tile, Connection conn) throws Exception {
        Tile parent = tile.getParent();
        Set<String> parentFids = this.getUpwardFids(parent, conn);
        HashSet<String> currFids = new HashSet<String>();
        FeatureSource fs = this.featureType.getFeatureSource(null, null);
        GeometryDescriptor geom = fs.getSchema().getGeometryDescriptor();
        CoordinateReferenceSystem nativeCrs = geom.getCoordinateReferenceSystem();
        ReferencedEnvelope nativeTileEnvelope = null;
        if (!CRS.equalsIgnoreMetadata((Object)Tile.WGS84, (Object)nativeCrs)) {
            try {
                nativeTileEnvelope = tile.getEnvelope().transform(nativeCrs, true);
            }
            catch (ProjectionException pe) {
                LOGGER.log(Level.INFO, "Could not reproject the current tile bounds " + tile.getEnvelope() + " to the native SRS, intersecting with the layer declared lat/lon bounds and retrying");
                ReferencedEnvelope llEnv = this.featureType.getLatLonBoundingBox();
                ReferencedEnvelope reduced = tile.getEnvelope().intersection((Envelope)llEnv);
                if (reduced.isNull() || reduced.getWidth() == 0.0 || reduced.getHeight() == 0.0) {
                    return Collections.emptySet();
                }
                ReferencedEnvelope refRed = new ReferencedEnvelope((Envelope)reduced, tile.getEnvelope().getCoordinateReferenceSystem());
                nativeTileEnvelope = refRed.transform(nativeCrs, true);
            }
        } else {
            nativeTileEnvelope = tile.getEnvelope();
        }
        try (FeatureIterator fi = this.getSortedFeatures(geom, tile.getEnvelope(), nativeTileEnvelope, conn);){
            MathTransform tx = null;
            double[] coords = new double[2];
            boolean first = true;
            while (fi.hasNext() && currFids.size() < this.featuresPerTile) {
                SimpleFeature f = (SimpleFeature)fi.next();
                if (parentFids.contains(f.getID())) continue;
                if (first) {
                    first = false;
                    CoordinateReferenceSystem nativeCRS = f.getType().getCoordinateReferenceSystem();
                    this.featureType.getFeatureType().getCoordinateReferenceSystem();
                    if (nativeCRS != null && !CRS.equalsIgnoreMetadata((Object)nativeCRS, (Object)Tile.WGS84)) {
                        tx = CRS.findMathTransform((CoordinateReferenceSystem)nativeCRS, (CoordinateReferenceSystem)Tile.WGS84);
                    }
                }
                Point p = ((Geometry)f.getDefaultGeometry()).getCentroid();
                coords[0] = p.getX();
                coords[1] = p.getY();
                if (tx != null) {
                    tx.transform(coords, 0, coords, 0, 1);
                }
                if (!tile.contains(coords[0], coords[1])) continue;
                currFids.add(f.getID());
            }
        }
        return currFids;
    }

    protected abstract FeatureIterator getSortedFeatures(GeometryDescriptor var1, ReferencedEnvelope var2, ReferencedEnvelope var3, Connection var4) throws Exception;

    private Set<String> getUpwardFids(Tile tile, Connection conn) throws Exception {
        if (tile == null) {
            return Collections.emptySet();
        }
        HashSet<String> fids = new HashSet<String>();
        fids.addAll(this.readFeaturesForTile(tile, conn));
        Tile parent = tile.getParent();
        if (parent != null) {
            fids.addAll(this.getUpwardFids(parent, conn));
        }
        return fids;
    }

    /*
     * Exception decompiling
     */
    protected Set<String> readCachedTileFids(Tile tile, Connection conn) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected String getDatabaseName(WMSMapContent con, Layer layer) throws Exception {
        return this.getDatabaseName(this.featureType);
    }

    protected String getDatabaseName(FeatureTypeInfo cfg) throws Exception {
        return cfg.getNamespace().getPrefix() + "_" + cfg.getName();
    }

    static {
        try {
            Class.forName("org.h2.Driver");
        }
        catch (Exception e) {
            throw new RuntimeException("Could not initialize the class constants", e);
        }
    }

    protected class CachedTile
    extends Tile {
        public CachedTile(long x, long y, long z) {
            super(x, y, z);
        }

        @Override
        public boolean contains(double x, double y) {
            if (super.contains(x, y)) {
                return true;
            }
            double maxx = this.envelope.getMaxX();
            double maxy = this.envelope.getMaxY();
            if (x == maxx && x >= CachedHierarchyRegionatingStrategy.this.dataEnvelope.getMaxX()) {
                return true;
            }
            return y == maxy && y >= CachedHierarchyRegionatingStrategy.this.dataEnvelope.getMaxY();
        }

        public CachedTile(ReferencedEnvelope wgs84Envelope) {
            super(wgs84Envelope);
        }

        public CachedTile(Tile parent) {
            super(parent.x, parent.y, parent.z);
        }

        @Override
        public Tile getParent() {
            if (this.envelope.contains((BoundingBox)CachedHierarchyRegionatingStrategy.this.dataEnvelope)) {
                return null;
            }
            Tile parent = super.getParent();
            if (parent != null) {
                parent = new CachedTile(super.getParent());
            }
            return parent;
        }
    }
}

