/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.kml.iterator;

import java.util.NoSuchElementException;
import org.geoserver.kml.KmlEncodingContext;
import org.geoserver.kml.utils.KmlCentroidBuilder;
import org.geoserver.kml.utils.KmlCentroidOptions;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.collection.DecoratingSimpleFeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.GeometryDescriptor;

class KMLCentroidFeatureCollection
extends DecoratingSimpleFeatureCollection {
    private SimpleFeatureType schema;
    private KmlEncodingContext context;

    protected KMLCentroidFeatureCollection(FeatureCollection<SimpleFeatureType, SimpleFeature> delegate, KmlEncodingContext context) {
        super(delegate);
        this.context = context;
        SimpleFeatureTypeBuilder tb = new SimpleFeatureTypeBuilder();
        for (AttributeDescriptor ad : ((SimpleFeatureType)delegate.getSchema()).getAttributeDescriptors()) {
            if (ad instanceof GeometryDescriptor) {
                GeometryDescriptor gd = (GeometryDescriptor)ad;
                Class binding = ad.getType().getBinding();
                if (Point.class.isAssignableFrom(binding)) {
                    tb.add(ad);
                    continue;
                }
                tb.minOccurs(ad.getMinOccurs());
                tb.maxOccurs(ad.getMaxOccurs());
                tb.nillable(ad.isNillable());
                tb.add(ad.getLocalName(), Point.class, gd.getCoordinateReferenceSystem());
                continue;
            }
            tb.add(ad);
        }
        tb.setName(((SimpleFeatureType)delegate.getSchema()).getName());
        this.schema = tb.buildFeatureType();
    }

    public SimpleFeatureIterator features() {
        return new KMLCentroidFeatureIterator(this.delegate.features(), this.schema, this.context);
    }

    static class KMLCentroidFeatureIterator
    implements SimpleFeatureIterator {
        private SimpleFeatureIterator delegate;
        private SimpleFeatureBuilder builder;
        private KmlCentroidBuilder centroids;
        private KmlEncodingContext context;
        private KmlCentroidOptions centroidOpts;

        public KMLCentroidFeatureIterator(SimpleFeatureIterator features, SimpleFeatureType schema, KmlEncodingContext context) {
            this.delegate = features;
            this.builder = new SimpleFeatureBuilder(schema);
            this.centroids = new KmlCentroidBuilder();
            this.context = context;
            this.centroidOpts = KmlCentroidOptions.create(context);
        }

        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        public SimpleFeature next() throws NoSuchElementException {
            SimpleFeature f = (SimpleFeature)this.delegate.next();
            for (Object attribute : f.getAttributes()) {
                if (attribute instanceof Geometry && !(attribute instanceof Point)) {
                    Geometry geom = (Geometry)attribute;
                    Coordinate point = this.centroids.geometryCentroid(geom, this.context.getRequest().getBbox(), this.centroidOpts);
                    attribute = geom.getFactory().createPoint(point);
                }
                this.builder.add(attribute);
            }
            return this.builder.buildFeature(f.getID());
        }

        public void close() {
            this.delegate.close();
        }
    }
}

