/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.kml.decorator;

import de.micromata.opengis.kml.v_2_2_0.Feature;
import de.micromata.opengis.kml.v_2_2_0.Placemark;
import de.micromata.opengis.kml.v_2_2_0.atom.Link;
import java.io.IOException;
import java.util.logging.Logger;
import org.geoserver.kml.KmlEncodingContext;
import org.geoserver.kml.decorator.AbstractGeoSearchDecorator;
import org.geoserver.kml.decorator.KmlDecoratorFactory;
import org.geoserver.wms.WMSInfo;
import org.geotools.util.logging.Logging;

public class PlacemarkSelfLinkDecoratorFactory
implements KmlDecoratorFactory {
    @Override
    public KmlDecoratorFactory.KmlDecorator getDecorator(Class<? extends Feature> featureClass, KmlEncodingContext context) {
        if (!(context.getService() instanceof WMSInfo)) {
            return null;
        }
        String selfLinks = (String)context.getRequest().getFormatOptions().get("selfLinks");
        if (selfLinks != null && selfLinks.equalsIgnoreCase("true") && Placemark.class.isAssignableFrom(featureClass)) {
            return new PlacemarkSelfLinkDecorator();
        }
        return null;
    }

    static class PlacemarkSelfLinkDecorator
    extends AbstractGeoSearchDecorator {
        static final Logger LOGGER = Logging.getLogger(PlacemarkSelfLinkDecorator.class);

        PlacemarkSelfLinkDecorator() {
        }

        @Override
        public Feature decorate(Feature feature, KmlEncodingContext context) {
            Placemark pm = (Placemark)feature;
            String link = "";
            try {
                link = this.getFeatureTypeURL(context);
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            String[] id = context.getCurrentFeature().getID().split("\\.");
            link = link + "/" + id[1] + ".kml";
            Link al = pm.createAndSetAtomLink(link);
            al.setRel("self");
            return pm;
        }
    }
}

